/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.script.reflect;

import java.lang.reflect.Array;
import java.util.Collection;
import oracle.bpm.script.reflect.Component;
import oracle.bpm.util.Conversion;

class Util {
    Util() {
    }

    static boolean canBeCalled(Class[] argTypes, Object[] arguments) throws Throwable {
        if (argTypes.length == 0 && (arguments == null || arguments.length == 0)) {
            return true;
        }
        if (arguments == null || argTypes.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            Class argType = argTypes[i];
            Object argument = arguments[i];
            if (Util.canBeCalled(argType, argument)) continue;
            return false;
        }
        return true;
    }

    static boolean canBeCalled(Class<?> argType, Object argument) throws Throwable {
        boolean result;
        if (argument instanceof Component) {
            argument = ((Component)argument).getInstance();
        }
        if (!(result = argument == null ? !argType.isPrimitive() : (!argType.isPrimitive() ? argType.isAssignableFrom(argument.getClass()) : argType.isAssignableFrom(Util.typeOf(argument.getClass())))) && argument != null) {
            if (Conversion.getMethod(argument.getClass(), argType) != null) {
                result = true;
            } else if (argType.isArray() && Collection.class.isAssignableFrom(argument.getClass())) {
                result = true;
            }
        }
        return result;
    }

    static String capitalize(String attribute) {
        if (attribute == null || attribute.length() < 1) {
            return attribute;
        }
        return Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    static Class classOf(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    static Object convert(Object argument, Class<?> type) throws Throwable {
        Object result;
        if (argument instanceof Component) {
            result = ((Component)argument).getInstance();
        } else if (argument instanceof Collection && type.isArray()) {
            result = Util.toArray((Collection)argument, type.getComponentType());
        } else {
            if (argument != null && type.isAssignableFrom(argument.getClass())) {
                return argument;
            }
            result = Conversion.convertTo(argument, type);
        }
        return result;
    }

    static Object[] preInvoke(Class[] argTypes, Object[] arguments) throws Throwable {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Util.convert(arguments[i], argTypes[i]);
        }
        return arguments;
    }

    static Object toArray(Collection collection, Class elementType) throws Throwable {
        if (collection == null) {
            return null;
        }
        int length = collection.size();
        Object array = Array.newInstance(elementType, length);
        int i = 0;
        for (Object element : collection) {
            Array.set(array, i, Util.convert(element, elementType));
            ++i;
        }
        return array;
    }

    static Class typeOf(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        throw new IllegalArgumentException("type: " + clazz + " is not primitive");
    }
}

