/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.script.reflect;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.script.reflect.Constructor;
import oracle.bpm.script.reflect.Field;
import oracle.bpm.script.reflect.Method;
import oracle.bpm.script.reflect.Util;
import oracle.bpm.util.ArrayUtils;

public class Component {
    private JavaClass clazz;
    private Constructor[] constructors;
    private Map<String, Field> fields;
    private Object instance;
    private Map<String, List<Method>> methods;
    private int noArgConstructor = -1;

    public Component(Object instance) throws Throwable {
        if (instance instanceof Component) {
            Component component = (Component)instance;
            this.clazz = component.clazz;
            this.instance = component.instance;
        } else {
            this.clazz = JavaClass.fromClass(instance.getClass());
            this.setInstance(instance);
        }
    }

    public Component(String className) throws ClassNotFoundException {
        this.clazz = JavaClass.forName(className);
    }

    public Component(Class<?> clazz, Object[] arguments) throws Throwable {
        this.clazz = JavaClass.fromClass(clazz);
        this.initialize(arguments);
    }

    public Object getInstance() throws Throwable {
        if (this.instance == null) {
            this.checkConstructors();
            if (this.noArgConstructor < 0) {
                throw new IllegalStateException("The component '" + this.clazz.getName() + "' has not been instantiated. Please call a constructor first.");
            }
            this.constructors[this.noArgConstructor].call();
        }
        return this.instance;
    }

    public List asArray() throws Throwable {
        if (!List.class.isAssignableFrom(this.clazz.getOriginalClass()) && !this.clazz.getOriginalClass().isArray()) {
            throw new IllegalStateException("Class " + this.clazz.getName() + " is not an array");
        }
        return Arrays.asList((Object[])this.getInstance());
    }

    public Object call(String method) throws Throwable {
        Object[] args = new Object[]{};
        return this.call(method, args);
    }

    public Object call(String method, Object[] arguments) throws Throwable {
        Method mtd = this.findMethod(method, arguments);
        if (mtd == null) {
            throw new IllegalArgumentException("No matching method found: name=" + method + ", args=" + ArrayUtils.toString(arguments));
        }
        return mtd.call(arguments);
    }

    public Component convertTo(Object value) throws Throwable {
        return new Component(Util.convert(value, this.clazz.getOriginalClass()));
    }

    public Object get(String attribute) throws Throwable {
        this.checkFields();
        Field field = this.fields.get(attribute);
        if (field != null) {
            return field.getValue();
        }
        String getter = "get" + Util.capitalize(attribute);
        Method method = this.findMethod(getter);
        if (method != null) {
            return method.call();
        }
        getter = "is" + Util.capitalize(attribute);
        method = this.findMethod(getter);
        if (method != null) {
            return method.call();
        }
        getter = "has" + Util.capitalize(attribute);
        method = this.findMethod(getter);
        if (method != null) {
            return method.call();
        }
        method = this.findMethod(attribute);
        if (method != null) {
            return method.call();
        }
        throw new IllegalArgumentException("Attribute not found: " + attribute);
    }

    public void initialize(Object[] arguments) throws Throwable {
        Constructor constructor = null;
        this.checkConstructors();
        for (Constructor current : this.constructors) {
            if (!current.canBeCalled(arguments)) continue;
            constructor = current;
            break;
        }
        if (constructor == null) {
            throw new IllegalArgumentException("No matching constructor found : args=" + ArrayUtils.toString(arguments));
        }
        constructor.call(arguments);
    }

    public void set(String attribute, Object value) throws Throwable {
        this.checkFields();
        Field field = this.fields.get(attribute);
        if (field != null) {
            field.setValue(value);
            return;
        }
        String setter = "set" + Util.capitalize(attribute);
        Object[] arguments = new Object[]{value};
        Method method = this.findMethod(setter, arguments);
        if (method != null) {
            method.call(arguments);
            return;
        }
        method = this.findMethod(attribute, arguments);
        if (method != null) {
            method.call(arguments);
            return;
        }
        throw new IllegalArgumentException("Attribute not found: " + attribute);
    }

    void setInstance(Object instance) {
        this.instance = instance;
    }

    private void checkConstructors() {
        if (this.constructors != null) {
            return;
        }
        Class originalClass = this.clazz.getOriginalClass();
        java.lang.reflect.Constructor<?>[] constr = originalClass.getConstructors();
        this.constructors = new Constructor[constr.length];
        for (int i = 0; i < constr.length; ++i) {
            java.lang.reflect.Constructor<?> constructor = constr[i];
            if (constructor.getParameterTypes().length == 0) {
                this.noArgConstructor = i;
            }
            this.constructors[i] = new Constructor(this, constructor);
        }
    }

    private void checkFields() {
        if (this.fields != null) {
            return;
        }
        Class originalClass = this.clazz.getOriginalClass();
        java.lang.reflect.Field[] flds = originalClass.getFields();
        this.fields = new TreeMap<String, Field>();
        for (java.lang.reflect.Field fld : flds) {
            Field field = new Field(this, fld);
            this.fields.put(field.getName(), field);
        }
    }

    private void checkMethods() {
        if (this.methods != null) {
            return;
        }
        Class originalClass = this.clazz.getOriginalClass();
        java.lang.reflect.Method[] javaMethods = originalClass.getMethods();
        this.methods = new TreeMap<String, List<Method>>();
        for (java.lang.reflect.Method javaMethod : javaMethods) {
            Method mtd = new Method(this, javaMethod);
            List<Method> list = this.methods.get(mtd.getName());
            if (list == null) {
                list = new LinkedList<Method>();
                this.methods.put(mtd.getName(), list);
            }
            list.add(mtd);
        }
    }

    private Method findMethod(String method, Object[] arguments) throws Throwable {
        Method mtd = null;
        this.checkMethods();
        List<Method> methods = this.methods.get(method);
        if (methods != null) {
            for (Method current : methods) {
                if (!current.canBeCalled(arguments)) continue;
                mtd = current;
                break;
            }
        }
        return mtd;
    }

    private Method findMethod(String name) throws Throwable {
        Object[] args = new Object[]{};
        return this.findMethod(name, args);
    }
}

