/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.bpm.collections.Tuple;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.script.ClassBuilder;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptClassLoader
extends ClassLoader {
    @NotNull
    private final ClassBuilder builder;
    private static final boolean DEBUG = true;

    public ScriptClassLoader(@Nullable ClassLoader parent, @NotNull ComponentCatalog catalog) {
        super(parent);
        this.builder = new ClassBuilder(catalog);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.log("Finding: " + name);
        try {
            if (name == null) {
                throw new IllegalArgumentException("class name cannot be null");
            }
            Tuple<String, byte[]> classData = this.builder.buildClass(name);
            if (classData == null) {
                throw new ClassNotFoundException(name);
            }
            String className = classData.getFirst();
            byte[] bytecode = classData.getSecond();
            this.dump(className, bytecode);
            return this.defineClass(className, bytecode, 0, bytecode.length);
        }
        catch (AmbiguousTypeNameException e) {
            throw (ClassNotFoundException)new ClassNotFoundException(name).initCause(e);
        }
    }

    private void dump(String className, byte[] bytecode) {
        File home = new File(System.getProperty("user.home"));
        File classFile = new File(home, className + ".class");
        this.log("Writing: " + classFile);
        try {
            FileOutputStream fos = new FileOutputStream(classFile);
            StreamUtils.copy(new ByteArrayInputStream(bytecode), fos);
            StreamUtils.close(fos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void log(Object msg) {
        System.out.println("[ScriptClassLoader] " + msg);
    }
}

