/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.script;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bcgen.ClassCode;
import oracle.bpm.bcgen.FieldD;
import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.MethodD;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Tuple;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.script.runtime.CompiledMethod;
import oracle.bpm.script.runtime.RuntimeHelper;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassBuilder {
    @NotNull
    private final ComponentCatalog catalog;
    private static final Function<MethodTypeDescription, AttributeTypeDescription> AS_ATTRIBUTE = new Function<MethodTypeDescription, AttributeTypeDescription>(){

        @Override
        public AttributeTypeDescription eval(MethodTypeDescription value) {
            return value.asAttribute();
        }
    };
    private static final ObjectType XML_OBJECT_TYPE = TD.getObjectType(XMLObject.class);
    private static final ObjectType COMPILED_METHOD_OBJECT_TYPE = TD.getObjectType(CompiledMethod.class);
    private static final ObjectType RUNTIME_HELPER_OBJECT_TYPE = TD.getObjectType(RuntimeHelper.class);
    private static final String[] NO_NAMES = new String[0];
    private static final String UNWRAP_MTD_NAME = "$unwrap";
    private static final String WRAP_MTD_NAME = "$wrap";
    private static final Type[] WRAP_MTD_ARGS = new Type[]{XML_OBJECT_TYPE};

    public ClassBuilder(@NotNull ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    @Nullable
    Tuple<String, byte[]> buildClass(@NotNull String name) throws AmbiguousTypeNameException {
        TypeRef typeRef = this.catalog.find(name);
        if (typeRef == null) {
            return null;
        }
        TypeDescription type = typeRef.get();
        if (type == null || !type.isBpmObject()) {
            return null;
        }
        XObjectTypeDescription xotd = (XObjectTypeDescription)type;
        return this.buildClass(xotd);
    }

    private Tuple<String, byte[]> buildClass(XObjectTypeDescription xotd) {
        String className = xotd.getText();
        ClassCode cls = ClassCode.create((ModSet)Mod.PUBLIC, (String)className, (String)"java.lang.Object", (String)xotd.asSchemaObject().getLocation());
        List<MethodTypeDescription> attributes = xotd.isBpmObject() ? BpmObjectTypeDescriptionHelper.getAttributes((ObjectTypeDescription)xotd) : xotd.getAttributes();
        FieldD instanceField = cls.addField(Mod.PRIVATE.FINAL(), (Type)XML_OBJECT_TYPE, "xmlInstance");
        this.buildConstructors(xotd, cls, instanceField);
        for (AttributeTypeDescription attribute : CollectionUtils.asSequence(attributes).map(AS_ATTRIBUTE)) {
            this.buildAttribute(cls, instanceField, attribute);
        }
        for (MethodTypeDescription method : xotd.getMembers(14)) {
            this.buildMethod(cls, method);
        }
        this.addToString(cls, instanceField);
        return Tuple.create(className, this.dumpClass(cls));
    }

    private void buildMethod(@NotNull ClassCode cls, @NotNull MethodTypeDescription method) {
        if (!method.isConstructor()) {
            JVMCodeBuilder cb = this.createMethod(cls, method);
            SourceCode sourceCode = method.getCode();
            if (sourceCode != null) {
                FieldD compiledMtdField = this.generateCompiledMethodField(cls, cb, method);
                this.generateCompiledMethodCall(method, cb, compiledMtdField);
                TypeDescription resultType = method.getResultType();
                Type resultBcelType = this.typeOf(resultType);
                if (resultType.isPredefined() && resultType.isPrimitive()) {
                    this.unbox(cb, resultType);
                } else if (resultType.isVoid()) {
                    cb.pop();
                } else {
                    cb.convert(resultBcelType);
                }
            } else if (!method.getResultType().isVoid()) {
                cb.loadNull();
            }
            cb.retrn();
            cb.endCode();
        }
    }

    private void generateCompiledMethodCall(MethodTypeDescription method, JVMCodeBuilder cb, FieldD compiledMtdField) {
        cb.loadThis();
        cb.loadField(compiledMtdField);
        this.makeArgumentArray(cb, method);
        MethodD invoke = MethodD.create((Type)TD.OBJECT, (ObjectType)COMPILED_METHOD_OBJECT_TYPE, (String)"invoke", (Type[])new Type[]{TD.OBJECT_ARRAY});
        invoke.setReferencesInterface(MethodD.ReferencesInterface.YES);
        cb.invoke(invoke);
    }

    private FieldD generateCompiledMethodField(@NotNull ClassCode cls, @NotNull JVMCodeBuilder cb, @NotNull MethodTypeDescription method) {
        FieldD compiledMtdField = cls.addField((ModSet)Mod.PRIVATE, (Type)COMPILED_METHOD_OBJECT_TYPE, "$mtd_" + method.getName());
        cb.loadThis();
        cb.loadField(compiledMtdField);
        cb.beginIf();
        cb.compareNull(false);
        cb.addThen();
        cb.loadThis();
        this.generateCompiledMethod(cb, method);
        cb.storeField(compiledMtdField);
        cb.endIf();
        return compiledMtdField;
    }

    private void generateCompiledMethod(@NotNull JVMCodeBuilder cb, @NotNull MethodTypeDescription method) {
        cb.loadThis();
        Object[] argNames = new String[method.getArgumentCount()];
        for (int i = 0; i < argNames.length; ++i) {
            argNames[i] = method.getArgument(i).getName();
        }
        cb.createArray(TD.STRING_ARRAY, argNames);
        SourceCode sourceCode = method.getCode();
        cb.loadConstant(sourceCode.getLanguage());
        cb.loadConstant(sourceCode.asString());
        Type[] argTypes = new Type[]{TD.OBJECT, TD.STRING_ARRAY, TD.STRING, TD.STRING};
        MethodD compileMethod = MethodD.createStatic((Type)COMPILED_METHOD_OBJECT_TYPE, (ObjectType)RUNTIME_HELPER_OBJECT_TYPE, (String)"$compileMethod", (Type[])argTypes);
        compileMethod.setReferencesInterface(MethodD.ReferencesInterface.NO);
        cb.invoke(compileMethod);
    }

    private void makeArgumentArray(JVMCodeBuilder cb, MethodTypeDescription method) {
        int count = method.getArgumentCount();
        cb.createArray(TD.OBJECT_ARRAY, count);
        for (int i = 0; i < count; ++i) {
            cb.dup();
            cb.loadConstant(i);
            Argument argument = method.getArgument(i);
            TypeDescription argType = argument.getType();
            cb.loadArgument(i);
            if (argType.isPrimitive()) {
                this.box(cb, argType);
            }
            cb.arrayStore();
        }
    }

    private JVMCodeBuilder createMethod(ClassCode cls, MethodTypeDescription method) {
        TypeDescription resultType = method.getResultType();
        ArrayList<String> argNames = new ArrayList<String>(method.getArgumentCount());
        ArrayList<Type> argTypes = new ArrayList<Type>(method.getArgumentCount());
        for (int i = 0; i < method.getArgumentCount(); ++i) {
            Argument argument = method.getArgument(i);
            argNames.add(argument.getName() == null ? "arg" + i : argument.getName());
            argTypes.add(this.typeOf(argument.getType()));
        }
        return cls.addMethod((ModSet)Mod.PUBLIC, this.typeOf(resultType), method.getName(), argTypes.toArray(new Type[argTypes.size()]), argNames.toArray(new String[argNames.size()]), null);
    }

    private byte[] dumpClass(ClassCode cls) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            cls.save((OutputStream)baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    private void buildConstructors(XObjectTypeDescription xotd, ClassCode cls, FieldD instanceField) {
        try {
            XmlTypeDescription attributesObject = BpmObjectTypeDescriptionHelper.getAttributesObject((ObjectTypeDescription)xotd);
            this.addNoArgConstructor(cls, instanceField, attributesObject);
            this.addXmlObjectConstructor(cls, instanceField);
            this.addWrapMethod(cls);
            this.addUnWrapMethod(cls, instanceField);
        }
        catch (BpmObjectTypeDescriptionHelper.CannotFindAttributesObjectException e) {
            cls.addConstructor((ModSet)Mod.PUBLIC);
        }
    }

    private void addToString(@NotNull ClassCode cls, @NotNull FieldD instanceField) {
        JVMCodeBuilder cb = cls.addMethod((ModSet)Mod.PUBLIC, (Type)TD.STRING, "toString", Type.NO_ARGS, NO_NAMES, Type.NO_ARGS);
        cb.loadThis();
        cb.loadField(instanceField);
        cb.invoke(MethodD.create((Type)TD.STRING, (ObjectType)XML_OBJECT_TYPE, (String)"toString", (Type[])new Type[0]));
        cb.retrn();
        cb.endCode();
    }

    private void addNoArgConstructor(@NotNull ClassCode cls, @NotNull FieldD instanceField, @NotNull XmlTypeDescription attributesObject) {
        JVMCodeBuilder cb = cls.addConstructor((ModSet)Mod.PUBLIC, Type.NO_ARGS, NO_NAMES);
        cb.loadThis();
        cb.dup();
        cb.invokeSuperConstructor(Type.NO_ARGS);
        cb.newObject((Type)XML_OBJECT_TYPE);
        cb.dup();
        cb.loadConstant(attributesObject.getName());
        cb.loadConstant(attributesObject.getNamespace());
        cb.loadConstant(attributesObject.isElementsAreQualified());
        Type[] argTypes = new Type[]{TD.STRING, TD.STRING, TD.BOOLEAN};
        cb.invokeConstructor(XML_OBJECT_TYPE, argTypes);
        cb.dup();
        cb.loadConstant(attributesObject.getText());
        cb.invoke(MethodD.create((Type)Type.VOID, (ObjectType)XML_OBJECT_TYPE, (String)"setFuegoName", (Type[])new Type[]{TD.STRING}));
        cb.storeField(instanceField);
        cb.retrn();
        cb.endCode();
    }

    private void addXmlObjectConstructor(@NotNull ClassCode cls, @NotNull FieldD instanceField) {
        Type[] argTypes = WRAP_MTD_ARGS;
        String[] argNames = new String[]{"xmlInstance"};
        JVMCodeBuilder cb = cls.addConstructor((ModSet)Mod.PRIVATE, argTypes, argNames);
        cb.loadThis();
        cb.invokeSuperConstructor(Type.NO_ARGS);
        cb.loadThis();
        cb.loadArgument(0);
        cb.storeField(instanceField);
        cb.retrn();
        cb.endCode();
    }

    private void addWrapMethod(@NotNull ClassCode cls) {
        String[] argNames = new String[]{"xmlInstance"};
        JVMCodeBuilder cb = cls.addMethod(Mod.PUBLIC.STATIC(), (Type)cls.getType(), WRAP_MTD_NAME, WRAP_MTD_ARGS, argNames, Type.NO_ARGS);
        cb.loadArgument(0);
        cb.beginIf();
        cb.compareNull(true);
        cb.addThen();
        ObjectType thiz = cls.getType();
        cb.newObject((Type)thiz);
        cb.dup();
        cb.loadArgument(0);
        cb.invokeConstructor(thiz, (Type)XML_OBJECT_TYPE);
        cb.addElse();
        cb.loadNull();
        cb.endIf();
        cb.retrn();
        cb.endCode();
    }

    private void addUnWrapMethod(@NotNull ClassCode cls, @NotNull FieldD instanceField) {
        JVMCodeBuilder cb = cls.addMethod((ModSet)Mod.PUBLIC, (Type)XML_OBJECT_TYPE, UNWRAP_MTD_NAME, Type.NO_ARGS, NO_NAMES, Type.NO_ARGS);
        cb.loadThis();
        cb.loadField(instanceField);
        cb.retrn();
        cb.endCode();
    }

    private void buildAttribute(@NotNull ClassCode cls, @NotNull FieldD instanceField, @NotNull AttributeTypeDescription attribute) {
        if (attribute.hasGetter()) {
            this.buildGetter(cls, instanceField, attribute);
        }
        if (attribute.hasSetter()) {
            this.buildSetter(cls, instanceField, attribute);
        }
    }

    private void buildSetter(@NotNull ClassCode cls, @NotNull FieldD instanceField, @NotNull AttributeTypeDescription attribute) {
        String capitalized = Identifier.capitalize(attribute.getName());
        TypeDescription resultType = attribute.getResultType();
        Type attributeType = this.typeOf(resultType);
        JVMCodeBuilder cb = cls.addMethod((ModSet)Mod.PUBLIC, TD.VOID, "set" + capitalized, new Type[]{attributeType}, new String[]{"value"}, null);
        if (resultType.isPredefined() || resultType.isBpmObject()) {
            cb.loadThis();
            cb.loadField(instanceField);
            cb.loadConstant(attribute.getWriteSignature());
            cb.loadArgument(0);
            if (resultType.isBpmObject()) {
                this.unwrap(cb, attributeType);
            } else if (resultType.isPrimitive()) {
                this.box(cb, resultType);
            }
            cb.invoke(MDKit.INVOKEABLE_SET_ATTR);
            cb.pop();
        }
        cb.retrn();
        cb.endCode();
    }

    private void buildGetter(@NotNull ClassCode cls, @NotNull FieldD instanceField, @NotNull AttributeTypeDescription attribute) {
        String capitalized = Identifier.capitalize(attribute.getName());
        TypeDescription resultType = attribute.getResultType();
        Type attributeType = this.typeOf(resultType);
        JVMCodeBuilder cb = cls.addMethod((ModSet)Mod.PUBLIC, attributeType, "get" + capitalized, null, null, null);
        cb.loadThis();
        cb.loadField(instanceField);
        cb.loadConstant(attribute.getReadSignature());
        cb.invoke(MDKit.GET_ATTRIBUTE);
        if (resultType.isPredefined()) {
            if (resultType.isPrimitive()) {
                this.unbox(cb, resultType);
            } else {
                cb.convert(attributeType);
            }
        } else if (resultType.isBpmObject()) {
            cb.convert((Type)XML_OBJECT_TYPE);
            cb.invoke(MethodD.createStatic((Type)attributeType, (ObjectType)((ObjectType)attributeType), (String)WRAP_MTD_NAME, (Type[])WRAP_MTD_ARGS));
        } else {
            cb.pop();
            cb.loadNull();
        }
        cb.retrn();
        cb.endCode();
    }

    private void unwrap(JVMCodeBuilder cb, Type boType) {
        cb.dup();
        cb.beginIf();
        cb.compareNull(false);
        cb.addThen();
        cb.pop();
        cb.loadNull();
        cb.addElse();
        MethodD unwrapMtd = MethodD.create((Type)XML_OBJECT_TYPE, (ObjectType)((ObjectType)boType), (String)UNWRAP_MTD_NAME, (Type[])Type.NO_ARGS);
        unwrapMtd.setReferencesInterface(MethodD.ReferencesInterface.NO);
        cb.invoke(unwrapMtd);
        cb.endIf();
    }

    private void unbox(@NotNull JVMCodeBuilder cb, @NotNull TypeDescription newType) {
        if (newType.isInt() || newType.isEnum()) {
            cb.invoke(MDKit.OBJ_TO_LONG);
            cb.convert(TD.valueOf((TypeDescription)newType));
        } else if (newType.isReal()) {
            cb.invoke(MDKit.OBJ_TO_DOUBLE);
            cb.convert(TD.valueOf((TypeDescription)newType));
        } else if (newType.isBool()) {
            cb.invoke(MDKit.OBJ_TO_BOOLEAN);
        } else {
            cb.convert(TD.valueOf((TypeDescription)newType));
        }
    }

    private void box(@NotNull JVMCodeBuilder cb, @NotNull TypeDescription resultType) {
        ObjectType type = TD.getObjectType((TypeDescription)resultType.primitiveEquivalent(false));
        MethodD md = MDKit.getBoxMethod((String)type.getClassName());
        cb.convert(md.getArgType(0));
        cb.invoke(md);
    }

    private Type typeOf(TypeDescription type) {
        return type.isBpmObject() ? TD.getObjectType((String)type.getText()) : TD.valueOf((TypeDescription)type);
    }
}

