/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.persistence;

import com.collaxa.cube.admin.adaptors.common.SchemaVersion;
import com.collaxa.cube.persistence.BpelSessionCustomizer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.bpmn.engine.service.persistence.BPMNSchemaFeatureBuilder;
import oracle.bpm.bpmn.engine.service.persistence.version.BPMNBaseSchemaFeatureBuilder;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;

public class BPMNSessionCustomizer
extends BpelSessionCustomizer {
    private Logger mLogger = Logger.getLogger("oracle.bpm.bpmn.engine.service.persistence");

    public void customize(Session session) {
        session.getEventManager().addListener((SessionEventListener)new MyListener());
    }

    public class MyListener
    extends BpelSessionCustomizer.MyListener {
        public MyListener() {
            super((BpelSessionCustomizer)BPMNSessionCustomizer.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preLogin(SessionEvent event) {
            super.preLogin(event);
            Session session = event.getSession();
            DatabaseLogin login = (DatabaseLogin)session.getDatasourceLogin();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = (Connection)login.connectToDatasource(null, session);
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SELECT GUID from VERSION");
                if (rs.next()) {
                    String version = rs.getString(1);
                    SchemaVersion dbVersion = new SchemaVersion();
                    dbVersion.setDbVersion(version);
                    dbVersion.setExpectedVersion("11.1.1.7.0");
                    BPMNSchemaFeatureBuilder schemaFeatureBuilder = BPMNBaseSchemaFeatureBuilder.createSchemaFeatureBuilder(dbVersion);
                    ((BPMNBaseSchemaFeatureBuilder)schemaFeatureBuilder).disableSchemaFeatures(session);
                }
            }
            catch (Exception e) {
                BPMNSessionCustomizer.this.mLogger.log(Level.SEVERE, "[class: oracle.bpm.bpmn.engine.service.persistence.version.BPMNSessionCustomizer.MyListener] [method: preLogin] Exception occured in Session Customizer listener", e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e1) {
                        BPMNSessionCustomizer.this.mLogger.log(Level.SEVERE, "[class: oracle.bpm.bpmn.engine.service.persistence.version.BPMNSessionCustomizer.MyListener] [method: preLogin] Exception occured in Session Customizer listener", e1);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e1) {
                        BPMNSessionCustomizer.this.mLogger.log(Level.SEVERE, "[class: oracle.bpm.bpmn.engine.service.persistence.version.BPMNSessionCustomizer.MyListener] [method: preLogin] Exception occured in Session Customizer listener", e1);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        BPMNSessionCustomizer.this.mLogger.log(Level.SEVERE, "[class: oracle.bpm.bpmn.engine.service.persistence.version.BPMNSessionCustomizer.MyListener] [method: preLogin] Exception occured in Session Customizer listener", e);
                    }
                }
            }
        }
    }
}

