/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.persistence;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableValuesExt;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditSequence;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.util.ByteArray;
import org.jetbrains.annotations.NotNull;

public class AuditPersistence {
    private EntityManager mEntityManager;
    private static final Class logClassName = AuditPersistence.class;

    public AuditPersistence(EntityManager em) {
        this.mEntityManager = em;
    }

    public Object persistEntity(Object entity) throws AuditPersistenceException {
        EntityManager em = this.getEntityManager();
        em.persist(entity);
        return entity;
    }

    public Long getNextIDFromStore(String sequenceName, int extent) throws AuditPersistenceException {
        String logMethodName = "getNextIDFromStore";
        Long nextID = null;
        try {
            Query q = this.getEntityManager().createNamedQuery("auditSequence.selectForUpdate").setParameter("sequenceName", (Object)sequenceName);
            AuditSequence as = (AuditSequence)q.getSingleResult();
            nextID = as.getSeqCount();
            as.setSeqCount(as.getSeqCount() + (long)extent);
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.debug(AuditPersistence.class, "getNextIDFromStore", new Object[]{"Problem obtaining the sequence information {" + sequenceName + "} {" + extent + "} " + e.toString(), e});
            throw new AuditPersistenceException("Problem obtaining the sequence information {" + sequenceName + "} {" + extent + "} " + e.toString(), e);
        }
        return nextID;
    }

    public List<AuditQueryVariableMetadata> queryAuditQueryAttributesFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQueryAttributes.findAll").getResultList();
    }

    public List<AuditQueryVariableMetadata> queryAuditQueryAttributesFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryAttributes.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQueryVariableValuesExt> queryAuditQueryAttrValuesExtFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQueryAttrValuesExt.findAll").getResultList();
    }

    public List<AuditQueryVariableValuesExt> queryAuditQueryAttrValuesExtFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryAttrValuesExt.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAll() throws AuditPersistenceException {
        return this.getEntityManager().createNamedQuery("AuditQuery.findAll").getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAllByRange(int firstResult, int maxResults) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQuery.findAll");
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            query = query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public List<AuditQuery> queryAuditQueryFindAllbyProcessId(String processId) throws AuditPersistenceException {
        List result = null;
        result = this.getEntityManager().createNamedQuery("AuditQuery.findAllByInstanceId").setParameter("instanceId", (Object)processId).getResultList();
        return result;
    }

    @Deprecated
    public List<AuditQuery> getActiveInstancesAsOfQueryId(long queryId) throws AuditPersistenceException {
        List<AuditQuery> result = null;
        return result;
    }

    @Deprecated
    public List<AuditQuery> getAllInstancesAfterQueryId(long queryId) throws AuditPersistenceException {
        List<AuditQuery> result = null;
        return result;
    }

    @NotNull
    public List<AuditQuery> queryAudit(int firstResult, int resultPageSize, boolean active, int totalResults, Calendar referenceTime, long backTrackTime) throws AuditPersistenceException {
        List result = null;
        boolean hasRefTime = referenceTime != null;
        boolean hasRange = totalResults > 0;
        StringBuffer qStr = new StringBuffer("select * from bpm_audit_query a where ");
        if (hasRange) {
            qStr.append("(? = 0 OR ROWNUM < ? ) ");
        }
        if (hasRefTime) {
            qStr.append((hasRange ? "AND " : "") + "a.ci_partition_date >= ? " + "AND a.ci_partition_date <= ? ");
        }
        if (hasRefTime || hasRange) {
            qStr.append("AND ");
        }
        qStr.append("(? = 'N' OR NOT exists (select 1 from bpm_audit_query b where b.component_instance_id = a.component_instance_id and operation in ('STALE_ABORTED', 'STALE_COMPLETED', 'INSTANCE_SYSTEM_FAULT', 'INSTANCE_TERMINATED', 'FLOW_NODE_CANCELLED'))) order by a.create_time");
        int p = 1;
        Query query = this.getEntityManager().createNativeQuery(qStr.toString(), AuditQuery.class);
        if (hasRange) {
            query.setParameter(p++, (Object)totalResults);
            query.setParameter(p++, (Object)totalResults);
        }
        if (hasRefTime) {
            Calendar startTime = Calendar.getInstance();
            startTime.setTime(new Date(referenceTime.getTimeInMillis() - backTrackTime));
            query.setParameter(p++, startTime, TemporalType.TIMESTAMP);
            query.setParameter(p++, referenceTime, TemporalType.TIMESTAMP);
        }
        query.setParameter(p++, (Object)(active ? "Y" : "N"));
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (resultPageSize > 0) {
            query = query.setMaxResults(resultPageSize);
        }
        result = query.getResultList();
        return result;
    }

    public List<AuditQuery> queryAudit(String expression, Map<String, Object> parameters) throws AuditPersistenceException {
        String logMethodName = "queryAudit";
        Query query = null;
        if (expression != null) {
            query = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE " + expression);
            if (parameters != null) {
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    query.setParameter(parameter.getKey(), parameter.getValue());
                }
            }
        }
        return query.getResultList();
    }

    public List<AuditQuery> queryAudit(String tablePrefix, String expression, String orderBy, Map<String, Object> parameters, int firstResult, int resultPageSize) throws AuditPersistenceException {
        String logMethodName = "queryAudit";
        Query query = null;
        if (expression != null) {
            String exp1 = "SELECT aq FROM AuditQuery aq WHERE ";
            if (tablePrefix != null && tablePrefix.length() > 0) {
                exp1 = exp1.replaceAll("aq", tablePrefix);
            }
            StringBuffer expr = new StringBuffer();
            expr.append(exp1).append(expression).append(orderBy != null && orderBy.length() > 0 ? " ORDER BY " + orderBy : "");
            query = this.getEntityManager().createQuery(expr.toString());
            if (parameters != null) {
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    query.setParameter(parameter.getKey(), parameter.getValue());
                }
            }
        } else {
            return null;
        }
        if (firstResult > 0) {
            query = query.setFirstResult(firstResult);
        }
        if (resultPageSize > 0) {
            query = query.setMaxResults(resultPageSize);
        }
        return query.getResultList();
    }

    public AuditQueryMetadata getAuditQueryMetadata(String compositeDN) throws AuditPersistenceException {
        String logMethodName = "getAuditQueryMetadata";
        AuditQueryMetadata result = null;
        try {
            result = (AuditQueryMetadata)this.getEntityManager().find(AuditQueryMetadata.class, (Object)compositeDN);
            return result;
        }
        catch (NoResultException e) {
            BPELExecutionLogger.LOG.debug(AuditPersistence.class, "getAuditQueryMetadata", new Object[]{"No audit metadata found for compositeDN {" + compositeDN + "}", e});
            return null;
        }
    }

    public AuditQueryMetadata getPreviousAuditQueryMetadata(CompositeDNModel cm) throws AuditPersistenceException {
        String logMethodName = "getPreviousAuditQueryMetadata";
        List result = null;
        Query q = this.getEntityManager().createNamedQuery("AuditQueryMetadata.findDeployment").setParameter("appName", (Object)cm.getApplicationName()).setParameter("compositeName", (Object)cm.getCompositeName());
        result = q.getResultList();
        if (result.size() > 0) {
            return (AuditQueryMetadata)result.get(0);
        }
        return null;
    }

    public ByteArray getAuditQueryLog(long queryId) throws AuditPersistenceException {
        Query query = this.getEntityManager().createQuery("SELECT NEW oracle.bpm.util.ByteArray(a.auditLog) FROM AuditQuery a WHERE a.queryId = :queryId AND a.auditLog IS NOT NULL");
        query.setParameter("queryId", (Object)queryId);
        ByteArray result = null;
        try {
            result = (ByteArray)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    public ByteArray getAuditDetail(long ciKey, long detailId) throws AuditPersistenceException {
        Query query = this.getEntityManager().createQuery("SELECT NEW oracle.bpm.util.ByteArray(ad.bin) FROM AuditQueryDetails ad WHERE ad.cikey = :ciKey AND ad.detailId = :detailId AND ad.bin IS NOT NULL");
        query.setParameter("ciKey", (Object)ciKey);
        query.setParameter("detailId", (Object)detailId);
        ByteArray result = null;
        try {
            result = (ByteArray)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    public List<AuditQueryVariableRange> getAllVariableRanges(String compositeDN) throws AuditPersistenceException {
        Query query = this.getEntityManager().createNamedQuery("AuditQueryVariableRange.getAllRanges");
        query.setParameter("compositeDN", (Object)compositeDN);
        List result = null;
        result = query.getResultList();
        return result;
    }

    public Integer getLastDetailId(Long ciKey) {
        String logMethodName = "getLastDetailId";
        Integer result = null;
        try {
            Query query = this.getEntityManager().createNamedQuery("AuditQueryDetails.getDetailsId");
            query.setParameter("cikey", (Object)ciKey);
            result = (Integer)query.getSingleResult();
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.debug(AuditPersistence.class, "getLastDetailId", new Object[]{"Unable to get the number of items ", e});
            result = null;
        }
        return result;
    }

    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws AuditPersistenceException {
        return this.queryEventFor("queryLastEventforCompositeDN", "compositeDN", compositeDN, firstResult, maxResult, "Located end record");
    }

    public long markAuditAsStale(String compositeDN, long batchSize, long state) throws AuditPersistenceException {
        String logMethodName = "queryLastEventforCompositeDN ";
        AuditQueryMetadata md = this.getAuditQueryMetadata(compositeDN);
        if (md != null) {
            md.setStatus(state);
        }
        long result = 0L;
        return result;
    }

    public AuditQueryVariableMetadata findAuditQueryVariableMetadata(String compositeDN) {
        return (AuditQueryVariableMetadata)this.mEntityManager.find(AuditQueryVariableMetadata.class, (Object)compositeDN);
    }

    public List<AuditQuery> queryLastEventforCompositeId(String compositeInstanceId) throws AuditPersistenceException {
        return this.queryEventFor("getLastEventforCompositeId", "compositeId", compositeInstanceId, -1, -1, "Located end record");
    }

    public List<AuditQuery> queryFirstEventforCompositeId(String compositeInstanceId) throws AuditPersistenceException {
        return this.queryEventFor("getFirstEventforCompositeId", "compositeId", compositeInstanceId, -1, -1, "Located start record");
    }

    public List<AuditQuery> queryLastEventforComponentId(String componentInstanceId) throws AuditPersistenceException {
        return this.queryEventFor("getLastEventforComponentId", "componentId", componentInstanceId, -1, -1, "Located end record");
    }

    public List<AuditQuery> queryFirstEventforComponentId(String componentInstanceId) throws AuditPersistenceException {
        return this.queryEventFor("getFirstEventforComponentId", "componentId", componentInstanceId, -1, -1, "Located start record");
    }

    public List<AuditQuery> queryAbortedEventsforCompositeId(String compositeInstanceId) throws AuditPersistenceException {
        return this.queryEventFor("getAbortEventforCompositeId", "compositeId", compositeInstanceId, -1, -1, "Located aborted records");
    }

    @Deprecated
    public void setEntityManager(EntityManager em) {
        this.mEntityManager = em;
    }

    private EntityManager getEntityManager() throws AuditPersistenceException {
        String logMethodName = logClassName + ".getEntityManager ";
        if (this.mEntityManager == null) {
            throw new AuditPersistenceException(logMethodName + "Unable to locate the Entity Manager");
        }
        return this.mEntityManager;
    }

    private List<AuditQuery> queryEventFor(String queryName, String fieldName, String fieldValue, int firstResult, int maxResult, String logMessage) throws AuditPersistenceException {
        Query query1 = this.getEntityManager().createNamedQuery("AuditQuery." + queryName);
        query1.setParameter(fieldName, (Object)fieldValue);
        if (firstResult > 0) {
            query1.setFirstResult(firstResult);
        }
        if (maxResult > 0) {
            query1.setMaxResults(maxResult);
        }
        List queryResult = query1.getResultList();
        TreeMap<String, Long> queryIds = new TreeMap<String, Long>();
        StringBuffer parameterIds = new StringBuffer();
        int j = 0;
        Iterator i = queryResult.iterator();
        while (i.hasNext()) {
            String key = "p" + j;
            Object[] vals = (Object[])i.next();
            queryIds.put(key, ((Number)vals[1]).longValue());
            parameterIds.append(":").append(key).append(i.hasNext() ? "," : "");
            ++j;
        }
        BPELExecutionLogger.LOG.debug(AuditPersistence.class, queryName, new Object[]{logMessage + " {" + fieldValue + "} First, Max {" + firstResult + ", " + maxResult + "} {" + queryIds.values() + "}"});
        List result = null;
        if (queryIds.size() > 0) {
            Query query2 = this.getEntityManager().createQuery("SELECT aq FROM AuditQuery aq WHERE aq.queryId in ( " + parameterIds + ") ");
            for (Map.Entry entry : queryIds.entrySet()) {
                query2.setParameter((String)entry.getKey(), entry.getValue());
            }
            result = query2.getResultList();
        }
        return result;
    }
}

