/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.persistence;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import java.util.concurrent.atomic.AtomicLong;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.soa.management.config.bpmn.BPMNConfig;
import org.jetbrains.annotations.NotNull;

public class AuditKeyGenerator {
    private Integer auditKeyExtents;
    private AtomicLong mKey;
    private static final Object lockObj = new Object();
    private static AuditKeyGenerator instance;
    public static final String AUDIT_SEQUENCE = "AUDIT_QUERY_SEQ";
    public static final String AUDIT_SEQUENCE_EXT = "AUDIT_QUERY_SEQ_EXT";
    private static final Integer DEFAULT_AUDIT_KEY_EXTENTS;
    private static final Class logClassName;

    private AuditKeyGenerator() {
    }

    public static AuditKeyGenerator getInstance() throws Exception {
        if (instance == null) {
            instance = new AuditKeyGenerator();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId(@NotNull ICubeContext ctx) throws Exception {
        String logMethodName = "nextId";
        long key = 0L;
        Object object = lockObj;
        synchronized (object) {
            if (this.auditKeyExtents == null) {
                this.auditKeyExtents = this.getAuditKeyExtent(ctx);
            }
            if (this.mKey == null) {
                this.mKey = new AtomicLong(AuditKeyGenerator.nextIDFromStore(ctx, this.auditKeyExtents));
                key = this.mKey.get();
            } else {
                key = this.mKey.addAndGet(1L);
                if (key % (long)this.auditKeyExtents.intValue() == 0L) {
                    this.mKey.set(AuditKeyGenerator.nextIDFromStore(ctx, this.auditKeyExtents));
                    key = this.mKey.get();
                }
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "nextId", new Object[]{"Generated ID {" + this.mKey + "}"});
        return key;
    }

    private static Long nextIDFromStore(ICubeContext ctx, Integer extent) throws AuditPersistenceException {
        String logMethodName = "nextIDFromStore";
        Long nextId = null;
        try {
            nextId = AuditUtil.nextIDFromStore(ctx, AUDIT_SEQUENCE, extent);
            if (nextId == 0L) {
                nextId = 1L;
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "nextIDFromStore", new Object[]{"Unable to obtain the next ID ", AUDIT_SEQUENCE, e});
            throw new AuditPersistenceException("Unable to obtain the next ID {AUDIT_QUERY_SEQ}" + e.toString(), e);
        }
        return nextId;
    }

    private Integer getAuditKeyExtent(ICubeContext ctx) throws Exception {
        BPMNConfig config;
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        Integer ext = this.restoreKeyExt(ctx);
        if (ext == null && serviceEngine != null && (config = serviceEngine.getBPMNConfig()) != null) {
            ext = config.getAuditKeyExtents();
        }
        return ext != null ? ext : DEFAULT_AUDIT_KEY_EXTENTS;
    }

    private Integer restoreKeyExt(ICubeContext ctx) throws Exception {
        String logMethodName = "restoreKeyExt";
        Integer ext = null;
        if (ctx != null) {
            ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
            if (cubeInstance != null && !cubeInstance.getScopeContext().getRootScope().contains(AUDIT_SEQUENCE_EXT)) {
                cubeInstance.getScopeContext().getRootScope().declare(AUDIT_SEQUENCE_EXT);
            }
            ext = (Integer)(cubeInstance != null ? cubeInstance.getScopeContext().getRootScope().getObject(AUDIT_SEQUENCE_EXT) : null);
            BPELExecutionLogger.LOG.debug(logClassName, "restoreKeyExt", new Object[]{"Restoring Ext {" + (ext != null ? ext.toString() : "NOT_SET") + "}"});
        }
        return ext;
    }

    static {
        DEFAULT_AUDIT_KEY_EXTENTS = 1000;
        logClassName = AuditKeyGenerator.class;
    }
}

