/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.payload;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AuditExpressionExecution
implements Serializable {
    private String elementId;
    private String expression;
    private GatewayType gatewayType;
    private boolean result;
    private String sequenceFlowId;
    private String sequenceFlowLabel;
    private String sourceId;
    private String sourceLabel;
    private String targetId;
    private String targetLabel;
    public static final String AUDIT_GATEWAY_EXECUTION = "AUDIT_GATEWAY_EXECUTION";
    private static final String ELEMENT_ID = "ELEMENT_ID";
    private static final String EXPRESSION = "EXPRESSION";
    private static final String GATEWAY_TYPE = "GATEWAY_TYPE";
    private static final String RESULT = "RESULT";
    private static final String SEQUENCE_FLOW_ID = "SEQUENCE_FLOW_ID";
    private static final String SEQUENCE_FLOW_LABEL = "SEQUENCE_FLOW_LABEL";
    private static final String SOURCE_ID = "SOURCE_ID";
    private static final String SOURCE_LABEL = "SOURCE_LABEL";
    private static final String TARGET_ID = "TARGET_ID";
    private static final String TARGET_LABEL = "TARGET_LABEL";
    private static final long serialVersionUID = 1L;

    public AuditExpressionExecution(Map<String, String> map) {
        this.expression = map.get(EXPRESSION);
        this.result = Boolean.parseBoolean(map.get(RESULT));
        this.elementId = map.get(ELEMENT_ID);
        this.sourceId = map.get(SOURCE_ID);
        this.targetId = map.get(TARGET_ID);
        this.sourceLabel = map.get(SOURCE_LABEL);
        this.targetLabel = map.get(TARGET_LABEL);
        this.sequenceFlowId = map.get(SEQUENCE_FLOW_ID);
        this.sequenceFlowLabel = map.get(SEQUENCE_FLOW_LABEL);
        this.gatewayType = map.get(GATEWAY_TYPE) != null ? GatewayType.valueOf(map.get(GATEWAY_TYPE)) : null;
    }

    public AuditExpressionExecution(@NotNull GatewayType gatewayType, @NotNull String elementId, String sourceId, String targetId, String expression, boolean result) {
        this(gatewayType, elementId, sourceId, null, targetId, null, null, null, expression, result);
    }

    public AuditExpressionExecution(@NotNull GatewayType gatewayType, @NotNull String elementId, String sourceId, String sourceLabel, String targetId, String targetLabel, String sequenceFlowId, String sequenceFlowLabel, String expression, boolean result) {
        this.gatewayType = gatewayType;
        this.expression = expression;
        this.result = result;
        this.elementId = elementId;
        this.sourceId = sourceId;
        this.sourceLabel = sourceLabel;
        this.targetId = targetId;
        this.targetLabel = targetLabel;
        this.sequenceFlowId = sequenceFlowId;
        this.sequenceFlowLabel = sequenceFlowLabel;
    }

    public static String getKey(String activityId) {
        return "AUDIT_GATEWAY_EXECUTION-" + activityId;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setSourceLabel(String sourceLabel) {
        this.sourceLabel = sourceLabel;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public void setTargetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public void setSequenceFlowId(String sequenceFlowId) {
        this.sequenceFlowId = sequenceFlowId;
    }

    public String getSequenceFlowId() {
        return this.sequenceFlowId;
    }

    public void setSequenceFlowLabel(String sequenceFlowLabel) {
        this.sequenceFlowLabel = sequenceFlowLabel;
    }

    public String getSequenceFlowLabel() {
        return this.sequenceFlowLabel;
    }

    public GatewayType getGatewayType() {
        return this.gatewayType;
    }

    public Map<String, String> asSerializable() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ELEMENT_ID, this.elementId);
        map.put(TARGET_ID, this.targetId);
        map.put(SOURCE_ID, this.sourceId);
        map.put(EXPRESSION, this.expression);
        map.put(RESULT, String.valueOf(this.result));
        map.put(SOURCE_LABEL, this.sourceLabel);
        map.put(TARGET_LABEL, this.targetLabel);
        map.put(SEQUENCE_FLOW_ID, this.sequenceFlowId);
        map.put(SEQUENCE_FLOW_LABEL, this.sequenceFlowLabel);
        map.put(GATEWAY_TYPE, this.gatewayType.name());
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\ngatewayType=").append((Object)this.gatewayType).append("\n[").append(this.result).append("=").append(this.expression).append("]").append("\n element=").append(this.elementId).append("\n source=").append(this.sourceId).append(" sourceLabel=\"").append(this.sourceLabel).append("\"\n target=").append(this.targetId).append(" targetLabel=\"").append(this.targetLabel).append("\"\n sequenceFlowId=").append(this.sequenceFlowId).append(" sequenceFlowLabel=\"").append(this.sequenceFlowLabel).append("\"");
        return sb.toString();
    }

    public static enum GatewayType {
        COMPLEX_GATEWAY,
        EXCLUSICE_GATEWAY,
        INCLUSIVE_GATEWAY;

    }
}

