/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit.impl;

import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.util.CompressUtils;
import com.collaxa.cube.engine.util.EngineRecycleBinRegistry;
import com.oracle.bpel.client.util.TransactionUtils;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.impl.MeasurementPublisher;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceRemote;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;
import oracle.bpm.bpmn.engine.service.BPMNInstanceObserver;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.BPMNTransactionSynchronization;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditActivityInfo;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditKeyGenerator;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistence;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryDetails;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.util.ByteArray;
import oracle.soa.common.recycle.IRecyclable;
import oracle.soa.common.recycle.RecycleBin;
import oracle.soa.common.util.CXCompressUtils;
import oracle.soa.common.util.NonSyncStringWriter;
import oracle.soa.common.util.XMLUtil;
import oracle.soa.management.config.bpmn.BPMNConfig;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuditService
implements IAuditService {
    private AuditPersistence auditPersistence;
    private EntityManager em;
    private IMeasurementMetadataServiceLocal mMeasurementService;
    private static final Class logClassName = AuditService.class;
    private static final int BUFFER_LIMIT = 2000;
    private static final long STATUS_ACTIVE = 1L;
    private static final long STATUS_INACTIVE = 0L;
    private static final long STATUS_DELETED = -1L;
    private static final String AUDIT_PAYLOAD_NS = "http://xmlns.oracle.com/bpmn/engine/audit";
    private static final String CDATA_OPENING_TAG = "<![CDATA[";
    private static final String CDATA_CLOSING_TAG = "]]>";
    private static final String CDATA_OPENING_TAG_REGEX = "<!\\[CDATA\\[";
    private static final String CDATA_CLOSING_TAG_REGEX = "]]>";
    private static final String CDATA_CLOSE_OPEN_TAG = "]]]]><![CDATA[>";

    public AuditService(EntityManager em) {
        this.em = em;
        this.auditPersistence = new AuditPersistence(em);
    }

    public static IElementContext getElementContext(IAuditInstance event) {
        IElementContext eCtx = MeasurementUtil.getElementContext((IAuditInstance)event);
        return eCtx;
    }

    public static BPMNAuditTrail getAuditTrail(ICubeContext ctx) throws Exception {
        String logMethodName = "getAuditTrail";
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IAuditTrail auditTrail = cubeInstance.getAuditTrail();
        BPELExecutionLogger.LOG.debug(logClassName, "getAuditTrail", new Object[]{"Obtained an audit trail {" + auditTrail.getClass().getName() + "}"});
        if (auditTrail == null || !(auditTrail instanceof BPMNAuditTrail)) {
            BPELExecutionLogger.LOG.debug(logClassName, "getAuditTrail", new Object[]{"Initializing the BPMNInstanceObserver for Audit Persistence"});
            BPMNAuditTrail bpmnAuditTrail = new BPMNAuditTrail((ICubeInstance)cubeInstance, ctx);
            cubeInstance.setAuditTrail((IAuditTrail)bpmnAuditTrail);
            if (TransactionUtils.isActive()) {
                TransactionSynchronizationRegistry txRegistiry = TransactionUtils.getTransactionSynchronizationRegistry();
                BPMNTransactionSynchronization sync = new BPMNTransactionSynchronization(bpmnAuditTrail, BPMNUtility.getInternalManagementservice(ctx));
                txRegistiry.registerInterposedSynchronization((Synchronization)sync);
            }
            BPMNInstanceObserver.addBPMNObserver(ctx);
            auditTrail = bpmnAuditTrail;
        }
        return (BPMNAuditTrail)auditTrail;
    }

    public void init() throws Exception {
    }

    @Override
    public Long logAuditInstance(ICubeContext ctx, BPMNAuditEvent event) throws AuditPersistenceException {
        String logMethodName = "logAuditEvent ";
        BPELExecutionLogger.LOG.debug(logClassName, "logAuditEvent ", new Object[]{"BEGIN - Adding IAuditInstance to the list to be persisted {" + event.getActivityId() + "}"});
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        event.setCreateTime(c);
        try {
            AuditService.getAuditTrail(ctx).logEvent(event);
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.warn(logClassName, "logAuditEvent ", new Object[]{"Unable to post audit event " + e.toString()});
            throw new AuditPersistenceException(e);
        }
        BPELExecutionLogger.LOG.debug(logClassName, "logAuditEvent ", new Object[]{"END"});
        return event.getQueryId();
    }

    @Override
    public void persistAuditMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> allRanges) throws AuditPersistenceException {
        String logMethodName = "persistAuditMetadata";
        BPELExecutionLogger.LOG.debug(logClassName, "persistAuditMetadata", new Object[]{"BEGIN {" + metadata.getCompositeDn() + "}"});
        AuditPersistence auditPersistency = this.getAuditPersistence();
        if (auditPersistency.getAuditQueryMetadata(metadata.getCompositeDn()) == null) {
            AuditQueryMetadata aqmd = new AuditQueryMetadata();
            aqmd.setCompositeDn(metadata.getCompositeDn());
            aqmd.setStatus(1L);
            CompositeDNModel cm = CompositeDNModel.parseCompositeDN((String)metadata.getCompositeDn());
            aqmd.setApplicationName(cm.getApplicationName());
            aqmd.setCompositeName(cm.getCompositeName());
            aqmd.setLabel(cm.getLabel());
            aqmd.setRevision(cm.getRevision());
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(System.currentTimeMillis());
            aqmd.setCreationDate(c);
            List<AuditQueryVariableMetadata> aqvmd = AuditUtil.createAuditQueryVariableMetadata(metadata, allRanges);
            aqmd.setAuditQueryVariableMetadata(aqvmd);
            auditPersistency.persistEntity(aqmd);
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "persistAuditMetadata", new Object[]{"Variable metadata already exists for the composite domain {" + metadata.getCompositeDn() + "}"});
        }
        BPELExecutionLogger.LOG.debug(logClassName, "persistAuditMetadata", new Object[]{"END"});
    }

    @Override
    public IAuditVariableMetadata getPreviousDeployment(String compositeDn) throws AuditPersistenceException {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        IAuditVariableMetadata result = null;
        CompositeDNModel cm = CompositeDNModel.parseCompositeDN((String)compositeDn);
        AuditQueryMetadata metadata = auditPersistency.getPreviousAuditQueryMetadata(cm);
        if (metadata != null) {
            result = AuditUtil.createAuditVariableMetadata(metadata);
        }
        return result;
    }

    @Override
    @Deprecated
    public void markAuditAsStale(List<AuditQuery> events) throws Exception {
        String logMethodName = "markAuditAsStale";
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"BEGIN"});
        AuditPersistence auditPersistency = this.getAuditPersistence();
        if (events != null && events.size() > 0) {
            ICubeContext ctx = this.createCubeContext();
            AuditKeyGenerator keyGen = AuditKeyGenerator.getInstance();
            for (AuditQuery event : events) {
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"Marking  {" + ai.getOperation().toString() + "}"});
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                if (AuditInstanceOperation.INSTANCE_TERMINATED == AuditInstanceOperation.valueOf((String)event.getOperation())) {
                    BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to STALE_COMPLETED"});
                    ai.setOperation(AuditInstanceOperation.STALE_COMPLETED);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"Marking  {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to STALE_ABORTED"});
                    ai.setOperation(AuditInstanceOperation.STALE_ABORTED);
                }
                BPELExecutionLogger.LOG.warn(logClassName, "markAuditAsStale", new Object[]{"******* Not Marking or persisting {" + ai.getQueryId() + "} {" + ai.getOperation().toString() + "} to STALE_ABORTED"});
                ai.setQueryId(Long.valueOf(keyGen.nextId(ctx)));
                AuditQueryMetadata aqmd = auditPersistency.getAuditQueryMetadata(ai.getCompositeDn());
                aqmd.setUndeployDate(c);
                aqmd.setStatus(-1L);
                this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"END"});
    }

    @Override
    public long markAuditAsStale(String compositeDN, long batchSize) throws Exception {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        long events = auditPersistency.markAuditAsStale(compositeDN, batchSize, -1L);
        return events;
    }

    @Override
    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws Exception {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryLastEventforCompositeDN(compositeDN, firstResult, maxResult);
        return events;
    }

    @Override
    public void markAuditAsAborted(String compositeInstanceId) throws Exception {
        String logMethodName = "markAuditAsAborted";
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsAborted", new Object[]{"BEGIN composite ID {" + compositeInstanceId + "}"});
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryFirstEventforCompositeId(compositeInstanceId);
        ArrayList<IAuditInstance> auditInstanceList = new ArrayList<IAuditInstance>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("compositeId", compositeInstanceId);
        List<AuditQuery> abortedInstances = auditPersistency.queryAbortedEventsforCompositeId(compositeInstanceId);
        TreeSet<String> aborted = new TreeSet<String>();
        if (abortedInstances != null && !abortedInstances.isEmpty()) {
            for (AuditQuery abortedInstance : abortedInstances) {
                aborted.add(abortedInstance.getComponentInstanceId());
            }
        }
        if (events != null) {
            ICubeContext ctx = this.createCubeContext();
            AuditKeyGenerator keyGen = AuditKeyGenerator.getInstance();
            for (AuditQuery event : events) {
                if (aborted.contains(event.getComponentInstanceId())) continue;
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                ai.setOperation(AuditInstanceOperation.INSTANCE_ABORTED);
                ai.setAuditInstanceType("END");
                ai.setTargetActivity(null);
                ai.setQueryId(Long.valueOf(keyGen.nextId(ctx)));
                BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsAborted", new Object[]{"Creating  {" + ai.toString() + "}"});
                Long qId = this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
                ai.setQueryId(qId);
                auditInstanceList.add(ai);
            }
            if (auditInstanceList.size() > 0) {
                this.publishToMeasurementInBatch(auditInstanceList);
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsAborted", new Object[]{"END {" + compositeInstanceId + "}"});
    }

    @Override
    public void markAuditCancelled(String instanceId) throws Exception {
        String logMethodName = "markAuditCancelled";
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditCancelled", new Object[]{"BEGIN {" + instanceId + "}"});
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryFirstEventforComponentId(instanceId);
        ArrayList<IAuditInstance> auditInstanceList = new ArrayList<IAuditInstance>();
        if (events != null) {
            ICubeContext ctx = this.createCubeContext();
            AuditKeyGenerator keyGen = AuditKeyGenerator.getInstance();
            for (AuditQuery event : events) {
                IAuditInstance ai = AuditUtil.createAuditInstance(event, event.getAuditQueryMetadata());
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(System.currentTimeMillis());
                ai.setCreateTime(c);
                ai.setOperation(AuditInstanceOperation.INSTANCE_ABORTED);
                ai.setAuditInstanceType("END");
                ai.setTargetActivity(null);
                ai.setQueryId(Long.valueOf(keyGen.nextId(ctx)));
                BPELExecutionLogger.LOG.debug(logClassName, "markAuditCancelled", new Object[]{"Creating  {" + ai.toString() + "}"});
                ai.setQueryId(Long.valueOf(keyGen.nextId(ctx)));
                Long qId = this.persistAuditQuery(auditPersistency, AuditUtil.createAuditQuery(ai));
                ai.setQueryId(qId);
                auditInstanceList.add(ai);
            }
            if (auditInstanceList.size() > 0) {
                this.publishToMeasurementInBatch(auditInstanceList);
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditCancelled", new Object[]{"END {" + instanceId + "}"});
    }

    @Override
    public List<IAuditInstance> queryAuditInstanceByProcessId(String instanceId) throws AuditPersistenceException {
        String logMethodName = "queryAuditInstanceByProcessId ";
        BPELExecutionLogger.LOG.debug(logClassName, "queryAuditInstanceByProcessId ", new Object[]{"BEGIN"});
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryAuditQueryFindAllbyProcessId(instanceId);
        BPELExecutionLogger.LOG.debug(logClassName, "queryAuditInstanceByProcessId ", new Object[]{"END {" + events.toString() + "}"});
        return this.createAuditInstances(events);
    }

    @Override
    @Deprecated
    public List<IAuditInstance> getActiveInstancesAsOfQueryId(long queryId) throws AuditPersistenceException {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.getActiveInstancesAsOfQueryId(queryId);
        return this.createAuditInstances(events);
    }

    @Override
    @Deprecated
    public List<IAuditInstance> getAllInstancesAfterQueryId(long queryId) throws AuditPersistenceException {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.getAllInstancesAfterQueryId(queryId);
        return this.createAuditInstances(events);
    }

    @Override
    @NotNull
    public List<IAuditInstance> queryAuditInstances(int firstResult, int resultPageSize, boolean active, int totalResults, Calendar referenceTime, long backTrackTime) throws AuditPersistenceException {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<AuditQuery> events = auditPersistency.queryAudit(firstResult, resultPageSize, active, totalResults, referenceTime, backTrackTime);
        return this.createAuditInstances(events);
    }

    @Override
    public List<IAuditInstance> queryAuditInstances(String expression) throws AuditPersistenceException {
        return this.queryAuditInstances(expression, null);
    }

    @Override
    public List<IAuditInstance> queryAuditInstances(String expression, Map<String, Object> parameters) throws AuditPersistenceException {
        String logMethodName = "queryAuditInstance";
        AuditPersistence auditPersistency = this.getAuditPersistence();
        try {
            return this.createAuditInstances(auditPersistency.queryAudit(expression, parameters));
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "queryAuditInstance", new Object[]{"Unable to query for Audit Instance with the JPQL Query {" + (expression == null ? "null" : expression) + "} " + e.toString()});
            throw new AuditPersistenceException(e);
        }
    }

    @Override
    public List<IAuditInstance> queryAuditInstances(String tablePrefix, String expression, String orderBy, Map<String, Object> parameters, int pageStart, int pageSize) throws AuditPersistenceException {
        String logMethodName = "queryAuditInstance";
        AuditPersistence auditPersistency = this.getAuditPersistence();
        try {
            return this.createAuditInstances(auditPersistency.queryAudit(tablePrefix, expression, orderBy, parameters, pageStart, pageSize));
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "queryAuditInstance", new Object[]{"Unable to query for Audit Instance with the JPQL Query ", expression == null ? "null expression" : "Expression {" + expression + "} ", (orderBy == null ? "" : " Order By {" + orderBy + "}") + "} ", e.toString(), e});
            throw new AuditPersistenceException(e);
        }
    }

    @Override
    public byte[] getAuditInstancePayload(long queryId) throws AuditPersistenceException {
        String logMethodName = "getAuditInstancePayload";
        AuditPersistence auditPersistency = this.getAuditPersistence();
        ByteArray auditLog = auditPersistency.getAuditQueryLog(queryId);
        if (auditLog != null) {
            RecycleBin pool = EngineRecycleBinRegistry.getInstance();
            NonSyncStringWriter sink = (NonSyncStringWriter)pool.get(NonSyncStringWriter.class);
            String payload = null;
            try {
                CXCompressUtils.uncompressStream((byte[])auditLog.getBytes(), (Writer)sink);
                payload = sink.toString();
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Problem inflating the audit log " + e.toString());
            }
            finally {
                pool.release((IRecyclable)sink);
            }
            try {
                NodeList payloadDataObjects;
                Element section;
                BPELExecutionLogger.LOG.debug(logClassName, "getAuditInstancePayload", new Object[]{"XML Payload {" + payload + "}"});
                Document doc = XMLUtil.parseDocumentFromXMLString((String)payload);
                Document resultDoc = XMLUtil.createDocument();
                if (resultDoc == null) {
                    BPELExecutionLogger.LOG.warn(logClassName, "getAuditInstancePayload", new Object[]{"The payload doess not contain the expected auditQueryPayload element."});
                    return new byte[0];
                }
                Element resultRoot = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "auditQueryPayload");
                if (doc.getFirstChild().getAttributes().getNamedItem("auditId") != null) {
                    long auditId = Long.parseLong(doc.getFirstChild().getAttributes().getNamedItem("auditId").getTextContent());
                    resultRoot.setAttribute("auditId", String.valueOf(auditId));
                }
                long ciKey = 0L;
                if (doc.getFirstChild().getAttributes().getNamedItem("ciKey") != null) {
                    try {
                        ciKey = Long.parseLong(doc.getFirstChild().getAttributes().getNamedItem("ciKey").getTextContent());
                    }
                    catch (NumberFormatException e) {
                        ciKey = -1L;
                    }
                }
                resultRoot.setAttribute("ciKey", String.valueOf(ciKey));
                NodeList payloadSection = doc.getElementsByTagName("serviceInput");
                if (payloadSection != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "serviceInput");
                    resultRoot.appendChild(section);
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                if ((payloadSection = doc.getElementsByTagName("serviceOutput")) != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "serviceOutput");
                    resultRoot.appendChild(section);
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                if ((payloadSection = doc.getElementsByTagName("dataState")) != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "dataState");
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    resultRoot.appendChild(section);
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                if ((payloadSection = doc.getElementsByTagName("gatewayExpressions")) != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "gatewayExpressions");
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    resultRoot.appendChild(section);
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                if ((payloadSection = doc.getElementsByTagName("activity")) != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "activity");
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    resultRoot.appendChild(section);
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                if ((payloadSection = doc.getElementsByTagName("messages")) != null && payloadSection.getLength() > 0) {
                    section = resultDoc.createElementNS(AUDIT_PAYLOAD_NS, "messages");
                    payloadDataObjects = payloadSection.item(0).getChildNodes();
                    resultRoot.appendChild(section);
                    this.buildPayloadDoc(auditPersistency, payloadDataObjects, ciKey, pool, sink, resultDoc, section);
                }
                resultDoc.appendChild(resultRoot);
                byte[] buffer = null;
                payload = XMLUtil.toString((Node)resultDoc);
                BPELExecutionLogger.LOG.debug(logClassName, "getAuditInstancePayload", new Object[]{"Reconstituted payload {" + payload + "}"});
                try {
                    buffer = CompressUtils.compressString((String)payload);
                }
                catch (Exception e) {
                    throw new AuditPersistenceException("Unable to compress the audit log information.", e);
                }
                return buffer;
            }
            catch (Exception e) {
                BPELExecutionLogger.LOG.error(logClassName, "getAuditInstancePayload", new Object[]{"Problem getting the audit log payload {" + e.toString() + "}"});
                throw new AuditPersistenceException(e);
            }
        }
        return new byte[0];
    }

    @Override
    public IAuditVariableMetadata getAuditVariableMetadata(String compositeDN) throws Exception {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        List<IAuditVariableRange> allRanges = this.createVariableRanges(auditPersistency.getAllVariableRanges(compositeDN));
        IAuditVariableMetadata varMetadata = AuditUtil.createAuditVariableMetadata(auditPersistency.getAuditQueryMetadata(compositeDN));
        varMetadata.setAllRanges(allRanges);
        return varMetadata;
    }

    @Override
    public AuditQueryMetadata getAuditQueryMetadata(String compositeDN) throws Exception {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        AuditQueryMetadata metadata = auditPersistency.getAuditQueryMetadata(compositeDN);
        return metadata;
    }

    @Override
    public void setEntityManager(EntityManager em) {
    }

    @Override
    public EntityManager getEntityManager() throws Exception {
        return null;
    }

    @Override
    public List<IAuditEvent> persistAuditData(ICubeContext ctx) throws AuditPersistenceException {
        try {
            return this.persistAuditData(AuditService.getAuditTrail(ctx));
        }
        catch (Exception e) {
            throw new AuditPersistenceException(e);
        }
    }

    @Override
    public List<IAuditEvent> persistAuditData(IAuditTrail auditTrail) throws AuditPersistenceException {
        String logMethodName = "persistAuditData ";
        BPELExecutionLogger.LOG.debug(logClassName, "persistAuditData ", new Object[]{"BEGIN"});
        ArrayList<IAuditEvent> auditEventList = new ArrayList<IAuditEvent>();
        if (auditTrail instanceof BPMNAuditTrail) {
            AuditPersistence auditPersistency = this.getAuditPersistence();
            try {
                Iterator events = auditTrail.getEvents();
                while (events.hasNext()) {
                    IAuditEvent evt = (IAuditEvent)events.next();
                    if (!(evt instanceof BPMNAuditEvent)) continue;
                    BPMNAuditEvent event = (BPMNAuditEvent)evt;
                    this.handleAuditPayload(event);
                    this.persistAuditQuery(auditPersistency, event.getAuditQuery());
                    auditEventList.add(event);
                }
                this.em.flush();
            }
            catch (AuditPersistenceException e) {
                BPELExecutionLogger.LOG.error(logClassName, "persistAuditData ", new Object[]{e});
                throw e;
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "persistAuditData ", new Object[]{"END"});
        return auditEventList;
    }

    @Override
    public void publishToMeasurement(IAuditTrail auditTrail) throws Exception {
        if (auditTrail instanceof BPMNAuditTrail) {
            this.publishAuditInstanceInBatch(((BPMNAuditTrail)auditTrail).getPersisted());
        }
    }

    @Override
    public int getAuditLevel(ICubeContext context) {
        int result = 0;
        ICubeInstanceImpl instance = CubeContextHelper.getCubeInstance((ICubeContext)context);
        AuditLevel auditLevel = ConfigurationHelper.getCurrentAuditLevel((ICubeProcess)instance.getProcessClass(), (ICubeContext)context);
        switch (auditLevel) {
            case Off: {
                result = 99999;
                break;
            }
            case Minimal: {
                result = 3;
                break;
            }
            case Production: {
                result = 2;
                break;
            }
            case Development: {
                result = 1;
                break;
            }
            default: {
                result = 99999;
            }
        }
        return result;
    }

    @Override
    public boolean canLog(ICubeContext context, AuditLevel level) {
        ICubeInstanceImpl instance = CubeContextHelper.getCubeInstance((ICubeContext)context);
        AuditLevel auditLevel = ConfigurationHelper.getCurrentAuditLevel((ICubeProcess)instance.getProcessClass(), (ICubeContext)context);
        if (AuditLevel.Off.equals((Object)auditLevel)) {
            return false;
        }
        return !auditLevel.isGreaterThan(level);
    }

    @Override
    public boolean canLog(ICubeContext context, AuditLevel level, IElementContext eCtx) throws Exception {
        String logMethodName = "canLog";
        boolean enabled = this.canLog(context, level);
        enabled = this.canLog(enabled, eCtx);
        BPELExecutionLogger.LOG.debug(logClassName, "canLog", new Object[]{"requested level {" + level.toString() + "}. Returning {" + enabled + "}"});
        return enabled;
    }

    @Override
    public boolean canLog(boolean enabled, IElementContext eCtx) throws Exception {
        String logMethodName = "canLog";
        boolean canLog = enabled;
        if (!canLog) {
            BPELExecutionLogger.LOG.debug(logClassName, "canLog", new Object[]{"Officially logging is off - checking the mesasurement framework"});
            canLog = this.canPublish(eCtx) != null;
        }
        BPELExecutionLogger.LOG.debug(logClassName, "canLog", new Object[]{"Logging enabled {" + enabled + "}. Returning {" + canLog + "}"});
        return canLog;
    }

    @Override
    public boolean canLog(ICubeContext iCubeContext, AuditLevel auditLevel, BpmnType bpmnType) {
        boolean canLog = this.canLog(iCubeContext, AuditLevel.Development) || AuditUtil.isAsyncType(bpmnType);
        return canLog;
    }

    @Override
    public Long nextIDFromStore(String sequenceName, int extent) throws AuditPersistenceException {
        AuditPersistence auditPersistency = this.getAuditPersistence();
        Long nextId = auditPersistency.getNextIDFromStore(sequenceName, extent);
        return nextId;
    }

    protected IMeasurementMetadataServiceLocal getMeasurementService() throws Exception {
        if (this.mMeasurementService == null) {
            this.mMeasurementService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
        }
        return this.mMeasurementService;
    }

    private static long getBufferLimit() {
        BPMNConfig config;
        long limit = 2000L;
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        if (serviceEngine != null && (config = serviceEngine.getBPMNConfig()) != null) {
            limit = config.getAuditDetailThreshold();
        }
        return limit;
    }

    private void buildPayloadDoc(AuditPersistence auditPersistency, NodeList payloadDataObjects, long ciKey, RecycleBin pool, NonSyncStringWriter sink, Document resultDoc, Element section) throws Exception {
        String logMethodName = "buildPayloadDoc";
        for (int i = 0; i < payloadDataObjects.getLength(); ++i) {
            Node payloadDataObject = payloadDataObjects.item(i);
            Node payloadDOValue = payloadDataObject.getFirstChild();
            Node resultDo = XMLUtil.cloneNode((Document)resultDoc, (Node)payloadDataObject);
            if (payloadDOValue == null) {
                NamedNodeMap n = payloadDataObject.getAttributes();
                Node detailIdNode = n.getNamedItem("detailId");
                if (detailIdNode == null) continue;
                long detailId = Long.parseLong(detailIdNode.getTextContent());
                ByteArray auditDetail = auditPersistency.getAuditDetail(ciKey, detailId);
                String detail = null;
                try {
                    sink.reset();
                    CXCompressUtils.uncompressStream((byte[])auditDetail.getBytes(), (Writer)sink);
                    detail = sink.toString();
                }
                catch (Exception e) {
                    throw new AuditPersistenceException("Problem inflating the audit detail " + e.toString());
                }
                finally {
                    pool.release((IRecyclable)sink);
                }
                String localName = payloadDataObject.getLocalName();
                if (!detail.startsWith("<?xml version=\"1.0\"?>")) {
                    detail = "execution".equals(localName) || "activity".equals(localName) ? "<?xml version=\"1.0\"?>" + detail : "<?xml version=\"1.0\"?><" + localName + " xmlns=\"" + payloadDataObject.getNamespaceURI() + "\">" + detail + "</" + localName + ">";
                }
                Element detailNode = XMLUtil.parseDocumentFromXMLString((String)detail).getDocumentElement();
                for (int j = 0; j < detailNode.getChildNodes().getLength(); ++j) {
                    Node n1 = detailNode.getChildNodes().item(j);
                    resultDo.appendChild(XMLUtil.cloneNode((Document)resultDoc, (Node)n1));
                }
                section.appendChild(resultDo);
                continue;
            }
            section.appendChild(XMLUtil.cloneNode((Document)resultDoc, (Node)payloadDataObject));
        }
    }

    private void publishAuditInstanceInBatch(List<IAuditEvent> events) throws AuditPersistenceException {
        ArrayList<IAuditInstance> auditInstanceList = new ArrayList<IAuditInstance>();
        for (IAuditEvent e : events) {
            BPMNAuditEvent event = (BPMNAuditEvent)e;
            IAuditInstance auditInstance = AuditUtil.createAuditInstance(event.getAuditQuery(), event.getAuditQueryMetadata());
            auditInstance.setAssociatedVariables(event.getAssociatedVariables());
            auditInstanceList.add(auditInstance);
        }
        this.publishToMeasurementInBatch(auditInstanceList);
    }

    private void publishToMeasurementInBatch(List<IAuditInstance> auditInstanceList) throws AuditPersistenceException {
        try {
            String logMethodName = "publishToMeasurementInBatch";
            MeasurementPublisher pub = new MeasurementPublisher();
            ArrayList<IMeasure> measuresList = new ArrayList<IMeasure>();
            ArrayList<IAuditInstance> pubAuditInstanceList = new ArrayList<IAuditInstance>();
            for (IAuditInstance ai : auditInstanceList) {
                IElementContext eCtx = AuditService.getElementContext(ai);
                IMeasure measure = this.canPublish(eCtx);
                if (pub != null && measure != null) {
                    BPELExecutionLogger.LOG.debug(logClassName, "publishToMeasurementInBatch", new Object[]{"Measurement is enabled with {" + measure.getActions().size() + "} actions. Publishing AuditInstance {" + ai.getQueryId() + "}"});
                    measuresList.add(measure);
                    pubAuditInstanceList.add(ai);
                    continue;
                }
                BPELExecutionLogger.LOG.debug(logClassName, "publishToMeasurementInBatch", new Object[]{"Measurement is disabled or there are no pending actions. Not publishing {" + ai.getQueryId() + "}"});
            }
            if (pub != null && measuresList.size() > 0) {
                pub.publishBatchAsList(pubAuditInstanceList, measuresList);
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error((Object)("Problem when publishing a batch of Audit Instances {" + auditInstanceList.toString() + "}"), (Throwable)e);
            throw new AuditPersistenceException(e);
        }
    }

    private IMeasure canPublish(IElementContext eCtx) throws Exception {
        String logMethodName = "canPublish";
        IMeasure measure = null;
        if (!Util.isEnvMeasurementDisabled(eCtx.getCompositeDN()) && !(measure = this.getMeasurementService().isElementRegistered(eCtx)).isMeasurementEnabled()) {
            measure = null;
        }
        BPELExecutionLogger.LOG.debug(logClassName, "canPublish", new Object[]{"Measurement enabled status {" + (measure != null ? "true" : "false") + "}"});
        if (measure != null && measure.getActions() != null && measure.getActions().size() > 0) {
            String disabledActions = Util.getEnvDisabledActions();
            measure.setActions(MeasurementUtil.getEnabledActionsList((IMeasure)measure, (String)disabledActions));
        }
        return measure;
    }

    private List<IAuditInstance> createAuditInstances(List<AuditQuery> auditQuery) throws AuditPersistenceException {
        String logMethodName = "createAuditInstances";
        ArrayList<IAuditInstance> instances = new ArrayList<IAuditInstance>();
        try {
            for (AuditQuery aq : auditQuery) {
                String varCSV;
                String[] names;
                AuditQueryMetadata amd = aq.getAuditQueryMetadata();
                IAuditInstance ai = AuditUtil.createAuditInstance(aq, amd);
                if (aq.getElementVariableCSV() != null && (names = (varCSV = aq.getElementVariableCSV()).replaceFirst("\\[", "").replaceFirst("\\]", "").split(",")) != null && names.length > 0) {
                    for (int i = 0; i < names.length; ++i) {
                        ai.addAssociatedVariable(names[i].trim());
                    }
                }
                BPELExecutionLogger.LOG.debug(logClassName, "createAuditInstances", new Object[]{"Associated varaibles Query ID {" + ai.getQueryId() + "} Activity {" + ai.getActivityId() + "} Operation {" + ai.getOperation() + "} {" + ai.getVariables().toString() + "}"});
                instances.add(ai);
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "createAuditInstances", new Object[]{"Unable to convert AuditQuery to IAuditInstance " + e.toString()});
            throw new AuditPersistenceException("Unable to convert AuditQuery to IAuditInstance " + e.toString(), e);
        }
        return instances;
    }

    private List<IAuditVariableRange> createVariableRanges(List<AuditQueryVariableRange> allRanges) throws AuditPersistenceException {
        String logMethodName = "createVariableRanges";
        ArrayList<IAuditVariableRange> ranges = new ArrayList<IAuditVariableRange>();
        try {
            for (AuditQueryVariableRange range : allRanges) {
                IAuditVariableRange ar = AuditUtil.createAuditvariableRange(range);
                ranges.add(ar);
            }
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "createVariableRanges", new Object[]{"Unable to convert AuditQueryVariableRange to IAuditVariableRange " + e.toString()});
            throw new AuditPersistenceException("Unable to convert AuditQueryVariableRange to IAuditVariableRange " + e.toString(), e);
        }
        return ranges;
    }

    private Long persistAuditQuery(AuditPersistence auditPersistency, AuditQuery auditQuery) throws AuditPersistenceException {
        AuditQueryMetadata aqmd = auditPersistency.getAuditQueryMetadata(auditQuery.getCompositeDn());
        return this.persistAuditQuery(auditPersistency, auditQuery, aqmd);
    }

    private Long persistAuditQuery(AuditPersistence auditPersistency, AuditQuery auditQuery, AuditQueryMetadata metadata) throws AuditPersistenceException {
        String logMethodName = "persistAuditQuery ";
        auditQuery.setAuditQueryMetadata(metadata);
        auditQuery = (AuditQuery)auditPersistency.persistEntity(auditQuery);
        BPELExecutionLogger.LOG.debug(logClassName, "persistAuditQuery ", new Object[]{"Persisted {" + auditQuery.getQueryId() + "} {" + auditQuery.getActivityId() + "} {" + auditQuery.getActivityName() + "} {" + auditQuery.getOperation() + "}"});
        return auditQuery.getQueryId();
    }

    private void handleAuditPayload(BPMNAuditEvent event) throws AuditPersistenceException {
        AuditActivityInfo info;
        List<AuditExpressionExecution> execList;
        String logMethodName = "handleAuditPayload";
        BPELExecutionLogger.LOG.debug(logClassName, "handleAuditPayload", new Object[]{"BEGIN"});
        if (event.getPayloadDoc() != null) {
            try {
                this.processPayloadDoc(event.getPayloadDoc(), event);
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Unable to process the payload Document.", e);
            }
        }
        if (!event.hasPayloadElements()) {
            BPELExecutionLogger.LOG.debug(logClassName, "handleAuditPayload", new Object[]{"END - No payload elements provided"});
            return;
        }
        StringBuffer buffer = new StringBuffer();
        byte[] log = null;
        buffer.append("<?xml version=\"1.0\"?><auditQueryPayload xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://xmlns.oracle.com/bpmn/engine/audit\" auditId=\"" + event.getQueryId() + "\" " + "ciKey=\"" + event.getComponentInstanceId() + "\">");
        Map<String, IAuditVariable> payloadElements = event.getPayloadElements(IAuditVariable.Direction.DIRECTION_INPUT);
        if (payloadElements != null && payloadElements.size() > 0) {
            buffer.append("<serviceInput>");
            this.renderPayloadSection(payloadElements, event, buffer, "element", IAuditVariable.Direction.DIRECTION_INPUT);
            buffer.append("</serviceInput>");
        }
        if ((payloadElements = event.getPayloadElements(IAuditVariable.Direction.DIRECTION_OUTPUT)) != null && payloadElements.size() > 0) {
            buffer.append("<serviceOutput>");
            this.renderPayloadSection(payloadElements, event, buffer, "element", IAuditVariable.Direction.DIRECTION_OUTPUT);
            buffer.append("</serviceOutput>");
        }
        if ((payloadElements = event.getPayloadElements(IAuditVariable.Direction.DIRECTION_STATE)) != null && payloadElements.size() > 0) {
            buffer.append("<dataState>");
            this.renderPayloadSection(payloadElements, event, buffer, "dataObject", IAuditVariable.Direction.DIRECTION_STATE);
            buffer.append("</dataState>");
        }
        if ((execList = event.getExpressionExecution()) != null && execList.size() > 0) {
            buffer.append("<gatewayExpressions>");
            this.renderGatewaySection(event, execList, buffer);
            buffer.append("</gatewayExpressions>");
        }
        if ((info = event.getActivityInfo()) != null && info.hasInfo()) {
            buffer.append("<activity>");
            this.renderActivityInfoSection(event, info, buffer);
            buffer.append("</activity>");
        }
        if (event.getComment() != null && event.getComment().length() > 0) {
            buffer.append("<messages>");
            this.renderMessageSection(event, event.getComment(), buffer);
            buffer.append("</messages>");
        }
        buffer.append("</auditQueryPayload>");
        try {
            log = CompressUtils.compressString((String)buffer.toString());
        }
        catch (Exception e) {
            throw new AuditPersistenceException("Unable to compress the audit log information.", e);
        }
        event.setAuditLog(log);
        BPELExecutionLogger.LOG.debug(logClassName, "handleAuditPayload", new Object[]{"END {" + buffer + "}"});
    }

    private void processPayloadDoc(@NotNull Document d, BPMNAuditEvent event) throws Exception {
        String logMethodName = "processPayloadDoc";
        BPELExecutionLogger.LOG.debug(logClassName, "processPayloadDoc", new Object[]{"BEGIN parsing", " {" + XMLUtil.toString((Node)d) + "}"});
        Element r = d.getDocumentElement();
        NodeList n = r.getChildNodes();
        String value = null;
        for (int i = 0; i < n.getLength(); ++i) {
            Element el = (Element)n.item(i);
            String name = el.getAttribute("name");
            Element v = (Element)el.getElementsByTagName("value").item(0);
            Element p = (Element)el.getElementsByTagName("oldValue").item(0);
            this.putVariableToPayload(event, name, v.getFirstChild(), p.getFirstChild(), IAuditVariable.Direction.DIRECTION_STATE);
            value = XMLUtil.toString((Node)el);
        }
    }

    private void putVariableToPayload(BPMNAuditEvent event, String name, Object value, Object previous, IAuditVariable.Direction direction) {
        String logMethodName = "putVariableToPayload";
        IAuditVariable var = null;
        var = event.getVariable(name);
        if (var == null) {
            var = AuditUtil.createNewAuditVariable();
            var.setName(name);
        }
        var.setValue(previous);
        var.setValue(value);
        var.setDirection(direction);
        BPELExecutionLogger.LOG.debug(logClassName, "putVariableToPayload", new Object[]{"Adding the variable {" + name + "} to the audit log detail"});
        event.addAuditPayloadElement(var);
    }

    private void renderPayloadSection(Map<String, IAuditVariable> payloadElements, BPMNAuditEvent event, StringBuffer buffer, String elementName, IAuditVariable.Direction direction) throws AuditPersistenceException {
        this.renderPayloadDataObject(payloadElements, event, buffer, elementName, direction);
    }

    private void renderPayloadDataObject(Map<String, IAuditVariable> payloadElements, BPMNAuditEvent event, StringBuffer buffer, String elementName, IAuditVariable.Direction direction) throws AuditPersistenceException {
        String logMethodName = "renderPayloadDataObject";
        int combinedSize = 0;
        String v = null;
        String p = null;
        byte[] log = null;
        AuditPersistence auditPersistency = this.getAuditPersistence();
        Set<Map.Entry<String, IAuditVariable>> payloadSet = payloadElements.entrySet();
        for (Map.Entry<String, IAuditVariable> entry : payloadSet) {
            log = null;
            IAuditVariable variable = entry.getValue();
            String name = variable.getName();
            Object value = variable.getValue();
            Object previous = variable.getPreviousValue();
            String variableType = this.getTypeName(variable.getType());
            if (value instanceof Element) {
                v = XMLUtil.toString((Node)((Element)value));
                if (v == null) {
                    BPELExecutionLogger.LOG.warn(logClassName, "renderPayloadDataObject", new Object[]{"The value for the variable {" + name + "} may not have rendered correctly"});
                }
            } else {
                v = value != null ? this.renderCDataValue(String.valueOf(value)) : "";
            }
            if (previous instanceof Element) {
                p = XMLUtil.toString((Node)((Element)previous));
            } else if (previous != null) {
                v = this.renderCDataValue(String.valueOf(value));
            } else {
                p = null;
            }
            if (v == null) {
                v = "";
            }
            int vLength = v.length() + (p != null ? p.length() : 0);
            long bufferLimit = 2000L;
            String objRefAttr = null;
            if (direction == IAuditVariable.Direction.DIRECTION_INPUT) {
                objRefAttr = "targetRef";
            }
            if (direction == IAuditVariable.Direction.DIRECTION_OUTPUT) {
                objRefAttr = "sourceRef";
            }
            if ((long)vLength > bufferLimit || (long)(combinedSize + vLength) > bufferLimit) {
                try {
                    log = CompressUtils.compressString((String)("<value xmlns=\"http://xmlns.oracle.com/bpmn/engine/audit\">" + v + "</value>" + (p != null ? "<oldValue xmlns=\"http://xmlns.oracle.com/bpmn/engine/audit\">" + p + "</oldValue>" : "")));
                }
                catch (Exception e) {
                    throw new AuditPersistenceException("Unable to compress the audit log information.", e);
                }
                try {
                    long ciKey = Long.parseLong(event.getComponentInstanceId());
                    long detailId = this.persistAuditDetail(auditPersistency, ciKey, log, event.getPartitionDate());
                    BPELExecutionLogger.LOG.debug(logClassName, "renderPayloadDataObject", new Object[]{"AUDIT_DETAILS detailId {" + detailId + "} ciKey {" + ciKey + "} varaible name {" + name + "} at {" + event.getActivityId() + ", " + event.getOperation() + "}"});
                    buffer.append("<" + elementName + " name=\"" + name + "\" " + " detailId=\"" + detailId + "\"" + " isBusinessIndicator=\"" + (variable.isCounter() || variable.isMeasure() || variable.isDimension() ? "true" : "false") + "\"" + (variable.getType() != null ? " type=\"" + variableType + "\"" : "") + "/>");
                }
                catch (NumberFormatException e) {
                    BPELExecutionLogger.LOG.error(logClassName, "renderPayloadDataObject", new Object[]{"The componentInstanceId {" + event.getComponentInstanceId() + "} can not be converted to Long. Audit Detail will not be persisted"});
                }
            } else {
                buffer.append("<" + elementName + " name=\"" + name + "\"" + " isBusinessIndicator=\"" + (variable.isCounter() || variable.isMeasure() || variable.isDimension() ? "true" : "false") + "\"" + (variable.getType() != null ? " type=\"" + variableType + "\"" : "") + "><value>").append(v).append("</value>").append(p != null ? "<oldValue>" + p + "</oldValue>" : "").append("</" + elementName + ">");
            }
            combinedSize = buffer.length();
        }
    }

    private void renderGatewaySection(BPMNAuditEvent event, List<AuditExpressionExecution> execList, StringBuffer buffer) throws AuditPersistenceException {
        String logMethodName = "renderGatewaySection";
        StringBuffer sb = new StringBuffer();
        for (AuditExpressionExecution exec : execList) {
            sb.append("<flowElement xmlns=\"" + AUDIT_PAYLOAD_NS + "\" ").append("result=\"" + String.valueOf(exec.isResult()) + "\" ").append("elementId=\"" + exec.getElementId() + "\" ").append("sourceId=\"" + exec.getSourceId() + "\" ").append("targetId=\"" + exec.getTargetId() + "\" ").append("sequenceFlowId=\"" + exec.getSequenceFlowId() + "\">").append("<sourceActivity><![CDATA[").append(exec.getSourceLabel()).append("]]></sourceActivity>").append("<targetActivity><![CDATA[").append(exec.getTargetLabel()).append("]]></targetActivity>");
            if (exec.getSequenceFlowLabel() != null && exec.getSequenceFlowLabel().length() > 0) {
                sb.append("<sequenceFlow><![CDATA[").append(exec.getSequenceFlowLabel()).append("]]></sequenceFlow>");
            }
            sb.append("<expression><![CDATA[").append(exec.getExpression()).append("]]></expression>").append("</flowElement>");
        }
        if (buffer.length() + sb.length() > 2000) {
            AuditPersistence auditPersistency = this.getAuditPersistence();
            byte[] log = null;
            try {
                log = CompressUtils.compressString((String)("<execution xmlns=\"http://xmlns.oracle.com/bpmn/engine/audit\">" + sb.toString() + "</execution>"));
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Unable to compress the audit log information.", e);
            }
            try {
                long ciKey = Long.parseLong(event.getComponentInstanceId());
                long detailId = this.persistAuditDetail(auditPersistency, ciKey, log, event.getPartitionDate());
                BPELExecutionLogger.LOG.debug(logClassName, "renderGatewaySection", new Object[]{"GATEWAY EXECUTION DETAIL detailId {" + detailId + "} ciKey {" + ciKey + "}"});
                buffer.append("<execution detailId=\"" + detailId + "\" />");
            }
            catch (NumberFormatException e) {
                BPELExecutionLogger.LOG.error(logClassName, "renderGatewaySection", new Object[]{"The componentInstanceId {" + event.getComponentInstanceId() + "} can not be converted to Long. Audit Detail will not be persisted"});
            }
        } else {
            buffer.append("<execution>").append(sb).append("</execution>");
        }
    }

    private void renderMessageSection(BPMNAuditEvent event, String message, StringBuffer buffer) throws AuditPersistenceException {
        String logMethodName = "renderMessageSection";
        if (buffer.length() + message.length() > 2000) {
            AuditPersistence auditPersistency = this.getAuditPersistence();
            byte[] log = null;
            try {
                log = CompressUtils.compressString((String)("<comment>" + message.toString() + "</comment>"));
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Unable to compress the audit log information.", e);
            }
            try {
                long ciKey = Long.parseLong(event.getComponentInstanceId());
                long detailId = this.persistAuditDetail(auditPersistency, ciKey, log, event.getPartitionDate());
                BPELExecutionLogger.LOG.debug(logClassName, "renderMessageSection", new Object[]{"COMMENT DETAIL detailId {" + detailId + "} ciKey {" + ciKey + "}"});
                buffer.append("<message detailId=\"" + detailId + "\" />");
            }
            catch (NumberFormatException e) {
                BPELExecutionLogger.LOG.error(logClassName, "renderMessageSection", new Object[]{"The componentInstanceId {" + event.getComponentInstanceId() + "} can not be converted to Long. Audit Detail will not be persisted"});
            }
        } else {
            buffer.append("<message><comment>").append(message).append("</comment></message>");
        }
    }

    private void renderActivityInfoSection(BPMNAuditEvent event, AuditActivityInfo activityInfo, StringBuffer buffer) throws AuditPersistenceException {
        String logMethodName = "renderActivityInfoSection";
        if (buffer.length() + activityInfo.size() > 2000) {
            AuditPersistence auditPersistency = this.getAuditPersistence();
            byte[] log = null;
            try {
                log = CompressUtils.compressString((String)("<activityInformation xmlns=\"http://xmlns.oracle.com/bpmn/engine/audit\">" + activityInfo.asXML() + "</activityInformation>"));
            }
            catch (Exception e) {
                throw new AuditPersistenceException("Unable to compress the audit log information.", e);
            }
            try {
                long ciKey = Long.parseLong(event.getComponentInstanceId());
                long detailId = this.persistAuditDetail(auditPersistency, ciKey, log, event.getPartitionDate());
                BPELExecutionLogger.LOG.debug(logClassName, "renderActivityInfoSection", new Object[]{"ACTIVITY INFORMATION detailId {" + detailId + "} ciKey {" + ciKey + "}"});
                buffer.append("<activityInformation detailId=\"" + detailId + "\" />");
            }
            catch (NumberFormatException e) {
                BPELExecutionLogger.LOG.error(logClassName, "renderActivityInfoSection", new Object[]{"The componentInstanceId {" + event.getComponentInstanceId() + "} can not be converted to Long. Audit Detail will not be persisted"});
            }
        } else {
            buffer.append("<activityInformation>").append(activityInfo.asXML()).append("</activityInformation>");
        }
    }

    private String getTypeName(String type) {
        String typeName = null;
        if (type != null) {
            typeName = "D".equals(type) ? "DIMENSION" : ("M".equals(type) ? "MEASURE" : ("C".equals(type) ? "COUNTER" : ("A".equals(type) ? "ATTRIBUTE" : "")));
        }
        return typeName;
    }

    private long persistAuditDetail(AuditPersistence auditPersistency, long ciKey, byte[] buffer, Calendar partitionDate) throws AuditPersistenceException {
        AuditQueryDetails ad = new AuditQueryDetails();
        ad.setCikey(ciKey);
        ad.setBinCsize(buffer.length);
        ad.setBinUsize(buffer.length);
        ad.setBin(buffer);
        ad.setPartitionDate(partitionDate.getTime());
        ad = (AuditQueryDetails)auditPersistency.persistEntity(ad);
        return ad.getDetailId();
    }

    private ICubeContext createCubeContext() throws Exception {
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        ICubeContext ctx = CubeContextFactory.newInstance().create(serviceEngine.getEngineType());
        IInternalInstanceManagementServiceRemote service = AuditUtil.getService();
        ctx.addToEnvironment("internalManagementService", (Object)service);
        return ctx;
    }

    private AuditPersistence getAuditPersistence() {
        return this.auditPersistence;
    }

    private String renderCDataValue(String value) {
        value = value.replaceAll(CDATA_OPENING_TAG_REGEX, "&lt;![CDATA[").replaceAll("]]>", "]]&gt;");
        value = CDATA_OPENING_TAG + value + "]]>";
        return value;
    }
}

