/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service.audit;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngine;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.CubeInstanceKey;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceRemote;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.model.runtime.LoopRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.MultiInstanceRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNAuditTrailLocalBean;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.services.instancequery.impl.AuditInstance;
import oracle.bpm.services.instancequery.impl.AuditVariable;
import oracle.bpm.services.instancequery.impl.AuditVariableMetadata;
import oracle.bpm.services.instancequery.impl.AuditVariableRange;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class AuditUtil {
    private static final Class logClassName = AuditUtil.class;
    private static Map<String, EVariableType> sVariableTypeMap;
    private static final int DEFAULT_AUDIT_UPDATE_BATCH_SIZE = 10000;
    private static final List<BpmnType> sAsyncTypes;

    public static IAuditInstance createNewAuditInstance(IAuditVariableMetadata metadata) {
        return AuditInstance.newInstance((IAuditVariableMetadata)metadata);
    }

    public static IAuditVariable createNewAuditVariable() {
        return AuditVariable.newInstance();
    }

    public static IAuditVariableMetadata createNewAuditVariableMetadata() {
        return AuditVariableMetadata.newInstance();
    }

    public static IAuditInstance createAuditInstance(AuditQuery auditQuery, AuditQueryMetadata metadata) {
        IAuditVariableMetadata avmd = AuditUtil.createAuditVariableMetadata(metadata);
        IAuditInstance ai = AuditUtil.createNewAuditInstance(avmd);
        ai.setActivityId(auditQuery.getActivityId());
        ai.setActivityName(auditQuery.getActivityName());
        ai.setActivityType(auditQuery.getActivityType());
        ai.setAuditInstanceType(auditQuery.getAuditInstanceType());
        ai.setComment(auditQuery.getComment() != null ? new String(auditQuery.getComment(), Charset.forName("utf-8")) : null);
        ai.setComponentInstanceId(auditQuery.getComponentInstanceId());
        ai.setComponentName(auditQuery.getComponentName());
        ai.setComponentType(auditQuery.getComponentType());
        ai.setCompositeDn(auditQuery.getCompositeDn());
        ai.setCompositeInstanceId(auditQuery.getCompositeInstanceId());
        ai.setCompositeName(auditQuery.getCompositeName());
        ai.setProcessName(auditQuery.getProcessName());
        ai.setLoopCount(auditQuery.getLoopCount());
        ai.setCreateTime(auditQuery.getCreateTime());
        ai.setDueDate(auditQuery.getDueDate());
        ai.setFaultIsrecoverable("Y".equals(auditQuery.getFaultIsrecoverable()));
        ai.setFaultType(auditQuery.getFaultType());
        ai.setInvokedComponentName(auditQuery.getInvokedComponentName());
        ai.setLabel(auditQuery.getLabel());
        ai.setInstanceCount(auditQuery.getInstanceCount());
        ai.setOperation(auditQuery.getOperation() != null ? AuditInstanceOperation.valueOf((String)auditQuery.getOperation()) : null);
        ai.setParentThreadId(auditQuery.getParentThreadId());
        ai.setParticipant(auditQuery.getParticipant());
        ai.setUserTaskNumber(auditQuery.getUserTaskNumber());
        ai.setPartitionDate(auditQuery.getPartitionDate());
        ai.setPriority(auditQuery.getPriority());
        ai.setProcessDueDate(auditQuery.getProcessDueDate());
        ai.setQueryId(auditQuery.getQueryId());
        ai.setReferenceId(auditQuery.getReferenceId());
        ai.setRoleId(auditQuery.getRoleId());
        ai.setScopeId(auditQuery.getScopeId());
        ai.setSourceActivity(auditQuery.getSourceActivity());
        ai.setTargetActivity(auditQuery.getTargetActivity());
        ai.setThreadId(auditQuery.getThreadId());
        ai.setTitle(auditQuery.getTitle());
        ai.setAuditLevel(auditQuery.getAuditLevel());
        ai.setAuditLog(auditQuery.getAuditLog());
        ai.setFlowElementType(auditQuery.getFlowElementType());
        ai.setECID(auditQuery.getECID());
        ai.setDateValues(auditQuery.getDateValues());
        ai.setNumberValues(auditQuery.getNumberValues());
        ai.setStringValues(auditQuery.getStringValues());
        return ai;
    }

    public static IAuditVariableRange createAuditvariableRange(AuditQueryVariableRange range) {
        IAuditVariableRange varRange = AuditUtil.createNewAuidtVariableRange();
        varRange.setCompositeDN(range.getCompositeDN());
        varRange.setVarLabel(range.getVarLabel());
        varRange.setRangeName(range.getRangeName());
        varRange.setNumberRangeStart(range.getNumberRangeStart());
        varRange.setNumberRangeEnd(range.getNumberRangeEnd());
        return varRange;
    }

    public static void insertVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> ranges) throws Exception {
        AuditUtil.getService().insertAuditVariableMetadata(metadata, ranges);
    }

    public static IAuditVariableMetadata getPreviousDeployment(String compositeDn) throws Exception {
        return AuditUtil.getService().getPreviousDeployment(compositeDn);
    }

    public static void markAuditAsStale(String compositeDN) throws Exception {
        String logMethodName = "markAuditAsStale";
        IInternalInstanceManagementServiceRemote service = AuditUtil.getService();
        long result = 0L;
        long count = 0L;
        int batchSize = AuditUtil.getAuditUpdateBatchSize();
        do {
            result = service.markAuditAsStale(compositeDN, batchSize);
            count += result;
        } while (result != 0L);
        BPELExecutionLogger.LOG.debug(logClassName, "markAuditAsStale", new Object[]{"Number of audit records updated {" + count + "}"});
    }

    public static void markAuditAsAborted(IBPMContext context, String compositeInstanceId) throws Exception {
        AuditUtil.getService().markAuditAsAborted(context, compositeInstanceId);
    }

    public static AuditQuery createAuditQuery(IAuditInstance auditInstance) {
        AuditQuery aq = new AuditQuery();
        aq.setActivityId(auditInstance.getActivityId());
        aq.setActivityName(auditInstance.getActivityName());
        aq.setActivityType(auditInstance.getActivityType());
        aq.setAuditInstanceType(auditInstance.getAuditInstanceType());
        aq.setComment(auditInstance.getComment() != null ? auditInstance.getComment().getBytes(Charset.forName("utf-8")) : null);
        aq.setComponentInstanceId(auditInstance.getComponentInstanceId());
        aq.setComponentName(auditInstance.getComponentName());
        aq.setComponentType(auditInstance.getComponentType());
        aq.setCompositeDn(auditInstance.getCompositeDn());
        aq.setCompositeInstanceId(auditInstance.getCompositeInstanceId());
        aq.setCompositeName(auditInstance.getCompositeName());
        aq.setProcessName(auditInstance.getProcessName());
        aq.setLoopCount(auditInstance.getLoopCount());
        aq.setCreateTime(auditInstance.getCreateTime());
        aq.setDueDate(auditInstance.getDueDate());
        aq.setFaultIsrecoverable(auditInstance.getFaultIsrecoverable() ? "Y" : "N");
        aq.setFaultType(auditInstance.getFaultType());
        aq.setInvokedComponentName(auditInstance.getInvokedComponentName());
        aq.setLabel(auditInstance.getLabel());
        aq.setInstanceCount(auditInstance.getInstanceCount());
        aq.setOperation(auditInstance.getOperation() != null ? auditInstance.getOperation().toString() : null);
        aq.setParentThreadId(auditInstance.getParentThreadId());
        aq.setParticipant(auditInstance.getParticipant());
        aq.setUserTaskNumber(auditInstance.getUserTaskNumber());
        aq.setPartitionDate(auditInstance.getPartitionDate());
        aq.setPriority(auditInstance.getPriority());
        aq.setProcessDueDate(auditInstance.getProcessDueDate());
        aq.setQueryId(auditInstance.getQueryId());
        aq.setReferenceId(auditInstance.getReferenceId());
        aq.setRoleId(auditInstance.getRoleId());
        aq.setScopeId(auditInstance.getScopeId());
        aq.setSourceActivity(auditInstance.getSourceActivity());
        aq.setTargetActivity(auditInstance.getTargetActivity());
        aq.setThreadId(auditInstance.getThreadId());
        aq.setTitle(auditInstance.getTitle());
        aq.setAuditLevel(auditInstance.getAuditLevel());
        aq.setAuditLog(auditInstance.getAuditLog());
        aq.setFlowElementType(auditInstance.getFlowElementType());
        aq.setECID(auditInstance.getECID());
        aq.setDateValues(auditInstance.getDateValues());
        aq.setNumberValues(auditInstance.getNumberValues());
        aq.setStringValues(auditInstance.getStringValues());
        return aq;
    }

    public static BPMNAuditEvent createNewAuditEvent(ICubeInstance instance) throws Exception {
        IAuditService svc = AuditServiceFactory.getInstance().getAuditService();
        ComponentDN cn = instance.getComponentDN();
        String previousLabel = instance.getCubeInstanceEO().getCompositeLabel();
        CompositeDNModel cs = CompositeDNModel.buildCompositeDN((String)cn.getApplicationName(), (String)cn.getCompositeName(), (String)cn.getRevision(), (String)previousLabel);
        String compositeDn = cs.getDNString();
        AuditQueryMetadata m = svc.getAuditQueryMetadata(compositeDn);
        BPMNAuditEvent event = new BPMNAuditEvent();
        event.setComponentType("BPMN");
        event.setCompositeInstanceId(instance.getCompositeInstanceId());
        event.setCompositeName(instance.getComponentDN().getCompositeName());
        Calendar c = Calendar.getInstance();
        c.setTime(instance.getPartitionDate());
        event.setPartitionDate(c);
        event.setThreadId(0L);
        event.setECID(instance.getECID());
        event.setLoopCount(0L);
        event.setCompositeDn(compositeDn);
        event.setAuditQueryMetadata(m);
        return event;
    }

    public static List<AuditQueryVariableMetadata> createAuditQueryVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> allRanges) {
        AuditQueryVariableMetadata aqvmd = null;
        ArrayList<AuditQueryVariableMetadata> varMetadata = new ArrayList<AuditQueryVariableMetadata>();
        aqvmd = new AuditQueryVariableMetadata();
        aqvmd.setCompositeDn(metadata.getCompositeDn());
        aqvmd.setExtensionId(0L);
        aqvmd.setDateNames(metadata.getDateNames());
        aqvmd.setDateTypes(metadata.getDateTypes());
        aqvmd.setNumberNames(metadata.getNumberNames());
        aqvmd.setNumberTypes(metadata.getNumberTypes());
        aqvmd.setNumberModelTypes(metadata.getNumberModelTypes());
        aqvmd.setStringNames(metadata.getStringNames());
        aqvmd.setStringTypes(metadata.getStringTypes());
        aqvmd.setStringModelTypes(metadata.getStringModelTypes());
        aqvmd.setAuditQueryVariableRange(allRanges);
        varMetadata.add(aqvmd);
        return varMetadata;
    }

    public static IAuditVariableMetadata createAuditVariableMetadata(@NotNull AuditQueryMetadata metadata) {
        String logMethodName = "createAuditVariableMetadata";
        IAuditVariableMetadata avm = AuditUtil.createNewAuditVariableMetadata();
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditVariableMetadata", new Object[]{"BEGIN {" + metadata + "}"});
        if (metadata.getAuditQueryVariableMetadata() != null) {
            for (AuditQueryVariableMetadata md : metadata.getAuditQueryVariableMetadata()) {
                avm.setCompositeDn(md.getCompositeDn());
                avm.setDateNames(md.getDateNames());
                avm.setDateTypes(md.getDateTypes());
                avm.setNumberNames(md.getNumberNames());
                avm.setNumberTypes(md.getNumberTypes());
                avm.setNumberModelTypes(md.getNumberModelTypes());
                avm.setStringNames(md.getStringNames());
                avm.setStringTypes(md.getStringTypes());
                avm.setStringModelTypes(md.getStringModelTypes());
                if (md.getAuditQueryVariableRange() == null || md.getAuditQueryVariableRange().size() <= 0) continue;
                ArrayList<IAuditVariableRange> allRanges = new ArrayList<IAuditVariableRange>();
                for (AuditQueryVariableRange range : md.getAuditQueryVariableRange()) {
                    allRanges.add(AuditUtil.createAuditvariableRange(range));
                }
                avm.setAllRanges(allRanges);
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditVariableMetadata", new Object[]{"END"});
        return avm;
    }

    public static void addVariableMetadata(IAuditVariableMetadata metadata, String name, String dataType, String type) {
        String logMethodName = "addVariableMetadata";
        BPELExecutionLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"BEGIN"});
        String vt = null;
        vt = type.length() > 1 ? type.substring(0, 1).toUpperCase() : type;
        EVariableType vx = sVariableTypeMap.get(dataType.toLowerCase());
        if (vx == null) {
            BPELExecutionLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"Unable to find Variable tyep for data Type " + dataType});
            return;
        }
        switch (vx) {
            case DATE: {
                metadata.addDateVariable(name, type);
                break;
            }
            case NUMBER: {
                metadata.addNumberVariable(name, type, dataType);
                break;
            }
            case STRING: {
                metadata.addStringVariable(name, type, dataType);
                break;
            }
            default: {
                BPELExecutionLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"Unable to recognize the variable data type {" + dataType + "} for variable {" + name + "}"});
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"END"});
    }

    public static void setAuditVariableValue(IScope scope, IAuditVariableMetadata metadata, IAuditInstance event, String name) throws CubeException {
        String logMethodName = "setAuditVariableValue";
        BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"BEGIN {" + name + "}"});
        Object valueObj = DataHandlingUtils.getVariableValue(name, scope);
        if (metadata == null) {
            CubeException ce = new CubeException(71301);
            BPELExecutionLogger.LOG.error(logClassName, "setAuditVariableValue", new Object[]{"Metadata is null for variable name {" + name + "}", ce});
            throw ce;
        }
        int slot = metadata.getSlot(name);
        if (slot == 0) {
            BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"END Unable to locate the slot for the variable {" + name + "}"});
            return;
        }
        EVariableType vx = AuditUtil.getAuditVariableType(metadata, name);
        if (vx == EVariableType.UNKNOWN) {
            CubeException ce = new CubeException(71301);
            BPELExecutionLogger.LOG.error(logClassName, "setAuditVariableValue", new Object[]{"Unable to find Variable type for data Type. {" + name + "} ", ce});
            throw ce;
        }
        if (valueObj != null) {
            BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"Variable Name {" + name + "} Normalized Data Type {" + vx.toString() + "} Value Class {" + valueObj.getClass().getName() + "}"});
            String v = null;
            v = valueObj instanceof Element ? ((Element)valueObj).getTextContent() : String.valueOf(valueObj);
            switch (vx) {
                case STRING: {
                    BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"Converting value {" + v + "} to string"});
                    event.setStringValue(slot, String.valueOf(v));
                    break;
                }
                case NUMBER: {
                    BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"Converting value {" + v + "} to BigDecimal"});
                    event.setNumberValue(slot, new BigDecimal(v));
                    break;
                }
                case DATE: {
                    BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"Converting value {" + v + "} to Date"});
                    event.setDateValue(slot, JaxbDatatypeConverter.parseDateTime((String)v));
                    break;
                }
                default: {
                    BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"The type {" + vx.toString() + "} for variable {" + name + "} is not supported. Setting to type STRING"});
                    event.setStringValue(slot, String.valueOf(valueObj));
                    break;
                }
            }
        } else {
            switch (vx) {
                case DATE: {
                    event.setDateValue(slot, (Calendar)valueObj);
                    break;
                }
                case NUMBER: {
                    event.setNumberValue(slot, (BigDecimal)valueObj);
                    break;
                }
                case STRING: {
                    event.setStringValue(slot, (String)valueObj);
                }
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "setAuditVariableValue", new Object[]{"END"});
    }

    public static String getProjectVariableType(Object variable) {
        QName dataType = null;
        if (variable instanceof CXTypeVariable) {
            dataType = ((CXTypeVariable)variable).getType();
        } else if (variable instanceof CXElementVariable) {
            dataType = ((CXElementVariable)variable).getEntityDef().getElementQName();
        } else {
            throw new IllegalArgumentException();
        }
        return dataType.getLocalPart();
    }

    public static EVariableType getAuditVariableType(IAuditVariableMetadata metadata, String name) {
        EVariableType vx = null;
        vx = metadata.getNumberNames().contains(name) ? EVariableType.NUMBER : (metadata.getStringNames().contains(name) ? EVariableType.STRING : (metadata.getDateNames().contains(name) ? EVariableType.DATE : EVariableType.UNKNOWN));
        return vx;
    }

    public static String getActivityType(FlowNode flowNode, BpmnType bpmnType) {
        String result = bpmnType != null && bpmnType.getInnerType() == BpmnType.InnerType.EVENT ? ((Event)flowNode.asAnyNode(Event.class)).getEventTriggerType().name() : null;
        return result;
    }

    public static Long nextIDFromStore(ICubeContext ctx, String sequenceName, int extent) throws Exception {
        return AuditUtil.getServiceFromContext(ctx).nextIDFromStore(sequenceName, extent);
    }

    public static IInternalInstanceManagementServiceRemote getService() throws Exception {
        InitialContext jContext = new InitialContext();
        IInternalInstanceManagementServiceRemote service = (IInternalInstanceManagementServiceRemote)PortableRemoteObject.narrow((Object)jContext.lookup("InternalInstanceManagementService#oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceRemote"), IInternalInstanceManagementServiceRemote.class);
        return service;
    }

    public static void addInMessageToPayload(ICubeContext ctx, ICubeInstance cInstance, String scopeId, Map<String, Object> map, String activityId) throws CubeException {
        String logMethodName = "addInMessageToPayload";
        IAuditService service = null;
        try {
            service = AuditServiceFactory.getInstance().getAuditService();
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "addInMessageToPayload", new Object[]{"Unable to get the audit service", e});
            throw new CubeException((Throwable)e);
        }
        if (service.canLog(ctx, AuditLevel.Production)) {
            BPMNAuditTrail auditTrail = (BPMNAuditTrail)cInstance.getAuditTrail();
            String scopeName = InstanceAttributeType.getVariableName(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, activityId, scopeId);
            String auditScopeId = (String)ctx.getFromEnvironment(scopeName);
            if (auditScopeId != null) {
                BPELExecutionLogger.LOG.debug(logClassName, "addInMessageToPayload", new Object[]{"AUDIT SCOPE_NAME" + scopeName + "}", " AUDIT SCOPE_ID {" + auditScopeId + "}"});
                BPMNAuditEvent event = auditTrail.getLastAuditLog(auditScopeId, activityId);
                if (event != null) {
                    for (Map.Entry<String, Object> message : map.entrySet()) {
                        String name = message.getKey();
                        Object value = message.getValue();
                        IAuditVariable var = event.getVariable(name);
                        if (var == null) {
                            var = AuditUtil.createNewAuditVariable();
                            var.setName(name);
                            var.setValue(value);
                        }
                        var.setDirection(IAuditVariable.Direction.DIRECTION_INPUT);
                        BPELExecutionLogger.LOG.debug(logClassName, "addInMessageToPayload", new Object[]{"Adding the variable {" + name + "} to the audit log detail for {" + activityId + "} event {" + event.getActivityName() + "}"});
                        event.addAuditPayloadElement(var);
                    }
                } else {
                    Object[] args = new Object[]{activityId};
                    throw new CubeException(75006, args);
                }
            }
        }
    }

    public static void addOutMessageToPayload(ICubeContext ctx, Map<String, Object> payload) throws CubeException {
        String logMethodName = "addOutMessageToPayload";
        IAuditService service = null;
        try {
            service = AuditServiceFactory.getInstance().getAuditService();
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "addOutMessageToPayload", new Object[]{"Unable to get the audit service", e});
            throw new CubeException((Throwable)e);
        }
        if (service.canLog(ctx, AuditLevel.Production)) {
            ctx.addToEnvironment("AUDIT_LOG_OUTPUT_MESSAGE", payload);
        }
    }

    public static void addUserTaskNumberToPayload(ICubeContext ctx, ICubeInstance cInstance, String scopeId, Long userTaskNumber, String activityId) throws CubeException {
        String logMethodName = "addUserTaskNumberToPayload";
        String enabled = (String)ctx.getFromEnvironment("AUDIT_ENABLED");
        if (enabled != null && !Boolean.parseBoolean(enabled)) {
            return;
        }
        IAuditService service = null;
        try {
            service = AuditServiceFactory.getInstance().getAuditService();
        }
        catch (Exception e) {
            BPELExecutionLogger.LOG.error(logClassName, "addUserTaskNumberToPayload", new Object[]{"Unable to get the audit service", e});
            throw new CubeException((Throwable)e);
        }
        BPMNAuditTrail auditTrail = (BPMNAuditTrail)cInstance.getAuditTrail();
        String scopeName = InstanceAttributeType.getVariableName(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, activityId, scopeId);
        String auditScopeId = (String)ctx.getFromEnvironment(scopeName);
        if (auditScopeId != null) {
            BPELExecutionLogger.LOG.debug(logClassName, "addUserTaskNumberToPayload", new Object[]{"AUDIT SCOPE_NAME" + scopeName + "}", " AUDIT SCOPE_ID {" + auditScopeId + "}"});
            BPMNAuditEvent event = auditTrail.getLastAuditLog(auditScopeId, activityId);
            if (event != null) {
                event.setUserTaskNumber(userTaskNumber);
            } else {
                Object[] args = new Object[]{activityId};
                throw new CubeException(75006, args);
            }
        }
    }

    public static boolean isAsyncType(BpmnType bpmnType) {
        return sAsyncTypes.contains(bpmnType);
    }

    public static boolean isAsyncType(String bpmnType) {
        if ("PROCESS".equals(bpmnType)) {
            return false;
        }
        return AuditUtil.isAsyncType(BpmnType.valueOf((String)bpmnType));
    }

    public static IBPMNAuditTrailLocalBean getAuditTrailLocalService() throws Exception {
        InitialContext jContext = new InitialContext();
        return (IBPMNAuditTrailLocalBean)jContext.lookup("java:comp/env/ejb/local/bpmn/CubeAuditTrailBean");
    }

    public static <T extends FlowNode> Integer getLoopAttr(IScope scope, ICubeContext cubeContext, T element, boolean isInSubprocess) throws Exception {
        InstanceAttributeSupport<Integer> loopCountAttr = null;
        LoopCharacteristics loopCharacteristics = null;
        FlowNode fn = null;
        Activity activity = null;
        fn = isInSubprocess ? (FlowNode)element.getParentObject() : (FlowNode)element;
        if (fn instanceof Activity) {
            activity = (Activity)fn;
            loopCharacteristics = activity.getLoopCharacteristics();
            if (loopCharacteristics != null && loopCharacteristics instanceof Loop) {
                Loop loop = null;
                loop = (Loop)loopCharacteristics.as(Loop.class);
                LoopRuntimeHelper h = new LoopRuntimeHelper((FlowNode)activity, loop);
                loopCountAttr = h.getLoopCounterInstanceAttribute();
            } else if (loopCharacteristics != null && loopCharacteristics instanceof MultiInstance) {
                MultiInstance multiInstance = null;
                multiInstance = (MultiInstance)loopCharacteristics.as(MultiInstance.class);
                MultiInstanceRuntimeHelper h = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
                loopCountAttr = h.getLoopCounterInstanceAttribute();
            }
        }
        return AuditUtil.getLoopCountFromLoopAttr(scope, cubeContext, loopCountAttr, isInSubprocess);
    }

    public static void logSuspendInstance(long cikey) throws Exception {
        String logMethodName = "logSuspendInstance";
        DeploymentLogger.LOG.debug(logClassName, "logSuspendInstance", new Object[]{"SUSPEND BEGIN"});
        AuditUtil.logAuditEventForCiKey(cikey, AuditInstanceOperation.INSTANCE_SUSPENDED);
    }

    public static void logResumeInstance(long cikey) throws Exception {
        String logMethodName = "logResumeInstance";
        DeploymentLogger.LOG.debug(logClassName, "logResumeInstance", new Object[]{"SUSPEND BEGIN"});
        AuditUtil.logAuditEventForCiKey(cikey, AuditInstanceOperation.INSTANCE_RESUMED);
    }

    public static int getAuditLevel(ICubeContext context) {
        int result = 0;
        ICubeInstanceImpl instance = CubeContextHelper.getCubeInstance((ICubeContext)context);
        AuditLevel auditLevel = ConfigurationHelper.getCurrentAuditLevel((ICubeProcess)instance.getProcessClass(), (ICubeContext)context);
        switch (auditLevel) {
            case Off: {
                result = 99999;
                break;
            }
            case Minimal: {
                result = 3;
                break;
            }
            case Production: {
                result = 2;
                break;
            }
            case Development: {
                result = 1;
                break;
            }
            default: {
                result = 99999;
            }
        }
        return result;
    }

    private static void logAuditEventForCiKey(long cikey, AuditInstanceOperation operation) throws Exception {
        String logMethodName = "logAuditEventForCiKey";
        ICubeContext ctx = AuditUtil.createCubeContext();
        CubeEngine cEngine = new CubeEngine();
        CubeInstanceKey ciKey = new CubeInstanceKey(cikey);
        ICubeInstanceImpl instance = cEngine.load(ciKey, ctx);
        ctx.addToEnvironment("__cube-instance", (Object)instance);
        BPMNAuditEvent event = AuditUtil.createNewAuditEvent((ICubeInstance)instance);
        String instanceId = String.valueOf(instance.getKey().getInstanceId());
        event.setActivityName("PROCESS");
        event.setFlowElementType("PROCESS");
        event.setActivityId(instance.getComponentName());
        event.setLabel(operation.name());
        event.setTitle(event.getLabel());
        event.setScopeId(event.getActivityId() + ".0");
        event.setOperation(operation);
        event.setAuditInstanceType(operation.getType(false));
        event.setComponentInstanceId(instanceId);
        event.setComponentName(instance.getComponentName());
        event.setProcessName(instance.getComponentName());
        IAuditService auditService = AuditServiceFactory.getInstance().getAuditService();
        event.setAuditLevel(Long.valueOf(AuditUtil.getAuditLevel(ctx)));
        long id = auditService.logAuditInstance(ctx, event);
        DeploymentLogger.LOG.debug(logClassName, "logAuditEventForCiKey", new Object[]{"Persisted Audit Event {" + id + "} {" + event + "}"});
    }

    private static Integer getLoopCountFromLoopAttr(IScope scope, ICubeContext cubeContext, InstanceAttributeSupport loopCountAttr, boolean isInSubprocess) throws Exception {
        Integer loopCount = null;
        if (loopCountAttr != null) {
            if (isInSubprocess) {
                if (loopCountAttr.containsValue(scope.getParentScope(), cubeContext)) {
                    loopCount = (Integer)loopCountAttr.getValue(scope.getParentScope(), cubeContext);
                }
            } else if (loopCountAttr.containsValue(scope, cubeContext)) {
                loopCount = (Integer)loopCountAttr.getValue(scope, cubeContext);
            }
        }
        return loopCount;
    }

    private static IAuditVariableRange createNewAuidtVariableRange() {
        return AuditVariableRange.newInstance();
    }

    private static IInternalInstanceManagementService getServiceFromContext(ICubeContext ctx) throws Exception {
        IInternalInstanceManagementService service = (IInternalInstanceManagementService)ctx.getFromEnvironment("internalManagementService");
        if (service == null) {
            InitialContext jContext = new InitialContext();
            service = (IInternalInstanceManagementService)jContext.lookup("java:comp/env/oracle/bpm/engine/InternalInstanceManagementService");
            ctx.addToEnvironment("internalManagementService", (Object)service);
        }
        return service;
    }

    private static int getAuditUpdateBatchSize() {
        BPMNConfig config;
        int extents = 10000;
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        if (serviceEngine != null && (config = serviceEngine.getBPMNConfig()) != null) {
            extents = config.getAuditUpdateBatchSize();
        }
        return extents;
    }

    private static ICubeContext createCubeContext() throws Exception {
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        ICubeContext ctx = CubeContextFactory.newInstance().create(serviceEngine.getEngineType());
        return ctx;
    }

    static {
        sAsyncTypes = new ArrayList<BpmnType>();
        sVariableTypeMap = new HashMap<String, EVariableType>();
        sVariableTypeMap.put("Time", EVariableType.DATE);
        sVariableTypeMap.put("Int", EVariableType.NUMBER);
        sVariableTypeMap.put("String", EVariableType.STRING);
        sVariableTypeMap.put("Bool", EVariableType.STRING);
        sVariableTypeMap.put("boolean", EVariableType.STRING);
        sVariableTypeMap.put("Decimal", EVariableType.NUMBER);
        sVariableTypeMap.put("Real", EVariableType.NUMBER);
        sVariableTypeMap.put("time", EVariableType.DATE);
        sVariableTypeMap.put("dateTime", EVariableType.DATE);
        sVariableTypeMap.put("int", EVariableType.NUMBER);
        sVariableTypeMap.put("string", EVariableType.STRING);
        sVariableTypeMap.put("bool", EVariableType.STRING);
        sVariableTypeMap.put("real", EVariableType.NUMBER);
        sVariableTypeMap.put("decimal", EVariableType.NUMBER);
        sAsyncTypes.add(BpmnType.USER_TASK);
        sAsyncTypes.add(BpmnType.SERVICE_TASK);
        sAsyncTypes.add(BpmnType.RECEIVE_TASK);
        sAsyncTypes.add(BpmnType.SEND_TASK);
        sAsyncTypes.add(BpmnType.THROW_INTERMEDIATE_EVENT);
        sAsyncTypes.add(BpmnType.CATCH_INTERMEDIATE_EVENT);
        sAsyncTypes.add(BpmnType.BUSINESS_RULE_TASK);
    }

    private static enum EVariableType {
        DATE,
        NUMBER,
        STRING,
        UNKNOWN;

    }
}

