/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.xml.XMLHelper;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.management.config.bpmn.BPMNConfig;

public class Util {
    public static boolean getBooleanValue(String compositeDN, String booleanPropertyName) {
        PropertyModel prop = BPMNServiceEngine.getInstance().getCompositeProperty(compositeDN, booleanPropertyName);
        return prop != null && XMLHelper.isTrue((String)prop.getValue());
    }

    public static boolean isEnvMeasurementDisabled(String compositeDN) {
        BPMNConfig config;
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        if (serviceEngine != null && (config = BPMNServiceEngine.getInstance().getBPMNConfig()) != null && !config.getDisableSensors()) {
            return Util.getBooleanValue(compositeDN, "disableProcessSensors");
        }
        return true;
    }

    public static String getEnvDisabledActions() {
        BPMNConfig config;
        BPMNServiceEngine serviceEngine = BPMNServiceEngine.getInstance();
        if (serviceEngine != null && (config = BPMNServiceEngine.getInstance().getBPMNConfig()) != null) {
            return config.getDisableActions();
        }
        return "";
    }

    public static boolean getEnvBooleanValue(String caseSensitivePropertyName) {
        if (caseSensitivePropertyName != null && caseSensitivePropertyName.length() > 0) {
            try {
                String methodName = "get" + caseSensitivePropertyName;
                Class<?> c = BPMNServiceEngine.getInstance().getBPMNConfig().getClass();
                Method m = c.getMethod(methodName, null);
                Boolean val = (Boolean)m.invoke((Object)BPMNServiceEngine.getInstance().getBPMNConfig(), null);
                return val;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static IBPMContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return (IBPMContext)wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)orgEx;
            }
            throw new WorkflowException((Throwable)pae);
        }
    }
}

