/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import java.util.List;
import javax.transaction.Synchronization;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;

public class BPMNTransactionSynchronization
implements Synchronization {
    private BPMNAuditTrail mAuditTrail;
    private IInternalInstanceManagementServiceLocal mLocalBean = null;
    private static final String logClassName = BPMNTransactionSynchronization.class.getName();

    public BPMNTransactionSynchronization(BPMNAuditTrail auditTrail, IInternalInstanceManagementServiceLocal localBean) {
        this.mAuditTrail = auditTrail;
        this.mLocalBean = localBean;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        String logMethodName = "afterCompletion";
        BPELExecutionLogger.LOG.debug(logClassName, "afterCompletion", new Object[]{"BEGIN - Flushing {" + this.mAuditTrail.getEventCount() + "} audit records."});
        List<IAuditEvent> retry = this.mAuditTrail.getPersisted();
        List<IAuditEvent> persisted = null;
        try {
            try {
                if (this.mAuditTrail.getEventCount() > 0) {
                    BPELExecutionLogger.LOG.debug(logClassName, "afterCompletion", new Object[]{"Commiting  {" + this.mAuditTrail.getEventCount() + "} audit logs for transaction state " + i});
                    persisted = this.mLocalBean.persistAuditData(this.mAuditTrail);
                }
            }
            catch (Throwable e) {
                BPELExecutionLogger.LOG.error(logClassName, "afterCompletion", new Object[]{"Unable to commit the last {" + this.mAuditTrail.getEventCount() + "} audit logs " + e.toString(), e});
            }
            if (retry != null && retry.size() > 0) {
                if (persisted != null && persisted.size() > 0) {
                    BPELExecutionLogger.LOG.debug(logClassName, "afterCompletion", new Object[]{"Adding unpublished {" + retry.size() + "} messages."});
                    retry.addAll(persisted);
                }
            } else {
                retry = persisted;
            }
            if (retry != null && retry.size() > 0) {
                try {
                    this.mAuditTrail.setPersisted(retry);
                    this.mLocalBean.publishToMeasurement(this.mAuditTrail);
                }
                catch (Throwable e) {
                    BPELExecutionLogger.LOG.error(logClassName, "afterCompletion", new Object[]{"Unable to publish to measurement " + e.toString(), e});
                    this.mAuditTrail.setPersisted(persisted);
                }
            }
        }
        finally {
            this.mAuditTrail.clear();
            this.mLocalBean = null;
        }
        BPELExecutionLogger.LOG.debug(logClassName, "afterCompletion", new Object[]{"END"});
    }
}

