/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.bpel.dms.DMSInstrumentationServiceImpl;
import com.collaxa.cube.CubeException;
import com.collaxa.cube.ICubeResourceBundleManager;
import com.collaxa.cube.ResourceBundleHelper;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.CurrentEngineType;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.agents.recovery.BPELRecoveryListener;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.deployment.CubeProcessorFactory;
import com.collaxa.cube.engine.deployment.DeploymentHelper;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import com.collaxa.cube.engine.dispatch.message.IMessageHandler;
import com.collaxa.cube.engine.dispatch.message.MessageRegistry;
import com.collaxa.cube.engine.util.EngineBeanCache;
import com.collaxa.cube.engine.util.EngineRecycleBinRegistry;
import com.collaxa.cube.persistence.BpelDaoFactory;
import com.collaxa.cube.persistence.IDaoFactory;
import com.collaxa.cube.persistence.dao.ICubeInstanceDao;
import com.collaxa.cube.util.logging.ICubeLoggerManager;
import com.collaxa.cube.util.logging.LogFactory;
import com.oracle.bpel.client.ServerException;
import com.oracle.bpel.client.ejb.interfaces.ICubeInstanceManagerLocalBean;
import com.oracle.bpel.client.ejb.interfaces.ICubeProcessManagerLocalBean;
import com.oracle.bpel.client.ejb.interfaces.ICubeServerManagerLocalBean;
import com.oracle.bpel.client.util.BeanCache;
import com.oracle.bpel.client.util.ExceptionUtils;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.JavaWorkflowServiceClient;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.instancemanagement.IUserInitiateProcessCleanupService;
import oracle.bpm.bpmn.engine.instancemanagement.impl.ComponentMigrationListenerImpl;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.model.BPMNCubeProcessorFactory;
import oracle.bpm.bpmn.engine.model.BPMNProcess;
import oracle.bpm.bpmn.engine.model.RulesCalendar;
import oracle.bpm.bpmn.engine.model.SchedulerServiceHelper;
import oracle.bpm.bpmn.engine.model.TimerStartEventScheduler;
import oracle.bpm.bpmn.engine.model.deploy.schema.BpmnDesignSchema;
import oracle.bpm.bpmn.engine.model.runtime.BPMNWaitListener;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationAction;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.model.runtime.scripting.ScriptTaskUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.SchedulingHelper;
import oracle.bpm.bpmn.engine.resource.BPMNResourceBundleManager;
import oracle.bpm.bpmn.engine.runtime.BPMNCubeInstanceMigrationManager;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.ProcessRoleCache;
import oracle.bpm.bpmn.engine.runtime.UserDefinedLogging;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.service.BPMNDMSConstants;
import oracle.bpm.bpmn.engine.service.ClassloaderHelper;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessage;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessageHandler;
import oracle.bpm.bpmn.engine.service.RecoverGrabbedInstanceMessage;
import oracle.bpm.bpmn.engine.service.RecoverGrabbedInstanceMessageHandler;
import oracle.bpm.bpmn.engine.service.RecoverInstancesMessage;
import oracle.bpm.bpmn.engine.service.RecoverInstancesMessageHandler;
import oracle.bpm.bpmn.engine.service.ResumeComponentMessage;
import oracle.bpm.bpmn.engine.service.ResumeComponentMessageHandler;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeServerManagerLocalBean;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNProcessManagerLocalBean;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.DeployedProjectService;
import oracle.bpm.pml.service.impl.DeployedProjectServiceImpl;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.Organization;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.CubeServiceEngine;
import oracle.fabric.ICubeDMSMetadata;
import oracle.fabric.blocks.DefaultRevisionChangeListener;
import oracle.fabric.blocks.ImplementationType;
import oracle.fabric.blocks.RedeploymentTarget;
import oracle.fabric.common.FabricDeploymentException;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.integration.platform.blocks.cluster.ClusterInterface;
import oracle.integration.platform.blocks.deploy.DeploymentEvent;
import oracle.integration.platform.blocks.mesh.FabricLifecycleListener;
import oracle.integration.platform.blocks.migration.InstanceMigrationParticipant;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.common.FabricMDSAccessor;
import oracle.integration.platform.kernel.FabricMeshUtils;
import oracle.mds.core.MDSInstance;
import oracle.security.jps.JpsException;
import oracle.security.jps.internal.api.jaas.AssertionException;
import oracle.security.jps.internal.api.runtime.ActionExecutor;
import oracle.security.jps.internal.api.runtime.SubjectSecurity;
import oracle.soa.common.recycle.IRecyclable;
import oracle.soa.common.recycle.RecycleBin;
import oracle.soa.common.util.CXCompressUtils;
import oracle.soa.common.util.NonSyncStringWriter;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpel.BPELConfig;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.soa.management.facade.ActivityInstance;
import oracle.soa.management.internal.facade.bpm.BPMFaultImpl;
import oracle.soa.management.internal.facade.bpm.BPMInstanceImpl;
import oracle.soa.management.internal.facade.bpmn.BPMNFaultImpl;
import oracle.soa.management.internal.facade.bpmn.BPMNInstanceImpl;
import oracle.tip.pc.infra.exception.collaxa.CubeRuntimeException;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMIdentityType;
import org.jetbrains.annotations.Nullable;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.w3c.dom.Document;

public class BPMNServiceEngine
extends CubeServiceEngine
implements FabricLifecycleListener,
RedeploymentTarget<ComponentModel>,
DefaultRevisionChangeListener,
ApplicationListener,
InstanceMigrationParticipant {
    private BPMNConfig bpmnConfig;
    private BPMNXPathFunctionContext bpmnXPathFunctionContext;
    private BPMNXPathFunctionResolver bpmnXPathFunctionResolver;
    private ComponentMigrationSupport componentMigrationSupport;
    private boolean isDefaultRevisionChangeListenerRegistered = false;
    private IDaoFactory mDaoFactory;
    private List<String> mDeployedDN;
    private CompositeModel mLastUndeployedComposite;
    private UserDefinedLogging userDefinedLogging;
    private static final Map<Integer, Set<String>> COMPONENT2PROCESS_STATE_MAP = new HashMap<Integer, Set<String>>();
    private static final Map<String, Integer> PROCESS2COMPONENT_STATE_MAP = new HashMap<String, Integer>();
    private static final int RECOVER_BATCH_SIZE = 100;
    public static final String FORCE_DEPLOY = "oracle.bpm.bpmn.force.deploy";
    private static String adminUser;
    private static volatile DeployedProjectService sService;
    private static final Object lock;
    private static final String logClassName;
    private static BPMNServiceEngine sEngine;
    private static final String DEPLOYMENT_DESCRIPTOR_FILE_NAME = "bpmDeploymentDescriptor.xml";
    private static final String ORGANIZATION_FILE_NAME = "organization.xml";
    private static final String ADMINISTRATORS_GROUP = "Administrators";
    private static final String ROLE_SOA_ADMIN = "SOAAdmin";
    private static final String APP_NAME = "soa-infra";

    public BPMNServiceEngine() {
        CubeProcessorFactory.registerProcessor((ImplementationType)ImplementationType.BPMN, (CubeProcessorFactory)new BPMNCubeProcessorFactory());
        System.out.println("BPMNServiceEngine=> constructed ....");
        MessageRegistry.registerMessage(CreateComponentInstanceMessage.class, (IMessageHandler)new CreateComponentInstanceMessageHandler());
        MessageRegistry.registerMessage(RecoverGrabbedInstanceMessage.class, (IMessageHandler)new RecoverGrabbedInstanceMessageHandler());
        MessageRegistry.registerMessage(ComponentInstanceMigrationAction.OverwriteComponentMessage.class, (IMessageHandler)new ComponentInstanceMigrationAction.OverwriteComponentMessageHandler());
        MessageRegistry.registerMessage(ResumeComponentMessage.class, (IMessageHandler)new ResumeComponentMessageHandler());
        MessageRegistry.registerMessage(RecoverInstancesMessage.class, (IMessageHandler)new RecoverInstancesMessageHandler());
        sEngine = this;
        this.registerBPMNLoggerAndResource();
        this.mDMSMetadata = new ICubeDMSMetadata(){

            public String getEngineType() {
                return "bpmn";
            }

            public String getFaultExecutionTimeSensorName() {
                return "faultedExecutionTime";
            }

            public String getBusinessFaultsSensorName() {
                return "businessFaults";
            }

            public String getSystemFaultsSensorName() {
                return "systemFaults";
            }

            public String getMessageProcessingNounPath() {
                return "/soainfra/engines/message_processing/bpmn";
            }

            public String getComponentRequestsNounType() {
                return "soainfra_bpmn_requests";
            }

            public String getActiveRequestSensorName() {
                return "active";
            }

            public String getScheduledRequestSensorName() {
                return "scheduled";
            }

            public String getRequestThreadCountSensorName() {
                return "threadCount";
            }

            public String getRequestNounPath(String requestType) {
                return BPMNDMSConstants.getBPMNRequestNounPath(requestType);
            }

            public String getActivityNounType() {
                return "soainfra_bpmn_activity";
            }

            public String getExecutionTimeSensorName() {
                return "executionTime";
            }
        };
        this.mDMSService = new DMSInstrumentationServiceImpl(this.mDMSMetadata);
        this.mDeployedDN = new ArrayList<String>();
        this.componentMigrationSupport = new ComponentMigrationSupport(this);
        this.componentMigrationSupport.addComponentMigrationListener(new ComponentMigrationListenerImpl());
        this.userDefinedLogging = new UserDefinedLogging();
        this.mMigrationMgr = new BPMNCubeInstanceMigrationManager();
    }

    public static BPMNServiceEngine getInstance() {
        return sEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployedProjectService getDeployedProjectServiceImpl() throws MetadataException {
        Object object = lock;
        synchronized (object) {
            if (sService == null) {
                MDSInstance mInstance = FabricMDSAccessor.getMDSInstance();
                sService = new DeployedProjectServiceImpl(mInstance);
            }
        }
        return sService;
    }

    public static boolean isForceDeploy(ComponentModel model) {
        return BPMNServiceEngine.isPropertySet(model, FORCE_DEPLOY);
    }

    public static boolean isPropertySet(ComponentModel model, String property) {
        return BPMNServiceEngine.booleanValue(model.getProperty(property)) || BPMNServiceEngine.booleanValue(model.getComposite().getProperty(property));
    }

    public static Long stripCubeInstanceId(String facadeInstanceId) {
        String instanceId = facadeInstanceId.startsWith("bpmn:") ? facadeInstanceId.substring("bpmn:".length()) : facadeInstanceId;
        return Long.valueOf(instanceId);
    }

    public static Set<String> getProcessStatesForComponentState(int componentState) {
        Set<String> result = COMPONENT2PROCESS_STATE_MAP.get(componentState);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public static Integer getComponentStateForProcessState(String processState) {
        Integer result = PROCESS2COMPONENT_STATE_MAP.get(processState);
        return result;
    }

    public static boolean booleanValue(PropertyModel propertyModel) {
        return propertyModel != null && Boolean.valueOf(propertyModel.getValue()) != false;
    }

    public ComponentMigrationSupport getComponentMigrationSupport() {
        return this.componentMigrationSupport;
    }

    public UserDefinedLogging getUserDefinedLogging() {
        return this.userDefinedLogging;
    }

    public ClusterInterface getClusterInterface() {
        return this.mClusterInterface;
    }

    public void setBPMNXPathFunctionResolver(BPMNXPathFunctionResolver resolver) {
        this.bpmnXPathFunctionResolver = resolver;
    }

    public BPMNXPathFunctionResolver getBPMNXPathFunctionResolver() {
        return this.bpmnXPathFunctionResolver;
    }

    public void setBPMNXPathFunctionContext(BPMNXPathFunctionContext context) {
        this.bpmnXPathFunctionContext = context;
    }

    public BPMNXPathFunctionContext getBPMNXPathFunctionContext() {
        return this.bpmnXPathFunctionContext;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.getBPMNXPathFunctionResolver();
    }

    public String getEngineType() {
        return "bpmn";
    }

    public IDaoFactory getDaoFactory() {
        if (this.mDaoFactory == null) {
            this.mDaoFactory = new BpelDaoFactory(this.getBPMNConfig().getQualityOfService());
        }
        return this.mDaoFactory;
    }

    public Class getWaitListenerClass() {
        return BPMNWaitListener.class;
    }

    public Class<BPELRecoveryListener> getRecoveryListenerClass() {
        return BPELRecoveryListener.class;
    }

    public BPELConfig getBpelConfig() {
        return this.getBPMNConfig();
    }

    public void setBpelConfig(BPELConfig bpelConfig) {
        this.bpmnConfig = (BPMNConfig)bpelConfig;
    }

    public BPMNConfig getBPMNConfig() {
        if (this.bpmnConfig == null && this.getFabricConfigManager() != null) {
            this.bpmnConfig = (BPMNConfig)this.getFabricConfigManager().getConfigObject(ConfigDefs.URL_BPMN_CONFIG);
        }
        return this.bpmnConfig;
    }

    public void createComponentInstance(ComponentDN targetComponent, Properties customProperties) throws Exception {
        ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
        customProperties.put("START_EVENT_ID_PROPERTY", "START_EVENT_USER_INITIATE");
        ((IBPMNCubeInstanceManagerLocalBean)localBean).createComponentInstance(targetComponent, customProperties);
    }

    public Object executeEngineMethod(String methodName, Object[] parameters) throws Exception {
        if ("createComponentInstance".equals(methodName)) {
            ComponentDN target = (ComponentDN)parameters[0];
            Properties properties = (Properties)parameters[1];
            this.createComponentInstance(target, properties);
            return null;
        }
        if ("scheduleUserInitiateTaskCleanup".equals(methodName)) {
            BPMNUtility.getUserInitiateProcessCleanupService().schedule();
            return null;
        }
        return super.executeEngineMethod(methodName, parameters);
    }

    public Object executeComponentMethod(CompositeDN compositeDN, String componentName, String methodName, Object[] parameters) throws Exception {
        if ("getBPMNProcessModel".equals(methodName)) {
            Long instanceId = null;
            if (parameters.length > 1) {
                instanceId = BPMNServiceEngine.stripCubeInstanceId((String)parameters[0]);
            }
            return this.getBPMNProcessModel(compositeDN, componentName, instanceId);
        }
        return super.executeComponentMethod(compositeDN, componentName, methodName, parameters);
    }

    public Object executeComponentInstanceMethod(String instanceId, String methodName, Object[] parameters) throws Exception {
        if ("getAuditInstancePayload".equals(methodName)) {
            long queryId = (Long)parameters[0];
            return this.getAuditInstancePayload(queryId);
        }
        if ("getBPMNAudit".equals(methodName)) {
            ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
            List<IAuditInstance> auditInstances = ((IBPMNCubeInstanceManagerLocalBean)localBean).getBPMNAudit(instanceId);
            return auditInstances;
        }
        return super.executeComponentInstanceMethod(instanceId, methodName, parameters);
    }

    public String[] getConfigFileURLs() {
        String[] urls = new String[]{ConfigDefs.URL_BPMN_CONFIG, ConfigDefs.URL_SOA_INFRA_CONFIG};
        return urls;
    }

    public void deploy(ComponentModel model, boolean keepInstancesOnRedeploy) throws FabricDeploymentException {
        if (keepInstancesOnRedeploy) {
            try {
                ScriptTaskUtils.createScriptedProxy(RedeploymentTarget.class, (Object)this).deploy((Object)model, keepInstancesOnRedeploy);
            }
            catch (UnsupportedOperationException e) {
                try {
                    ComponentInstanceMigrationContext componentInstanceMigrationContext = ComponentInstanceMigrationContext.create();
                    ComponentInstanceMigrationAction.PreProcessTargetComponentAction preProcessTargetComponentAction = new ComponentInstanceMigrationAction.PreProcessTargetComponentAction(componentInstanceMigrationContext, this.componentMigrationSupport, model);
                    preProcessTargetComponentAction.execute();
                }
                catch (FabricDeploymentException e1) {
                    this.rollbackDeploy(model);
                    throw e1;
                }
                catch (Exception e1) {
                    this.rollbackDeploy(model);
                    throw new FabricDeploymentException((Throwable)e1);
                }
            }
        }
        this.deploy(model);
    }

    public void deploy(ComponentModel componentModel) {
        super.deploy(componentModel);
        if (!this.mClusterInterface.isLeader()) {
            return;
        }
        CompositeModel compositeModel = componentModel.getComposite();
        Organization organization = this.getBPMOrganization(compositeModel);
        if (organization != null) {
            try {
                this.importOrganization(organization);
            }
            catch (Exception e) {
                throw new FabricDeploymentException((Throwable)e);
            }
        }
        BpmnDesignSchema designSchema = null;
        try {
            designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN, organization);
            designSchema.init();
            designSchema.populateAll();
        }
        catch (Throwable t) {
            if (designSchema != null) {
                designSchema.rollback();
            }
            throw new FabricDeploymentException(t);
        }
        finally {
            if (designSchema != null) {
                designSchema.cleanup();
            }
        }
        String compositeDN = componentModel.getComposite().getDN();
        DeploymentDescriptorUtil.addToCache(compositeDN, organization);
        if (!this.mDeployedDN.contains(compositeDN)) {
            this.mDeployedDN.add(compositeDN);
        }
    }

    public void undeploy(ComponentModel model, boolean keepInstancesOnRedeploy) throws FabricDeploymentException {
        if (!keepInstancesOnRedeploy) {
            this.undeploy(model);
        } else {
            try {
                ScriptTaskUtils.createScriptedProxy(RedeploymentTarget.class, (Object)this).undeploy((Object)model, keepInstancesOnRedeploy);
            }
            catch (UnsupportedOperationException e) {
                try {
                    ComponentInstanceMigrationContext componentInstanceMigrationContext = ComponentInstanceMigrationContext.create();
                    ComponentInstanceMigrationAction.PreProcessSourceComponentAction preProcessSourceComponentAction = new ComponentInstanceMigrationAction.PreProcessSourceComponentAction(componentInstanceMigrationContext, this.componentMigrationSupport, model);
                    preProcessSourceComponentAction.execute();
                }
                catch (Exception e1) {
                    throw new FabricDeploymentException((Throwable)e1);
                }
            }
            CubeEngineLogger.LOG.info("CubeServiceEngine=> undeploy component " + model.getComposite().getDN() + '/' + model.getName());
            PropertyModel propertyModel = new PropertyModel("keepInstancesOnRedeploy", String.valueOf(keepInstancesOnRedeploy));
            model.getProperties().add(propertyModel);
            try {
                BeanCache.getServerManagerLocalBean((String)this.getEngineType()).undeployComponent(model);
            }
            catch (Throwable e) {
                CubeEngineLogger.LOG.error((Object)("Unable to undeploy process " + model.getName()), e);
                throw new RuntimeException(e);
            }
        }
    }

    public void undeploy(ComponentModel componentModel) throws FabricDeploymentException {
        super.undeploy(componentModel);
        try {
            BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
            IInternalInstanceManagementService service = (IInternalInstanceManagementService)BPMServiceLocator.getService((String)"internalInstanceManagementService");
            String componentName = componentModel.getName();
            String compositeDN = componentModel.getComposite().getDN();
            AuditUtil.markAuditAsStale(compositeDN);
            designSchema.undeploy();
            String processDN = new CompositeDN(compositeDN).getStringDN() + "*/" + componentName;
            if (this.shouldRemoveFlexFieldMapping(compositeDN, componentName)) {
                service.markInstanceAsStaleAndRemoveFlexFieldMapping(processDN);
            } else {
                service.markInstanceAsStale(processDN);
            }
            IBpmAGMetadataService agMetadataSvc = BPMServiceLocator.getBpmAGMetadataService();
            agMetadataSvc.purgeAGDefinitionFromCache(compositeDN);
            DeploymentDescriptorUtil.removeFromCache(compositeDN);
            ProcessRoleCache.clearCache(compositeDN);
            IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
            mService.unload(componentModel);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    public void load(ComponentModel componentModel) throws FabricDeploymentException {
        super.load(componentModel);
        if (!this.isDefaultRevisionChangeListenerRegistered) {
            this.registerDefaultRevisionChangeListener();
            this.isDefaultRevisionChangeListenerRegistered = true;
        }
        try {
            IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
            mService.load(componentModel);
        }
        catch (Exception e) {
            Object mService = null;
            throw new FabricDeploymentException((Throwable)e);
        }
        if (ClassloaderHelper.isLoaded("oracle.bpm.runtime.quartz.trigger.UniqueTriggerWithReschedule")) {
            this.addQuartzCalendars(componentModel);
        }
    }

    public Organization getBPMOrganization(String compositeDN) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        return this.getBPMOrganization(compositeModel);
    }

    public Organization getBPMOrganization(CompositeModel compositeModel) {
        Document dom = compositeModel.getMetadataManager().getDocumentAsDOM(ORGANIZATION_FILE_NAME);
        if (dom != null) {
            Organization organization = DeploymentDescriptorUtil.getBPMOrganization(dom);
            return organization;
        }
        return null;
    }

    public String getCompositeName(String compositeDN) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        return compositeModel.getName();
    }

    public PropertyModel getCompositeProperty(String compositeDN, String propertyName) {
        CompositeModel compositeModel = this.lookupCompositeModel(compositeDN);
        if (compositeModel != null) {
            PropertyModel prop = compositeModel.getProperty(propertyName);
            return prop;
        }
        return null;
    }

    public String getDeployedCompositeBaseURL(String compositeDN) throws Exception {
        StringBuffer url = new StringBuffer();
        url.append(this.getFabricConfigManager().getApplicationURLBase());
        url.append(compositeDN);
        url.append('/');
        return url.toString();
    }

    public void commitConfigChange(ComponentModel componentModel, boolean commit) throws FabricDeploymentException {
        super.commitConfigChange(componentModel, commit);
        if (commit) {
            try {
                BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
                if (ComponentMigrationSupport.isComponentSuspended(componentModel)) {
                    designSchema.markSuspended();
                } else {
                    boolean isActive = this.isActive(componentModel);
                    this.updateScheduleStartTimerEvents(componentModel, !isActive);
                    designSchema.setActive(isActive);
                }
            }
            catch (Exception e) {
                throw new FabricDeploymentException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScheduleStartTimerEvents(ComponentModel component, boolean pause) throws CubeException {
        if (component != null && component.getImplementationType() == ImplementationType.BPMN) {
            ICubeContext ctx = null;
            try {
                ComponentDN componentDN = new ComponentDN(component.getComposite().getDN(), component.getName());
                ctx = CubeContextFactory.newInstance().create(this.getEngineType());
                CurrentEngineType.push((String)this.getEngineType());
                ICubeProcess process = DeploymentHelper.lookupProcess((ComponentDN)componentDN, (ICubeContext)ctx);
                BPMNProcess bpmnProcess = (BPMNProcess)process;
                DeploymentLogger.LOG.debug("BPMNServiceEngine", "updateStartTimers", new Object[]{"updating scheduler for " + component.getComposite().getDN() + "/" + component.getName(), component.getComposite().getDN(), "/", component.getName()});
                TimerStartEventScheduler.updateSchedulers(component.getComposite().getDN(), component.getName(), bpmnProcess.getTimerEvents(), pause);
            }
            finally {
                if (ctx != null) {
                    CurrentEngineType.pop();
                }
            }
        }
    }

    public void stateChanged(int newState) {
        super.stateChanged(newState);
        String logMethodName = "stateChanged";
        if (newState == 3) {
            try {
                if (WorkflowUtil.isBPMInstall() && !"OFF".equals(this.getBPMNConfig().getUserInitiateProcessCleanupAction())) {
                    IUserInitiateProcessCleanupService svc = BPMNUtility.getUserInitiateProcessCleanupService();
                    svc.cancelTimer();
                    svc.schedule();
                }
            }
            catch (Exception e) {
                DeploymentLogger.LOG.error(logClassName, "stateChanged", new Object[]{"A problem was encounted during state change to STATE_RUNNING", e});
            }
        }
        if (newState == 4) {
            try {
                BPMNUtility.getUserInitiateProcessCleanupService().cancelTimer();
            }
            catch (Exception e) {
                DeploymentLogger.LOG.error(logClassName, "stateChanged", new Object[]{"A problem was encounted during state change to STATE_STOPPING", e});
            }
        }
    }

    public int abortInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        String logMethodName = "abortInstancesByCompositeInstanceId";
        DeploymentLogger.LOG.debug(logClassName, "abortInstancesByCompositeInstanceId", new Object[]{"BEGIN"});
        AuditUtil.markAuditAsAborted(Util.getInternalWorkflowContext(), String.valueOf(compositeInstanceId));
        int instances = super.abortInstancesByCompositeInstanceId(compositeInstanceId);
        IInternalInstanceManagementService service = (IInternalInstanceManagementService)BPMServiceLocator.getService((String)"internalInstanceManagementService");
        service.abortInstancesByCompositeInstanceId(Util.getInternalWorkflowContext(), compositeInstanceId);
        DeploymentLogger.LOG.debug(logClassName, "abortInstancesByCompositeInstanceId", new Object[]{"END"});
        return instances;
    }

    public int deleteInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        String logMethodName = "deleteInstancesByCompositeInstanceId";
        DeploymentLogger.LOG.debug(logClassName, "deleteInstancesByCompositeInstanceId", new Object[]{"BEGIN"});
        AuditUtil.markAuditAsAborted(Util.getInternalWorkflowContext(), String.valueOf(compositeInstanceId));
        int instances = super.deleteInstancesByCompositeInstanceId(compositeInstanceId);
        DeploymentLogger.LOG.debug(logClassName, "deleteInstancesByCompositeInstanceId", new Object[]{"END"});
        return instances;
    }

    public void resumeComponent(ComponentDN componentDN) throws Exception {
        this._resumeComponent(new CompositeDN(componentDN.getCompositeDN()), componentDN.getComponentName());
        ComponentModel componentModel = this.lookupComponentModel(componentDN);
        if (componentModel != null) {
            BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
            designSchema.markResumed();
        }
    }

    public boolean isDefaultRevision(String compositeDN) {
        CompositeModel compositeModel;
        boolean flag = false;
        if (compositeDN != null && compositeDN.length() > 0 && this.isDeployed(compositeDN) && (compositeModel = this.lookupCompositeModel(compositeDN)) != null) {
            flag = compositeModel.isDefaultInSeries();
        }
        return flag;
    }

    public void suspendComponent(ComponentDN componentDN) throws Exception {
        this.suspendComponent(new CompositeDN(componentDN.getCompositeDN()), componentDN.getComponentName());
        ComponentModel componentModel = this.lookupComponentModel(componentDN);
        if (componentModel != null) {
            BpmnDesignSchema designSchema = new BpmnDesignSchema(componentModel, this.mDeployedDN);
            designSchema.markSuspended();
        }
    }

    public void suspendComponent(final CompositeDN compositeDN, final String componentName) throws Exception {
        BPMNServiceEngine.runAs(BPMNServiceEngine.getAdminUser(), new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                BPMNServiceEngine.super.suspendComponent(compositeDN, componentName);
                return null;
            }
        });
    }

    public void resumeComponent(CompositeDN compositeDN, String componentName) throws Exception {
        this._resumeComponent(compositeDN, componentName);
        BpmnDesignSchema designSchema = new BpmnDesignSchema(this.lookupComponentModel(compositeDN, componentName), this.mDeployedDN);
        designSchema.markResumed();
    }

    public void suspendInstance(long cikey) throws ServerException, Exception {
        String logMethodName = "suspendInstance";
        DeploymentLogger.LOG.debug(logClassName, "suspendInstance", new Object[]{"SUSPEND {" + cikey + "}"});
        this._suspendInstance(cikey);
        AuditUtil.logSuspendInstance(cikey);
    }

    public void resumeInstance(long cikey) throws Exception {
        String logMethodName = "suspendInstance";
        DeploymentLogger.LOG.debug(logClassName, "suspendInstance", new Object[]{"RESUME {" + cikey + "}"});
        this._resumeInstance(cikey);
        AuditUtil.logResumeInstance(cikey);
    }

    public void defaultRevisionChanged(String series, String revision, String composite, String state, String mode) {
    }

    public void seriesRemoved(String seriesName) {
    }

    public boolean suspendInstanceIfRequired(long cikey) throws Exception {
        boolean wasSuspended = false;
        IBPMNCubeInstanceManagerLocalBean instanceManagerLocalBean = (IBPMNCubeInstanceManagerLocalBean)BeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
        int instanceState = instanceManagerLocalBean.getInstanceState(cikey);
        if (instanceState != 2) {
            this.suspendInstance(cikey);
            wasSuspended = true;
        }
        return wasSuspended;
    }

    public boolean isDeployed(String compositeDN) {
        boolean flag = false;
        if (compositeDN != null) {
            flag = this.getMesh().isDeployed(compositeDN);
        }
        return flag;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof DeploymentEvent) {
            DeploymentEvent deploymentEvent = (DeploymentEvent)applicationEvent;
            CompositeModel compositeModel = deploymentEvent.getModel();
            List componentModelList = compositeModel.getComponentList();
            if ("undeploy".equals(deploymentEvent.getMode())) {
                this.mLastUndeployedComposite = compositeModel;
                return;
            }
            for (ComponentModel componentModel : componentModelList) {
                if (!ImplementationType.BPMN.equals((Object)componentModel.getImplementationType())) continue;
                try {
                    if ("deploy".equals(deploymentEvent.getMode())) {
                        this.internalPostDeployComponent(componentModel, deploymentEvent.isKeepInstancesOnRedeploy());
                        continue;
                    }
                    if (!"redeployComplete".equals(deploymentEvent.getMode())) continue;
                    this.onComponentRedeployComplete(componentModel, deploymentEvent.isKeepInstancesOnRedeploy());
                }
                catch (Exception e) {
                    CubeEngineLogger.LOG.error((Object)("post deploy failed for component " + componentModel.getName()), (Throwable)e);
                }
            }
            if ("deploy".equals(deploymentEvent.getMode())) {
                this.internalPostDeployComposite(deploymentEvent.getModel(), deploymentEvent.isKeepInstancesOnRedeploy());
            } else if ("redeployComplete".equals(deploymentEvent.getMode())) {
                this.onCompositeRedeployComplete(deploymentEvent.getModel(), deploymentEvent.isKeepInstancesOnRedeploy());
            }
        }
    }

    public void init(ComponentModel model) {
        super.init(model);
    }

    public void postDeployComponent(ComponentModel model, boolean keepInstancesOnRedeploy) throws Exception {
        boolean isActive;
        if (BPMRuntimeLogger.isRuntimeTestEnabled()) {
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("model", model);
                ScriptTaskUtils.evaluateScript(ScriptTaskUtils.getScriptFile(ScriptTaskUtils.buildScriptName(model.getName(), model.getComposite().getName(), model.getComposite().getRevision())), map);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isActive = this.isActive(model)) {
            this.scheduleStartTimerEvents(model);
        }
    }

    public void onComponentRedeployComplete(ComponentModel newModel, boolean keepInstancesOnRedeploy) throws Exception {
        ComponentModel oldModel = null;
        if (this.mLastUndeployedComposite != null) {
            oldModel = this.mLastUndeployedComposite.getComponent(newModel.getName());
        }
        if (keepInstancesOnRedeploy && oldModel != null) {
            try {
                BpmnDesignSchema designSchema = new BpmnDesignSchema(oldModel, this.mDeployedDN);
                designSchema.markMigrated();
            }
            catch (Exception e) {
                throw new FabricDeploymentException((Throwable)e);
            }
            try {
                ComponentInstanceMigrationContext componentInstanceMigrationContext = ComponentInstanceMigrationContext.create();
                ComponentInstanceMigrationAction.PostOverwriteComponentAction postOverwriteComponentAction = new ComponentInstanceMigrationAction.PostOverwriteComponentAction(componentInstanceMigrationContext, this.componentMigrationSupport, oldModel, newModel);
                postOverwriteComponentAction.execute();
            }
            catch (Exception e) {
                CubeEngineLogger.LOG.error((Object)("init failed for component " + oldModel.getName()), (Throwable)e);
            }
        }
        this.postDeployComponent(newModel, keepInstancesOnRedeploy);
    }

    public void postDeployComposite(CompositeModel model, boolean keepInstancesOnRedeploy) {
    }

    public void onCompositeRedeployComplete(CompositeModel model, boolean keepInstancesOnRedeploy) {
        this.postDeployComposite(model, keepInstancesOnRedeploy);
    }

    public String getEngineMBeanType() {
        return "BPMNEngine";
    }

    public String getEngineMBeanName() {
        return "BPMNEngine";
    }

    protected BPMFaultImpl createFault() {
        return new BPMNFaultImpl();
    }

    protected BPMInstanceImpl createInstance() {
        return new BPMNInstanceImpl();
    }

    protected void resumeActivities(long cikey) throws Exception {
        List workItems = BeanCache.getInstanceManagerLocalBean((String)this.getEngineType()).getActivities(cikey);
        List activities = CubeFabricUtil.convert((ICubeInstanceDao)this.getJpaDaoFactory().getCubeInstanceDaoBean(), (List)workItems, (String)this.getEngineType());
        ArrayList<ActivityInstance> acts2Recover = new ArrayList<ActivityInstance>();
        for (ActivityInstance activity : activities) {
            acts2Recover.add(activity);
        }
        BeanCache.getServerManagerLocalBean((String)this.getEngineType()).recoverActivities(acts2Recover);
    }

    private static String getAdminUser() throws BPMIdentityException {
        if (adminUser == null) {
            JavaWorkflowServiceClient client = (JavaWorkflowServiceClient)JavaWorkflowServiceClient.getInstance();
            BPMIdentityService identityService = client.getIdentityService(null);
            for (BPMIdentity bpmIdentity : identityService.getGranteesToAppRole(ROLE_SOA_ADMIN, APP_NAME, false)) {
                if (bpmIdentity.getIdentityType() != BPMIdentityType.USER) continue;
                adminUser = bpmIdentity.getName();
                break;
            }
            if (adminUser == null) {
                throw new BPMIdentityException(10509);
            }
        }
        return adminUser;
    }

    private static <T> T runAs(final String userName, PrivilegedExceptionAction action) {
        try {
            ActionExecutor executor = AccessController.doPrivileged(new PrivilegedExceptionAction<ActionExecutor>(){

                @Override
                public ActionExecutor run() throws AssertionException, JpsException {
                    return SubjectSecurity.getInstance().getActionExecutor(userName);
                }
            }, null);
            return (T)executor.execute(action);
        }
        catch (PrivilegedActionException pae) {
            throw new SecurityException(pae);
        }
    }

    private void addQuartzCalendars(ComponentModel componentModel) {
        CompositeModel compositeModel = componentModel.getComposite();
        Organization organization = this.getBPMOrganization(compositeModel);
        String compositeDN = componentModel.getComposite().getDN();
        this.addQuartzCalendars(compositeDN, organization);
    }

    private void addQuartzCalendars(String compositeDN, Organization organization) throws RuntimeException {
        List calendarRuleList = organization.getCalendarRules().getCalendarRule();
        List holidayRuleList = organization.getHolidayRules().getHolidayRule();
        for (CalendarRule calendarRule : calendarRuleList) {
            HolidayRule holidayRule = null;
            if (calendarRule.isSetHolidayRuleId()) {
                String holidayRuleId = calendarRule.getHolidayRuleId();
                for (HolidayRule aHolidayRule : holidayRuleList) {
                    if (!aHolidayRule.getId().equals(holidayRuleId)) continue;
                    holidayRule = aHolidayRule;
                    break;
                }
            }
            this.addQuartzCalendar(compositeDN, calendarRule, holidayRule, true);
            this.addQuartzCalendar(compositeDN, calendarRule, holidayRule, false);
        }
    }

    private void addQuartzCalendar(String compositeDN, CalendarRule calendarRule, HolidayRule holidayRule, boolean inDbScheduler) {
        FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(inDbScheduler);
        try {
            RulesCalendar rulesCalendar = new RulesCalendar(calendarRule, holidayRule);
            rulesCalendar.setTimeZone(TimeZone.getDefault());
            SchedulerServiceHelper.addCalendar(schedulerService, RulesCalendar.buildName(compositeDN, calendarRule.getName()), rulesCalendar, true, true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalPostDeployComponent(ComponentModel model, boolean keepInstancesOnRedeploy) throws Exception {
        CompositeModel relatedComposite = this.componentMigrationSupport.findRelatedComposite(new oracle.fabric.composite.CompositeDN(model.getComposite().getDN()));
        if (relatedComposite == null) {
            this.postDeployComponent(model, keepInstancesOnRedeploy);
        }
    }

    private void internalPostDeployComposite(CompositeModel model, boolean keepInstancesOnRedeploy) {
        CompositeModel relatedComposite = this.componentMigrationSupport.findRelatedComposite(new oracle.fabric.composite.CompositeDN(model.getDN()));
        if (relatedComposite == null) {
            this.postDeployComposite(model, keepInstancesOnRedeploy);
        }
    }

    private boolean shouldRemoveFlexFieldMapping(String compositeDN, String componentName) {
        String dnWithoutLabel = new CompositeDN(compositeDN).getStringDN() + "*";
        List composites = this.getMesh().listComposites();
        for (CompositeModel composite : composites) {
            String dn = composite.getDN();
            if (!dn.startsWith(dnWithoutLabel) || dn.equals(compositeDN) || composite.getComponent(componentName) == null) continue;
            return false;
        }
        return true;
    }

    private void scheduleStartTimerEvents(ComponentModel model) {
        ICubeServerManagerLocalBean localBean;
        try {
            localBean = BeanCache.getServerManagerLocalBean((String)this.getEngineType());
        }
        catch (Exception e) {
            throw new CubeRuntimeException((Throwable)e);
        }
        ((IBPMNCubeServerManagerLocalBean)localBean).scheduleStartTimerEvents(model);
    }

    private void rollbackDeploy(ComponentModel model) {
        try {
            BpmnDesignSchema designSchema = new BpmnDesignSchema(model, this.mDeployedDN);
            designSchema.rollback();
        }
        catch (Exception e) {
            CubeEngineLogger.LOG.error((Object)("Failed to rollback bpmn design schema for " + model.getName()), (Throwable)e);
        }
    }

    private void _resumeComponent(final CompositeDN compositeDN, final String componentName) throws Exception {
        BPMNServiceEngine.runAs(BPMNServiceEngine.getAdminUser(), new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                BPMNServiceEngine.super.resumeComponent(compositeDN, componentName);
                ICubeContext context = CubeContextFactory.newInstance().create(BPMNServiceEngine.this.getEngineType());
                ComponentDN componentDN = new ComponentDN(compositeDN.getStringDN(), componentName);
                CubeContextHelper.bindProcessDN((ComponentDN)componentDN, (ICubeContext)context);
                DispatchHelper.dispatchLocal((IMessage)new RecoverInstancesMessage(componentDN, BPMNServiceEngine.this.getEngineType(), 100), (ICubeContext)context);
                return null;
            }
        });
    }

    private void _suspendInstance(final long cikey) throws Exception {
        BPMNServiceEngine.runAs(BPMNServiceEngine.getAdminUser(), new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                BPMNServiceEngine.super.suspendInstance(cikey);
                return null;
            }
        });
    }

    private void _resumeInstance(final long cikey) throws Exception {
        BPMNServiceEngine.runAs(BPMNServiceEngine.getAdminUser(), new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                BPMNServiceEngine.super.resumeInstance(cikey);
                return null;
            }
        });
    }

    private void registerDefaultRevisionChangeListener() {
        block2: {
            try {
                Object compositeDeploymentCoordinator = FabricMeshUtils.getApplicationContext().getBean("CompositeDeploymentCoordinator");
                Method method = compositeDeploymentCoordinator.getClass().getMethod("getDefaultRevisionChangeListeners", new Class[0]);
                List listeners = (List)method.invoke(compositeDeploymentCoordinator, new Object[0]);
                listeners.add(this);
            }
            catch (Exception e) {
                CubeEngineLogger.LOG.error((Object)"Failed to get Fabric application context", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private String getBPMNProcessModel(CompositeDN compositeDN, String componentName, @Nullable Long instanceId) throws Exception {
        String label = null;
        if (instanceId != null) {
            label = ((IBPMNCubeInstanceManagerLocalBean)BeanCache.getInstanceManagerLocalBean((String)this.getEngineType())).getCompositeLabel(instanceId);
        }
        ComponentDN componentDN = new ComponentDN(compositeDN.getDomainName(), compositeDN.getCompositeName(), compositeDN.getRevision(), label, componentName);
        ICubeProcessManagerLocalBean localBean = EngineBeanCache.getProcessManagerLocalBean((String)this.getEngineType());
        return ((IBPMNProcessManagerLocalBean)localBean).getBPMNProcessModelXML(componentDN);
    }

    private CompositeModel lookupCompositeModel(String compositeDN) {
        return this.getMesh().getComposite(compositeDN);
    }

    private String getAuditInstancePayload(long queryId) throws Exception {
        RecycleBin pool = EngineRecycleBinRegistry.getInstance();
        NonSyncStringWriter sink = (NonSyncStringWriter)pool.get(NonSyncStringWriter.class);
        ICubeInstanceManagerLocalBean localBean = EngineBeanCache.getInstanceManagerLocalBean((String)this.getEngineType());
        try {
            byte[] bs = ((IBPMNCubeInstanceManagerLocalBean)localBean).getAuditInstancePayload(queryId);
            CXCompressUtils.uncompressStream((byte[])bs, (Writer)sink);
            String string = sink.toString();
            return string;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleServerException((Throwable)t);
        }
        finally {
            pool.release((IRecyclable)sink);
        }
    }

    private void registerBPMNLoggerAndResource() {
        LogFactory.addLoggerManager((String)this.getEngineType(), (ICubeLoggerManager)BPMNLoggerManager.getInstance());
        ResourceBundleHelper.addResourceBundleManager((String)"bpmn", (ICubeResourceBundleManager)BPMNResourceBundleManager.getInstance());
    }

    private boolean isActive(ComponentModel componentModel) {
        return this.isActive(componentModel.getComposite());
    }

    private boolean isActive(CompositeModel compositeModel) {
        return "active".equals(compositeModel.getMode()) && "on".equals(compositeModel.getState());
    }

    private void importOrganization(Organization organization) throws Exception {
        IBPMContext ctx = this.getInternalBPMContext();
        DeploymentDescriptorUtil.importOrganization(ctx, organization);
    }

    private IBPMContext getInternalBPMContext() throws BPMException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof BPMException) {
                throw (BPMException)orgEx;
            }
            throw new BPMException((Exception)pae);
        }
    }

    static {
        PROCESS2COMPONENT_STATE_MAP.put("OPEN", 0);
        PROCESS2COMPONENT_STATE_MAP.put("SUSPENDED", 0);
        PROCESS2COMPONENT_STATE_MAP.put("PENDING_MIGRATION", 0);
        PROCESS2COMPONENT_STATE_MAP.put("PENDING_MIGRATION_SUSPENDED", 0);
        Set<String> processStates = PROCESS2COMPONENT_STATE_MAP.keySet();
        for (String processState : processStates) {
            Integer componentState = PROCESS2COMPONENT_STATE_MAP.get(processState);
            Set<String> states = COMPONENT2PROCESS_STATE_MAP.get(componentState);
            if (states == null) {
                states = new HashSet<String>();
                COMPONENT2PROCESS_STATE_MAP.put(componentState, states);
            }
            states.add(processState);
        }
        sService = null;
        lock = new Object();
        logClassName = BPMNServiceEngine.class.getName();
        sEngine = null;
    }
}

