/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.admin.observer.ServerConfigChangeAspect;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.observer.InstanceAbortAspect;
import com.collaxa.cube.observer.ICubeAspect;
import com.collaxa.cube.observer.ICubeObserver;
import oracle.bpm.bpmn.engine.instancemanagement.impl.UserInitiateProcessCleanupConfig;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.soa.management.config.bpmn.BPMNConfig;

public class BPMNConfigListener
implements ICubeObserver {
    private static final Class logClassName = BPMNConfigListener.class;

    public void update(ICubeAspect aspect) throws Exception {
        ServerConfigChangeAspect changeAspect;
        String logMethodName = "update";
        DeploymentLogger.LOG.debug(logClassName, "update", new Object[]{"BEGIN ", aspect.getClass().getName()});
        if (aspect instanceof ServerConfigChangeAspect && (changeAspect = (ServerConfigChangeAspect)aspect).getConfigObject() instanceof BPMNConfig) {
            BPMNConfig config = (BPMNConfig)changeAspect.getConfigObject();
            UserInitiateProcessCleanupConfig.getInstance().update(config);
            String action = config.getUserInitiateProcessCleanupAction();
            if ("OFF".equals(config.getUserInitiateProcessCleanupAction())) {
                DeploymentLogger.LOG.debug(logClassName, "update", new Object[]{"Cancelling UserInitiateProcessCleanup Timer "});
                BPMNUtility.getUserInitiateProcessCleanupService().cancelTimer();
            }
            if ("ABORT".equals(action) || "DELETE".equals(action)) {
                DeploymentLogger.LOG.debug(logClassName, "update", new Object[]{"Rescheduling UserInitiateProcessCleanup Timer "});
                BPMNUtility.getUserInitiateProcessCleanupService().cancelTimer();
                BPMNUtility.getUserInitiateProcessCleanupService().schedule();
            }
        }
        if (aspect instanceof InstanceAbortAspect) {
            InstanceAbortAspect abortAspect = (InstanceAbortAspect)aspect;
            BPMNAuditEvent event = null;
            try {
                ICubeContext ctx = abortAspect.getContext();
                ICubeInstance instance = (ICubeInstance)ctx.getFromEnvironment("__cube-instance");
                if ("bpmn".equals(instance.getCubeInstanceEO().getComponentType())) {
                    assert (instance != null) : "The instance can not be found or is not set properly";
                    event = AuditUtil.createNewAuditEvent(instance);
                    event.setOperation(AuditInstanceOperation.INSTANCE_ABORTED);
                    event.setComponentInstanceId(String.valueOf(abortAspect.getKey()));
                    event.setComponentName(instance.getComponentName());
                    event.setProcessName(instance.getComponentName());
                    event.setAuditInstanceType(AuditInstanceOperation.INSTANCE_ABORTED.getType(false));
                    event.setComment("Process initiated abort");
                    event.setActivityId(instance.getComponentName());
                    event.setActivityName("PROCESS");
                    event.setFlowElementType("PROCESS");
                    event.setLabel(AuditInstanceOperation.INSTANCE_ABORTED.name());
                    event.setTitle(event.getLabel());
                    event.setScopeId(event.getActivityId() + ".0");
                    event.setAuditLevel(Long.valueOf(AuditUtil.getAuditLevel(ctx)));
                    AuditServiceFactory.getInstance().getAuditService().logAuditInstance(ctx, event);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        DeploymentLogger.LOG.debug(logClassName, "update", new Object[]{"END"});
    }
}

