/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.BatchEvent;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditKeyGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BPMNAuditTrail
implements IAuditTrail {
    int defaultBatchThreshold = 10;
    BatchEvent mBatch = new BatchEvent();
    ICubeInstance mInstance;
    private int mBatchThreshold;
    private ICubeContext mCubeContext = null;
    private List<IAuditEvent> mPersisted;
    private static final Class logClassName = BPMNAuditTrail.class;

    public BPMNAuditTrail(BatchEvent event) {
        this.mBatch = event;
    }

    public BPMNAuditTrail(ICubeInstance cubeInstance, @NotNull ICubeContext ctx) {
        this.setCubeInstance(cubeInstance);
        this.mBatchThreshold = this.defaultBatchThreshold;
        this.mCubeContext = ctx;
    }

    public final void logEvent(IAuditEvent event) throws CubeException {
        String logMethodName = "logEvent";
        if (event instanceof BPMNAuditEvent) {
            if (this.mBatch.getInstanceCreationDate() == null && this.mInstance != null) {
                this.mBatch.setInstanceCreationDate(this.mInstance.getCreationDate());
            }
            try {
                ((BPMNAuditEvent)event).setQueryId(AuditKeyGenerator.getInstance().nextId(this.mCubeContext));
            }
            catch (Exception e) {
                BPELExecutionLogger.LOG.error((Object)"Unable to obtain the next Audit Query ID", (Throwable)e);
                throw new CubeException((Throwable)e);
            }
            this.mBatch.add(event);
            BPELExecutionLogger.LOG.debug(logClassName, "logEvent", new Object[]{"Added an event to batch {" + event + "} current batch size {" + this.mBatch.size() + "}"});
        }
    }

    public final void persist() throws CubeException {
        String logMethodName = "persist";
        if (this.mBatch.size() >= this.mBatchThreshold) {
            try {
                BPELExecutionLogger.LOG.debug(logClassName, "persist", new Object[]{"Persisting {" + this.getEventCount() + "} audit records."});
                this.mPersisted = BPMNUtility.persistAuditData(this.mCubeContext);
            }
            catch (Exception e) {
                BPELExecutionLogger.LOG.error(logClassName, "persist", new Object[]{"Exception when attempting to persist a batch of audit events. " + e.toString()});
                throw new CubeException((Throwable)e);
            }
            try {
                BPMNUtility.publishToMeasurement(this.mCubeContext);
                this.clear();
            }
            catch (Exception e) {
                BPELExecutionLogger.LOG.error(logClassName, "persist", new Object[]{"A problem occurred publishing to Measurement " + e.toString()});
            }
            this.mBatch = new BatchEvent();
            if (this.mInstance != null) {
                this.mBatch.setInstanceCreationDate(this.mInstance.getCreationDate());
                this.mBatch.setCikey(this.mInstance.getId());
            }
        }
    }

    public void setCubeInstance(ICubeInstance ci) {
        if (ci != null) {
            this.mInstance = ci;
            this.mBatch.setCikey(this.mInstance.getId());
        }
    }

    public final int getEventCount() {
        return this.mBatch.size();
    }

    public final boolean hasEvents() {
        return this.mBatch.size() > 0;
    }

    public ICubeContext getCubeContext() {
        return this.mCubeContext;
    }

    public final Iterator<IAuditEvent> getEvents() {
        return this.mBatch.getEvents().iterator();
    }

    public final void clear() {
        this.mBatch.getEvents().clear();
        this.mBatch.setInstanceCreationDate(null);
        if (this.mPersisted != null) {
            this.mPersisted.clear();
        }
    }

    public final ICubeInstance getCubeInstance() {
        return this.mInstance;
    }

    public List<IAuditEvent> getPersisted() {
        return this.mPersisted;
    }

    @Nullable
    public final BPMNAuditEvent getLastAuditLog(@NotNull String auditScopeId, @NotNull String activityId) {
        BPMNAuditEvent event = this.locateEvent(this.mBatch.getEvents(), auditScopeId, activityId);
        return event;
    }

    void setPersisted(List<IAuditEvent> persisted) {
        this.mPersisted = persisted;
    }

    private BPMNAuditEvent locateEvent(List<IAuditEvent> events, String auditScopeId, String activityId) {
        String logMethodName = "getLastAuditLog";
        if (events.size() > 0) {
            BPELExecutionLogger.LOG.debug(logClassName, "getLastAuditLog", new Object[]{"Looking for {" + auditScopeId + "} {" + activityId + "} ", "in {" + events.toString() + "}"});
            BPMNAuditEvent event = null;
            ListIterator<IAuditEvent> eventIterator = events.listIterator(events.size());
            while (eventIterator.hasPrevious()) {
                event = (BPMNAuditEvent)eventIterator.previous();
                if (!auditScopeId.equals(event.getScopeId()) || !activityId.equals(event.getActivityId())) continue;
                return event;
            }
        }
        return null;
    }
}

