/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.service;

import com.collaxa.cube.engine.audit.AuditCategory;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.audit.AuditType;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditActivityInfo;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableMetadata;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.services.instancequery.impl.AuditVariable;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BPMNAuditEvent
implements IAuditInstance,
IAuditEvent {
    private CompositeDNModel compositeDNModel;
    private AuditActivityInfo mActivityInfo;
    private List<String> mAssociatedVariables;
    private AuditQuery mAuditQuery;
    private List<AuditExpressionExecution> mExpressionExecution;
    private transient Map<IAuditVariable.Direction, Map<String, IAuditVariable>> mPayload;
    private transient Document mPayloadDoc;
    private transient Map<String, IAuditVariable> mVariables;
    private ArrayList<String> mVarNames;
    static final long serialVersionUID = -6255674863037290125L;
    private static final String AUDIT_PAYLOAD_NS = "http://xmlns.oracle.com/bpmn/engine/audit";
    static final Class logClassName = BPMNAuditEvent.class;

    public BPMNAuditEvent() {
        this.mAuditQuery = new AuditQuery();
    }

    public BPMNAuditEvent(AuditQuery auditQuery) {
        this.mAuditQuery = auditQuery;
    }

    public BPMNAuditEvent(IAuditInstance auditInstance) throws Exception {
        this.mAuditQuery = AuditUtil.createAuditQuery(auditInstance);
        this.mVariables = auditInstance.getAllVariables();
        this.mPayloadDoc = auditInstance.getPayloadDoc();
        IAuditService service = AuditServiceFactory.getInstance().getAuditService();
        AuditQueryMetadata varMd = service.getAuditQueryMetadata(auditInstance.getCompositeDn());
        this.mAuditQuery.setAuditQueryMetadata(varMd);
    }

    public IScope getScope() {
        return null;
    }

    public Object getMessage() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public Object[] getIndexes() {
        Object[] indexes = null;
        return indexes;
    }

    public IAuditVariable getVariable(String name) {
        if (!this.isVariablesAvailable()) {
            return null;
        }
        if (this.mVariables == null) {
            this.mVariables = new HashMap<String, IAuditVariable>();
        }
        if (this.mVariables.containsKey(name)) {
            return this.mVariables.get(name);
        }
        int slot = 0;
        Object v = null;
        AuditQueryVariableMetadata aqmd = null;
        if (this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().size() > 0) {
            aqmd = this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().get(0);
            slot = aqmd.getNumberNames().indexOf(name) + 1;
            v = slot > 0 ? this.createVariable(name, aqmd.getNumberType(slot), "NUMBER", slot, "AUDIT_QUERY", this.getNumberValue(slot)) : ((slot = aqmd.getStringNames().indexOf(name) + 1) > 0 ? this.createVariable(name, aqmd.getStringType(slot), "STRING", slot, "AUDIT_QUERY", this.getStringValue(slot)) : ((slot = aqmd.getDateNames().indexOf(name) + 1) > 0 ? this.createVariable(name, aqmd.getDateType(slot), "DATE", slot, "AUDIT_QUERY", this.getDateValue(slot)) : null));
        }
        if (v != null) {
            this.mVariables.put(v.getName(), (IAuditVariable)v);
        }
        return v;
    }

    public Map<String, IAuditVariable> getVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        return this.createFilteredVariableList(this.getVarNames(), this.mAssociatedVariables);
    }

    public Map<String, IAuditVariable> getAllVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        return this.createVariableList(this.getVarNames());
    }

    public void setActivityId(String activityId) {
        this.mAuditQuery.setActivityId(activityId);
    }

    public String getActivityId() {
        return this.mAuditQuery.getActivityId();
    }

    public void setActivityName(String activityName) {
        this.mAuditQuery.setActivityName(activityName);
    }

    public String getActivityName() {
        return this.mAuditQuery.getActivityName();
    }

    public void setLoopCount(Long value) {
        this.mAuditQuery.setLoopCount(value);
    }

    public Long getLoopCount() {
        return this.mAuditQuery.getLoopCount();
    }

    public void setAuditInstanceType(String auditInstanceType) {
        this.mAuditQuery.setAuditInstanceType(auditInstanceType);
    }

    public String getAuditInstanceType() {
        return this.mAuditQuery.getAuditInstanceType();
    }

    public void setComponentInstanceId(String componenetInstanceId) {
        this.mAuditQuery.setComponentInstanceId(componenetInstanceId);
    }

    public String getComponentInstanceId() {
        return this.mAuditQuery.getComponentInstanceId();
    }

    public void setComponentName(String componentName) {
        this.mAuditQuery.setComponentName(componentName);
    }

    public String getComponentName() {
        return this.mAuditQuery.getComponentName();
    }

    public void setComponentType(String componentType) {
        this.mAuditQuery.setComponentType(componentType);
    }

    public String getComponentType() {
        return this.mAuditQuery.getComponentType();
    }

    public void setCompositeDn(String compositeDn) {
        this.mAuditQuery.setCompositeDn(compositeDn);
    }

    public String getCompositeDn() {
        return this.mAuditQuery.getCompositeDn();
    }

    public void setCompositeInstanceId(String compositeInstanceId) {
        this.mAuditQuery.setCompositeInstanceId(compositeInstanceId);
    }

    public String getCompositeInstanceId() {
        return this.mAuditQuery.getCompositeInstanceId();
    }

    public void setCompositeName(String compositeName) {
        this.mAuditQuery.setCompositeName(compositeName);
    }

    public String getCompositeName() {
        return this.mAuditQuery.getCompositeName();
    }

    public void setProcessName(String processName) {
        this.mAuditQuery.setProcessName(processName);
    }

    public String getProcessName() {
        return this.mAuditQuery.getProcessName();
    }

    public void setStep(Long step) {
        this.mAuditQuery.setStep(step);
    }

    public Long getStep() {
        return this.mAuditQuery.getStep();
    }

    public void setCreateTime(Calendar createTime) {
        this.mAuditQuery.setCreateTime(createTime);
    }

    public Calendar getCreateTime() {
        return this.mAuditQuery.getCreateTime();
    }

    public void setDueDate(Calendar dueDate) {
        this.mAuditQuery.setDueDate(dueDate);
    }

    public Calendar getDueDate() {
        return this.mAuditQuery.getDueDate();
    }

    public void setFaultIsrecoverable(boolean isFailutRecoverable) {
        this.mAuditQuery.setFaultIsrecoverable(isFailutRecoverable ? "Y" : "N");
    }

    public boolean getFaultIsrecoverable() {
        return "Y".equals(this.mAuditQuery.getFaultIsrecoverable());
    }

    public void setFaultType(String faultType) {
        if (faultType != null) {
            if (faultType.length() < 250) {
                this.mAuditQuery.setFaultType(faultType);
            } else {
                this.mAuditQuery.setFaultType(faultType.substring(0, 250) + "...");
            }
        }
    }

    public String getFaultType() {
        return this.mAuditQuery.getFaultType();
    }

    public void setFlowElementType(String flowElementType) {
        this.mAuditQuery.setFlowElementType(flowElementType);
    }

    public String getFlowElementType() {
        return this.mAuditQuery.getFlowElementType();
    }

    public void setInvokedComponentName(String invokedComponentName) {
        this.mAuditQuery.setInvokedComponentName(invokedComponentName);
    }

    public String getInvokedComponentName() {
        return this.mAuditQuery.getInvokedComponentName();
    }

    public void setLabel(String label) {
        this.mAuditQuery.setLabel(label);
    }

    public String getLabel() {
        return this.mAuditQuery.getLabel();
    }

    public void setOperation(AuditInstanceOperation operation) {
        this.mAuditQuery.setOperation(operation.toString());
    }

    public AuditInstanceOperation getOperation() {
        return AuditInstanceOperation.valueOf((String)this.mAuditQuery.getOperation());
    }

    public void setParentThreadId(Long parentThreadId) {
        this.mAuditQuery.setParentThreadId(parentThreadId);
    }

    public Long getParentThreadId() {
        return this.mAuditQuery.getParentThreadId();
    }

    public void setParticipant(String participant) {
        this.mAuditQuery.setParticipant(participant);
    }

    public String getParticipant() {
        return this.mAuditQuery.getParticipant();
    }

    public void setUserTaskNumber(Long userTaskNumber) {
        this.mAuditQuery.setUserTaskNumber(userTaskNumber);
    }

    public Long getUserTaskNumber() {
        return this.mAuditQuery.getUserTaskNumber();
    }

    public Calendar getPartitionDate() {
        return this.mAuditQuery.getPartitionDate();
    }

    public void setPartitionDate(Calendar ciPartitionDate) {
        this.mAuditQuery.setPartitionDate(ciPartitionDate);
    }

    public Long getPriority() {
        return this.mAuditQuery.getPriority();
    }

    public void setPriority(Long priority) {
        this.mAuditQuery.setPriority(priority);
    }

    public void setProcessDueDate(Calendar processDueDate) {
        this.mAuditQuery.setProcessDueDate(processDueDate);
    }

    public Calendar getProcessDueDate() {
        return this.mAuditQuery.getProcessDueDate();
    }

    public void setQueryId(Long queryId) {
        this.mAuditQuery.setQueryId(queryId);
    }

    public Long getQueryId() {
        return this.mAuditQuery.getQueryId();
    }

    public void setReferenceId(String referenceId) {
        this.mAuditQuery.setReferenceId(referenceId);
    }

    public String getReferenceId() {
        return this.mAuditQuery.getReferenceId();
    }

    public void setRoleId(String roleId) {
        this.mAuditQuery.setRoleId(roleId);
    }

    public String getRoleId() {
        return this.mAuditQuery.getRoleId();
    }

    public void setSourceActivity(String sourceActivity) {
        this.mAuditQuery.setSourceActivity(sourceActivity);
    }

    public String getSourceActivity() {
        return this.mAuditQuery.getSourceActivity();
    }

    public void setTargetActivity(String targetActivity) {
        this.mAuditQuery.setTargetActivity(targetActivity);
    }

    public String getTargetActivity() {
        return this.mAuditQuery.getTargetActivity();
    }

    public void setThreadId(Long threadId) {
        this.mAuditQuery.setThreadId(threadId);
    }

    public Long getThreadId() {
        return this.mAuditQuery.getThreadId();
    }

    public void setTitle(String title) {
        this.mAuditQuery.setTitle(title);
    }

    public String getTitle() {
        return this.mAuditQuery.getTitle();
    }

    public void addAuditPayloadElement(IAuditVariable element) {
        Map<String, IAuditVariable> branch;
        if (this.mPayload == null) {
            this.mPayload = new HashMap<IAuditVariable.Direction, Map<String, IAuditVariable>>();
        }
        if ((branch = this.mPayload.get(element.getDirection())) == null) {
            branch = new HashMap<String, IAuditVariable>();
            this.mPayload.put(element.getDirection(), branch);
        }
        branch.put(element.getName(), element);
    }

    @Deprecated
    public Map<String, IAuditVariable> getPayloadElements() {
        return this.getPayloadElements(IAuditVariable.Direction.DIRECTION_STATE);
    }

    public Map<String, IAuditVariable> getPayloadElements(IAuditVariable.Direction direction) {
        return this.mPayload != null ? this.mPayload.get(direction) : null;
    }

    public void setAuditLevel(Long auditLevel) {
        this.mAuditQuery.setAuditLevel(auditLevel);
    }

    public Long getAuditLevel() {
        return this.mAuditQuery.getAuditLevel();
    }

    public void setAuditLog(byte[] auditLog) {
        this.mAuditQuery.setAuditLog(auditLog);
    }

    public byte[] getAuditLog() {
        return this.mAuditQuery.getAuditLog();
    }

    public String getDNApplicationName() {
        return this.getCompositeDNModel().getApplicationName();
    }

    public String getDNCompositeName() {
        return this.getCompositeDNModel().getCompositeName();
    }

    public String getDN() {
        return this.getCompositeDn();
    }

    public String getDNLabel() {
        return this.getCompositeDNModel().getLabel();
    }

    public String getDNRevision() {
        return this.getCompositeDNModel().getRevision();
    }

    public Calendar getDateValue(int slot) {
        return this.mAuditQuery.getDateValue(slot);
    }

    public void setDateValue(int slot, Calendar value) {
        this.mAuditQuery.setDateValue(value, slot);
    }

    public BigDecimal getNumberValue(int slot) {
        return this.mAuditQuery.getNumberValue(slot);
    }

    public void setNumberValue(int slot, BigDecimal value) {
        this.mAuditQuery.setNumberValue(value, slot);
    }

    public String getStringValue(int slot) {
        return this.mAuditQuery.getStringValue(slot);
    }

    public void setStringValue(int slot, String value) {
        this.mAuditQuery.setStringValue(value, slot);
    }

    public void setDateValues(List<Calendar> values) {
        this.mAuditQuery.setDateValues(values);
    }

    public void setNumberValues(List<BigDecimal> values) {
        this.mAuditQuery.setNumberValues(values);
    }

    public void setStringValues(List<String> values) {
        this.mAuditQuery.setStringValues(values);
    }

    public List<Calendar> getDateValues() {
        return this.mAuditQuery.getDateValues();
    }

    public List<BigDecimal> getNumberValues() {
        return this.mAuditQuery.getNumberValues();
    }

    public List<String> getStringValues() {
        return this.mAuditQuery.getStringValues();
    }

    public AuditQuery getAuditQuery() {
        return this.mAuditQuery;
    }

    public void setAuditQueryVariableMetadata(AuditQueryVariableMetadata metadata) {
        this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().add(0, metadata);
    }

    public AuditQueryVariableMetadata getAuditQueryVariableMetadata() {
        AuditQueryVariableMetadata varMd = null;
        if (this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().size() > 0) {
            varMd = this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().get(0);
        }
        return varMd;
    }

    public boolean hasPayload() {
        return this.mAuditQuery.getAuditLog() != null && this.mAuditQuery.getAuditLog().length > 0;
    }

    public void addAssociatedVariable(String name) {
        if (this.mAssociatedVariables == null) {
            this.mAssociatedVariables = new ArrayList<String>();
        }
        if (!this.mAssociatedVariables.contains(name)) {
            this.mAssociatedVariables.add(name);
            this.mAuditQuery.setElementVariableCSV(this.mAssociatedVariables.toString().replaceFirst("\\[", "").replaceFirst("\\]", ""));
        }
    }

    public List<String> getAssociatedVariables() {
        return this.mAssociatedVariables;
    }

    public void setAssociatedVariables(List<String> associatedVariables) {
        this.mAssociatedVariables = associatedVariables;
        if (associatedVariables != null) {
            this.mAuditQuery.setElementVariableCSV(associatedVariables.toString().replaceFirst("\\[", "").replaceFirst("\\]", ""));
        }
    }

    public void setAuditQueryMetadata(AuditQueryMetadata auditMetadata) {
        this.mAuditQuery.setAuditQueryMetadata(auditMetadata);
    }

    public AuditQueryMetadata getAuditQueryMetadata() {
        return this.mAuditQuery.getAuditQueryMetadata();
    }

    public String getScopeId() {
        return this.mAuditQuery.getScopeId();
    }

    public AuditCategory getCategory() {
        return null;
    }

    public AuditType getType() {
        return null;
    }

    public AuditLevel getLevel() {
        return null;
    }

    public String getActivityType() {
        return this.mAuditQuery.getActivityType();
    }

    public void setActivityType(String activityType) {
        this.mAuditQuery.setActivityType(activityType);
    }

    public void setInstanceCount(Long multiInstanceCount) {
        this.mAuditQuery.setInstanceCount(multiInstanceCount);
    }

    public Long getInstanceCount() {
        return this.mAuditQuery.getInstanceCount();
    }

    public void setScopeId(String scopeId) {
        this.mAuditQuery.setScopeId(scopeId);
    }

    public Long getAuditNumber1() {
        return this.mAuditQuery.getAuditNumber1();
    }

    public void setAuditNumber1(Long value) {
        this.mAuditQuery.setAuditNumber1(value);
    }

    public boolean hasPayloadElements() {
        return this.mPayload != null && this.mPayload.size() > 0 || this.mExpressionExecution != null && this.mExpressionExecution.size() > 0 || this.mActivityInfo != null && this.mActivityInfo.hasInfo() || this.getComment() != null && this.getComment().length() > 0;
    }

    public String getComment() {
        if (this.mAuditQuery.getComment() != null) {
            return new String(this.mAuditQuery.getComment(), Charset.forName("utf-8"));
        }
        return null;
    }

    public void setComment(String comment) {
        this.mAuditQuery.setComment(comment != null ? comment.getBytes(Charset.forName("utf-8")) : null);
    }

    public Document getPayloadDoc() {
        return this.mPayloadDoc;
    }

    public void setPayloadDoc(Document d) {
        this.mPayloadDoc = d;
    }

    public void setVariableValue(String name, Object value) throws BPMException {
        IAuditVariable var = this.getVariable(name);
        IAuditVariableMetadata md = AuditUtil.createAuditVariableMetadata(this.mAuditQuery.getAuditQueryMetadata());
        try {
            if (var != null) {
                String v = value instanceof Element ? ((Element)value).getTextContent() : String.valueOf(value);
                var.setValue(value);
                if ("STRING".equals(var.getDataType())) {
                    this.setStringValue(md.getSlot(name), String.valueOf(v));
                } else if ("DATE".equals(var.getDataType())) {
                    Calendar d = JaxbDatatypeConverter.parseDateTime((String)v);
                    this.setDateValue(md.getSlot(name), d);
                } else if ("NUMBER".equals(var.getDataType())) {
                    this.setNumberValue(md.getSlot(name), new BigDecimal(v));
                } else {
                    this.setStringValue(md.getSlot(name), v);
                }
            }
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new Object[]{name, value};
            throw new BPMException(71301, objs, (Throwable)e);
        }
    }

    public void recordDataChange(String name, Object oldValue, Object newValue) throws BPMException {
        String logMethodName = "recordDataChange";
        try {
            Element oldV;
            IAuditVariable var = this.getVariable(name);
            Element rootNode = null;
            if (this.mPayloadDoc == null) {
                this.mPayloadDoc = XMLUtil.createDocument();
                rootNode = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "auditQueryPayload");
                this.mPayloadDoc.appendChild(rootNode);
            } else {
                rootNode = this.mPayloadDoc.getDocumentElement();
            }
            Element newV = null;
            if (oldValue instanceof Element) {
                oldV = (Element)oldValue;
            } else {
                oldV = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, name);
                oldV.setTextContent(String.valueOf(oldValue));
            }
            if (newValue instanceof Element) {
                newV = (Element)newValue;
            } else {
                newV = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, name);
                newV.setTextContent(String.valueOf(newValue));
            }
            Element newElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "dataObject");
            newElement.setAttribute("name", name);
            if (var != null) {
                String variableType = "";
                if (var.getType() != null) {
                    variableType = "D".equals(var.getType()) ? "DIMENSION" : ("M".equals(var.getType()) ? "MEASURE" : ("C".equals(var.getType()) ? "COUNTER" : ""));
                }
                newElement.setAttribute("type", variableType);
                newElement.setAttribute("isBusinessIndicator", String.valueOf(var.isIndicator()));
            }
            Element oldValueElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "oldValue");
            oldValueElement.appendChild(XMLUtil.cloneNode((Document)this.mPayloadDoc, (Node)oldV));
            Element newValueElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "value");
            newValueElement.appendChild(XMLUtil.cloneNode((Document)this.mPayloadDoc, (Node)newV));
            newElement.appendChild(oldValueElement);
            newElement.appendChild(newValueElement);
            rootNode.appendChild(newElement);
            String xmlstr = XMLUtil.toString((Node)this.mPayloadDoc);
            BPELExecutionLogger.LOG.debug(logClassName, "recordDataChange", new Object[]{"PAYLOAD {" + xmlstr + "}"});
            this.setVariableValue(name, newValue);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new Object[]{name, oldValue, newValue};
            throw new BPMException(71301, objs, (Throwable)e);
        }
    }

    public boolean isMinimalInfoAvailable() {
        return true;
    }

    public String getECID() {
        return this.mAuditQuery.getECID();
    }

    public void setECID(String ecid) {
        this.mAuditQuery.setECID(ecid);
    }

    public long getTenantId() {
        return this.mAuditQuery.getTenantId();
    }

    public void setTenantId(long tenantId) {
        this.mAuditQuery.setTenantId(tenantId);
    }

    public void setExpressionExecution(List<AuditExpressionExecution> expressionExecution) {
        this.mExpressionExecution = expressionExecution;
    }

    public List<AuditExpressionExecution> getExpressionExecution() {
        return this.mExpressionExecution;
    }

    public void setActivityInfo(AuditActivityInfo activityInfo) {
        this.mActivityInfo = activityInfo;
    }

    public AuditActivityInfo getActivityInfo() {
        return this.mActivityInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        String createTime = null;
        if (this.mAuditQuery.getCreateTime() != null) {
            createTime = df.format(this.mAuditQuery.getCreateTime().getTime());
        }
        sb.append("{ queryId=").append(String.valueOf(this.mAuditQuery.getQueryId())).append(", operation=").append(this.mAuditQuery.getOperation()).append(", activityId=").append(this.mAuditQuery.getActivityId()).append(", activityName=").append(this.mAuditQuery.getActivityName()).append(", activityType=").append(this.mAuditQuery.getActivityType()).append(", sourceActivity=").append(this.getSourceActivity()).append(", targetActivity=").append(this.mAuditQuery.getTargetActivity()).append(", scopeId=").append(this.mAuditQuery.getScopeId()).append(", threadId=").append(String.valueOf(this.mAuditQuery.getThreadId())).append(", createTime=").append(createTime).append(", ECID=").append(this.mAuditQuery.getECID()).append(" }").append(" comment=\"").append(this.mAuditQuery.getComment()).append("\"");
        return sb.toString();
    }

    private CompositeDNModel getCompositeDNModel() {
        if (this.compositeDNModel == null) {
            this.compositeDNModel = CompositeDNModel.parseCompositeDN((String)this.getCompositeDn());
        }
        return this.compositeDNModel;
    }

    private IAuditVariable createVariable(String name, String type, String dataType, int slot, String table, Object value) {
        IAuditVariable v = AuditVariable.newInstance();
        v.setAttribute(slot);
        v.setName(name);
        v.setTable(table);
        v.setDataType(dataType);
        v.setType(type);
        v.setValue(value);
        if (this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().size() > 0) {
            List<AuditQueryVariableRange> range = this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().get(0).getRanges(name);
            ArrayList<IAuditVariableRange> vRange = new ArrayList<IAuditVariableRange>();
            for (AuditQueryVariableRange r : range) {
                IAuditVariableRange vr = AuditUtil.createAuditvariableRange(r);
                vRange.add(vr);
            }
            v.setRanges(vRange);
        }
        return v;
    }

    private boolean isVariablesAvailable() {
        return this.mAuditQuery.getAuditQueryMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().size() > 0;
    }

    private Map<String, IAuditVariable> createVariableList(List<String> names) {
        HashMap<String, IAuditVariable> variables = new HashMap<String, IAuditVariable>();
        for (String name : names) {
            if (name == null || name.length() <= 0) continue;
            IAuditVariable var = this.getVariable(name);
            variables.put(name, var);
        }
        return variables;
    }

    private Map<String, IAuditVariable> createFilteredVariableList(List<String> allNames, List<String> associatedNames) {
        HashMap<String, IAuditVariable> variables = new HashMap<String, IAuditVariable>();
        for (String name : allNames) {
            if (name == null || name.length() <= 0) continue;
            IAuditVariable var = this.getVariable(name);
            if (this.isMeasurement() || this.isCounter()) {
                if (var.getType().equals("D")) {
                    variables.put(name, var);
                    continue;
                }
                if (this.isMeasurement() && var.getType().equals("M") && associatedNames != null && associatedNames.contains(name)) {
                    variables.put(name, var);
                    continue;
                }
                if (!this.isCounter() || !var.getType().equals("C") || associatedNames == null || !associatedNames.contains(name)) continue;
                variables.put(name, var);
                continue;
            }
            if (!var.getType().equals("D") && !var.getType().equals("M")) continue;
            variables.put(name, var);
        }
        return variables;
    }

    private boolean isMeasurement() {
        AuditInstanceOperation op = this.getOperation();
        return op == AuditInstanceOperation.MEASUREMENT_START || op == AuditInstanceOperation.MEASUREMENT_START_STOP || op == AuditInstanceOperation.MEASUREMENT_STOP;
    }

    private boolean isCounter() {
        AuditInstanceOperation op = this.getOperation();
        return op == AuditInstanceOperation.MEASUREMENT_COUNTER;
    }

    private List<String> getVarNames() {
        if (this.mVarNames == null) {
            this.mVarNames = new ArrayList();
            if (this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata() != null && this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().size() > 0) {
                AuditQueryVariableMetadata aqmd = this.mAuditQuery.getAuditQueryMetadata().getAuditQueryVariableMetadata().get(0);
                this.mVarNames.addAll(aqmd.getNumberNames());
                this.mVarNames.addAll(aqmd.getStringNames());
                this.mVarNames.addAll(aqmd.getDateNames());
            }
        }
        return this.mVarNames;
    }
}

