/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.task.impl.xpath.BPMNWorkflowXPathContext;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;

public class GetProcessInitiator
implements XPathFunction,
IXPathFunction {
    BPMNWorkflowXPathContext bpmnWorkflowXPathContext = null;

    public GetProcessInitiator() {
    }

    public GetProcessInitiator(BPMNWorkflowXPathContext bpmnWorkflowXPathContext) {
        this.bpmnWorkflowXPathContext = bpmnWorkflowXPathContext;
    }

    public Object evaluate(List args) throws XPathFunctionException {
        try {
            if (this.bpmnWorkflowXPathContext == null) {
                return null;
            }
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluate", new Object[]{"Evaluating the getProcessInitiator function"});
            Task taskObject = this.bpmnWorkflowXPathContext.getTask();
            String instanceId = taskObject.getProcessInfo().getInstanceId();
            IInstanceQueryService queryService = this.getBPMServiceClient().getInstanceQueryService();
            IProcessInstance instance = queryService.getProcessInstance(GetProcessInitiator.getBPMContext(), instanceId);
            String creator = instance.getCreator();
            if (creator != null) {
                return XMLUtil.createSimpleElement((String)"http://xmlns.oracle.com/bpel/services/IdentityService", (String)"user", (String)creator);
            }
            return null;
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{"bpmn:getProcessInitiator"}, e);
            throw new XPathFunctionException(wfe);
        }
    }

    public Object call(IXPathContext context, List args) throws oracle.fabric.common.xml.xpath.XPathFunctionException {
        try {
            return this.evaluate(args);
        }
        catch (Throwable e) {
            throw new oracle.fabric.common.xml.xpath.XPathFunctionException(e);
        }
    }

    private static IBPMContext getBPMContext() throws BPMException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof BPMException) {
                throw (BPMException)((Object)orgEx);
            }
            throw new BPMException((Exception)pae);
        }
    }

    private IBPMServiceClient getBPMServiceClient() throws Exception {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        IBPMServiceClient svcClient = bpmServiceClientFactory.getBPMServiceClient();
        return svcClient;
    }
}

