/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.engine.core.BPELExecutionLogger;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.impl.xpath.BPMNWorkflowXPathContext;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GetLastPerformer
implements XPathFunction,
IXPathFunction {
    BPMNWorkflowXPathContext bpmnWorkflowXPathContext = null;
    public static String FUNCTION_NAME = "getLastPerformer";

    public GetLastPerformer() {
    }

    public GetLastPerformer(BPMNWorkflowXPathContext bpmnWorkflowXPathContext) {
        this.bpmnWorkflowXPathContext = bpmnWorkflowXPathContext;
    }

    public Object evaluate(List args) throws XPathFunctionException {
        try {
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluate", new Object[]{"Evaluating the getLastPerformer xpath"});
            if (this.bpmnWorkflowXPathContext == null) {
                throw new oracle.fabric.common.xml.xpath.XPathFunctionException("Internal Error : " + FUNCTION_NAME + " received null BPMN Workflow XPath Context");
            }
            Task taskObject = this.bpmnWorkflowXPathContext.getTask();
            if (taskObject == null) {
                throw new oracle.fabric.common.xml.xpath.XPathFunctionException("Internal Error : " + FUNCTION_NAME + " received null Task Object");
            }
            String processName = taskObject.getProcessInfo().getProcessId();
            String instanceId = taskObject.getProcessInfo().getInstanceId();
            String swimlaneRole = taskObject.getSystemAttributes().getSwimlaneRole();
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluate", new Object[]{"swimlaneRole : " + swimlaneRole + ", processName : " + processName + ", instanceId : " + instanceId});
            String lastPerformer = WorkflowUtil.getLastPerformerInSwimLane((String)swimlaneRole, (String)processName, (String)instanceId);
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluate", new Object[]{" lastPerformer : " + lastPerformer});
            if (lastPerformer != null) {
                return XMLUtil.createSimpleElement((String)"http://xmlns.oracle.com/bpel/services/IdentityService", (String)"user", (String)lastPerformer);
            }
            WorkflowException wfe = new WorkflowException(40014, (Object[])new String[]{taskObject.getSystemAttributes().getTaskId(), swimlaneRole});
            throw new XPathFunctionException(wfe);
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{FUNCTION_NAME}, e);
            throw new XPathFunctionException(wfe);
        }
    }

    public Object call(IXPathContext context, List args) throws oracle.fabric.common.xml.xpath.XPathFunctionException {
        try {
            return this.evaluate(args);
        }
        catch (Throwable e) {
            throw new oracle.fabric.common.xml.xpath.XPathFunctionException(e);
        }
    }

    private NodeList createNodeSet(Collection values) throws Exception {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        for (Participant obj : values) {
            Node node = this.createNode(obj, document);
            document.appendChild(node);
        }
        return document.getElementsByTagName("appRole");
    }

    private Node createNode(Participant participant, Document document) throws Exception {
        String namespaceURI = "http://xmlns.oracle.com/bpel/services/IdentityService";
        ParticipantTypeEnum type = ((PrincipleRefType)participant.getValue()).getType();
        String nodeName = null;
        if (ParticipantTypeEnum.USER == type) {
            nodeName = "user";
        } else if (ParticipantTypeEnum.GROUP == type) {
            nodeName = "group";
        } else if (ParticipantTypeEnum.APPROLE == type) {
            nodeName = "appRole";
        }
        Element elem = document.createElementNS(namespaceURI, nodeName);
        Text text = document.createTextNode(((PrincipleRefType)participant.getValue()).getName());
        elem.appendChild(text);
        return elem;
    }
}

