/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.lang.DecimalRuntime;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;

public class DecimalSupport {
    private DecimalSupport() {
    }

    private static abstract class BaseFunction2Arg
    extends BaseFunction {
        private BaseFunction2Arg() {
        }

        abstract Object evaluate(BigDecimal var1, BigDecimal var2);

        @Override
        final Object evaluate(List<BigDecimal> args) throws XPathFunctionException {
            this.checkArguments(args, 2);
            return this.evaluate(args.get(0), args.get(1));
        }
    }

    private static abstract class BaseFunction1Arg
    extends BaseFunction {
        private BaseFunction1Arg() {
        }

        abstract Object evaluate(BigDecimal var1);

        @Override
        final Object evaluate(List<BigDecimal> args) throws XPathFunctionException {
            this.checkArguments(args, 1);
            return this.evaluate(args.get(0));
        }
    }

    private static abstract class BaseFunction
    implements IXPathFunction {
        private BaseFunction() {
        }

        public final Object call(IXPathContext context, List args) throws XPathFunctionException {
            Object result;
            try {
                result = this.evaluate(BaseFunction.asBigDecimalList(args));
            }
            catch (NumberFormatException e) {
                throw new XPathFunctionException((Throwable)e);
            }
            if (result == null) {
                result = BigDecimal.ZERO;
            }
            if (result instanceof BigDecimal) {
                return ((BigDecimal)result).toPlainString();
            }
            if (result instanceof Number && !(result instanceof Double)) {
                return ((Number)result).doubleValue();
            }
            return result;
        }

        abstract Object evaluate(List<BigDecimal> var1) throws XPathFunctionException;

        final void checkArguments(List<?> arguments, int arity) throws XPathFunctionException {
            int actual = arguments.size();
            if (actual == arity) {
                return;
            }
            throw new XPathFunctionException(this.getName() + " requires " + arity + " arguments but " + actual + " supplied");
        }

        private static AbstractList<BigDecimal> asBigDecimalList(final List<?> args) {
            return new AbstractList<BigDecimal>(){

                @Override
                public BigDecimal get(int index) {
                    return DecimalRuntime.getArgument(args.get(index));
                }

                @Override
                public int size() {
                    return args.size();
                }
            };
        }

        private String getName() {
            return this.getClass().getSimpleName().toLowerCase(Locale.US);
        }
    }

    public static final class Subtract
    extends BaseFunction2Arg {
        @Override
        BigDecimal evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.subtract((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Round
    extends BaseFunction1Arg {
        @Override
        BigDecimal evaluate(BigDecimal n) {
            return DecimalRuntime.round((BigDecimal)n);
        }
    }

    public static final class Remainder
    extends BaseFunction2Arg {
        @Override
        BigDecimal evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.remainder((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Negative
    extends BaseFunction1Arg {
        @Override
        BigDecimal evaluate(BigDecimal n) {
            return DecimalRuntime.negative((BigDecimal)n);
        }
    }

    public static final class Multiply
    extends BaseFunction2Arg {
        @Override
        BigDecimal evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.multiply((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Floor
    extends BaseFunction1Arg {
        @Override
        BigDecimal evaluate(BigDecimal n) {
            return DecimalRuntime.floor((BigDecimal)n);
        }
    }

    public static final class Divide
    extends BaseFunction2Arg {
        @Override
        BigDecimal evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.divide((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Compare
    extends BaseFunction2Arg {
        @Override
        Integer evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.compare((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Ceiling
    extends BaseFunction1Arg {
        @Override
        BigDecimal evaluate(BigDecimal n) {
            return DecimalRuntime.ceiling((BigDecimal)n);
        }
    }

    public static final class Add
    extends BaseFunction2Arg {
        @Override
        BigDecimal evaluate(BigDecimal n1, BigDecimal n2) {
            return DecimalRuntime.add((BigDecimal)n1, (BigDecimal)n2);
        }
    }

    public static final class Abs
    extends BaseFunction1Arg {
        @Override
        BigDecimal evaluate(BigDecimal n) {
            return DecimalRuntime.abs((BigDecimal)n);
        }
    }
}

