/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.xml.dom.DOMUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.lang.Time;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpmUtil {
    private BpmUtil() {
    }

    private static void checkArguments(String fname, List<?> arguments, int required) throws XPathFunctionException {
        int actual = arguments.size();
        if (actual == required) {
            return;
        }
        throw new XPathFunctionException(fname + " requires " + required + " arguments but " + actual + " supplied");
    }

    public static final class NodeSet
    implements IXPathFunction {
        private static final Document EMPTY_DOCUMENT = DOMUtil.createDocument();

        public Object call(IXPathContext context, List args) throws XPathFunctionException {
            NodeSet.checkArguments(args);
            ArrayList<Element> list = new ArrayList<Element>();
            Set<Element> set = NodeSet.asSet(list);
            NodeSet.addNodes(set, args.get(0));
            NodeSet.addNodes(set, args.get(1));
            return NodeSet.nodeList(list);
        }

        private static <E> Set<E> asSet(final List<E> list) {
            return new IdentityHashSet<E>(){

                public boolean add(E o) {
                    if (!super.add(o)) {
                        return false;
                    }
                    list.add(o);
                    return true;
                }
            };
        }

        private static Element buildElement(Object data) {
            if (data instanceof Element) {
                return (Element)data;
            }
            if (data instanceof Attr) {
                Attr attr = (Attr)data;
                data = attr.getValue();
            }
            Document doc = EMPTY_DOCUMENT;
            Element element = doc.createElement("element");
            element.appendChild(doc.createTextNode(String.valueOf(data)));
            return element;
        }

        private static void addNode(Set<Element> elems, Object data) {
            Element elem = NodeSet.buildElement(data);
            if (!elems.add(elem)) {
                elems.add((Element)elem.cloneNode(true));
            }
        }

        private static void addNodes(Set<Element> elems, Object data) {
            if (data instanceof NodeList) {
                Node node;
                NodeList nlist = (NodeList)data;
                int i = 0;
                while ((node = nlist.item(i)) != null) {
                    NodeSet.addNode(elems, node);
                    ++i;
                }
            } else {
                NodeSet.addNode(elems, data);
            }
        }

        private static NodeList nodeList(final Node[] nodes) {
            return new NodeList(){

                @Override
                @Nullable
                public Node item(int index) {
                    return index >= nodes.length ? null : nodes[index];
                }

                @Override
                public int getLength() {
                    return nodes.length;
                }
            };
        }

        private static NodeList nodeList(Collection<Element> elems) {
            Node[] nodes = new Element[elems.size()];
            elems.toArray(nodes);
            return NodeSet.nodeList(nodes);
        }

        private static void checkArguments(List<?> arguments) throws XPathFunctionException {
            BpmUtil.checkArguments("node-set", arguments, 2);
        }
    }

    public static final class Convert
    implements IXPathFunction {
        public Object call(IXPathContext context, List args) throws XPathFunctionException {
            Convert.checkArguments(args);
            int kind = Convert.getInt(args, 1);
            int length = Convert.getInt(args, 2);
            int scale = Convert.getInt(args, 3);
            if (kind != 6) {
                throw new XPathFunctionException("unsupported conversion: " + kind);
            }
            return Time.valueOf((String)Convert.getString(args, 0)).toXMLString(scale);
        }

        private static String getString(List<?> list, int position) {
            Object o = Convert.unwrapNode(list, position);
            return o == null ? "" : o.toString();
        }

        private static Object unwrapNode(List<?> list, int position) {
            Object o = list.get(position);
            if (o instanceof NodeList) {
                o = ((NodeList)o).item(0);
            }
            if (o instanceof Node) {
                Node nl = (Node)o;
                o = nl.getTextContent();
            }
            return o;
        }

        private static int getInt(List<?> list, int position) {
            Object o = Convert.unwrapNode(list, position);
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o != null && !(o instanceof Number)) {
                try {
                    o = new BigDecimal(o.toString());
                }
                catch (NumberFormatException ignore) {
                    o = null;
                }
            }
            double d = o == null ? Double.NaN : ((Number)o).doubleValue();
            return (int)Math.round(d);
        }

        private static void checkArguments(List<?> arguments) throws XPathFunctionException {
            BpmUtil.checkArguments("convert", arguments, 4);
        }
    }
}

