/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath.functions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import java.util.List;
import java.util.Properties;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttributeHelper;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.bpmn.engine.runtime.xpath.functions.BaseBPMNXpathFunction;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;

public abstract class BaseGetInstanceAttribute
extends BaseBPMNXpathFunction {
    static final int FUNCTION_ARITY = 2;
    static final int ARG_FLOWELEMENT = 0;
    static final int ARG_ATTRIBUTENAME = 1;

    protected abstract InstanceAttributeType getInstanceAttributeType();

    protected String getVariableName(IXPathContext context, List args) {
        String flowElementName = this.getStringArgument(args, 0);
        String attributeName = this.getStringArgument(args, 1);
        return InstanceAttributeType.getVariableName(this.getInstanceAttributeType(), flowElementName, attributeName);
    }

    @Override
    protected Object call(IXPathContext context, List args, ICubeContext cubeContext, IScope scope) throws Exception {
        XMLElement instanceAttributeValueXMLElement;
        String variableName = this.getVariableName(context, args);
        if (ProcessInstanceAttributeHelper.isPIAandReadOnly(variableName)) {
            return ProcessInstanceAttributeHelper.getPiaValue(variableName, scope);
        }
        Object instanceAttributeValue = scope.getObject(variableName);
        if (instanceAttributeValue instanceof CXTypeVariable) {
            instanceAttributeValue = ((CXTypeVariable)instanceAttributeValue).getValue();
        } else if (instanceAttributeValue instanceof CXElementVariable) {
            instanceAttributeValue = ((CXElementVariable)instanceAttributeValue).getValue();
        } else if (instanceAttributeValue instanceof XMLDocument) {
            instanceAttributeValue = ((XMLDocument)instanceAttributeValue).getDocumentElement();
        } else if (instanceAttributeValue instanceof List) {
            instanceAttributeValue = BPMNXPathUtil.convListToNodeList((List)instanceAttributeValue);
        }
        if (instanceAttributeValue instanceof XMLElement && !this.isNativeStructure(instanceAttributeValueXMLElement = (XMLElement)instanceAttributeValue)) {
            Object xpathVariableContext = context.getVariableValue(null, null, "xpath-variable-context");
            if (xpathVariableContext != null) {
                ((XMLElement)instanceAttributeValue).setProperty("xpath-variable-context", xpathVariableContext);
            }
            this.patchSchemaComponentsForCubeDOMNavigator(context, cubeContext, instanceAttributeValueXMLElement);
        }
        return instanceAttributeValue;
    }

    private Properties getDirectives(IXPathContext context) {
        BPMNExpressionExecutionContext bpmnExpressionExecutionContext = (BPMNExpressionExecutionContext)context.getVariableValue(null, null, "BPMNEXPRESSION_EXECUTIONCONTEXT");
        return bpmnExpressionExecutionContext.getDirectives();
    }

    private void patchSchemaComponentsForCubeDOMNavigator(IXPathContext context, ICubeContext cubeContext, XMLElement instanceAttributeValueXMLElement) {
        Properties directives = this.getDirectives(context);
        if (this.isOnDemandInit(directives)) {
            DataHandlingUtils.BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator((Object)instanceAttributeValueXMLElement, directives, cubeContext);
        }
    }

    private boolean isOnDemandInit(Properties directives) {
        return Boolean.valueOf(directives.getProperty(BPMNExpression.DIRECTIVE_ONDEMANDINIT));
    }

    private boolean isNativeStructure(XMLElement xmlElement) {
        return "http://www.w3.org/2001/XMLSchema".equals(xmlElement.getQName().getNamespaceURI());
    }
}

