/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.CubeXMLLogger;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathVariableResolver;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.blocks.AssemblyModelObject;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.XSDException;
import oracle.fabric.common.xml.xpath.FabricXPathContext;
import oracle.fabric.common.xml.xpath.FabricXPathUtil;
import oracle.fabric.common.xml.xpath.FabricXPathVariableResolver;
import oracle.fabric.composite.model.ComponentModel;
import oracle.integration.platform.blocks.xpath.XPathContext;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLParseException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPMNXPathUtil
extends FabricXPathUtil {
    private static Map<BPMNExpression.BPMNExpressionResultType, QName> resultTypes = new HashMap<BPMNExpression.BPMNExpressionResultType, QName>();

    public static Object adjustXPathReturnValue(Object value) {
        Object result = value;
        if (value != null && !(value instanceof Element)) {
            result = FabricXPathUtil.adjustXPathReturnValue((Object)value);
        }
        return result;
    }

    public static XPath createXPath(BPMNExpressionExecutionContext bpmnExpressionExecutionContext, NamespaceContext namespaceContext, ICubeContext ctx, IScope scope) throws CubeException {
        XPath xpath = BPMNXPathUtil.getXPath((NamespaceContext)namespaceContext);
        xpath.setXPathFunctionResolver((XPathFunctionResolver)((Object)BPMNXPathUtil.getFunctionResolver(ctx)));
        xpath.setXPathVariableResolver(BPMNXPathUtil.getVariableResolver(scope, ctx, bpmnExpressionExecutionContext));
        return xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(String xpathExpressionText, XPath xpath, ICubeContext ctx, QName returnType, ComponentModel scaComponent) throws CubeException {
        Object object;
        try {
            XPathContext.setXPathContext((AssemblyModelObject)scaComponent);
            XPathExpression xPathExpression = BPMNXPathUtil.getXPathExpression(xpathExpressionText, xpath);
            object = xPathExpression.evaluate(BPMNXPathUtil.getXPathContext(null, xpath.getNamespaceContext(), ctx, xpath.getXPathVariableResolver(), scaComponent), returnType);
        }
        catch (Throwable throwable) {
            try {
                XPathContext.unsetXPathContext();
                throw throwable;
            }
            catch (XPathExpressionException e) {
                CubeXMLLogger.LOG.warn("BPELXPathUtil", "evaluate", new Object[]{e});
                throw new BPELFault(BPELDefs.QNX_SUB_LANGUAGE_EXECUTION_FAULT, (Throwable)new XPathException(9500, new Object[]{xpathExpressionText, e.getMessage()}));
            }
        }
        XPathContext.unsetXPathContext();
        return object;
    }

    public static Object evaluate(String xpathExpressionText, XPath xpath, ICubeContext ctx) throws CubeException {
        return BPMNXPathUtil.evaluate(xpathExpressionText, xpath, ctx, oracle.xml.xpath.XPathContext.OBJECT, CubeContextHelper.getScaComponent((ICubeContext)ctx));
    }

    public static XPathExpression getXPathExpression(String xpathExpressionText, XPath xpath) throws CubeException, XPathExpressionException {
        xpathExpressionText = StringEscapeUtils.unescapeXml((String)xpathExpressionText);
        return xpath.compile(xpathExpressionText);
    }

    public static XPathVariableResolver getVariableResolver(IScope scope, ICubeContext ctx, BPMNExpressionExecutionContext bpmnExpressionExecutionContext) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (scope != null) {
            dataMap.put("IScope", scope);
        }
        boolean relaxQNameTest = false;
        if (ctx != null) {
            dataMap.put("ICubeContext", ctx);
            ICubeInstance ci = (ICubeInstance)ctx.getFromEnvironment("__cube-instance");
            if (ci != null && CubeFabricUtil.isRelaxXPathQName((ComponentModel)ci.getProcessClass().getScaComponent())) {
                relaxQNameTest = true;
            }
        }
        FabricXPathVariableResolver xPathVariableResolver = new FabricXPathVariableResolver();
        BPMNXPathVariableResolver bpmnxPathVariableResolver = new BPMNXPathVariableResolver(bpmnExpressionExecutionContext, scope);
        xPathVariableResolver.addSecondaryResolver((XPathVariableResolver)bpmnxPathVariableResolver);
        if (relaxQNameTest) {
            xPathVariableResolver.addVariable(new QName("variable-relax-qname-test"), (Object)Boolean.TRUE);
        }
        xPathVariableResolver.addVariable(new QName("xpath-function-data"), dataMap);
        xPathVariableResolver.addVariable(new QName("BPMNEXPRESSION_EXECUTIONCONTEXT"), (Object)bpmnExpressionExecutionContext);
        return xPathVariableResolver;
    }

    public static Object checkExpressionValue(Object value, String expression, boolean expectSingleNode, int lineNumber) throws CubeException {
        if (expectSingleNode) {
            if (value instanceof NodeList) {
                value = BPMNXPathUtil.convertResultList((NodeList)((NodeList)value));
            }
            if (value == null) {
                String lineStr = String.valueOf(lineNumber);
                throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, new XPathException(9504, new Object[]{expression, lineStr}).getMessage());
            }
        } else if (value == null) {
            value = DOMUtil.createEmptyNodeList();
        } else if (value instanceof List) {
            value = BPMNXPathUtil.convListToNodeList((List)value);
        } else if (value instanceof Node) {
            value = DOMUtil.createSingleNodeList((Node)((Node)value));
        }
        return value;
    }

    public static NodeList convListToNodeList(List<Node> list) {
        if (list == null) {
            return null;
        }
        XMLNodeList xmlNodeList = new XMLNodeList();
        for (Node node : list) {
            xmlNodeList.addNode(node);
        }
        return xmlNodeList;
    }

    public static QName mapBPMNExpressionResultType(BPMNExpression.BPMNExpressionResultType bpmnExpressionResultType) {
        QName resultType = resultTypes.get((Object)bpmnExpressionResultType);
        if (resultType == null) {
            resultType = oracle.xml.xpath.XPathContext.OBJECT;
        }
        return resultType;
    }

    public static void insertBefore(Object fromValue, Object toValue, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        Element refElem;
        if (toValue instanceof NodeList) {
            toValue = ((NodeList)toValue).item(0);
        }
        if (DOMUtil.isRootElement((Element)(refElem = (Element)toValue))) {
            throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
        }
        Element toElem = (Element)refElem.getParentNode();
        if (fromValue instanceof NodeList) {
            NodeList list = (NodeList)fromValue;
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                DOMUtil.simpleInsertBeforeNode((Element)toElem, (Object)list.item(i), (Node)refElem);
            }
        } else {
            DOMUtil.simpleInsertBeforeNode((Element)toElem, (Object)fromValue, (Node)refElem);
        }
        DOMUtil.checkXSINIL((Object)toElem);
    }

    public static void insertAfter(Object fromValue, Object toValue, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        Element refElem;
        if (toValue instanceof NodeList) {
            NodeList nl = (NodeList)toValue;
            toValue = nl.item(nl.getLength() - 1);
        }
        if (DOMUtil.isRootElement((Element)(refElem = (Element)toValue))) {
            throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
        }
        Element toElem = (Element)refElem.getParentNode();
        if (fromValue instanceof NodeList) {
            NodeList list = (NodeList)fromValue;
            int size = list.getLength();
            Node refNextSibling = refElem.getNextSibling();
            for (int i = 0; i < size; ++i) {
                if (refNextSibling == null) {
                    DOMUtil.simpleAppendNode((Element)toElem, (Object)list.item(i));
                    continue;
                }
                DOMUtil.simpleInsertBeforeNode((Element)toElem, (Object)list.item(i), (Node)refNextSibling);
            }
        } else {
            Node refNextSibling = refElem.getNextSibling();
            if (refNextSibling == null) {
                DOMUtil.simpleAppendNode((Element)toElem, (Object)fromValue);
            } else {
                DOMUtil.simpleInsertBeforeNode((Element)toElem, (Object)fromValue, (Node)refNextSibling);
            }
        }
        DOMUtil.checkXSINIL((Object)toElem);
    }

    public static void remove(Object value, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        NodeList valueList;
        if (value == null) {
            throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
        }
        if (value instanceof NodeList) {
            valueList = (NodeList)value;
        } else {
            valueList = new XMLNodeList();
            ((XMLNodeList)valueList).addNode((Node)value);
        }
        int size = valueList.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = valueList.item(i);
            Node p = n.getParentNode();
            if (n instanceof XMLAttr) {
                p = ((XMLAttr)n).getOwnerElement();
            }
            if (p == null) {
                throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
            }
            if (n instanceof XMLAttr) {
                ((XMLElement)p).removeAttributeNode((Attr)((XMLAttr)n));
                continue;
            }
            p.removeChild(n);
        }
    }

    public static void append(Object fromValue, Object toValue, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        Element toElem = (Element)toValue;
        if (fromValue instanceof NodeList) {
            NodeList list = (NodeList)fromValue;
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                DOMUtil.simpleAppendNode((Element)toElem, (Object)list.item(i));
            }
        } else {
            DOMUtil.simpleAppendNode((Element)toElem, (Object)fromValue);
        }
        DOMUtil.checkXSINIL((Object)toElem);
    }

    public static void copyListToParentElement(Object fromValue, Element parentElem, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        NodeList fromList;
        if (fromValue instanceof NodeList) {
            fromList = (NodeList)fromValue;
        } else {
            fromList = new XMLNodeList();
            if (fromValue != null) {
                ((XMLNodeList)fromList).addNode((Node)fromValue);
            }
        }
        NodeList childNodes = parentElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            parentElem.removeChild(childNodes.item(i));
        }
        int fromSize = fromList.getLength();
        for (int i = 0; i < fromSize; ++i) {
            Node fromObj = fromList.item(i);
            BPMNXPathUtil.simpleAppendNode(parentElem, fromObj, new QName(fromObj.getNamespaceURI(), fromObj.getLocalName()));
        }
    }

    public static void copyList(Object fromValue, Object toValue, IWorkItem wi, IScope sc, ICubeContext ctx) throws CubeException {
        int fromSize;
        int i;
        boolean fromListIsAttr;
        boolean fromListIsElem;
        Node o;
        NodeList toValueList;
        NodeList fromList;
        if (fromValue instanceof NodeList) {
            fromList = (NodeList)fromValue;
        } else {
            fromList = new XMLNodeList();
            if (fromValue != null) {
                ((XMLNodeList)fromList).addNode((Node)fromValue);
            }
        }
        if (toValue instanceof NodeList) {
            toValueList = (NodeList)toValue;
        } else {
            toValueList = new XMLNodeList();
            ((XMLNodeList)toValueList).addNode((Node)toValue);
        }
        int size = toValueList.getLength();
        Element parentElem = null;
        Node tmpParentNode = null;
        Node nextSiblingNode = null;
        if (fromList != null && fromList.getLength() > 0) {
            o = fromList.item(0);
            fromListIsElem = DOMUtil.isElement((Object)o);
            fromListIsAttr = o instanceof Attr;
        } else {
            o = toValueList.item(0);
            fromListIsElem = DOMUtil.isElement((Object)o);
            fromListIsAttr = o instanceof Attr;
        }
        QName toValueQName = null;
        for (i = 0; i < size; ++i) {
            Node o2 = toValueList.item(i);
            if (fromListIsElem) {
                if (DOMUtil.isElement((Object)o2)) {
                    Element e = (Element)o2;
                    toValueQName = new QName(e.getNamespaceURI(), e.getLocalName());
                    tmpParentNode = e.getParentNode();
                    if (nextSiblingNode != null && e != nextSiblingNode) {
                        throw new BPELFault(BPELDefs.QN_20_MISMATCHED_ASSIGNMENT_FAILURE);
                    }
                    nextSiblingNode = DOMUtil.getNextNonBlankSiblingNode((Node)e);
                } else {
                    throw new BPELFault(BPELDefs.QN_20_MISMATCHED_ASSIGNMENT_FAILURE);
                }
            }
            if (fromListIsAttr) {
                if (o2 instanceof Attr) {
                    Attr a = (Attr)o2;
                    tmpParentNode = a.getOwnerElement();
                } else {
                    throw new BPELFault(BPELDefs.QN_20_MISMATCHED_ASSIGNMENT_FAILURE);
                }
            }
            if (parentElem == null) {
                if (DOMUtil.isElement(tmpParentNode)) {
                    parentElem = tmpParentNode;
                } else {
                    throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
                }
            }
            if (tmpParentNode == null) {
                throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
            }
            if (tmpParentNode == parentElem) continue;
            throw new BPELFault(BPELDefs.QN_20_SELECTION_FAILURE);
        }
        if (fromListIsAttr) {
            for (i = 0; i < size; ++i) {
                parentElem.removeAttributeNode((Attr)toValueList.item(i));
            }
            if (fromList != null) {
                fromSize = fromList.getLength();
                for (int i2 = 0; i2 < fromSize; ++i2) {
                    DOMUtil.simpleSetAttr((Element)parentElem, (Attr)((Attr)fromList.item(i2)));
                }
            }
        }
        if (fromListIsElem && parentElem != null) {
            for (i = 0; i < size; ++i) {
                parentElem.removeChild(toValueList.item(i));
            }
            if (fromList != null) {
                fromSize = fromList.getLength();
                for (int i3 = 0; i3 < fromSize; ++i3) {
                    if (nextSiblingNode == null) {
                        BPMNXPathUtil.simpleAppendNode(parentElem, fromList.item(i3), toValueQName);
                        continue;
                    }
                    BPMNXPathUtil.simpleInsertBeforeNode(parentElem, fromList.item(i3), nextSiblingNode, toValueQName);
                }
            }
        }
    }

    public static void simpleAppendNode(Element elem, Object fromObj, QName qName) {
        if (fromObj == null) {
            return;
        }
        Document doc = elem.getOwnerDocument();
        Node node = fromObj instanceof String || fromObj instanceof Number ? doc.createTextNode(fromObj.toString()) : (Node)fromObj;
        node = doc.importNode(node, true);
        BPMNXPathUtil.changeElementName(qName, node);
        elem.appendChild(node);
    }

    public static void simpleInsertBeforeNode(Element elem, Object fromObj, Node refChild, QName qName) {
        if (fromObj == null) {
            return;
        }
        Document doc = elem.getOwnerDocument();
        Node newChild = fromObj instanceof String || fromObj instanceof Number ? doc.createTextNode(fromObj.toString()) : (Node)fromObj;
        newChild = doc.importNode(newChild, true);
        BPMNXPathUtil.changeElementName(qName, newChild);
        elem.insertBefore(newChild, refChild);
    }

    public static List<Node> convNodeListToList(NodeList nodeList, IScope iScope, ICubeContext iCubeContext) {
        List list = DOMUtil.convNodeListToList((NodeList)nodeList);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, DOMUtil.convertToRootElement((Element)((Element)list.get(i))));
        }
        return list;
    }

    public static void validateXMLElement(Object value, ICubeContext iCubeContext) throws XMLParseException, XSDException {
        if (value instanceof XMLElement) {
            XMLElement xmlElement = (XMLElement)value;
            ComponentModel model = CubeContextHelper.getScaComponent((ICubeContext)iCubeContext);
            SchemaManager schemaManager = model.getComposite().getSchemaManager();
            BPMNXPathUtil.validateXMLElement(xmlElement, schemaManager, iCubeContext);
        }
    }

    public static void validateXMLElement(XMLElement xmlElement, SchemaManager schemaManager, ICubeContext iCubeContext) throws XSDException, XMLParseException {
        XMLSchema xmlSchema;
        String namespaceURI = xmlElement.getNamespaceURI();
        if (namespaceURI != null && (xmlSchema = schemaManager.lookupSchema(namespaceURI)) != null) {
            xmlElement.validateContent(xmlSchema);
        }
    }

    static BPMNXPathFunctionResolver getFunctionResolver(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionResolver();
    }

    private static void changeElementName(QName qName, Node node) {
        if (node instanceof Element) {
            DOMUtil.changeElementName((QName)qName, (Element)((Element)node));
        }
    }

    private static oracle.xml.xpath.XPathContext getXPathContext(Node node, NamespaceContext namespaceContext, ICubeContext ctx, XPathVariableResolver variableResolver, ComponentModel scaComponent) {
        return new FabricXPathContext(node, variableResolver, namespaceContext, scaComponent);
    }

    static {
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.BOOLEAN, XPathConstants.BOOLEAN);
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.NUMBER, XPathConstants.NUMBER);
        resultTypes.put(BPMNExpression.BPMNExpressionResultType.STRING, XPathConstants.STRING);
    }
}

