/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.util.CubeNamespaceContext;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.xpath.XPathException;
import com.collaxa.cube.xml.xpath.jaxen.DOMXPath;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNCubeDOMNavigator;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathVariableContext;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.xml.parser.v2.XMLNode;
import org.collaxa.thirdparty.jaxen.ExtendedVariableContext;
import org.collaxa.thirdparty.jaxen.FunctionContext;
import org.collaxa.thirdparty.jaxen.JaxenException;
import org.collaxa.thirdparty.jaxen.Navigator;
import org.collaxa.thirdparty.jaxen.VariableContext;

public class BPMNJaxenXPathUtil {
    private static Navigator singleton = BPMNCubeDOMNavigator.getInstance();

    public static Object evaluate(String xpathExpressionText, BPMNExpressionExecutionContext bpmnExpressionExecutionContext, NamespaceContext namespaceContext, ICubeContext ctx, IScope scope, BPMNExpression.BPMNExpressionResultType bpmnExpressionResultType) throws CubeException {
        try {
            DOMXPath xpath = new DOMXPath(xpathExpressionText){

                public Navigator getNavigator() {
                    return singleton;
                }
            };
            xpath.setVariableContext(BPMNJaxenXPathUtil.getVariableContext(scope, ctx, bpmnExpressionExecutionContext));
            xpath.setNamespaceContext(CubeNamespaceContext.jaxenCtx((NamespaceContext)namespaceContext));
            xpath.setFunctionContext(BPMNJaxenXPathUtil.getFunctionContext(ctx));
            if (bpmnExpressionResultType == BPMNExpression.BPMNExpressionResultType.NODELIST) {
                return xpath.selectNodes(null);
            }
            return xpath.selectSingleNode(null);
        }
        catch (JaxenException e) {
            throw new BPELFault(BPELDefs.QNX_SUB_LANGUAGE_EXECUTION_FAULT, (Throwable)new XPathException(9500, new Object[]{xpathExpressionText, e.getMessage()}));
        }
    }

    public static VariableContext getVariableContext(IScope scope, ICubeContext ctx, BPMNExpressionExecutionContext bpmnExpressionExecutionContext) {
        ExtendedVariableContext variableContext = new ExtendedVariableContext();
        variableContext.setVariableValue("variable-ignore-errors", (Object)Boolean.TRUE);
        variableContext.setVariableValue("variable-init-mode", (Object)Boolean.TRUE);
        variableContext.setVariableValue("schema-manager", (Object)DataHandlingUtils.getSchemaManager(ctx));
        variableContext.setVariableValue("initializeUnusedElements", (Object)Boolean.TRUE);
        variableContext.setVariableValue("xpath-variable-context", (Object)variableContext);
        variableContext.setVariableValue("BPMNEXPRESSION_EXECUTIONCONTEXT", (Object)bpmnExpressionExecutionContext);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (scope != null) {
            dataMap.put("IScope", scope);
        }
        if (ctx != null) {
            dataMap.put("ICubeContext", ctx);
        }
        variableContext.setVariableValue("xpath-function-data", dataMap);
        return new BPMNXPathVariableContext(bpmnExpressionExecutionContext, (VariableContext)variableContext);
    }

    private static FunctionContext getFunctionContext(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionContext();
    }

    private static boolean getBoolProperty(XMLNode xn, String propName) {
        Boolean b = (Boolean)xn.getProperty(propName);
        return b == null ? false : b;
    }
}

