/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime.xpath;

import com.collaxa.cube.xml.CubeXMLLogger;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.jaxen.DOMXPath;
import com.collaxa.cube.xml.xpath.jaxen.DocumentNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.runtime.SchemaXMLGenerator;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.Tuple;
import oracle.bpm.lang.Ref;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.XSDException;
import oracle.fabric.common.xml.xpath.functions.helper.SchemaHelper;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.ExtendedVariableContext;
import org.collaxa.thirdparty.jaxen.NamedAccessNavigator;
import org.collaxa.thirdparty.jaxen.Navigator;
import org.collaxa.thirdparty.jaxen.UnresolvableException;
import org.collaxa.thirdparty.jaxen.VariableContext;
import org.collaxa.thirdparty.jaxen.XPath;
import org.collaxa.thirdparty.jaxen.dom.NamespaceNode;
import org.collaxa.thirdparty.jaxen.saxpath.SAXPathException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BPMNCubeDOMNavigator
extends DocumentNavigator
implements NamedAccessNavigator {
    private final boolean enableAutoDerivedTypeDetection = AutoDerivedTypeDetection;
    private static final boolean AutoDerivedTypeDetection = Boolean.valueOf(System.getProperty("oracle.bpel.bpelc.tmp.AutoDerivedTypeDetection", "true"));
    private static final BPMNCubeDOMNavigator INSTANCE = new BPMNCubeDOMNavigator();
    public static final String XSD_TYPE = "xsd-type";
    public static final String XSD_DERIVED_TYPE_COLLECTION = "xsd-derived-type-collection";

    protected BPMNCubeDOMNavigator() {
    }

    public static Navigator getInstance() {
        return INSTANCE;
    }

    public String getTextStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    public String getElementStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    public String getAttributeStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    public Iterator<Node> getChildAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (this.isDocument(contextNode)) {
            return this.getChildAxisIterator((Document)contextNode, localName, namespaceURI);
        }
        if (this.isElement(contextNode)) {
            return this.getChildAxisIterator((Element)contextNode, localName, namespaceURI);
        }
        return null;
    }

    public Iterator<Node> getChildAxisIterator(Object contextNode) {
        if (this.isDocument(contextNode)) {
            return BPMNCubeDOMNavigator.getIterator(((Document)contextNode).getChildNodes());
        }
        if (this.isElement(contextNode)) {
            Element node = (Element)contextNode;
            NodeList childNodes = node.getChildNodes();
            if (childNodes.getLength() == 0) {
                this.populateNode(node, null, null);
                childNodes = node.getChildNodes();
            }
            return BPMNCubeDOMNavigator.getIterator(childNodes);
        }
        return null;
    }

    public Iterator<Node> getAttributeAxisIterator(Object contextNode) {
        if (this.isDocument(contextNode)) {
            return null;
        }
        if (this.isElement(contextNode)) {
            Element elem = (Element)contextNode;
            Iterator<Node> it = BPMNCubeDOMNavigator.getAttributeIterator(elem);
            if (it == null) {
                this.populateNode(elem, null, null);
                it = BPMNCubeDOMNavigator.getAttributeIterator(elem);
            }
            return it;
        }
        return null;
    }

    public Iterator<Node> getAttributeAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (this.isDocument(contextNode)) {
            return null;
        }
        if (this.isElement(contextNode)) {
            Element node = (Element)contextNode;
            QName stepQName = new QName(namespaceURI, localName);
            Attr attr = node.getAttributeNodeNS(namespaceURI, localName);
            if (attr == null && this.populateNode(node, null, stepQName)) {
                attr = node.getAttributeNodeNS(namespaceURI, localName);
            }
            if (attr != null) {
                return Collections.singletonList(attr).iterator();
            }
        }
        return null;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new DOMXPath(xpath);
    }

    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object element) {
        Iterator it = this.getNamespaceAxisIterator(element);
        while (it.hasNext()) {
            NamespaceNode ns = (NamespaceNode)it.next();
            if (!prefix.equals(ns.getNodeName())) continue;
            return ns.getNodeValue();
        }
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    protected String getNodeStringValue(Node node) {
        return node.getTextContent();
    }

    private static NodeIterator getIterator(NodeList children) {
        if (children.getLength() <= 0) {
            return null;
        }
        return new NodeIterator(children);
    }

    private static Iterator<Node> getAttributeIterator(Element el) {
        NamedNodeMap attrs = el.getAttributes();
        if (attrs != null && attrs.getLength() > 0) {
            return new AttributeIterator(el);
        }
        return null;
    }

    private static boolean compareNS(String xsNS, String stepNS) {
        if (xsNS == null || "".equals(xsNS)) {
            return stepNS == null || "".equals(stepNS);
        }
        return xsNS.equals(stepNS);
    }

    private static List<XMLElement> toList(NodeList nodeList) {
        ArrayList<XMLElement> result = new ArrayList<XMLElement>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (!(item instanceof XMLElement)) continue;
            result.add((XMLElement)item);
        }
        return result;
    }

    private static QName getXsiType(XMLElement xmlElement) {
        QName typeQName = null;
        Attr attr = xmlElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (attr != null) {
            String xsiTypeValue = attr.getValue();
            int index = xsiTypeValue.indexOf(58);
            String prefix = index > 0 ? xsiTypeValue.substring(0, index) : "";
            String namespace = xmlElement.resolveNamespacePrefix(prefix);
            String type = xsiTypeValue.substring(index + 1);
            typeQName = new QName(namespace, type, prefix);
        }
        return typeQName;
    }

    private Iterator<Node> getChildAxisIterator(Document contextNode, String localName, String namespaceURI) {
        Element el = contextNode.getDocumentElement();
        if (el.getNodeName().equals(localName) && (namespaceURI == null || namespaceURI.equals(el.getNamespaceURI()))) {
            return Collections.singletonList(el).iterator();
        }
        return null;
    }

    private Iterator<Node> getChildAxisIterator(Element contextNode, String localName, String namespaceURI) {
        QName stepQName = new QName(namespaceURI, localName);
        NodeList nodeList = DOMUtil.getChildElementsNodeList((Element)contextNode, (String)namespaceURI, (String)localName);
        if (nodeList.getLength() == 0 && this.populateNode(contextNode, stepQName, null)) {
            nodeList = DOMUtil.getChildElementsNodeList((Element)contextNode, (String)namespaceURI, (String)localName);
        }
        return BPMNCubeDOMNavigator.getIterator(nodeList);
    }

    private XSDComplexType lookupXSDComplexType(XMLElement element, SchemaManager xsdMgr, @Nullable QName targetElementQName, @Nullable QName targetAttributeQName) throws XSDException {
        QName qname = new QName(element.getNamespaceURI(), element.getNodeName());
        XSDNode xsdNode = (XSDNode)element.getProperty(XSD_TYPE);
        if (xsdNode == null) {
            QName xsiType = BPMNCubeDOMNavigator.getXsiType(element);
            if (xsiType != null) {
                xsdNode = xsdMgr.lookupXSDTypeDefinition(xsiType);
            } else if (DOMUtil.isRootElement((Element)element)) {
                XSDElement xsdElement = xsdMgr.lookupXSDElementDeclaration(qname);
                if (xsdElement != null) {
                    xsdNode = xsdElement.getType();
                }
            } else {
                XMLElement parentElement = (XMLElement)element.getParentNode();
                XSDComplexType parentXsd = this.lookupXSDComplexType(parentElement, xsdMgr, qname, null);
                if (parentXsd != null) {
                    XSDElement xsdElement = this.searchChildNode(parentXsd, qname, xsdMgr);
                    if (xsdElement == null && this.enableAutoDerivedTypeDetection) {
                        Collection<XSDNode> xsdParentNodes = this.lookupPossibleTransitiveTypeDefinitions(parentElement, parentXsd, xsdMgr);
                        LinkedHashMap<XSDNode, Tuple> foundChildXsdElements = new LinkedHashMap<XSDNode, Tuple>();
                        for (XSDNode transitiveParentNode : xsdParentNodes) {
                            XSDElement childFound;
                            if (!(transitiveParentNode instanceof XSDComplexType) || (childFound = this.searchChildNode((XSDComplexType)transitiveParentNode, qname, xsdMgr)) == null) continue;
                            XSDNode type = childFound.getType();
                            if (foundChildXsdElements.containsKey(type)) {
                                ((List)((Tuple)foundChildXsdElements.get(type)).getSecond()).add(transitiveParentNode);
                                continue;
                            }
                            ArrayList<XSDNode> list = new ArrayList<XSDNode>();
                            list.add(transitiveParentNode);
                            foundChildXsdElements.put(type, Tuple.create((Object)childFound, list));
                        }
                        if (!foundChildXsdElements.isEmpty()) {
                            if (foundChildXsdElements.size() > 1) {
                                Map.Entry entry;
                                Iterator it;
                                if (targetElementQName != null) {
                                    it = foundChildXsdElements.entrySet().iterator();
                                    while (it.hasNext()) {
                                        entry = it.next();
                                        if (entry.getKey() instanceof XSDComplexType) {
                                            if (this.searchChildNode((XSDComplexType)entry.getKey(), targetElementQName, xsdMgr) != null) continue;
                                            it.remove();
                                            continue;
                                        }
                                        it.remove();
                                    }
                                }
                                if (targetAttributeQName != null) {
                                    it = foundChildXsdElements.entrySet().iterator();
                                    while (it.hasNext()) {
                                        entry = it.next();
                                        if (entry.getKey() instanceof XSDComplexType) {
                                            if (((XSDComplexType)entry.getKey()).getAttributeDeclaration(targetAttributeQName.getNamespaceURI(), targetAttributeQName.getLocalPart()) != null) continue;
                                            it.remove();
                                            continue;
                                        }
                                        it.remove();
                                    }
                                }
                            }
                            if (foundChildXsdElements.size() == 1) {
                                Tuple tuple = (Tuple)foundChildXsdElements.values().iterator().next();
                                xsdElement = (XSDElement)tuple.getFirst();
                                parentElement.setProperty(XSD_DERIVED_TYPE_COLLECTION, tuple.getSecond());
                            }
                        }
                    }
                    if (xsdElement != null) {
                        xsdNode = this.checkRefState(xsdMgr, xsdElement).getType();
                    }
                }
            }
            if (!(xsdNode instanceof XSDComplexType)) {
                xsdNode = null;
            }
            if (xsdNode != null) {
                element.setProperty(XSD_TYPE, (Object)xsdNode);
            }
        }
        return (XSDComplexType)xsdNode;
    }

    private XSDElement checkRefState(SchemaManager xsdMgr, XSDElement xsdElement) throws XSDException {
        if (xsdElement != null && xsdElement.getRefState() == 0) {
            xsdElement = xsdMgr.lookupXSDElementDeclaration(new QName(xsdElement.getRefNamespace(), xsdElement.getRefLocalname()));
        }
        return xsdElement;
    }

    private XSDElement searchChildNode(XSDComplexType type, QName qname, @NotNull SchemaManager xsdMgr) throws XSDException {
        XSDNode[] transitiveChildElements;
        XSDElement childFound = null;
        for (XSDNode transitiveChildElement : transitiveChildElements = type.getChildElements()) {
            XSDElement xsdElement;
            if (!(transitiveChildElement instanceof XSDElement)) continue;
            if (transitiveChildElement.getQName().equals(qname)) {
                childFound = (XSDElement)transitiveChildElement;
                break;
            }
            QName childElemRefQName = SchemaHelper.getXSDElementRef((XSDElement)((XSDElement)transitiveChildElement));
            if (childElemRefQName != null && (childFound = this.searchInSubstitutions(xsdElement = xsdMgr.lookupXSDElementDeclaration(childElemRefQName), qname)) != null) break;
        }
        return this.checkRefState(xsdMgr, childFound);
    }

    private XSDElement searchInSubstitutions(XSDElement xsdElement, QName qname) {
        Vector substitutionGroup = xsdElement.getSubstitutionGroup();
        if (substitutionGroup != null) {
            for (Object element : substitutionGroup) {
                if (!(element instanceof XSDElement) || !((XSDElement)element).getQName().equals(qname)) continue;
                return (XSDElement)element;
            }
        }
        return null;
    }

    private Collection<XSDNode> lookupPossibleTransitiveTypeDefinitions(XMLElement element, XSDComplexType xsdType, SchemaManager xsdMgr) throws XSDException {
        Collection types = (Collection)element.getProperty(XSD_DERIVED_TYPE_COLLECTION);
        if (types == null) {
            types = xsdMgr.lookupXSDTransitiveDerivedTypeDefinition((XSDNode)xsdType);
            element.setProperty(XSD_DERIVED_TYPE_COLLECTION, (Object)types);
        }
        return types;
    }

    private boolean populateNode(Element element, @Nullable QName targetElementQName, @Nullable QName targetAttributeQName) {
        boolean result = false;
        try {
            XMLElement contextElement = (XMLElement)element;
            XMLElement rootElement = (XMLElement)element.getOwnerDocument().getDocumentElement();
            ExtendedVariableContext vc = (ExtendedVariableContext)rootElement.getProperty("xpath-variable-context");
            boolean init = false;
            if (vc != null) {
                boolean bl = init = vc.getVariableValue(null, null, "variable-init-mode") != null;
            }
            if (targetElementQName == null && targetAttributeQName == null && vc != null) {
                vc.setVariableValue("variable-ignore-errors", (Object)Boolean.TRUE);
                vc.setVariableValue("assert-assign-type-check", (Object)Boolean.FALSE);
            }
            if (init) {
                QName qname = new QName(contextElement.getNamespaceURI(), contextElement.getNodeName());
                SchemaManager xsdMgr = (SchemaManager)vc.getVariableValue(null, null, "schema-manager");
                XSDComplexType complexType = this.lookupXSDComplexType(contextElement, xsdMgr, targetElementQName, targetAttributeQName);
                if (complexType == null) {
                    System.out.println("Error while initializing variable, couldn't resolve element " + qname);
                    return false;
                }
                result = this.populateAttributes(contextElement, complexType, xsdMgr, targetAttributeQName);
                result |= this.populateChildElements(contextElement, complexType, xsdMgr, targetElementQName, vc);
            }
        }
        catch (XSDException e) {
            e.printStackTrace();
            CubeXMLLogger.LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UnresolvableException e) {
            e.printStackTrace();
            CubeXMLLogger.LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private boolean populateAttributes(XMLElement element, XSDComplexType xsdComplexType, SchemaManager xsdMgr, QName stepQName) throws UnresolvableException, XSDException {
        Collection<XSDNode> transitiveTypes;
        boolean result = false;
        XSDAttribute[] xsdAttributes = xsdComplexType.getAttributeDeclarations();
        if (xsdAttributes != null) {
            for (XSDAttribute xsdAttribute : xsdAttributes) {
                boolean foundStep;
                boolean bl = foundStep = stepQName != null && stepQName.equals(xsdAttribute.getQName());
                if ((xsdAttribute.isRequired() || foundStep) && !element.hasAttributeNS(xsdAttribute.getTargetNS(), xsdAttribute.getName())) {
                    this.addChildAttribute((Element)element, xsdAttribute);
                }
                result |= foundStep;
            }
        }
        if (!result && stepQName != null && this.enableAutoDerivedTypeDetection && (transitiveTypes = this.lookupPossibleTransitiveTypeDefinitions(element, xsdComplexType, xsdMgr)) != null) {
            LinkedList<XSDNode> transitiveTypesCopy = new LinkedList<XSDNode>(transitiveTypes);
            Iterator it = transitiveTypesCopy.iterator();
            while (it.hasNext()) {
                XSDNode type = (XSDNode)it.next();
                if (type instanceof XSDComplexType) {
                    XSDAttribute attribute = ((XSDComplexType)type).getAttributeDeclaration(stepQName.getNamespaceURI(), stepQName.getLocalPart());
                    if (attribute != null) {
                        if (result) continue;
                        this.addChildAttribute((Element)element, attribute);
                        result = true;
                        continue;
                    }
                    it.remove();
                    continue;
                }
                it.remove();
            }
            if (result) {
                element.setProperty(XSD_DERIVED_TYPE_COLLECTION, transitiveTypesCopy);
            }
        }
        return result;
    }

    private XMLAttr addChildAttribute(Element element, XSDAttribute xsdAttribute) {
        String vcValue = xsdAttribute.getDefaultVal();
        XMLAttr attribute = (XMLAttr)element.getOwnerDocument().createAttributeNS(xsdAttribute.getTargetNS(), xsdAttribute.getName());
        if (vcValue != null && xsdAttribute.isRequired()) {
            attribute.setNodeValue(vcValue);
        }
        element.setAttributeNode((Attr)attribute);
        return attribute;
    }

    private boolean populateChildElements(XMLElement element, XSDComplexType xsdComplexType, SchemaManager xsdMgr, QName targetElementQName, ExtendedVariableContext vc) throws UnresolvableException, XSDException {
        Collection<XSDNode> transitiveTypes;
        if (this.exitTraversing(xsdComplexType, (VariableContext)vc, targetElementQName)) {
            return false;
        }
        List<XMLElement> nodes = BPMNCubeDOMNavigator.toList(element.getChildNodes());
        boolean result = this.populateChildElements(element, nodes, (Ref<Integer>)Ref.createRef((Object)0), xsdComplexType.getGroup(), xsdMgr, targetElementQName, vc, true, new HashSet<XSDGroup>());
        if (!result && targetElementQName != null && this.enableAutoDerivedTypeDetection && (transitiveTypes = this.lookupPossibleTransitiveTypeDefinitions(element, xsdComplexType, xsdMgr)) != null) {
            LinkedList<XSDNode> transitiveTypesCopy = new LinkedList<XSDNode>(transitiveTypes);
            Iterator it = transitiveTypesCopy.iterator();
            while (it.hasNext()) {
                XSDNode derivedType = (XSDNode)it.next();
                if (derivedType instanceof XSDComplexType) {
                    if (this.searchChildNode((XSDComplexType)derivedType, targetElementQName, xsdMgr) != null) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
            if (!transitiveTypesCopy.isEmpty()) {
                boolean createMandatory = false;
                nodes = BPMNCubeDOMNavigator.toList(element.getChildNodes());
                this.populateChildElements(element, nodes, (Ref<Integer>)Ref.createRef((Object)0), ((XSDComplexType)transitiveTypesCopy.get(0)).getGroup(), xsdMgr, targetElementQName, vc, createMandatory, new HashSet<XSDGroup>());
                element.setProperty(XSD_DERIVED_TYPE_COLLECTION, transitiveTypesCopy);
                result = true;
            }
        }
        return result;
    }

    private boolean populateChildElements(XMLElement element, List<XMLElement> childNodes, Ref<Integer> itemRef, XSDGroup group, SchemaManager xsdMgr, QName targetElementQName, ExtendedVariableContext vc, boolean createMandatory, Set<XSDGroup> visited) throws UnresolvableException, XSDException {
        boolean result = false;
        BPMNServiceEngine engine = BPMNServiceEngine.getInstance();
        BPMNConfig config = engine.getBPMNConfig();
        boolean bforceOptionalCreation = false;
        if (config != null) {
            bforceOptionalCreation = config.getForceOptionalCreation();
        }
        if (!visited.contains(group)) {
            visited.add(group);
            int order = group.getOrder();
            Vector xsdNodeVector = group.getNodeVector();
            if (order == 0) {
                for (XSDNode xsdNode : xsdNodeVector) {
                    int item;
                    if (xsdNode instanceof XSDElement) {
                        XMLElement newElement;
                        boolean create;
                        boolean mandatory = !((XSDElement)xsdNode).isEmptiable();
                        XSDElement xsdElement = this.checkRefState(xsdMgr, (XSDElement)xsdNode);
                        Map<QName, XSDElement> substitutions = this.getSubstitutionMap(xsdElement);
                        boolean found = substitutions.containsKey(targetElementQName);
                        if (item == childNodes.size()) {
                            boolean bl = create = createMandatory && (mandatory || bforceOptionalCreation) && substitutions.size() == 1 || found;
                            if (create && (newElement = this.addChildElement(element, xsdElement, vc)) != null) {
                                childNodes.add(newElement);
                                ++item;
                            }
                        } else if (substitutions.containsKey(childNodes.get(item).getQName())) {
                            for (item = ((Integer)itemRef.get()).intValue(); item < childNodes.size() && substitutions.containsKey(childNodes.get(item).getQName()); ++item) {
                            }
                        } else {
                            boolean bl = create = createMandatory && (mandatory || bforceOptionalCreation) && substitutions.size() == 1 || found;
                            if (create) {
                                if (found) {
                                    xsdElement = substitutions.get(targetElementQName);
                                }
                                if ((newElement = this.insertChildElement(element, (Node)childNodes.get(item), xsdElement, vc)) != null) {
                                    childNodes.add(item, newElement);
                                    ++item;
                                }
                            }
                        }
                        result |= found;
                    } else if (xsdNode instanceof XSDGroup) {
                        XSDGroup xsdGroup = (XSDGroup)xsdNode;
                        result |= this.populateChildElements(element, childNodes, itemRef, xsdGroup, xsdMgr, targetElementQName, vc, createMandatory, visited);
                        item = (Integer)itemRef.get();
                    }
                    itemRef.set((Object)item);
                }
            } else if (order == 2) {
                XSDElement xsdElement;
                boolean[] present = new boolean[xsdNodeVector.size()];
                Map[] substitutionMaps = new Map[xsdNodeVector.size()];
                Set[] qNames = new Set[xsdNodeVector.size()];
                HashMap<QName, Integer> qNameIndexMap = new HashMap<QName, Integer>();
                for (int i = 0; i < xsdNodeVector.size(); ++i) {
                    XSDNode xsdNode = (XSDNode)xsdNodeVector.get(i);
                    if (xsdNode instanceof XSDElement) {
                        xsdElement = this.checkRefState(xsdMgr, (XSDElement)xsdNode);
                        substitutionMaps[i] = this.getSubstitutionMap(xsdElement);
                        qNames[i] = substitutionMaps[i].keySet();
                    } else if (xsdNode instanceof XSDGroup) {
                        qNames[i] = this.computeTransitiveGroupQNamesWithSubstitutions(xsdMgr, (XSDGroup)xsdNode);
                    }
                    if (qNames[i] == null) continue;
                    for (QName qName : qNames[i]) {
                        qNameIndexMap.put(qName, i);
                    }
                }
                int item = (Integer)itemRef.get();
                while (item < childNodes.size() && qNameIndexMap.containsKey(childNodes.get(item).getQName())) {
                    Integer index = (Integer)qNameIndexMap.get(childNodes.get(item).getQName());
                    present[index.intValue()] = true;
                    if (xsdNodeVector.get(index) instanceof XSDElement) {
                        ++item;
                        continue;
                    }
                    if (!(xsdNodeVector.get(index) instanceof XSDGroup)) continue;
                    itemRef.set((Object)item);
                    result |= this.populateChildElements(element, childNodes, itemRef, (XSDGroup)xsdNodeVector.get(index), xsdMgr, targetElementQName, vc, createMandatory, visited);
                    item = (Integer)itemRef.get();
                }
                itemRef.set((Object)item);
                for (int i = 0; i < present.length; ++i) {
                    if (present[i]) continue;
                    if (xsdNodeVector.get(i) instanceof XSDElement) {
                        XMLElement newElement;
                        boolean create;
                        xsdElement = (XSDElement)xsdNodeVector.get(i);
                        boolean found = substitutionMaps[i].containsKey(targetElementQName);
                        if (found) {
                            result = true;
                            xsdElement = (XSDElement)substitutionMaps[i].get(targetElementQName);
                        }
                        boolean bl = create = found || createMandatory && (!xsdElement.isEmptiable() || bforceOptionalCreation) && substitutionMaps[i].size() == 1;
                        if (!create || (newElement = item == childNodes.size() ? this.addChildElement(element, xsdElement, vc) : this.insertChildElement(element, (Node)childNodes.get(item), xsdElement, vc)) == null) continue;
                        childNodes.add(newElement);
                        ++item;
                        continue;
                    }
                    if (!(xsdNodeVector.get(i) instanceof XSDGroup)) continue;
                    itemRef.set((Object)item);
                    result |= this.populateChildElements(element, childNodes, itemRef, (XSDGroup)xsdNodeVector.get(i), xsdMgr, targetElementQName, vc, createMandatory, visited);
                    item = (Integer)itemRef.get();
                }
                itemRef.set((Object)item);
            } else if (order == 1) {
                int item = (Integer)itemRef.get();
                Set<QName> groupQNames = this.computeTransitiveGroupQNamesWithSubstitutions(xsdMgr, group);
                for (XSDNode xsdNode : xsdNodeVector) {
                    XSDGroup innerXsdGroup;
                    Set<QName> innerGroupQNames;
                    if (xsdNode instanceof XSDElement) {
                        XSDElement xsdElement = this.checkRefState(xsdMgr, (XSDElement)xsdNode);
                        Map<QName, XSDElement> substitutions = this.getSubstitutionMap(xsdElement);
                        boolean found = substitutions.containsKey(targetElementQName);
                        if (found) {
                            xsdElement = substitutions.get(targetElementQName);
                            XMLElement newElement = item == childNodes.size() ? this.addChildElement(element, xsdElement, vc) : this.insertChildElement(element, (Node)childNodes.get(item), xsdElement, vc);
                            if (newElement != null) {
                                childNodes.add(newElement);
                                itemRef.set((Object)(++item));
                            }
                            result = true;
                        }
                    } else if (xsdNode instanceof XSDGroup && (innerGroupQNames = this.computeTransitiveGroupQNamesWithSubstitutions(xsdMgr, innerXsdGroup = (XSDGroup)xsdNode)).contains(targetElementQName)) {
                        while (item < childNodes.size() && groupQNames.contains(childNodes.get(item).getQName()) && !innerGroupQNames.contains(childNodes.get(item).getQName())) {
                            ++item;
                        }
                        itemRef.set((Object)item);
                        result = this.populateChildElements(element, childNodes, itemRef, innerXsdGroup, xsdMgr, targetElementQName, vc, createMandatory, visited);
                    }
                    if (!result) continue;
                    break;
                }
                for (item = ((Integer)itemRef.get()).intValue(); item < childNodes.size() && groupQNames.contains(childNodes.get(item).getQName()); ++item) {
                }
                itemRef.set((Object)item);
            }
        }
        return result;
    }

    private Map<QName, XSDElement> getSubstitutionMap(XSDElement xsdElement) {
        LinkedHashMap<QName, XSDElement> map = new LinkedHashMap<QName, XSDElement>();
        map.put(xsdElement.getQName(), xsdElement);
        Vector substitutionGroup = xsdElement.getSubstitutionGroup();
        if (substitutionGroup != null) {
            for (Object s : substitutionGroup) {
                if (!(s instanceof XSDElement)) continue;
                XSDElement element = (XSDElement)s;
                map.put(element.getQName(), element);
            }
        }
        return map;
    }

    private Set<QName> computeTransitiveGroupQNamesWithSubstitutions(SchemaManager xsdMgr, XSDGroup group) throws XSDException {
        LinkedHashSet<QName> result = new LinkedHashSet<QName>();
        LinkedList<XSDGroup> groupQueue = new LinkedList<XSDGroup>();
        groupQueue.add(group);
        while (!groupQueue.isEmpty()) {
            XSDGroup xsdGroup = (XSDGroup)groupQueue.poll();
            Vector nodes = xsdGroup.getNodeVector();
            for (XSDNode node : nodes) {
                XSDGroup innerGroup;
                if (node instanceof XSDElement) {
                    XSDElement xsdElement = this.checkRefState(xsdMgr, (XSDElement)node);
                    result.addAll(this.getSubstitutionMap(xsdElement).keySet());
                    continue;
                }
                if (!(node instanceof XSDGroup) || (innerGroup = (XSDGroup)node).equals(xsdGroup) || groupQueue.contains(innerGroup)) continue;
                groupQueue.add(innerGroup);
            }
        }
        return result;
    }

    private void initializeElement(XMLElement xmlElement, XSDElement xsdElement) {
        String defaultVal = xsdElement.getDefaultVal();
        if (defaultVal != null) {
            xmlElement.setTextContent(defaultVal);
        } else if (xsdElement.getType() instanceof XSDSimpleType) {
            SchemaXMLGenerator.initializeSimpleType(xmlElement, (XSDSimpleType)xsdElement.getType(), false);
        }
    }

    private XMLElement addChildElement(XMLElement contextElement, XSDElement childElementDec, ExtendedVariableContext vc) throws UnresolvableException, XSDException {
        if (this.detectCycle(contextElement, childElementDec.getType(), vc)) {
            return null;
        }
        XMLElement child = (XMLElement)contextElement.getOwnerDocument().createElementNS(childElementDec.getTargetNS(), childElementDec.getName());
        this.initializeElement(child, childElementDec);
        contextElement.appendChild((Node)child);
        return child;
    }

    private XMLElement insertChildElement(XMLElement contextElement, Node beforeNode, XSDElement childElementDec, ExtendedVariableContext vc) throws UnresolvableException, XSDException {
        if (this.detectCycle(contextElement, childElementDec.getType(), vc)) {
            return null;
        }
        XMLElement newChild = (XMLElement)contextElement.getOwnerDocument().createElementNS(childElementDec.getTargetNS(), childElementDec.getName());
        this.initializeElement(newChild, childElementDec);
        contextElement.insertBefore((Node)newChild, beforeNode);
        return newChild;
    }

    private boolean detectCycle(XMLElement parent, XSDNode childType, ExtendedVariableContext vc) throws UnresolvableException {
        while (parent != null && !DOMUtil.isRootElement((Element)parent)) {
            XSDNode parentType = (XSDNode)parent.getProperty(XSD_TYPE);
            if (parentType != null && parentType == childType) {
                int axis;
                return vc.containsVariable(null, null, "axis") && (12 == (axis = ((Integer)vc.getVariableValue(null, null, "axis")).intValue()) || 2 == axis);
            }
            parent = (XMLElement)parent.getParentNode();
        }
        return false;
    }

    private boolean exitTraversing(XSDComplexType typeDef, VariableContext vc, QName stepQName) {
        boolean exit = false;
        if ("anyType".equals(typeDef.getName())) {
            exit = true;
        } else if (typeDef.isAbstract() || "http://www.w3.org/2001/XMLSchema".equals(typeDef.getTargetNS()) || typeDef.getBaseType() == null) {
            exit = true;
        } else if (stepQName != null && typeDef.getGroup() != null) {
            Vector vector = typeDef.getGroup().getNodeVector();
            boolean matchElem = false;
            boolean matchWildCard = false;
            for (Object item : vector) {
                if (!(item instanceof XSDElement)) continue;
                XSDElement ed = (XSDElement)item;
                String edXSName = ed.getName();
                String edXSNS = ed.getTargetNS();
                if (!edXSName.equals(stepQName.getLocalPart()) || !BPMNCubeDOMNavigator.compareNS(edXSNS, stepQName.getNamespaceURI())) continue;
                matchElem = true;
                break;
            }
            if (!matchElem) {
                for (Object item : vector) {
                    if (!(item instanceof XSDGroup)) continue;
                    XSDGroup group = (XSDGroup)item;
                    Vector children = group.getNodeVector();
                    for (Object item2 : children) {
                        XSDNode node2 = (XSDNode)item2;
                        if (node2 instanceof XSDElement) {
                            XSDElement ed = (XSDElement)item2;
                            String edXSName = ed.getName();
                            String edXSNS = ed.getTargetNS();
                            if (edXSName.equals(stepQName.getLocalPart()) && BPMNCubeDOMNavigator.compareNS(edXSNS, stepQName.getNamespaceURI())) break;
                            if (0 != node2.getNodeType()) continue;
                            matchWildCard = true;
                            break;
                        }
                        if (0 != node2.getNodeType()) continue;
                        matchWildCard = true;
                        break;
                    }
                    if (!matchWildCard) continue;
                    break;
                }
                if (matchWildCard) {
                    exit = true;
                }
            }
        }
        if (exit) {
            ((ExtendedVariableContext)vc).setVariableValue("variable-ignore-errors", (Object)Boolean.TRUE);
        }
        return exit;
    }

    protected static final class NodeIterator
    implements Iterator<Node> {
        NodeList mList;
        int pos;

        public NodeIterator(NodeList list) {
            this.mList = list;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.mList.getLength();
        }

        @Override
        public Node next() {
            return this.mList.item(this.pos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class AttributeIterator
    implements Iterator<Node> {
        private NamedNodeMap map;
        private int pos;

        AttributeIterator(Node parent) {
            this.map = parent.getAttributes();
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.map.getLength();
        }

        @Override
        public Node next() {
            return this.map.item(this.pos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

