/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.AuditLogSentenceLogger;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.LogSentenceContext;
import oracle.bpm.bpmn.engine.runtime.LogSentenceEvaluator;
import oracle.bpm.bpmn.engine.runtime.LogSentenceLogger;
import oracle.bpm.bpmn.engine.runtime.SoaInfraLogSentenceLogger;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import org.jetbrains.annotations.Nullable;

public class UserDefinedLogging {
    List<LogSentenceLogger> logSentenceLoggers = new ArrayList<LogSentenceLogger>();

    public UserDefinedLogging() {
        this.logSentenceLoggers.add(new SoaInfraLogSentenceLogger());
        this.logSentenceLoggers.add(new AuditLogSentenceLogger());
    }

    public void log(LogSentenceContext logSentenceContext, LogHandlerTrigger logHandlerTrigger, IScope scope) {
        LogSentenceEvaluator logSentenceEvaluator;
        if (this.isEnabled(logSentenceContext.getCubeContext()) && (logSentenceEvaluator = this.getLogSentenceEvaluator(logSentenceContext, logHandlerTrigger)) != null) {
            Loggable loggableNode = (Loggable)logSentenceContext.getFlowNode().asAnyNode(Loggable.class);
            Sequence<LogHandler> logHandlers = UserDefinedLogging.getLogHandlersByTrigger(loggableNode, logHandlerTrigger);
            for (LogHandler logHandler : logHandlers) {
                String logValue = logSentenceEvaluator.evaluate(logSentenceContext, logHandler, scope);
                this.log(logHandler, logValue, logSentenceContext);
            }
        }
    }

    private static Sequence<LogHandler> getLogHandlersByTrigger(Loggable loggable, final LogHandlerTrigger logHandlerTrigger) {
        return CollectionUtils.select((Iterable)loggable.getLogHandlerSet().getLogHandlers(), (Predicate)new Predicate<LogHandler>(){

            public boolean check(@Nullable LogHandler logHandler) {
                return logHandler != null && logHandler.getTrigger() == logHandlerTrigger;
            }
        });
    }

    private boolean isEnabled(ICubeContext iCubeContext) {
        AuditLevel auditLevel = ConfigurationHelper.getCurrentAuditLevel((ICubeProcess)CubeContextHelper.getCubeProcess((ICubeContext)iCubeContext), (ICubeContext)iCubeContext);
        return AuditLevel.Development.equals((Object)auditLevel);
    }

    private void log(LogHandler logHandler, String logValue, LogSentenceContext logSentenceContext) {
        for (LogSentenceLogger logSentenceLogger : this.logSentenceLoggers) {
            logSentenceLogger.log(logHandler, logValue, logSentenceContext);
        }
    }

    private LogSentenceEvaluator getLogSentenceEvaluator(LogSentenceContext logSentenceContext, LogHandlerTrigger flowNodeTrigger) {
        LogSentenceEvaluator logSentenceEvaluator = null;
        switch (flowNodeTrigger) {
            case BEFORE_INPUT_DATA_ASSOCIATION: 
            case AFTER_OUTPUT_DATA_ASSOCIATION: {
                logSentenceEvaluator = new DataObjectsLogSentenceEvaluator();
                break;
            }
            case AFTER_INPUT_DATA_ASSOCIATION: {
                logSentenceEvaluator = new DataInputsLogSentenceEvaluator(logSentenceContext);
                break;
            }
            case BEFORE_OUTPUT_DATA_ASSOCIATION: {
                logSentenceEvaluator = new DataOutputsLogSentenceEvaluator(logSentenceContext);
                break;
            }
            case BEFORE_ITERATION: 
            case BEFORE_INSTANCE_EXECUTION: 
            case AFTER_INSTANCE_EXECUTION: {
                if (logSentenceContext.getFlowNode().getBpmnType() != BpmnType.SUBPROCESS) break;
                LoopCharacteristicsType loopCharacteristics = ((Subprocess)logSentenceContext.getFlowNode().asAnyNode(Subprocess.class)).getLoopCharacteristicsType();
                if (loopCharacteristics == LoopCharacteristicsType.MULTIINSTANCE) {
                    logSentenceEvaluator = new DataObjectsLogSentenceEvaluator();
                    break;
                }
                if (loopCharacteristics != LoopCharacteristicsType.LOOP) break;
                logSentenceEvaluator = new DataObjectsLogSentenceEvaluator();
            }
        }
        return logSentenceEvaluator;
    }

    public class MultiInstanceLogSentenceEvaluator
    implements LogSentenceEvaluator {
        @Override
        public String evaluate(LogSentenceContext logSentenceContext, LogHandler logHandler, IScope iScope) {
            throw new UnsupportedOperationException("Under development.");
        }
    }

    public class LoopLogSentenceEvaluator
    implements LogSentenceEvaluator {
        @Override
        public String evaluate(LogSentenceContext logSentenceContext, LogHandler logHandler, IScope iScope) {
            throw new UnsupportedOperationException("Under development.");
        }
    }

    public class DataOutputsLogSentenceEvaluator
    implements LogSentenceEvaluator {
        final SequenceBuilder<String> dataElementNames;
        final Sequence<String> dataObjectIdElementRefs;

        public DataOutputsLogSentenceEvaluator(LogSentenceContext logSentenceContext) {
            this.dataElementNames = SequenceBuilder.create(logSentenceContext.getDataElementVariables().keySet());
            Sequence<DataObject> dataObjectRefs = DataHandlingUtils.getDataObjectsInScope(logSentenceContext.getFlowNode());
            this.dataObjectIdElementRefs = dataObjectRefs.map((Function)new Function<DataObject, String>(){

                public String eval(DataObject value) {
                    return value.getId();
                }
            });
        }

        @Override
        public String evaluate(LogSentenceContext logSentenceContext, LogHandler logHandler, IScope iScope) {
            String value = null;
            Expression expression = logHandler.getExpression();
            BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOUTPUTS_CONTEXT, (Sequence<String>)this.dataElementNames.build(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, this.dataObjectIdElementRefs, expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
            try {
                HashMap<String, DataElementVariable> dataObjectVariables = new HashMap<String, DataElementVariable>();
                BPMNExpression.fillDataElementVariablesFromDataObjectRefs(logSentenceContext.getFlowNode(), iScope, dataObjectVariables, this.dataObjectIdElementRefs);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, logSentenceContext.getDataElementVariables(), dataObjectVariables, logSentenceContext.getFlowNode());
                value = targetBPMNExpression.evaluateString(iScope, logSentenceContext.getCubeContext());
            }
            catch (CubeException e) {
                DataHandlingUtils.DataHandlingLogger.debug(logSentenceContext.getWorkItem(), logSentenceContext.getFlowNode(), (Object)e);
            }
            return value;
        }
    }

    public class DataObjectsLogSentenceEvaluator
    implements LogSentenceEvaluator {
        @Override
        public String evaluate(LogSentenceContext logSentenceContext, LogHandler logHandler, IScope scope) {
            String value = null;
            Expression expression = logHandler.getExpression();
            BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
            try {
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(logSentenceContext.getFlowNode(), targetBpmnExpressionMetadata, scope);
                value = targetBPMNExpression.evaluateString(scope, logSentenceContext.getCubeContext());
            }
            catch (CubeException e) {
                DataHandlingUtils.DataHandlingLogger.debug(logSentenceContext.getWorkItem(), logSentenceContext.getFlowNode(), (Object)e);
            }
            return value;
        }
    }

    public class DataInputsLogSentenceEvaluator
    implements LogSentenceEvaluator {
        final SequenceBuilder<String> dataElementNames;
        final Sequence<String> dataObjectIdElementRefs;

        public DataInputsLogSentenceEvaluator(LogSentenceContext logSentenceContext) {
            this.dataElementNames = SequenceBuilder.create(logSentenceContext.getDataElementVariables().keySet());
            Sequence<DataObject> dataObjectRefs = DataHandlingUtils.getDataObjectsInScope(logSentenceContext.getFlowNode());
            this.dataObjectIdElementRefs = dataObjectRefs.map((Function)new Function<DataObject, String>(){

                public String eval(DataObject value) {
                    return value.getId();
                }
            });
        }

        @Override
        public String evaluate(LogSentenceContext logSentenceContext, LogHandler logHandler, IScope iScope) {
            String value = null;
            Expression expression = logHandler.getExpression();
            BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, (Sequence<String>)this.dataElementNames.build(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, this.dataObjectIdElementRefs, expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
            try {
                HashMap<String, DataElementVariable> dataObjectVariables = new HashMap<String, DataElementVariable>();
                BPMNExpression.fillDataElementVariablesFromDataObjectRefs(logSentenceContext.getFlowNode(), iScope, dataObjectVariables, this.dataObjectIdElementRefs);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, logSentenceContext.getDataElementVariables(), dataObjectVariables, logSentenceContext.getFlowNode());
                value = targetBPMNExpression.evaluateString(iScope, logSentenceContext.getCubeContext());
            }
            catch (CubeException e) {
                DataHandlingUtils.DataHandlingLogger.debug(logSentenceContext.getWorkItem(), logSentenceContext.getFlowNode(), (Object)e);
            }
            return value;
        }
    }
}

