/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.runtime.CXTypeDataElementVariable;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SchemaXMLGenerator {
    private Document document;
    private int maxDepth = 4;
    private Stack<Node> nodesStack;
    private StringBuilder tabs = new StringBuilder();

    public SchemaXMLGenerator() {
        this.nodesStack = new Stack();
        this.document = DOMUtil.getDocumentBuilder().newDocument();
        this.nodesStack.push(this.document);
    }

    public static void initializeSimpleType(XMLElement xmlElement, XSDSimpleType xsdSimpleType) {
        SchemaXMLGenerator.initializeSimpleType(xmlElement, xsdSimpleType, true);
    }

    public static void initializeSimpleType(XMLElement xmlElement, XSDSimpleType xsdSimpleType, boolean initializeTime) {
        String localName;
        if (xsdSimpleType.isBuiltInDataType() && (localName = xsdSimpleType.getName()) != null) {
            QName qName = new QName(xsdSimpleType.getTargetNS(), localName);
            if (initializeTime || !CXTypeDataElementVariable.DATE_QNAME.equals(qName) && !CXTypeDataElementVariable.DATETIME_QNAME.equals(qName) && !CXTypeDataElementVariable.TIME_QNAME.equals(qName)) {
                String value = SchemaXMLGenerator.generateValue(qName);
                xmlElement.setTextContent(value);
            }
        }
    }

    public void generateTypeElement(XSDNode xsdType, QName qName, String defaultValue) {
        if (this.nodesStack.size() > this.maxDepth) {
            return;
        }
        this.finest("targetns: " + qName.getNamespaceURI());
        this.finest("name: " + qName.getLocalPart());
        Element element = this.document.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (defaultValue != null) {
            Text textNode = this.document.createTextNode(defaultValue);
            element.appendChild(textNode);
        }
        XMLElement currentElement = (XMLElement)this.getCurrentNode();
        currentElement.appendChild(element);
        this.nodesStack.push(element);
        this.finest("type: " + xsdType);
        this.processNode(xsdType);
        this.nodesStack.pop();
    }

    public void generateElement(XSDElement xsdElement) {
        this.indent();
        this.finest("element declaration: " + xsdElement);
        String defaultVal = xsdElement.getDefaultVal();
        if (defaultVal != null || !xsdElement.isEmptiable()) {
            this.generateTypeElement(xsdElement.getType(), new QName(xsdElement.getTargetNS(), xsdElement.getName()), defaultVal);
        }
        this.dedent();
    }

    public Document getValue() {
        Document document = null;
        if (this.nodesStack.size() > 0) {
            Node node = this.nodesStack.pop();
            if (node instanceof Document) {
                document = (Document)node;
            } else {
                throw new IllegalStateException("unexpected node " + node.getClass());
            }
        }
        return document;
    }

    private static boolean hasFacets(XSDSimpleType simpleType) {
        boolean hasFacets = false;
        XSDConstrainingFacet[] facets = simpleType.getFacets();
        if (facets != null) {
            for (XSDConstrainingFacet facet : facets) {
                if (facet == null) continue;
                return true;
            }
        }
        return hasFacets;
    }

    private static String generateValue(QName simpleTypeQName) {
        return CXTypeDataElementVariable.getDefaultValue(simpleTypeQName);
    }

    private Node getCurrentNode() {
        return this.nodesStack.peek();
    }

    private void generateAny(XSDAny xsdAny) {
        this.indent();
        this.finest("xsdAny: " + xsdAny);
        XMLElement xmlElement = (XMLElement)this.getCurrentNode();
        this.finest("setTextContent: " + xsdAny.getName());
        this.dedent();
    }

    private void generateGroup(XSDGroup xsdGroup) {
        this.indent();
        this.finest("xsdGroup: " + xsdGroup);
        int order = xsdGroup.getOrder();
        this.finest("order: " + order);
        Vector nodeVector = xsdGroup.getNodeVector();
        for (int i = 0; i < nodeVector.size(); ++i) {
            Object o = nodeVector.elementAt(i);
            this.finest("nodeVector index: " + i);
            this.finest("nodeVector element: " + o);
            if (!(o instanceof XSDNode)) continue;
            this.processNode((XSDNode)o);
        }
        this.dedent();
    }

    private void generateComplexType(XSDComplexType xsdComplexType) {
        this.indent();
        this.finest("xsdComplexType: " + xsdComplexType);
        this.finest("xsdComplexType QName: " + xsdComplexType.getQName());
        XSDAttribute[] attributeDeclarations = xsdComplexType.getAttributeDeclarations();
        if (attributeDeclarations != null) {
            for (XSDAttribute attributeDeclaration : attributeDeclarations) {
                this.processNode((XSDNode)attributeDeclaration);
            }
        }
        XSDGroup group = xsdComplexType.getGroup();
        this.generateGroup(group);
        this.dedent();
    }

    private void generateSimpleType(XSDSimpleType xsdSimpleType) {
        this.indent();
        this.finest("xsdSimpleType: " + xsdSimpleType);
        XMLElement xmlElement = (XMLElement)this.getCurrentNode();
        if (xmlElement.getTextContent() == null) {
            SchemaXMLGenerator.initializeSimpleType(xmlElement, xsdSimpleType);
        }
        this.dedent();
    }

    private void generateAttribute(XSDAttribute xsdAttribute) {
        this.indent();
        this.finest("attribute declaration: " + xsdAttribute);
        if (xsdAttribute.isRequired()) {
            String value;
            XMLElement xmlElement = (XMLElement)this.getCurrentNode();
            this.finest("targetns: " + xsdAttribute.getTargetNS());
            this.finest("name: " + xsdAttribute.getName());
            String defaultVal = xsdAttribute.getDefaultVal();
            String fixedVal = xsdAttribute.getFixedVal();
            if (fixedVal != null) {
                value = fixedVal;
            } else if (defaultVal != null) {
                value = defaultVal;
            } else {
                QName qName = new QName(xsdAttribute.getTargetNS(), xsdAttribute.getName());
                value = SchemaXMLGenerator.generateValue(qName);
            }
            xmlElement.setAttributeNS(xsdAttribute.getTargetNS(), xsdAttribute.getName(), value);
        }
        this.dedent();
    }

    private void processNode(XSDNode xsdNode) {
        if (xsdNode instanceof XSDAny) {
            this.generateAny((XSDAny)xsdNode);
        } else if (xsdNode instanceof XSDGroup) {
            this.generateGroup((XSDGroup)xsdNode);
        } else if (xsdNode instanceof XSDComplexType) {
            this.generateComplexType((XSDComplexType)xsdNode);
        } else if (xsdNode instanceof XSDSimpleType) {
            this.generateSimpleType((XSDSimpleType)xsdNode);
        } else if (xsdNode instanceof XSDElement) {
            this.generateElement((XSDElement)xsdNode);
        } else if (xsdNode instanceof XSDAttribute) {
            this.generateAttribute((XSDAttribute)xsdNode);
        }
    }

    private void finest(String message) {
        ComponentMigrationSupport.getLogger().finest("SchemaXMLGenerator->" + this.tabs + message);
    }

    private void indent() {
        this.tabs.append('\t');
    }

    private void dedent() {
        this.tabs.deleteCharAt(this.tabs.length() - 1);
    }
}

