/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.xml.xpath.XPathException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeModel;

public final class ProcessRoleCache {
    private static final Object lock = new Object();
    private static Map<String, Map<String, String>> sSwimLaneRoles = new HashMap<String, Map<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSwimlaneRole(String compositeDN, String processName, String activityId) throws Exception {
        String role;
        Map<String, String> processToRole = sSwimLaneRoles.get(compositeDN);
        if (processToRole == null) {
            Object object = lock;
            synchronized (object) {
                processToRole = sSwimLaneRoles.get(compositeDN);
                if (processToRole == null) {
                    processToRole = ProcessRoleCache.getProcesRoleMap(compositeDN, processName, activityId);
                }
            }
        }
        if ((role = processToRole.get(processName + "." + activityId)) == null) {
            Object object = lock;
            synchronized (object) {
                role = processToRole.get(processName + "." + activityId);
                if (role == null) {
                    role = ProcessRoleCache.getProcessRole(compositeDN, processName, activityId, processToRole);
                }
            }
        }
        return role;
    }

    public static void clearCache(String dn) {
        Map<String, String> processRole = sSwimLaneRoles.remove(dn);
        if (processRole != null) {
            processRole.clear();
            processRole = null;
        }
    }

    private static Map<String, String> getProcesRoleMap(String dn, String processName, String activityId) {
        HashMap<String, String> map = new HashMap<String, String>();
        sSwimLaneRoles.put(dn, map);
        return map;
    }

    private static String getProcessRole(String dn, String processName, String activityId, Map processActivtyToRoleMap) throws Exception {
        CompositeDN compositeDNObj = new CompositeDN(dn);
        CompositeModel compositeModel = BPMNServiceEngine.getInstance().getMesh().getComposite(dn);
        Project bpmProject = BPMNServiceEngine.getDeployedProjectServiceImpl().findDeployedProject(compositeDNObj, compositeModel);
        Process bpmProcess = bpmProject.findProcess(processName);
        Activity userTask = ModelUtils.findActivity((Process)bpmProcess, (String)activityId);
        if (userTask == null) {
            throw new XPathException(77000, new Object[]{processName});
        }
        Lane lane = userTask.getLane();
        if (lane == null) {
            throw new XPathException(77001, new Object[]{userTask.getLabel(Locale.getDefault()) + "[" + userTask.getId() + "]", processName});
        }
        String role = lane.getRole();
        processActivtyToRoleMap.put(processName + "." + activityId, role);
        return role;
    }
}

