/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.oracle.bpel.client.BPELFault;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.xml.parser.v2.XMLElement;

public class ProcessInstanceAttributeHelper {
    private static final String PIA_PREFIX = "__process---";
    public static final int NUM_WRITABLE_PIA = 6;
    public static final String BPEL_ATTRNAME = "attrName";
    private static final String NO_PROCESS_OWNER = "";
    static final String EMPTY_STRING = "";
    static final String EMPTY_NAMESPACE = "";
    public static final String ZERO = "0";
    private static final String NO_TASK_NUMBER = "NONE";

    public static Object createXMLValue(String name, String value) {
        XMLElement xmlElement = ProcessInstanceAttributeHelper.createXMLElement(name, value);
        return xmlElement.getOwnerDocument();
    }

    public static Object cantReturnEmpty(Object o) {
        return ProcessInstanceAttributeHelper.cantReturnEmpty(o, "");
    }

    public static Object cantReturnEmpty(Object o, Object def) {
        return ProcessInstanceAttributeHelper.isEmpty(o) ? def : o;
    }

    public static boolean isEmpty(Object o) {
        return o == null;
    }

    public static boolean validateOwner(IScope scope, ICubeContext context, String owner) throws CubeException {
        String ownerType = (String)ProcessInstanceAttribute.OWNERTYPE.getValue(scope, context);
        return ProcessInstanceAttributeHelper.validateOwner(owner, ownerType);
    }

    public static boolean validateOwner(String owner, String ownerType) throws CubeException {
        boolean isValid = false;
        isValid = IIdentityType.IDENTITY_TYPE.USER.name().equalsIgnoreCase(ownerType) ? ProcessInstanceAttributeHelper.isValidUser(owner) : (IIdentityType.IDENTITY_TYPE.GROUP.name().equalsIgnoreCase(ownerType) ? ProcessInstanceAttributeHelper.isValidGroup(owner) : (IIdentityType.IDENTITY_TYPE.ROLE.name().equalsIgnoreCase(ownerType) ? ProcessInstanceAttributeHelper.isValidRole(owner) : false));
        return isValid;
    }

    public static void validate(ProcessInstanceAttribute attr, IScope sc, ICubeContext ctx) throws CubeException {
        boolean isValid;
        Object value = null;
        try {
            value = attr.getValue(sc, ctx);
            isValid = attr.isValid(sc, ctx, value);
        }
        catch (NumberFormatException e) {
            isValid = false;
            value = "Not a number";
        }
        if (!isValid) {
            String summary = "Process instance attribute '" + attr.getAttrName() + "' wrong value : '" + value + "'";
            BPMRuntimeLogger.log(Level.INFO, "ProcessInstanceAttributeHelper", "validate", summary);
            throw new BPELFault(BPELDefs.QN_20_INVALID_VARIABLES, summary);
        }
    }

    public static void validate(ProcessInstanceAttribute attr, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
        String value = pia.get(attr.getAttrName().toUpperCase());
        boolean isValid = attr.isValid(value, pia, sc, ctx);
        if (!isValid) {
            String summary = "Process instance attribute '" + attr.getAttrName() + "' wrong value : '" + value + "'";
            BPMRuntimeLogger.log(Level.INFO, "ProcessInstanceAttributeHelper", "validate", summary);
            throw new BPELFault(BPELDefs.QN_20_INVALID_VARIABLES, summary);
        }
    }

    public static boolean validateCreator(IScope sc, ICubeContext ctx) throws CubeException {
        String creator = (String)ProcessInstanceAttribute.CREATOR.getValue(sc, ctx);
        return ProcessInstanceAttributeHelper.validateCreator(creator);
    }

    public static boolean validateCreator(String creator) throws CubeException {
        return ProcessInstanceAttributeHelper.isValidUser(creator) || ProcessInstanceAttributeHelper.isValidRole(creator);
    }

    public static String validateOu(Object ouName, String taskNumber) throws WorkflowException {
        return WorkflowUtil.getInternalOrganizationService().searchByOUNameOrHierarchyPath((String)ouName, taskNumber);
    }

    public static String validateOu(Object ouName) throws WorkflowException {
        return ProcessInstanceAttributeHelper.validateOu(ouName, NO_TASK_NUMBER);
    }

    public static String extractProcessOwnerName(String compositeDN) {
        List roles = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getApplicationRoles().getApplicationRole();
        String processOwner = "";
        for (ApplicationRoleType role : roles) {
            if (role.getProcessRole() != null && !role.getProcessRole().getId().equals("ProcessOwner")) continue;
            return BPMServicesUtil.getRoleId((ApplicationRoleType)role);
        }
        return "";
    }

    public static void validate(List<String> piaList, IScope sc, ICubeContext ctx) throws CubeException {
        String lastAttr = null;
        try {
            for (String attrName : piaList) {
                ProcessInstanceAttribute attr = ProcessInstanceAttribute.valueOf(attrName);
                lastAttr = attrName;
                ProcessInstanceAttributeHelper.validate(attr, sc, ctx);
            }
        }
        catch (IllegalArgumentException ignored) {
        }
        catch (BPELFault e) {
            if (BPELDefs.QN_20_INVALID_VARIABLES.equals(e.getFaultName())) {
                e.setPart(BPEL_ATTRNAME, lastAttr);
            }
            throw e;
        }
    }

    public static void validate(Map<String, String> piaList, IScope sc, ICubeContext ctx) throws CubeException {
        String lastAttr = null;
        try {
            for (String attrName : piaList.keySet()) {
                ProcessInstanceAttribute attr = ProcessInstanceAttribute.valueOf(attrName);
                lastAttr = attrName;
                ProcessInstanceAttributeHelper.validate(attr, piaList, sc, ctx);
            }
        }
        catch (IllegalArgumentException ignored) {
        }
        catch (BPELFault e) {
            if (BPELDefs.QN_20_INVALID_VARIABLES.equals(e.getFaultName())) {
                e.setPart(BPEL_ATTRNAME, lastAttr);
            }
            throw e;
        }
    }

    public static boolean isScopeStored(InstanceAttributeType instanceAttributeType, String instanceAttributeName) {
        return !ProcessInstanceAttributeHelper.isPIA(instanceAttributeType) || ProcessInstanceAttribute.isWritable(instanceAttributeName) || ProcessInstanceAttribute.isAutoUpdate(instanceAttributeName);
    }

    public static boolean isPIA(InstanceAttributeType type) {
        return InstanceAttributeType.PROCESS_INSTANCE_ATTRIBUTE.equals((Object)type);
    }

    public static boolean isPIAandReadOnly(String variableName) {
        if (!InstanceAttributeType.isProcessInstanceAttribute(variableName)) {
            return false;
        }
        String attributeName = InstanceAttributeType.getAttributeName(variableName);
        return !ProcessInstanceAttribute.isWritable(attributeName);
    }

    public static Object getPiaValue(String variableName, IScope scope) throws CubeException {
        String piaName = InstanceAttributeType.getAttributeName(variableName);
        return ProcessInstanceAttribute.valueOfPIA(piaName).getValue(scope, null);
    }

    public static String getProcessInstanceAttributeVariableName(String variable) {
        return InstanceAttributeType.getVariableName(InstanceAttributeType.PROCESS_INSTANCE_ATTRIBUTE, "", variable);
    }

    private static boolean isValidGroup(String owner) {
        boolean isValid;
        try {
            ServiceFactory.getAuthorizationServiceInstance().lookupGroup(owner);
            isValid = true;
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    private static boolean isValidUser(String userName) {
        boolean isValid;
        try {
            ServiceFactory.getAuthorizationServiceInstance().lookupUser(userName);
            isValid = true;
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    private static XMLElement createXMLElement(String name, String value) {
        XMLElement xmlElement = (XMLElement)DOMUtil.createRootElement((String)name, (String)"");
        xmlElement.setTextContent(value);
        return xmlElement;
    }

    private static boolean isValidRole(String roleName) {
        boolean isValidRole;
        try {
            ServiceFactory.getAuthorizationServiceInstance().lookupAppRole(roleName, "OracleBPMProcessRolesApp");
            isValidRole = true;
        }
        catch (Exception e) {
            isValidRole = false;
        }
        return isValidRole;
    }
}

