/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.CubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import java.util.Date;
import java.util.Map;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ScopeUtils;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttributeHelper;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.lang.Time;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.soa.management.ComponentDN;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;

public enum ProcessInstanceAttribute {
    CREATIONDATE("creationDate"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            Time ret = new Time(ci.getCreationDate());
            return ret.toXMLString();
        }
    }
    ,
    INSTANCENUMBER("instanceNumber"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getId();
        }
    }
    ,
    INSTANCEID("instanceId"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ProcessInstanceAttribute.BPMN + ci.getId();
        }
    }
    ,
    ECID("ecid"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getECID();
        }
    }
    ,
    PROCESSDN("processDN"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            ComponentDN dn = ci.getComponentDN();
            return BPMNUtility.removeLabelFromDN(dn.getCompositeDN()) + "/" + dn.getComponentName();
        }
    }
    ,
    CONVERSATIONID("conversationId"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String conversationId = ci.getConversationId();
            return ProcessInstanceAttributeHelper.cantReturnEmpty(conversationId);
        }
    }
    ,
    COMPONENTNAME("componentName"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getComponentName();
        }
    }
    ,
    COMPONENTTYPE("componentType"){

        @Override
        public Object getAutoValue(IScope sc) {
            return "BPMN";
        }
    }
    ,
    COMPOSITENAME("compositeName"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getCompositeName();
        }
    }
    ,
    COMPOSITEDN("compositeDN"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getComponentDN().getCompositeDN();
        }
    }
    ,
    COMPOSITELABEL("compositeLabel"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getCompositeLabel();
        }
    }
    ,
    COMPOSITEREVISION("compositeRevision"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getCompositeRevision();
        }
    }
    ,
    COMPOSITEINSTANCEID("compositeInstanceId"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ci.getCompositeInstanceId();
        }
    }
    ,
    ACTIVITYNAME("activityName"){

        @Override
        public Object getAutoValue(IScope sc) {
            return new String(ProcessInstanceAttribute.NO_FLOW_ELEMENT_NAME);
        }
    }
    ,
    MODIFYDATE("modifyDate"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            Date create = ci.getCreationDate();
            Date modify = ci.getModifyDate();
            Time ret = ProcessInstanceAttributeHelper.isEmpty(ci.getModifyDate()) ? new Time(create) : new Time(modify);
            return ret.toXMLString();
        }
    }
    ,
    TITLE("title"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String title = ci.getTitle();
            return ProcessInstanceAttributeHelper.createXMLValue("title", (String)ProcessInstanceAttributeHelper.cantReturnEmpty(title));
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return xmlElement.getText();
        }
    }
    ,
    PRIORITY("priority"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            return ProcessInstanceAttributeHelper.createXMLValue("priority", Integer.toString(ci.getPriority()));
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return Integer.parseInt((String)ProcessInstanceAttributeHelper.cantReturnEmpty(xmlElement.getText(), "0"));
        }
    }
    ,
    CREATOR("creator"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String creator = ci.getCreator();
            return ProcessInstanceAttributeHelper.createXMLValue("creator", (String)ProcessInstanceAttributeHelper.cantReturnEmpty(creator));
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return xmlElement.getText();
        }

        @Override
        public boolean isValid(IScope sc, ICubeContext ctx, Object value) throws CubeException {
            return super.isValid(sc, ctx, value) && ProcessInstanceAttributeHelper.validateCreator((String)value);
        }

        @Override
        public boolean isValid(Object value, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
            return this.isValid(sc, ctx, value);
        }
    }
    ,
    OWNER("owner"){

        @Override
        public Object getAutoValue(IScope sc) throws CubeException {
            return ProcessInstanceAttributeHelper.createXMLValue("owner", this.getAutoValueString(sc));
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return xmlElement.getText();
        }

        private String getAutoValueString(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String compositeDN = ci.getComponentDN().getCompositeDN();
            return ProcessInstanceAttributeHelper.extractProcessOwnerName(compositeDN);
        }

        @Override
        public boolean isValid(IScope sc, ICubeContext ctx, Object value) throws CubeException {
            return super.isValid(sc, ctx, value) && ProcessInstanceAttributeHelper.validateOwner(sc, ctx, (String)value);
        }

        @Override
        public boolean isValid(Object value, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
            String ownerType = (String)(pia.containsKey("OWNERTYPE") ? pia.get("OWNERTYPE") : OWNERTYPE.getValue(sc, ctx));
            return super.isValid(value, pia, sc, ctx) && ProcessInstanceAttributeHelper.validateOwner((String)value, ownerType);
        }

        @Override
        public boolean isDefaultValue(IScope sc, ICubeContext ctx) throws CubeException {
            return this.getAutoValueString(sc).equals(this.getValue(sc, ctx));
        }
    }
    ,
    OWNERTYPE("ownerType"){

        @Override
        public Object getAutoValue(IScope sc) {
            return ProcessInstanceAttributeHelper.createXMLValue("ownerType", IIdentityType.IDENTITY_TYPE.ROLE.name());
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return xmlElement.getText();
        }

        @Override
        public boolean isValid(IScope sc, ICubeContext ctx, Object value) throws CubeException {
            boolean isValid = false;
            for (IIdentityType.IDENTITY_TYPE valid : IIdentityType.IDENTITY_TYPE.values()) {
                if (!valid.name().equals(value)) continue;
                isValid = true;
            }
            return super.isValid(sc, ctx, value) && isValid;
        }

        @Override
        public boolean isValid(Object value, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
            String owner = (String)(pia.containsKey("OWNER") ? pia.get("OWNER") : OWNER.getValue(sc, ctx));
            return this.isValid(sc, ctx, value) && ProcessInstanceAttributeHelper.validateOwner(owner, (String)value);
        }
    }
    ,
    ORGANIZATIONALUNIT("organizationalUnit"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String compositeDN = ci.getComponentDN().getCompositeDN();
            String value = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getProcessOrganizationalUnitName();
            return ProcessInstanceAttributeHelper.createXMLValue("organizationalUnit", value);
        }

        @Override
        public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
            XMLDocument xmlDocument = (XMLDocument)super.getValue(sc, ctx);
            XMLElement xmlElement = (XMLElement)xmlDocument.getDocumentElement();
            return xmlElement.getText();
        }

        @Override
        public boolean isValid(IScope sc, ICubeContext ctx, Object ouName) throws CubeException {
            boolean isValid;
            try {
                ProcessInstanceAttributeHelper.validateOu(ouName);
                isValid = true;
            }
            catch (WorkflowException e) {
                isValid = false;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.ERRORS, (String)"oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute", (String)"organizationalUnit", (String)("Invalid ou name '" + ouName + "', composite instance id '" + sc.getCubeInstance().getCompositeInstanceId() + "'"));
            }
            return super.isValid(sc, ctx, ouName) && isValid;
        }

        @Override
        public boolean isValid(Object value, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
            return this.isValid(sc, ctx, value);
        }
    }
    ,
    CASEID("caseId"){

        @Override
        public Object getAutoValue(IScope sc) {
            CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
            String caseId = ProcessInstanceAttribute.NO_FLOW_ELEMENT_NAME;
            try {
                caseId = ScopeUtils.getCaseId((ICubeInstanceImpl)ci);
            }
            catch (CubeException e) {
                // empty catch block
            }
            if (caseId == null) {
                caseId = ProcessInstanceAttribute.NO_FLOW_ELEMENT_NAME;
            }
            return caseId;
        }
    };

    private static final String BPMN = "bpmn:";
    private static final String NO_FLOW_ELEMENT_NAME = "";
    private String attrName;

    private ProcessInstanceAttribute(String attrName) {
        this.attrName = attrName;
    }

    public static boolean exists(String instanceAttributeName) {
        try {
            ProcessInstanceAttribute.valueOfPIA(instanceAttributeName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ProcessInstanceAttribute valueOfPIA(String instanceAttributeName) {
        return ProcessInstanceAttribute.valueOf(instanceAttributeName.toUpperCase());
    }

    public String getAttrName() {
        return this.attrName;
    }

    public InstanceAttributeType getType() {
        return InstanceAttributeType.PROCESS_INSTANCE_ATTRIBUTE;
    }

    public void setAutoValue(IScope sc, ICubeContext ctx) throws CubeException {
        if (!this.isInitialized(sc, ctx)) {
            ProcessInstanceAttribute.initAllAttributes(sc, ctx);
        }
        this.setValue(sc, ctx, this.getAutoValue(sc));
    }

    public void declareAndSetAutoValue(IScope sc, ICubeContext ctx) throws CubeException {
        this.declareAndSet(sc, ctx, this.getAutoValue(sc));
    }

    public void setValue(IScope sc, ICubeContext ctx, Object value) throws CubeException {
        if (!this.isInitialized(sc, ctx)) {
            ProcessInstanceAttribute.initAllAttributes(sc, ctx);
        }
        DataHandlingUtils.setInstanceAttributeValue(this.getType(), NO_FLOW_ELEMENT_NAME, this.getAttrName(), sc, ctx, value);
    }

    public void declareAndSet(IScope sc, ICubeContext ctx, Object value) throws CubeException {
        DataHandlingUtils.declareAndSetInstanceAttribute(this.getType(), NO_FLOW_ELEMENT_NAME, this.getAttrName(), sc, ctx, value);
    }

    public Object getValue(IScope sc, ICubeContext ctx) throws CubeException {
        if (!this.isInitialized(sc, ctx)) {
            ProcessInstanceAttribute.initAllAttributes(sc, ctx);
        }
        return DataHandlingUtils.getInstanceAttributeValue(this.getType(), NO_FLOW_ELEMENT_NAME, this.getAttrName(), sc, ctx);
    }

    private static void initAllAttributes(IScope sc, ICubeContext ctx) throws CubeException {
        for (ProcessInstanceAttribute pia : ProcessInstanceAttribute.getAll()) {
            if (pia.isInitialized(sc, ctx)) continue;
            pia.declareAndSetAutoValue(sc, ctx);
        }
    }

    public abstract Object getAutoValue(IScope var1) throws CubeException;

    private boolean isInitialized(IScope sc, ICubeContext ctx) {
        boolean isInitialized;
        try {
            DataHandlingUtils.getInstanceAttributeValue(this.getType(), NO_FLOW_ELEMENT_NAME, this.getAttrName(), sc, ctx);
            isInitialized = true;
        }
        catch (CubeException e) {
            isInitialized = false;
        }
        return isInitialized;
    }

    public boolean isValid(IScope sc, ICubeContext ctx, Object value) throws CubeException {
        if (!this.isInitialized(sc, ctx)) {
            ProcessInstanceAttribute.initAllAttributes(sc, ctx);
        }
        return true;
    }

    public boolean isValid(Object value, Map<String, String> pia, IScope sc, ICubeContext ctx) throws CubeException {
        if (!this.isInitialized(sc, ctx)) {
            ProcessInstanceAttribute.initAllAttributes(sc, ctx);
        }
        return true;
    }

    public boolean isDefaultValue(IScope sc, ICubeContext ctx) throws CubeException {
        return this.getAutoValue(sc).equals(this.getValue(sc, ctx));
    }

    public static Sequence<ProcessInstanceAttribute> getWritableProcessInstanceAttributes() {
        return SequenceBuilder.create().append((Object)TITLE).append((Object)OWNER).append((Object)OWNERTYPE).append((Object)ORGANIZATIONALUNIT).append((Object)PRIORITY).append((Object)CREATOR).build();
    }

    private static Sequence<ProcessInstanceAttribute> getAutoUpdateProcessInstanceAttributes() {
        return SequenceBuilder.create().append((Object)ACTIVITYNAME).build();
    }

    public static Sequence<ProcessInstanceAttribute> getAll() {
        return CollectionUtils.asSequence((Object[])ProcessInstanceAttribute.values());
    }

    public static boolean isWritable(String attrName) {
        return ProcessInstanceAttribute.getWritableProcessInstanceAttributes().contains((Object)ProcessInstanceAttribute.valueOfPIA(attrName));
    }

    public static boolean isAutoUpdate(String attrName) {
        return ProcessInstanceAttribute.getAutoUpdateProcessInstanceAttributes().contains((Object)ProcessInstanceAttribute.valueOfPIA(attrName));
    }
}

