/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.Map;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.project.model.processes.FlowNode;

public class LogSentenceContext {
    Map<String, DataElementVariable> dataElementVariables;
    private ICubeContext cubeContext = null;
    private FlowNode flowNode = null;
    private ICubeInstanceImpl instance = null;
    private Long threadIn = null;
    private IWorkItem workItem = null;

    public LogSentenceContext(ICubeContext cubeContext, FlowNode flowNode, IWorkItem workItem) {
        this.cubeContext = cubeContext;
        this.threadIn = null;
        this.instance = CubeContextHelper.getCubeInstance((ICubeContext)cubeContext);
        this.workItem = workItem;
        this.flowNode = flowNode;
    }

    public ICubeContext getCubeContext() {
        return this.cubeContext;
    }

    public Long getThreadIn() throws CubeException {
        if (this.threadIn == null) {
            this.threadIn = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(this.workItem.getNodeActivationContext());
        }
        return this.threadIn;
    }

    public ICubeInstanceImpl getInstance() {
        return this.instance;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public void setDataElementVariables(Map<String, DataElementVariable> dataElementVariables) {
        this.dataElementVariables = dataElementVariables;
    }

    public Map<String, DataElementVariable> getDataElementVariables() {
        return this.dataElementVariables;
    }

    public IWorkItem getWorkItem() {
        return this.workItem;
    }

    public String toString() {
        return "LogSentenceContext{cubeContext=" + this.cubeContext + ", threadIn=" + this.threadIn + ", instance=" + this.instance + ", flowNode=" + this.flowNode + ", workItem=" + this.workItem + ", dataElementVariables=" + this.dataElementVariables + '}';
    }
}

