/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import org.jetbrains.annotations.NotNull;

public enum InstanceAttributeType {
    ACTIVITY_INSTANCE_ATTRIBUTE("activity"),
    PROCESS_INSTANCE_ATTRIBUTE("process"),
    GATEWAY_INSTANCE_ATTRIBUTE("gateway");

    private static String ATTRNAME_SEPARATOR;
    private static final String ELEMNAME_SEPARATOR = "-";
    private String variablePrefix;

    private InstanceAttributeType(String variablePrefix) {
        this.variablePrefix = "__" + variablePrefix;
    }

    public String getVariablePrefix() {
        return this.variablePrefix;
    }

    @NotNull
    public static String getVariableName(@NotNull InstanceAttributeType instanceAttributeType, @NotNull String flowElementName, @NotNull String attributeName) {
        return instanceAttributeType.getVariablePrefix() + ELEMNAME_SEPARATOR + flowElementName + ATTRNAME_SEPARATOR + attributeName;
    }

    public static boolean isProcessInstanceAttribute(String variableName) {
        return variableName.startsWith(PROCESS_INSTANCE_ATTRIBUTE.getVariablePrefix() + ELEMNAME_SEPARATOR + ATTRNAME_SEPARATOR);
    }

    public static String getAttributeName(String variableName) {
        return variableName.substring(variableName.lastIndexOf(ATTRNAME_SEPARATOR) + ATTRNAME_SEPARATOR.length());
    }

    static {
        ATTRNAME_SEPARATOR = "--";
    }
}

