/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ProcessRoleType;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DeploymentDescriptorUtil {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static JAXBContext jaxbContext;
    private static Map<String, Organization> orgCache;
    private static final String APP_ROLE_SEPARATOR = ".";
    private static final ApplicationContextTypeEnum DEFAULT_APPLICATION_CONTEXT;

    public static Map<String, String> getProcessRoles(String compositeDN) {
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        return DeploymentDescriptorUtil.getProcessRoles(organization);
    }

    public static Map<String, String> getProcessRoles(Organization organization) {
        List roles;
        if (organization == null) {
            throw new IllegalArgumentException("null organization");
        }
        HashMap<String, String> roleMap = new HashMap<String, String>();
        if (organization.getApplicationRoles() != null && (roles = organization.getApplicationRoles().getApplicationRole()) != null) {
            for (ApplicationRoleType role : roles) {
                String logicalRoleName;
                String physicalRoleName = role.getName();
                ProcessRoleType processRole = role.getProcessRole();
                if (processRole == null || (logicalRoleName = processRole.getId()) == null || physicalRoleName == null) continue;
                roleMap.put(logicalRoleName, physicalRoleName);
            }
        }
        return roleMap;
    }

    public static List<Participant> getParticipantsForProcessRole(String compositeDN, String processRole, Map<String, String> parameters) throws Exception {
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        if (processRole == null) {
            throw new IllegalArgumentException("null processRole");
        }
        Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        String compositeName = BPMNServiceEngine.getInstance().getCompositeName(compositeDN);
        String appRoleName = null;
        List roles = organization.getApplicationRoles().getApplicationRole();
        for (ApplicationRoleType role : roles) {
            String name;
            ProcessRoleType procRole = role.getProcessRole();
            if (procRole == null || !processRole.equals(name = procRole.getId())) continue;
            appRoleName = BPMServicesUtil.getRoleId((ApplicationRoleType)role);
        }
        if (appRoleName == null) {
            return new ArrayList<Participant>();
        }
        if (parameters == null) {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance();
            ArrayList<Participant> participants = new ArrayList<Participant>();
            participants.add(DeploymentDescriptorUtil.createApplicationRole(appRoleName, DEFAULT_APPLICATION_CONTEXT.value()));
            return participants;
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        IBPMServiceClient svcClient = bpmServiceClientFactory.getBPMServiceClient();
        IBPMOrganizationService bpmOrganizationService = svcClient.getBPMOrganizationService();
        IBPMContext ctx = DeploymentDescriptorUtil.getBPMContext();
        PeopleQuery peopleQuery = null;
        Object peopleQueryCtx = null;
        List participants = bpmOrganizationService.executePeopleQuery(ctx, peopleQuery, null);
        return participants;
    }

    public static String getOrganizationalUnit(String compositeDN) {
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        String ou = organization.getProcessOrganizationalUnitId();
        return ou;
    }

    public static Organization getBPMOrganization(String compositeDN) {
        Organization org = null;
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        if (orgCache.containsKey(compositeDN)) {
            org = orgCache.get(compositeDN);
        } else {
            BPMNServiceEngine engine = BPMNServiceEngine.getInstance();
            org = engine.getBPMOrganization(compositeDN);
            DeploymentDescriptorUtil.addToCache(compositeDN, org);
        }
        return org;
    }

    public static void addToCache(String compositeDN, Organization org) {
        orgCache.put(compositeDN, org);
    }

    public static void removeFromCache(String compositeDN) {
        if (orgCache.containsKey(compositeDN)) {
            orgCache.remove(compositeDN);
        }
    }

    public static void importOrganization(IBPMContext ctx, Organization organization) throws Exception {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        IBPMServiceClient svcClient = bpmServiceClientFactory.getBPMServiceClient();
        IBPMOrganizationService bpmOrganizationService = svcClient.getBPMOrganizationService();
        bpmOrganizationService.importOrganization(ctx, organization, true);
    }

    public static ApplicationContext createApplicationContext() {
        ApplicationContext applName = objectFactory.createApplicationContext();
        applName.setApplicationType(DEFAULT_APPLICATION_CONTEXT);
        return applName;
    }

    public static Organization getBPMOrganization(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("null XML Document");
        }
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Organization organization = (Organization)unmarshaller.unmarshal((Node)doc.getDocumentElement());
            return organization;
        }
        catch (Exception e) {
            throw new RuntimeException("null XML Document", e);
        }
    }

    private static Participant createApplicationRole(String name, String applicationContext) {
        PrincipleRefType principleRefType = objectFactory.createPrincipleRefType();
        principleRefType.setName(name);
        principleRefType.setApplicationContext(applicationContext);
        principleRefType.setType(ParticipantTypeEnum.APPROLE);
        Participant applicationRole = objectFactory.createParticipant(principleRefType);
        return applicationRole;
    }

    private static IBPMContext getBPMContext() throws BPMException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof BPMException) {
                throw (BPMException)((Object)orgEx);
            }
            throw new BPMException((Exception)pae);
        }
    }

    static {
        orgCache = Collections.synchronizedMap(new WeakHashMap());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        DEFAULT_APPLICATION_CONTEXT = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP;
    }
}

