/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.xml.xsd.XPathQueryInfo;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import oracle.bpm.bpmn.engine.runtime.CXElementDataElementVariable;
import oracle.bpm.bpmn.engine.runtime.CXTypeDataElementVariable;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.fabric.common.wsdl.SchemaManager;
import org.jetbrains.annotations.NotNull;

public abstract class DataElementVariable<S> {
    private DataDeclaration dataDeclaration;

    protected DataElementVariable(DataDeclaration dataDeclaration) {
        this.dataDeclaration = dataDeclaration;
    }

    public abstract boolean isNativeStructure();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract S getStructure();

    public abstract void initValue(NamespaceContext var1, SchemaManager var2) throws CubeException;

    public abstract void initValue(NamespaceContext var1, SchemaManager var2, List<XPathQueryInfo> var3) throws CubeException;

    public abstract boolean isUndefined();

    public static DataElementVariable create(DataDeclaration dataDeclaration) {
        DataElementVariable dataElementVariable;
        DataDeclarationBpmnDecorator dataDeclarationBpmnDecorator = new DataDeclarationBpmnDecorator(dataDeclaration);
        if (dataDeclarationBpmnDecorator.getStructureType() == DataDeclarationBpmnDecorator.BpmnStructureType.ELEMENT_STRUCTURE) {
            CXElementVariable elementVariable = new CXElementVariable();
            elementVariable.setName(dataDeclaration.getName());
            elementVariable.setElement(dataDeclarationBpmnDecorator.getStructure());
            dataElementVariable = new CXElementDataElementVariable(dataDeclaration, elementVariable);
        } else if (dataDeclarationBpmnDecorator.getStructureType() == DataDeclarationBpmnDecorator.BpmnStructureType.TYPE_STRUCTURE) {
            CXTypeVariable typeVariable = new CXTypeVariable();
            typeVariable.setName(dataDeclaration.getName());
            typeVariable.setType(dataDeclarationBpmnDecorator.getStructure());
            dataElementVariable = new CXTypeDataElementVariable(dataDeclaration, typeVariable);
        } else {
            throw new IllegalArgumentException();
        }
        return dataElementVariable;
    }

    @NotNull
    public static DataElementVariable create(@NotNull DataDeclaration dataDeclaration, @NotNull Object cubeVariable) {
        DataElementVariable dataElementVariable;
        if (cubeVariable instanceof CXElementVariable) {
            dataElementVariable = new CXElementDataElementVariable(dataDeclaration, (CXElementVariable)cubeVariable);
        } else if (cubeVariable instanceof CXTypeVariable) {
            dataElementVariable = new CXTypeDataElementVariable(dataDeclaration, (CXTypeVariable)cubeVariable);
        } else {
            throw new IllegalArgumentException("cubeVariable must be CXElement or CXType but is " + (cubeVariable == null ? null : cubeVariable.getClass()));
        }
        return dataElementVariable;
    }

    public DataDeclaration getDataDeclaration() {
        return this.dataDeclaration;
    }
}

