/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.CubeInstanceMigrationManager;
import com.collaxa.cube.engine.data.CubeInstancePersistenceMgr;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.blocks.migration.ComponentInstanceResultFactory;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.InstanceMigrationContext;
import oracle.soa.management.facade.MigrationPlan;

public abstract class BaseCubeInstanceMigrationManager
implements CubeInstanceMigrationManager {
    public ComponentInstanceMigrationReport checkCompatibility(InstanceMigrationContext imCtx, ComponentInstance instance, CompositeModel newRevision, ICubeContext iCtx) {
        throw new UnsupportedOperationException();
    }

    public ComponentInstanceMigrationResult migrate(InstanceMigrationContext imCtx, ComponentInstance instance, CompositeModel newRevision, MigrationPlan plan, ICubeContext ctx) {
        ComponentInstanceMigrationResult result;
        try {
            String id = instance.getId();
            if (id.contains(":")) {
                id = id.split(":")[1];
            }
            CubeInstancePersistenceMgr.updateRevision((long)Long.parseLong(id), (String)newRevision.getRevision(), (ICubeContext)ctx);
            result = ComponentInstanceResultFactory.getInstance().create(instance.getComponentName(), instance.getServiceEngine().getEngineType(), instance.getId(), true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ComponentInstanceResultFactory.getInstance().create(instance.getComponentName(), instance.getServiceEngine().getEngineType(), instance.getId(), false, e.getMessage());
        }
        return result;
    }
}

