/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.util.Map;
import java.util.Properties;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.project.model.processes.FlowNode;

public class BPMNExpressionExecutionContext {
    private Map<String, DataElementVariable> dataElementVariables;
    private Properties directives;
    private BPMNExpressionMetadata expressionData;
    private Map<String, DataElementVariable> externalDataElementVariables;
    private FlowNode node;

    public BPMNExpressionExecutionContext(BPMNExpressionMetadata expressionData, Map<String, DataElementVariable> dataElementVariables, Properties directives) {
        this(expressionData, dataElementVariables, null, directives, null);
    }

    public BPMNExpressionExecutionContext(BPMNExpressionMetadata expressionData, Map<String, DataElementVariable> dataElementVariables, Properties directives, FlowNode node) {
        this(expressionData, dataElementVariables, null, directives, node);
    }

    public BPMNExpressionExecutionContext(BPMNExpressionMetadata expressionData, Map<String, DataElementVariable> dataElementVariables, Map<String, DataElementVariable> externalDataElementVariables, Properties directives, FlowNode node) {
        this.expressionData = expressionData;
        this.dataElementVariables = dataElementVariables;
        this.externalDataElementVariables = externalDataElementVariables;
        this.directives = directives;
        this.node = node;
    }

    public Properties getDirectives() {
        return this.directives;
    }

    public BPMNExpressionMetadata getExpressionData() {
        return this.expressionData;
    }

    public Map<String, DataElementVariable> getDataElementVariables() {
        return this.dataElementVariables;
    }

    public Map<String, DataElementVariable> getExternalDataElementVariables() {
        return this.externalDataElementVariables;
    }

    public DataElementVariable resolve(String dataElement) {
        return this.getDataElementVariables().get(dataElement);
    }

    public DataElementVariable resolveExternal(String dataElement) {
        DataElementVariable dataElementVariable = null;
        Map<String, DataElementVariable> dataElementVariables = this.getExternalDataElementVariables();
        if (dataElementVariables != null) {
            dataElementVariable = dataElementVariables.get(dataElement);
        }
        return dataElementVariable;
    }

    public FlowNode getFlowNode() {
        return this.node;
    }
}

