/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.runtime.LogSentenceContext;
import oracle.bpm.bpmn.engine.runtime.LogSentenceLogger;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditVariable;

public class AuditLogSentenceLogger
implements LogSentenceLogger {
    public final AuditInstanceOperation getAuditInstanceOperation(LogHandler logHandler) {
        switch (logHandler.getTrigger()) {
            case BEFORE_INPUT_DATA_ASSOCIATION: {
                return AuditInstanceOperation.BEFORE_INPUT_DATA_ASSOCIATION;
            }
            case AFTER_OUTPUT_DATA_ASSOCIATION: {
                return AuditInstanceOperation.AFTER_OUTPUT_DATA_ASSOCIATION;
            }
            case AFTER_INPUT_DATA_ASSOCIATION: {
                return AuditInstanceOperation.AFTER_INPUT_DATA_ASSOCIATION;
            }
            case BEFORE_OUTPUT_DATA_ASSOCIATION: {
                return AuditInstanceOperation.BEFORE_OUTPUT_DATA_ASSOCIATION;
            }
            case BEFORE_ITERATION: {
                return AuditInstanceOperation.BEFORE_ITERATION;
            }
            case BEFORE_INSTANCE_EXECUTION: {
                return AuditInstanceOperation.BEFORE_INSTANCE_EXECUTION;
            }
            case AFTER_INSTANCE_EXECUTION: {
                return AuditInstanceOperation.AFTER_INSTANCE_EXECUTION;
            }
        }
        throw new IllegalArgumentException("Log sentence trigger " + logHandler.getTrigger() + " not supported.");
    }

    @Override
    public void log(LogHandler logHandler, String logValue, LogSentenceContext logSentenceContext) {
        if (logHandler.mustDisplayInAuditTrail()) {
            this.insertAuditEvent(logSentenceContext, logValue, logHandler);
        }
    }

    final void insertAuditEvent(LogSentenceContext logSentenceContext, String logValue, LogHandler logHandler) {
        try {
            BPMNAuditEvent event = AuditUtil.createNewAuditEvent((ICubeInstance)logSentenceContext.getInstance());
            event.setActivityName(logSentenceContext.getFlowNode().getName());
            event.setOperation(this.getAuditInstanceOperation(logHandler));
            event.setAuditInstanceType(logSentenceContext.getFlowNode().getBpmnType().name());
            event.setActivityId(logSentenceContext.getFlowNode().getId());
            event.setTitle(logSentenceContext.getFlowNode().getName());
            event.setComponentInstanceId(String.valueOf(logSentenceContext.getInstance().getKey().getInstanceId()));
            event.setComponentName(logSentenceContext.getInstance().getComponentName());
            event.setProcessName(logSentenceContext.getFlowNode().getProcess().getId());
            event.setInstanceCount(0L);
            event.setThreadId(logSentenceContext.getThreadIn());
            ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)logSentenceContext.getCubeContext());
            event.setCompositeInstanceId(cubeInstance.getCompositeInstanceId());
            event.setCompositeName(cubeInstance.getComponentDN().getCompositeName());
            event.setECID(cubeInstance.getECID());
            BpmnType flowNodeType = logSentenceContext.getFlowNode().getBpmnType();
            event.setFlowElementType(flowNodeType == null ? "PROCESS" : flowNodeType.getInnerType().name());
            event.setActivityType(AuditUtil.getActivityType(logSentenceContext.getFlowNode(), flowNodeType));
            event.setAuditLevel(1L);
            event.setLabel(logSentenceContext.getFlowNode().getDefaultLabel());
            event.setLoopCount(0L);
            event.setParentThreadId(-1L);
            event.setThreadId(logSentenceContext.getThreadIn());
            String varName = "Logevent " + logHandler.getLevel().name();
            IAuditVariable var = event.getVariable(varName);
            if (var == null) {
                var = AuditUtil.createNewAuditVariable();
                var.setName(varName);
                var.setValue((Object)logValue);
            }
            event.addAuditPayloadElement(var);
            DeploymentLogger.LOG.debug("Logging event", " {" + event.toString() + "}", new Object[]{" source composite DN {" + event.getCompositeDn() + "}"});
            AuditServiceFactory.getInstance().getAuditService().logAuditInstance(logSentenceContext.getCubeContext(), event);
        }
        catch (Exception e) {
            DeploymentLogger.LOG.error((Object)"Problem encountered when logging an Audit Event", (Throwable)e);
            e.printStackTrace();
        }
    }
}

