/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class Utils {
    private static final String GET = "get";
    private static final String SET = "set";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void copyField(T source, T target, String name) throws IllegalAccessException, NoSuchFieldException {
        Class<?> aClass = source.getClass();
        if (!aClass.equals(target.getClass())) {
            throw new IllegalArgumentException();
        }
        Field field = aClass.getDeclaredField(name);
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object o = field.get(source);
            field.set(target, o);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static <T> void copyObject(T src, T target, List<String> excludeToCopyList) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        for (Method getterMethod : src.getClass().getDeclaredMethods()) {
            String methodName = getterMethod.getName();
            if (!methodName.startsWith(GET) || excludeToCopyList.contains(methodName)) continue;
            try {
                Object value = getterMethod.invoke(src, new Object[0]);
                if (value == null) continue;
                Method setterMethod = target.getClass().getDeclaredMethod(Utils.getSetterMethodName(getterMethod), getterMethod.getReturnType());
                setterMethod.invoke(target, value);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    private static String getSetterMethodName(Method getterMethod) {
        return SET + getterMethod.getName().substring(GET.length());
    }
}

