/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ScopeUtils {
    public static Set<String> getTaskIdsSet(String nodeId, Map<String, Set<String>> tasksInRootScope) {
        Set<String> taskIds = null;
        Set<String> set = tasksInRootScope.get(nodeId);
        if (set != null) {
            if (set instanceof Set) {
                taskIds = set;
            } else if (set instanceof Collection) {
                taskIds = new HashSet<String>((Collection)set);
                tasksInRootScope.put(nodeId, taskIds);
            } else {
                throw new IllegalArgumentException("Expected a Set or Collection but was: " + set.getClass().getName());
            }
        }
        return taskIds;
    }

    public static void setCaseId(ICubeInstanceImpl instance, String caseId) throws CubeException {
        instance.getScopeContext().getRootScope().declareAndSet("cm.caseId", (Object)caseId);
    }

    public static String getCaseId(ICubeInstanceImpl instance) throws CubeException {
        String result = null;
        IScopeImpl rootScope = instance.getScopeContext().getRootScope();
        if (rootScope.contains("cm.caseId")) {
            result = (String)rootScope.getObject("cm.caseId");
        }
        return result;
    }

    public static Object getWorkItemValue(IWorkItem wi, String key) throws CubeException {
        Object result = wi.getNodeActivationContext().get(key);
        if (result == null) {
            result = wi.getScope().getAsObject(ScopeUtils.buildVariableName(key, wi.getKey().toString()));
        }
        return result;
    }

    public static String buildVariableName(String variable, String wiKey) {
        return variable + wiKey;
    }
}

