/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.xml.dom.DOMUtil;
import javax.xml.namespace.QName;
import oracle.bpm.lang.SchemaObject;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class SchemaUtils {
    private static int MAXIMUM_TREE_DEPTH = 3;

    public static XMLElement generateXMLForXSDType(SchemaManager schemaManager, String namespace, String argName, SchemaObject schemaObject) throws Exception {
        String complexTypeName = schemaObject.getName();
        String complexTypeNS = schemaObject.getNamespace();
        XSDComplexType complexType = (XSDComplexType)schemaManager.lookupXSDTypeDefinition(new QName(complexTypeNS, complexTypeName));
        XMLElement complexElement = (XMLElement)DOMUtil.createRootElement((String)argName, (String)namespace);
        if (complexType != null) {
            complexElement = SchemaUtils.generateXMLForXSDNode(schemaManager, complexElement, complexType.getChildElements(), 0);
        }
        return complexElement;
    }

    public static XMLElement generateXMLForXSDElement(SchemaManager schemaManager, String namespace, String argName) throws Exception {
        XSDElement xsdElement = schemaManager.lookupXSDElementDeclaration(new QName(namespace, argName));
        XSDNode[] nodes = null;
        if (xsdElement != null) {
            nodes = xsdElement.getChildElements();
        }
        XMLElement rootElement = (XMLElement)DOMUtil.createRootElement((String)argName, (String)namespace);
        return SchemaUtils.generateXMLForXSDNode(schemaManager, rootElement, nodes, 0);
    }

    private static XMLElement generateXMLForXSDNode(SchemaManager schemaManager, XMLElement rootElement, XSDNode[] childNodes, int treeDepth) throws Exception {
        if (treeDepth < 0 || treeDepth > MAXIMUM_TREE_DEPTH) {
            return null;
        }
        if (treeDepth == MAXIMUM_TREE_DEPTH) {
            return rootElement;
        }
        if (childNodes != null) {
            for (int i = 0; i < childNodes.length; ++i) {
                XSDNode node = childNodes[i];
                if (!node.isNodeType(3)) continue;
                XSDElement xsdElem = (XSDElement)node;
                String nodeName = xsdElem.getName();
                String nodeNS = xsdElem.getTargetNS();
                if (nodeName != null) {
                    if (xsdElem.getMinOccurs() == 0 && xsdElem.getMaxOccurs() == 0x7FFFFFF8) continue;
                    if (xsdElem.getType() instanceof XSDSimpleType) {
                        rootElement.appendChild((Node)rootElement.getDocument().createElementNS(nodeNS, nodeName));
                        continue;
                    }
                    if (!(xsdElem.getType() instanceof XSDComplexType)) continue;
                    XSDComplexType complexType = (XSDComplexType)xsdElem.getType();
                    XMLElement complexElement = (XMLElement)rootElement.getDocument().createElementNS(nodeNS, nodeName);
                    rootElement.appendChild((Node)SchemaUtils.generateXMLForXSDNode(schemaManager, complexElement, complexType.getChildElements(), treeDepth + 1));
                    continue;
                }
                String refName = xsdElem.getRefLocalname();
                String refNamespace = xsdElem.getRefNamespace();
                if (refName == null) continue;
                XSDElement xsdElement = schemaManager.lookupXSDElementDeclaration(new QName(refNamespace, refName));
                XMLElement xmlElement = (XMLElement)rootElement.getDocument().createElementNS(refNamespace, refName);
                rootElement.appendChild((Node)SchemaUtils.generateXMLForXSDNode(schemaManager, xmlElement, xsdElement.getChildElements(), treeDepth + 1));
            }
        }
        return rootElement;
    }
}

