/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.engine.CubeEngineLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.bpm.bpmn.engine.model.SchedulerServiceHelper;
import oracle.bpm.bpmn.engine.model.SchedulingLogger;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerFactory;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import org.jetbrains.annotations.Nullable;

public class SchedulingHelper {
    public static void schedule(String compositeDN, String key, StringProperties stringProperties, String cronExpression, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class listener, boolean persistJobs) {
        CubeEngineLogger.LOG.debug(SchedulingHelper.class, "Schedule " + compositeDN + " for cron expression " + cronExpression, new Object[0]);
        FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
        SchedulingHelper.printScheduled(compositeDN, "Scheduling (" + cronExpression + ")...");
        SchedulerServiceHelper.scheduleJob(schedulerService, compositeDN, key, stringProperties, cronExpression, startTime, endTime, calendar, outOfCalendarPolicy, listener);
        SchedulingHelper.printScheduled(compositeDN, null);
    }

    public static void schedule(String compositeDN, String key, StringProperties stringProperties, List<String> cronExpressions, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class listener, boolean persistJobs) {
        CubeEngineLogger.LOG.debug(SchedulingHelper.class, "Schedule " + compositeDN + " for cron expressions " + cronExpressions, new Object[0]);
        FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
        SchedulingHelper.printScheduled(compositeDN, "Scheduling (" + cronExpressions + ")...");
        SchedulerServiceHelper.scheduleJob(schedulerService, compositeDN, key, stringProperties, cronExpressions, startTime, endTime, calendar, outOfCalendarPolicy, listener);
        SchedulingHelper.printScheduled(compositeDN, null);
    }

    public static void schedule(String compositeDN, String key, StringProperties stringProperties, Date expDate, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class listener, boolean persistJobs) {
        if (expDate != null) {
            CubeEngineLogger.LOG.debug(SchedulingHelper.class, "Schedule " + compositeDN + " for date " + expDate, new Object[0]);
            FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
            SchedulingHelper.printScheduled(compositeDN, "Scheduling... (" + expDate + ")");
            SchedulerServiceHelper.scheduleJob(schedulerService, compositeDN, key, stringProperties, expDate, startTime, endTime, calendar, outOfCalendarPolicy, listener);
            SchedulingHelper.printScheduled(compositeDN, null);
        }
    }

    public static void schedule(String compositeDN, String key, StringProperties stringProperties, Date expDate, Class listener, boolean persistJobs) {
        if (expDate != null) {
            CubeEngineLogger.LOG.debug(SchedulingHelper.class, "Schedule " + compositeDN + " for date " + expDate, new Object[0]);
            Calendar start = Calendar.getInstance();
            start.setTime(expDate);
            FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
            SchedulingHelper.printScheduled(compositeDN, "Scheduling... (" + expDate + ")");
            schedulerService.scheduleJob(compositeDN, key, stringProperties, start, listener);
            SchedulingHelper.printScheduled(compositeDN, null);
        }
    }

    public static void unschedule(String compositeDN, String key, boolean persistJobs) throws Exception {
        CubeEngineLogger.LOG.debug(SchedulingHelper.class, "Unschedule " + compositeDN + " (" + key + ")", new Object[0]);
        SchedulingHelper.printScheduled(compositeDN, "Unscheduling...");
        FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
        schedulerService.unscheduleJob(compositeDN, key);
        SchedulingHelper.printScheduled(compositeDN, null);
    }

    public static FabricSchedulerService getSchedulerService(boolean persistJobs) {
        FabricSchedulerService schedulerService = persistJobs ? FabricSchedulerFactory.getInstance().getSchedulerService(FabricSchedulerFactory.SchedulerQOS.DB) : FabricSchedulerFactory.getInstance().getSchedulerService(FabricSchedulerFactory.SchedulerQOS.IN_MEMORY_NONTX);
        return schedulerService;
    }

    public static List<StringProperties> listScheduled(String compositeDN, boolean persistJobs) throws Exception {
        FabricSchedulerService schedulerService = SchedulingHelper.getSchedulerService(persistJobs);
        return schedulerService.listScheduledJobs(compositeDN);
    }

    public static void printScheduled(String compositeDN, @Nullable String action) {
        if (action != null) {
            SchedulingLogger.log(new Date() + " " + action);
            SchedulingLogger.log("Previous jobs: ");
        } else {
            SchedulingLogger.log("Current jobs: ");
        }
        try {
            SchedulingLogger.log("\tMemory: " + SchedulingHelper.listScheduled(compositeDN, false));
            SchedulingLogger.log("\tDB: " + SchedulingHelper.listScheduled(compositeDN, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

