/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.collaxa.cube.engine.types.bpel.CXCorrelationSet;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.XPathException;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import com.oracle.bpel.client.BPELFault;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.TrappableException;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingMsg;
import oracle.bpm.bpmn.engine.model.runtime.util.XSLMapper;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.CXTypeDataElementVariable;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.LogSentenceContext;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttributeHelper;
import oracle.bpm.bpmn.engine.runtime.UserDefinedLogging;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentOperation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.fabric.blocks.AssemblyModelObject;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.XSDException;
import oracle.fabric.common.xml.util.XMLSchemaTypeManager;
import oracle.fabric.common.xml.xpath.SimpleNamespaceContext;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.integration.platform.blocks.xpath.XPathContext;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DataHandlingUtils {
    public static void declareDataObjects(IScope sc, ICubeContext ctx, DataDeclarationContainer container) throws CubeException {
        DataHandlingUtils.declareDataObjects(sc, ctx, container, false);
    }

    public static void declareDataObjects(IScope sc, ICubeContext ctx, DataDeclarationContainer container, boolean skipIfDeclared) throws CubeException {
        for (DataObject dataObject : container.getLocalDeclarations(DataObject.class)) {
            if (skipIfDeclared && DataHandlingUtils.isDeclared(dataObject.getName(), sc) || DataHandlingUtils.declareAndSet((DataDeclaration)dataObject, sc, ctx)) continue;
            BPMRuntimeLogger.log(Level.SEVERE, BPMNProcessBlock.class.toString(), "__initScope", "Failed to declare dataObject " + dataObject.getName() + " in scope " + sc.getScopeId() + " with type " + dataObject.getType().getText());
        }
    }

    public static void declareProjectDataObjects(IScope sc, ICubeContext ctx, Project project) throws CubeException {
        for (ProjectDataObject dataObject : project.getProjectDataObjects()) {
            if (DataHandlingUtils.declareAndSet((DataDeclaration)dataObject, sc, ctx)) continue;
            BPMRuntimeLogger.log(Level.SEVERE, BPMNProcessBlock.class.toString(), "__initScope", "Failed to declare project dataObject " + dataObject.getName() + " in scope " + sc.getScopeId() + " with type " + dataObject.getType().getText());
        }
    }

    public static boolean declareAndSet(DataDeclaration dataDeclaration, IScope sc, ICubeContext ctx) throws CubeException {
        DataDeclarationBpmnDecorator dataDeclarationBpmnDecorator = new DataDeclarationBpmnDecorator(dataDeclaration);
        DataElementVariable dataElementVariable = DataElementVariable.create(dataDeclarationBpmnDecorator);
        if (dataDeclarationBpmnDecorator.isInitialized()) {
            HashMap<String, URI> map = new HashMap<String, URI>();
            dataElementVariable.initValue(new BPMNNamespaceContext(map), DataHandlingUtils.getSchemaManager(ctx));
        }
        sc.declareAndSet(dataElementVariable.getDataDeclaration().getName(), dataElementVariable.getStructure());
        return true;
    }

    public static boolean isDeclared(String name, IScope sc) throws CubeException {
        return sc.contains(name);
    }

    public static void declareCorrelationKeys(IScope sc, CorrelationKeyContainer model) throws CubeException {
        DataHandlingUtils.declareCorrelationKeys(sc, model, false);
    }

    public static void declareCorrelationKeys(IScope sc, CorrelationKeyContainer model, boolean skipIfDeclared) throws CubeException {
        for (CorrelationKey correlationKey : model.getCorrelationKeys()) {
            String corrSetName = correlationKey.getName();
            String correlationKeyName = "__correlationSet_" + corrSetName;
            if (skipIfDeclared && DataHandlingUtils.isDeclared(correlationKeyName, sc)) continue;
            CXCorrelationSet cs = new CXCorrelationSet();
            for (CorrelationProperty property : correlationKey.getProperties()) {
                cs.setProperty(property.getFullName(), null);
            }
            sc.declareAndSet(correlationKeyName, (Object)cs);
        }
    }

    public static void declareAndSetInstanceAttribute(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx, Object value) throws CubeException {
        if (ProcessInstanceAttributeHelper.isScopeStored(instanceAttributeType, instanceAttributeName)) {
            scope.declareAndSet(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName), value);
        }
    }

    public static <T> T getInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx) throws CubeException {
        if (ProcessInstanceAttributeHelper.isScopeStored(instanceAttributeType, instanceAttributeName)) {
            return (T)scope.getObject(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName));
        }
        return (T)ProcessInstanceAttribute.valueOf(instanceAttributeName.toUpperCase()).getAutoValue(scope);
    }

    public static <T> void setInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx, T value) throws CubeException {
        if (ProcessInstanceAttributeHelper.isScopeStored(instanceAttributeType, instanceAttributeName)) {
            scope.set(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName), value);
        }
    }

    public static boolean containsInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx) throws CubeException {
        return ProcessInstanceAttributeHelper.isScopeStored(instanceAttributeType, instanceAttributeName) ? scope.contains(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName)) : true;
    }

    public static Object getVariableValue(String variableName, IScope scope, boolean isPrimitive) throws CubeException {
        Object value = DataHandlingUtils.getVariableValue(variableName, scope);
        if (value != null && isPrimitive) {
            value = DataHandlingUtils.getValueFromData(value);
        }
        return value;
    }

    public static Object getVariableValue(String variableName, IScope scope) throws CubeException {
        return DataHandlingUtils.getVariableValue(scope.getObject(variableName));
    }

    public static QName getVariableType(String variableName, IScope scope) throws CubeException {
        return DataHandlingUtils.getVariableType(scope.getObject(variableName));
    }

    public static Object getVariableValue(Object variable) {
        Object result = variable instanceof CXTypeVariable ? ((CXTypeVariable)variable).getValue() : (variable instanceof CXElementVariable ? ((CXElementVariable)variable).getValue() : (variable instanceof Document ? ((Document)variable).getDocumentElement() : variable));
        return result;
    }

    public static void setVariableValue(String variableName, IScope scope, Object value) throws CubeException {
        DataHandlingUtils.setVariableValue(scope.getObject(variableName), value);
    }

    public static void setVariableValue(Object variable, Object value) {
        if (variable instanceof CXTypeVariable) {
            ((CXTypeVariable)variable).setValue((Object)DOMUtil.getTextValue((Node)((Node)value)));
        } else if (variable instanceof CXElementVariable) {
            ((CXElementVariable)variable).setValue((Element)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static XMLElement generateXMLElement(QName typeQName, QName rootQName, ICubeContext ctx) throws CubeException {
        SchemaManager schemaManager = DataHandlingUtils.getSchemaManager(ctx);
        XMLElement result = SchemaToXML.generateXMLElementForType(null, (int)-1, (QName)rootQName, (QName)typeQName, null, (boolean)false, (NamespaceContext)new SimpleNamespaceContext(), (SchemaManager)schemaManager);
        return result;
    }

    public static SchemaManager getSchemaManager(ICubeContext ctx) {
        return CubeContextHelper.getScaComponent((ICubeContext)ctx).getComposite().getWSDLManager().getSchemaManager();
    }

    public static Map<String, Object> processInputDataForServiceActivities(FlowNode flowNode, Map<String, String> partNamesMap, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem) throws CubeException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData(flowNode, inputDataAssociationSet, sc, ctx, workItem);
        Sequence dataDeclarationSequence = inputDataAssociationSet.getArgumentsContainer().getDeclarations();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            Object value;
            String partName = partNamesMap.get(dataDeclaration.getName());
            DataElementVariable dataElementVariable = data.get(dataDeclaration.getName());
            if (dataElementVariable.getValue() == null) {
                dataElementVariable.initValue(new BPMNNamespaceContext(Collections.<String, URI>emptyMap()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if ((value = dataElementVariable.getValue()) instanceof XMLElement && dataElementVariable instanceof CXTypeDataElementVariable) {
                XMLElement xmlElement = (XMLElement)value;
                xmlElement.setTagName("", partName);
            }
            result.put(partName, value);
        }
        return result;
    }

    public static Map<String, DataElementVariable> processInputData(FlowNode flowNode, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem) throws CubeException {
        return DataHandlingUtils.processInputData(flowNode, inputDataAssociationSet, sc, ctx, workItem, new HashMap<String, Object>());
    }

    public static Map<String, DataElementVariable> processInputData(FlowNode flowNode, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem, Map<String, Object> initialValues) throws CubeException {
        Sequence dataTransformations;
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Start processing inputDataAssociationSet...");
        Map<String, DataElementVariable> dataInputVariables = DataHandlingUtils.createDataElementVariables(inputDataAssociationSet, initialValues, ctx);
        Sequence dataAssociations = inputDataAssociationSet.getDataAssignments();
        if (dataAssociations != null && !dataAssociations.isEmpty()) {
            LogSentenceContext logSentenceContext = new LogSentenceContext(ctx, flowNode, workItem);
            DataHandlingUtils.triggerUserDefinedLog(logSentenceContext, sc, LogHandlerTrigger.BEFORE_INPUT_DATA_ASSOCIATION);
            for (DataAssignment dataAssignment : dataAssociations) {
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Start processing dataAssociation " + DataHandlingMsg.INFO_DATAASSOCIATION(dataAssignment).getString()));
                }
                DataAssignmentItem sourceDataAssignmentItem = dataAssignment.getSource();
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getRefs(), sourceDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, sourceDataAssignmentItem.getExpression().getNamespaces());
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                DataAssignmentItem targetDataAssignmentItem = dataAssignment.getTarget();
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, (Sequence<String>)targetDataAssignmentItem.getRefs(), targetDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, targetDataAssignmentItem.getExpression().getNamespaces());
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, dataInputVariables, flowNode);
                targetBPMNExpression.setOnDemandInit();
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(sourceBPMNExpression).getString()));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Target BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(targetBPMNExpression).getString()));
                }
                DataHandlingUtils.performAssignmentOperation(sc, ctx, workItem, dataAssignment, sourceBPMNExpression, targetBPMNExpression);
                if (!DataHandlingLogger.isDebug()) continue;
                DataHandlingLogger.debug(workItem, flowNode, (Object)("Target DataElements=" + DataHandlingMsg.dumpDataElements(targetBPMNExpression.getDataElementVariables())));
            }
            logSentenceContext.setDataElementVariables(dataInputVariables);
            DataHandlingUtils.triggerUserDefinedLog(logSentenceContext, sc, LogHandlerTrigger.AFTER_INPUT_DATA_ASSOCIATION);
        }
        if ((dataTransformations = inputDataAssociationSet.getDataTransformations()) != null) {
            for (DataTransformation dataTransformation : dataTransformations) {
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataTransformation.getSourceRefs(), dataTransformation.getTransformationName(), BPMNExpressionLanguage.XPATH, null);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                ArrayList<String> targetRefs = new ArrayList<String>();
                targetRefs.add(dataTransformation.getTargetRef());
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(targetRefs), null, BPMNExpressionLanguage.XPATH, null);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, dataInputVariables, flowNode);
                DataHandlingUtils.performTransformation(flowNode, sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression, dataTransformation);
            }
        }
        DataHandlingUtils.validateDataElementVariables(inputDataAssociationSet, dataInputVariables.values(), ctx, workItem, flowNode);
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Finished processing inputDataAssociationSet.");
        return dataInputVariables;
    }

    public static void processOutputDataForServiceActivities(FlowNode flowNode, Map<String, String> partNamesMap, DataAssociationSet outputDataAssociationSet, IScope sc, ICubeContext ctx, Map<String, Object> payload, IWorkItem workItem, boolean inbound) throws CubeException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Sequence dataDeclarationSequence = outputDataAssociationSet.getArgumentsContainer().getDeclarations();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            String partName = partNamesMap.get(dataDeclaration.getName());
            data.put(dataDeclaration.getName(), payload.get(partName));
        }
        DataHandlingUtils.processOutputData(flowNode, outputDataAssociationSet, sc, ctx, data, workItem);
    }

    public static void processOutputExecDataOnly(FlowNode flowNode, DataAssociationSet outputDataAssociationSet, IScope sc, ICubeContext ctx, Map<String, Object> data, IWorkItem workItem, String execDataOrTaskVarName, String taskElementToCopy) throws CubeException {
        Sequence dataTransformations;
        BPMNExpressionMetadata sourceBpmnExpressionMetadata;
        String sourceRef;
        Iterator it;
        Sequence refs;
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Start processing execData in outputDataAssociationSet...");
        Map<String, DataElementVariable> dataOutputVariables = DataHandlingUtils.createDataElementVariables(outputDataAssociationSet, data, ctx);
        Sequence outputDataAssociations = outputDataAssociationSet.getDataAssignments();
        if (outputDataAssociations != null && !outputDataAssociations.isEmpty()) {
            for (DataAssignment dataAssignment : outputDataAssociations) {
                String expr;
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Start processing dataAssociation " + DataHandlingMsg.INFO_DATAASSOCIATION(dataAssignment).getString()));
                }
                DataAssignmentItem sourceDataAssignmentItem = dataAssignment.getSource();
                boolean isExecDataTaskIdCopy = false;
                refs = sourceDataAssignmentItem.getRefs();
                it = refs.iterator();
                if (it.hasNext() && (sourceRef = (String)it.next()) != null && sourceRef.trim().equals(execDataOrTaskVarName) && sourceDataAssignmentItem.getExpression() != null && (expr = sourceDataAssignmentItem.getExpression().getExpressionValue()) != null && expr.contains(taskElementToCopy)) {
                    isExecDataTaskIdCopy = true;
                }
                if (!isExecDataTaskIdCopy) continue;
                sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOUTPUTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getOtherRefs(), sourceDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, sourceDataAssignmentItem.getExpression().getNamespaces());
                Sequence dataObjectRefs = sourceDataAssignmentItem.getOtherRefs();
                HashMap<String, DataElementVariable> dataObjectVariables = new HashMap<String, DataElementVariable>();
                BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, sc, dataObjectVariables, (Sequence<String>)dataObjectRefs);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, dataObjectVariables, flowNode);
                DataAssignmentItem targetDataAssignmentItem = dataAssignment.getTarget();
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)targetDataAssignmentItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getOtherRefs(), targetDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, targetDataAssignmentItem.getExpression().getNamespaces());
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                targetBPMNExpression.setOnDemandInit();
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(sourceBPMNExpression).getString()));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source External DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getExternalDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Target BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(targetBPMNExpression).getString()));
                }
                DataHandlingUtils.performCopy(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                if (!DataHandlingLogger.isDebug()) break;
                DataHandlingLogger.debug(workItem, flowNode, (Object)("Target DataElements=" + DataHandlingMsg.dumpDataElements(targetBPMNExpression.getDataElementVariables())));
                break;
            }
        }
        if ((dataTransformations = outputDataAssociationSet.getDataTransformations()) != null) {
            for (DataTransformation dataTransformation : dataTransformations) {
                boolean isExecData = false;
                refs = dataTransformation.getSourceRefs();
                it = refs.iterator();
                if (it.hasNext() && (sourceRef = (String)it.next()) != null && sourceRef.trim().equals(execDataOrTaskVarName)) {
                    isExecData = true;
                }
                if (!isExecData) continue;
                sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataTransformation.getSourceRefs(), dataTransformation.getTransformationName(), BPMNExpressionLanguage.XPATH, null);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                if (!dataOutputVariables.isEmpty()) {
                    sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, sourceBPMNExpression.getDataElementVariables(), flowNode);
                }
                ArrayList<String> targetRefs = new ArrayList<String>();
                targetRefs.add(dataTransformation.getTargetRef());
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(targetRefs), null, BPMNExpressionLanguage.XPATH, null);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                DataHandlingUtils.performTransformation(flowNode, sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression, dataTransformation);
                break;
            }
        }
    }

    public static void processOutputData(FlowNode flowNode, DataAssociationSet outputDataAssociationSet, IScope sc, ICubeContext ctx, Map<String, Object> data, IWorkItem workItem) throws CubeException {
        Sequence dataTransformations;
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Start processing outputDataAssociationSet...");
        Map<String, DataElementVariable> dataOutputVariables = DataHandlingUtils.createDataElementVariables(outputDataAssociationSet, data, ctx);
        Sequence outputDataAssociations = outputDataAssociationSet.getDataAssignments();
        if (outputDataAssociations != null && !outputDataAssociations.isEmpty()) {
            LogSentenceContext logSentenceContext = new LogSentenceContext(ctx, flowNode, workItem);
            logSentenceContext.setDataElementVariables(dataOutputVariables);
            DataHandlingUtils.triggerUserDefinedLog(logSentenceContext, sc, LogHandlerTrigger.BEFORE_OUTPUT_DATA_ASSOCIATION);
            Map<String, DataElementVariable> targetDataObjectsMap = DataHandlingUtils.buildTargetDataObjectsMap((Sequence<DataAssignment>)outputDataAssociations, flowNode, sc);
            ArrayList<String> piaList = new ArrayList<String>(6);
            for (DataAssignment dataAssignment : outputDataAssociations) {
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Start processing dataAssociation " + DataHandlingMsg.INFO_DATAASSOCIATION(dataAssignment).getString()));
                }
                DataAssignmentItem sourceDataAssignmentItem = dataAssignment.getSource();
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOUTPUTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssignmentItem.getOtherRefs(), sourceDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, sourceDataAssignmentItem.getExpression().getNamespaces());
                Sequence dataObjectRefs = sourceDataAssignmentItem.getOtherRefs();
                HashMap<String, DataElementVariable> dataObjectVariables = new HashMap<String, DataElementVariable>();
                BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, sc, dataObjectVariables, (Sequence<String>)dataObjectRefs);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, dataObjectVariables, flowNode);
                DataAssignmentItem targetDataAssignmentItem = dataAssignment.getTarget();
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)targetDataAssignmentItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)targetDataAssignmentItem.getOtherRefs(), targetDataAssignmentItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, targetDataAssignmentItem.getExpression().getNamespaces());
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                targetBPMNExpression.setOnDemandInit();
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(sourceBPMNExpression).getString()));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source External DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getExternalDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Target BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(targetBPMNExpression).getString()));
                }
                DataHandlingUtils.performAssignmentOperation(sc, ctx, workItem, dataAssignment, sourceBPMNExpression, targetBPMNExpression);
                DataHandlingUtils.addPIAforValidation(dataAssignment, piaList);
                if (!DataHandlingLogger.isDebug()) continue;
                DataHandlingLogger.debug(workItem, flowNode, (Object)("Target DataElements=" + DataHandlingMsg.dumpDataElements(targetBPMNExpression.getDataElementVariables())));
            }
            ProcessInstanceAttributeHelper.validate(piaList, sc, ctx);
            DataHandlingUtils.validateDataElementVariables(outputDataAssociationSet, targetDataObjectsMap.values(), ctx, workItem, flowNode);
            DataHandlingUtils.triggerUserDefinedLog(logSentenceContext, sc, LogHandlerTrigger.AFTER_OUTPUT_DATA_ASSOCIATION);
        }
        if ((dataTransformations = outputDataAssociationSet.getDataTransformations()) != null) {
            for (DataTransformation dataTransformation : dataTransformations) {
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataTransformation.getSourceRefs(), dataTransformation.getTransformationName(), BPMNExpressionLanguage.XPATH, null);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                if (!dataOutputVariables.isEmpty()) {
                    sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, sourceBPMNExpression.getDataElementVariables(), flowNode);
                }
                ArrayList<String> targetRefs = new ArrayList<String>();
                targetRefs.add(dataTransformation.getTargetRef());
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(targetRefs), null, BPMNExpressionLanguage.XPATH, null);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                DataHandlingUtils.performTransformation(flowNode, sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression, dataTransformation);
            }
        }
    }

    public static DataObject getDataObject(FlowNode flowNode, String dataObjectId) {
        DataObject dataObject = null;
        for (Subprocess currentSubprocess = flowNode.getSubprocess(); currentSubprocess != null && (dataObject = (DataObject)currentSubprocess.findDeclaration(DataObject.class, dataObjectId)) == null; currentSubprocess = currentSubprocess.getSubprocess()) {
        }
        if (dataObject == null) {
            dataObject = (DataObject)flowNode.getProcess().findDeclaration(DataObject.class, dataObjectId);
        }
        if (dataObject == null) {
            dataObject = (DataObject)flowNode.getProcess().getProject().findDeclaration(DataObject.class, dataObjectId);
        }
        return dataObject;
    }

    public static Sequence<DataObject> getDataObjectsInScope(@NotNull FlowNode flowNode) {
        Subprocess currentSubprocess = flowNode.getSubprocess();
        return DataHandlingUtils.getDataObjectsInScope(flowNode.getProcess(), currentSubprocess);
    }

    public static Sequence<DataObject> getDataObjectsInScope(@NotNull Process process, @Nullable Subprocess subprocess) {
        HashMap<String, DataObject> dataObjectsScope = new HashMap<String, DataObject>();
        for (Subprocess currentSubprocess = subprocess; currentSubprocess != null; currentSubprocess = currentSubprocess.getSubprocess()) {
            DataHandlingUtils.addDataObjectsInContext((DataDeclarationContainer)currentSubprocess, dataObjectsScope);
        }
        DataHandlingUtils.addDataObjectsInContext((DataDeclarationContainer)process, dataObjectsScope);
        DataHandlingUtils.addDataObjectsInContext((DataDeclarationContainer)process.getProject().getProjectModel(), dataObjectsScope);
        return CollectionUtils.asSequence(dataObjectsScope.values());
    }

    public static Sequence<CorrelationKey> getCorrelationKeysInScope(@NotNull Process process, @Nullable Subprocess subprocess) {
        HashMap<String, CorrelationKey> correlationKeysScope = new HashMap<String, CorrelationKey>();
        for (Subprocess currentSubprocess = subprocess; currentSubprocess != null; currentSubprocess = currentSubprocess.getSubprocess()) {
            DataHandlingUtils.addCorrelationKeysInContext((CorrelationKeyContainer)currentSubprocess, correlationKeysScope);
        }
        DataHandlingUtils.addCorrelationKeysInContext((CorrelationKeyContainer)process, correlationKeysScope);
        return CollectionUtils.asSequence(correlationKeysScope.values());
    }

    public static void addDataObjectsInContext(DataDeclarationContainer container, Map<String, DataObject> dataObjectsInContext) {
        Sequence dataObjects = container.getLocalDeclarations(DataObject.class);
        for (DataObject dataObject : dataObjects) {
            if (dataObjectsInContext.containsKey(dataObject.getName())) continue;
            dataObjectsInContext.put(dataObject.getName(), dataObject);
        }
    }

    public static void addCorrelationKeysInContext(CorrelationKeyContainer container, Map<String, CorrelationKey> correlationKeysInContext) {
        Sequence correlationKeys = container.getCorrelationKeys();
        for (CorrelationKey correlationKey : correlationKeys) {
            if (correlationKeysInContext.containsKey(correlationKey.getName())) continue;
            correlationKeysInContext.put(correlationKey.getName(), correlationKey);
        }
    }

    public static void handleIoSpecificationImports(DataAssociationSet dataAssociationSet, BPMNCubeMapBuilderContext context) throws CubeException {
        Sequence dataDeclarationSequence = dataAssociationSet.getArgumentsContainer().getDeclarations();
        if (dataDeclarationSequence != null) {
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                try {
                    DataHandlingUtils.handleImport(dataDeclaration, context);
                }
                catch (Exception e) {
                    throw new CubeException((Throwable)e);
                }
            }
        }
    }

    public static void handleImport(DataDeclaration dataDeclaration, BPMNCubeMapBuilderContext context) throws Exception {
        URI resourceLocation;
        DataDeclarationBpmnDecorator dataDeclarationBpmnDecorator;
        ComponentModel componentModel = context.getComponentModel();
        if (componentModel != null && !(dataDeclarationBpmnDecorator = new DataDeclarationBpmnDecorator(dataDeclaration)).isNativeStructure() && (resourceLocation = dataDeclarationBpmnDecorator.getResourceLocation()) != null) {
            String resolvedLocation = componentModel.getComposite().getMetadataManager().resolve(resourceLocation.toString());
            DataDeclarationBpmnDecorator.LocationType resourceLocationType = dataDeclarationBpmnDecorator.getResourceLocationType();
            if (resourceLocationType == DataDeclarationBpmnDecorator.LocationType.WSDL) {
                componentModel.getComposite().getWSDLManager().loadWSDL(resolvedLocation);
                DataHandlingUtils.saveWsdlSchemaImportLocation(context, resolvedLocation);
            } else if (resourceLocationType == DataDeclarationBpmnDecorator.LocationType.XSD) {
                componentModel.getComposite().getSchemaManager().addXSDLoc(resolvedLocation);
                DataHandlingUtils.saveXsdSchemaImportLocation(context, resolvedLocation);
            }
        }
    }

    public static void saveXsdSchemaImportLocation(BPMNCubeMapBuilderContext context, String importLocation) {
        context.getCubeMap().addXsdImportLocation(importLocation);
    }

    public static void saveWsdlSchemaImportLocation(BPMNCubeMapBuilderContext context, String importLocation) {
        context.getCubeMap().addWsdlImportLocation(importLocation);
    }

    public static void restoreSchemaImportLocations(BPMNCubeMap bpmnCubeMap, ComponentModel component) throws Exception {
        Sequence<String> xsdImportLocations = bpmnCubeMap.getXsdImportLocations();
        for (String xsdImportLocation : xsdImportLocations) {
            component.getComposite().getSchemaManager().addXSDLoc(xsdImportLocation);
        }
        Sequence<String> wsdlImportLocations = bpmnCubeMap.getWsdlImportLocations();
        for (String wsdlImportLocation : wsdlImportLocations) {
            component.getComposite().getWSDLManager().loadWSDL(wsdlImportLocation);
        }
    }

    public static Object evalSourceValue(BPMNExpression sourceBPMNExpression, boolean expectSingleNode, IScope sc, ICubeContext ctx, IWorkItem workItem) throws CubeException {
        return sourceBPMNExpression.evaluateSingleNode(sc, ctx);
    }

    public static Object copyObjHelper(Object sourceValue, Object toValue, ICubeContext ctx) throws CubeException {
        Object value;
        Attr oldXsiTypeAttr = null;
        if (toValue instanceof Element) {
            oldXsiTypeAttr = ((Element)toValue).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        }
        if ((value = DOMUtil.copyObjHelper((Object)sourceValue, (Object)toValue, (boolean)false, (ICubeContext)ctx)) instanceof Element) {
            Element element = (Element)value;
            element.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (oldXsiTypeAttr != null) {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", oldXsiTypeAttr.getTextContent());
            }
        }
        return value;
    }

    public static void performCopy(IScope sc, ICubeContext ctx, IWorkItem workItem, Object sourceValue, BPMNExpression targetBPMNExpression) throws CubeException {
        sourceValue = BPMNWMPHelper.attemptSafeConversionDoubleToLong(sourceValue);
        String targetDataElement = (String)targetBPMNExpression.getBpmnExpressionMetadata().getDataElements().iterator().next();
        DataElementVariable targetDataElementVariable = targetBPMNExpression.getDataElementVariables().get(targetDataElement);
        if (targetDataElementVariable != null && targetDataElementVariable.isUndefined()) {
            targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
        }
        if (targetDataElementVariable != null && targetDataElementVariable.isNativeStructure()) {
            if (sourceValue instanceof Element) {
                sourceValue = DOMUtil.getTextValue((Node)((Element)sourceValue));
            } else if (sourceValue instanceof Attr) {
                sourceValue = ((Attr)sourceValue).getNodeValue();
            }
            if (sourceValue != null) {
                Object value;
                DataHandlingLogger.debug(workItem, "performCopy", (Object)"Assigning...");
                try {
                    value = BPMNWMPHelper.adjustFromDataValue(sourceValue, (CXTypeVariable)targetDataElementVariable.getStructure(), ctx);
                }
                catch (Exception e) {
                    throw new XPathException(77003, new Object[]{sourceValue, targetDataElementVariable.getDataDeclaration().getName(), ((CXTypeDataElementVariable)targetDataElementVariable).getStructure().getType()});
                }
                Element element = (Element)targetDataElementVariable.getValue();
                if (value != null) {
                    String data = String.valueOf(value);
                    if (data.isEmpty()) {
                        DataHandlingUtils.setEmptyTextContent(element);
                    } else {
                        element.setTextContent(data);
                    }
                    if (DataHandlingLogger.isDebug()) {
                        DataHandlingLogger.debug(workItem, "performCopy", (Object)("Value= " + DataHandlingMsg.dumpDataElementValue(data)));
                    }
                }
            }
        } else {
            Object variableValue = null;
            if (targetDataElementVariable != null) {
                variableValue = targetDataElementVariable.getValue();
            }
            BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
            Object toValue = targetBPMNExpression.evaluateObject(sc, ctx);
            if (toValue instanceof Node) {
                boolean replace;
                boolean bl = replace = variableValue == toValue;
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)"Copying...");
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Source value= " + DataHandlingMsg.dumpDataElementValue(sourceValue)));
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Target value= " + DataHandlingMsg.dumpDataElementValue(toValue)));
                }
                Object value = DOMUtil.copyObjHelper((Object)sourceValue, (Object)toValue, (boolean)false, (ICubeContext)ctx);
                if (DataHandlingLogger.isDebug()) {
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Result Value= " + DataHandlingMsg.dumpDataElementValue(value)));
                }
                if (replace) {
                    targetDataElementVariable.setValue(value);
                }
            }
        }
    }

    public static Element createRootElement(String name, SchemaObject schemaObject, ICubeContext iCubeContext) throws CubeException {
        XMLElement element = null;
        SchemaManager schemaManager = DataHandlingUtils.getSchemaManager(iCubeContext);
        if (schemaObject.isElement()) {
            element = SchemaToXML.generateXMLElement((String)name, (QName)schemaObject.getQName(), null, (boolean)false, (boolean)false, null, (SchemaManager)schemaManager);
        } else if (schemaObject.isType()) {
            element = SchemaToXML.generateXMLElementForType((String)name, (int)-1, (QName)schemaObject.getQName(), (QName)schemaObject.getQName(), null, (boolean)false, null, (SchemaManager)schemaManager);
        }
        return element;
    }

    public static void trapBPELFaults(MicroInstructionContext miContext, BPELFault e) {
        boolean setSuspendInstanceOnDataAssociationError = miContext.getNode().getFlowElement().getProcess().isSuspendInstanceOnDataAssociationError();
        QName faultName = e.getFaultName();
        if (setSuspendInstanceOnDataAssociationError && (faultName.equals(BPELDefs.QN_SELECTION_FAILURE) || faultName.equals(BPELDefs.QN_20_INVALID_VARIABLES) || faultName.equals(BPELDefs.QN_UNINITIALIZED_VARIABLE) || faultName.equals(BPELDefs.QNX_SUB_LANGUAGE_EXECUTION_FAULT))) {
            TrappableException ex = new TrappableException(faultName, e);
            throw ex;
        }
        throw e;
    }

    public static void trapXPathQueryFailed(MicroInstructionContext miContext, XPathException e) throws XPathException {
        boolean suspendInstanceOnDataAssociationError = miContext.getNode().getFlowElement().getProcess().isSuspendInstanceOnDataAssociationError();
        if (e.getErrorCode() == 9500 && suspendInstanceOnDataAssociationError) {
            TrappableException ex = new TrappableException(BPELDefs.QN_UNINITIALIZED_VARIABLE, e);
            throw ex;
        }
        throw e;
    }

    public static void triggerUserDefinedLog(LogSentenceContext logSentenceContext, IScope sc, LogHandlerTrigger logHandlerTrigger) {
        if (logSentenceContext.getFlowNode().isLoggable()) {
            UserDefinedLogging userDefinedLogging = BPMNServiceEngine.getInstance().getUserDefinedLogging();
            userDefinedLogging.log(logSentenceContext, logHandlerTrigger, sc);
        }
    }

    public static String getValueFromData(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        String result = value instanceof XMLElement ? ((XMLElement)value).getDocument().getDocumentElement().getTextContent() : (value instanceof Element ? ((Element)value).getTextContent() : String.valueOf(value));
        return result;
    }

    private static QName getVariableType(Object variable) {
        QName result = null;
        if (variable instanceof CXTypeVariable) {
            result = ((CXTypeVariable)variable).getType();
        } else if (variable instanceof CXElementVariable) {
            result = ((CXElementVariable)variable).getElement();
        } else if (variable instanceof Document) {
            Element documentElement = ((Document)variable).getDocumentElement();
            result = new QName(documentElement.getNamespaceURI(), documentElement.getLocalName());
        }
        return result;
    }

    private static void setEmptyTextContent(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Node childNode = nodeList.item(i);
                if (!(childNode instanceof Text)) continue;
                node.removeChild(childNode);
            }
        }
    }

    private static void addPIAforValidation(DataAssignment dataAssociation, List<String> piaList) {
        if (dataAssociation.getTarget().getRefs().iterator().hasNext()) {
            String attrName = ((String)dataAssociation.getTarget().getRefs().iterator().next()).toUpperCase();
            piaList.add(attrName);
        }
    }

    private static void performAssignmentOperation(IScope sc, ICubeContext ctx, IWorkItem workItem, DataAssignment dataAssignment, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        DataAssignmentOperation operation = dataAssignment.getOperation();
        switch (operation) {
            case COPY_LIST: {
                DataHandlingUtils.performCopyList(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                break;
            }
            case APPEND: {
                DataHandlingUtils.performAppend(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                break;
            }
            case INSERT_AFTER: {
                DataHandlingUtils.performInsertAfter(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                break;
            }
            case INSERT_BEFORE: {
                DataHandlingUtils.performInsertBefore(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                break;
            }
            default: {
                DataHandlingUtils.performCopy(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
            }
        }
    }

    private static void validateDataElementVariables(DataAssociationSet dataAssociationSet, Collection<DataElementVariable> dataElementVariables, ICubeContext iCubeContext, IWorkItem iWorkItem, FlowNode flownode) {
        DataHandlingLogger.debug(iWorkItem, flownode, (Object)"validating data element variables...");
        boolean valid = true;
        if (dataAssociationSet.isValidating()) {
            for (DataElementVariable dataElementVariable : dataElementVariables) {
                DataHandlingLogger.debug(iWorkItem, flownode, (Object)("validating data element variable: " + dataElementVariable.getDataDeclaration().getName()));
                Object value = dataElementVariable.getValue();
                if (value instanceof XMLElement) {
                    DataHandlingLogger.debug(iWorkItem, flownode, (Object)"data element variable value:");
                    DataHandlingLogger.debug(iWorkItem, flownode, (Object)DOMUtil.toXML((Node)((XMLElement)value)));
                } else {
                    DataHandlingLogger.debug(iWorkItem, flownode, (Object)("data element variable value: " + value));
                }
                try {
                    BPMNXPathUtil.validateXMLElement(value, iCubeContext);
                }
                catch (XMLParseException e) {
                    DataHandlingLogger.debug(iWorkItem, flownode, (Object)("validation failed for variable '" + dataElementVariable.getDataDeclaration().getName() + "'. Error: " + e.getMessage()));
                    valid = false;
                }
                catch (XSDException e) {
                    DataHandlingLogger.debug(iWorkItem, flownode, (Object)"failed to execute validation", (Throwable)e);
                }
            }
        }
        if (!valid) {
            DataHandlingLogger.debug(iWorkItem, flownode, (Object)"found an invalid data element, raise invalid variables error.");
            throw new BPELFault(BPELDefs.QN_20_INVALID_VARIABLES);
        }
    }

    private static Map<String, DataElementVariable> buildTargetDataObjectsMap(Sequence<DataAssignment> dataAssociations, FlowNode flowNode, IScope scope) throws CubeException {
        HashMap<String, DataElementVariable> variableMap = new HashMap<String, DataElementVariable>();
        for (DataAssignment dataAssignment : dataAssociations) {
            BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, scope, variableMap, (Sequence<String>)dataAssignment.getTarget().getRefs());
        }
        return variableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performTransformation(FlowNode flowNode, IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression, DataTransformation dataTransformation) throws CubeException {
        Object paramValue;
        Map.Entry<String, DataElementVariable> pairs;
        Map<String, DataElementVariable> dataElementVariableMap = sourceBPMNExpression.getDataElementVariables();
        Iterator<Map.Entry<String, DataElementVariable>> it = dataElementVariableMap.entrySet().iterator();
        Object var = null;
        Map<String, DataElementVariable> dataElementExtVariableMap = sourceBPMNExpression.getExternalDataElementVariables();
        Iterator<Map.Entry<String, DataElementVariable>> itExt = dataElementExtVariableMap.entrySet().iterator();
        HashMap<String, Object> paramMap = null;
        Iterator sourceNamesIt = dataTransformation.getSourceRefs().iterator();
        String primarySource = "";
        if (sourceNamesIt.hasNext()) {
            primarySource = (String)sourceNamesIt.next();
        }
        if (primarySource == null || primarySource.equals("")) {
            throw new CubeException((Throwable)new IllegalArgumentException("Transformation source not specified"));
        }
        Node sourceNode = null;
        String varName = "";
        while (it.hasNext()) {
            pairs = it.next();
            varName = pairs.getKey();
            paramValue = pairs.getValue().getValue();
            if (paramMap == null) {
                paramMap = new HashMap<String, Object>();
            }
            if (!varName.equals(primarySource)) {
                BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation parameter: " + varName);
                paramMap.put(varName, paramValue);
                continue;
            }
            BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation source: " + varName);
            sourceNode = (Node)paramValue;
        }
        while (itExt.hasNext()) {
            pairs = itExt.next();
            varName = pairs.getKey();
            paramValue = pairs.getValue().getValue();
            if (paramMap == null) {
                paramMap = new HashMap();
            }
            if (!varName.equals(primarySource)) {
                BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation parameter: " + varName);
                paramMap.put(varName, paramValue);
                continue;
            }
            BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation source: " + varName);
            sourceNode = (Node)paramValue;
        }
        String targetDataElement = (String)targetBPMNExpression.getBpmnExpressionMetadata().getDataElements().iterator().next();
        targetBPMNExpression.getBpmnExpressionMetadata().setExpression(targetDataElement);
        DataElementVariable targetDataElementVariable = targetBPMNExpression.getDataElementVariables().get(targetDataElement);
        if (targetDataElementVariable.isUndefined()) {
            targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
        }
        Node resultNode = (Node)targetDataElementVariable.getValue();
        try {
            Transformer transformer = dataTransformation.getTransformer();
            DocumentBuilder db = dataTransformation.getDocumentBuilder();
            if (transformer == null) {
                transformer = DataHandlingUtils.getTransformer(ctx, dataTransformation);
                dataTransformation.setTransformer(transformer);
            }
            if (db == null) {
                db = XSLMapper.getDocumentBuilder();
                dataTransformation.setDocumentBuilder(db);
            }
            ICubeProcess cubeProcess = CubeContextHelper.getCubeInstance((ICubeContext)ctx).getProcessClass();
            XPathContext.setXPathContext((AssemblyModelObject)cubeProcess.getScaComponent());
            Node transformedNode = null;
            Transformer transformer2 = transformer;
            synchronized (transformer2) {
                XPathContext.setXPathContext((AssemblyModelObject)CubeContextHelper.getCubeInstance((ICubeContext)ctx).getProcessClass().getScaComponent());
                try {
                    transformedNode = XSLMapper.transform(sourceNode, paramMap, transformer, db);
                }
                finally {
                    XPathContext.unsetXPathContext();
                }
            }
            Document targetDocument = resultNode.getOwnerDocument();
            transformedNode = targetDocument.importNode(((Document)transformedNode).getDocumentElement(), true);
            if (resultNode.getOwnerDocument().getDocumentElement() == resultNode) {
                targetDocument.replaceChild(transformedNode, resultNode);
            }
            targetDataElementVariable.setValue(transformedNode);
        }
        catch (Exception ex) {
            if (ex instanceof CubeException) {
                throw (CubeException)((Object)ex);
            }
            Object[] args = new String[]{"xsl/" + dataTransformation.getTransformationName() + ".xsl", primarySource};
            throw new CubeException(75003, args, (Throwable)ex);
        }
    }

    private static Transformer getTransformer(ICubeContext ctx, DataTransformation dataTransformation) throws Exception {
        String filename = "xsl/" + dataTransformation.getTransformationName() + ".xsl";
        InputStream in = null;
        ComponentModel componentModel = CubeContextHelper.getScaComponent((ICubeContext)ctx);
        in = componentModel.getComposite().getMetadataManager().getDocumentAsInputStream(filename);
        return XSLMapper.getTransformer(in);
    }

    private static Map<String, DataElementVariable> createDataElementVariables(DataAssociationSet dataAssociationSet, Map<String, Object> initialValues, ICubeContext cubeContext) {
        HashMap<String, DataElementVariable> dataElementVariables = new HashMap<String, DataElementVariable>();
        Sequence dataDeclarationSequence = dataAssociationSet.getArgumentsContainer().getDeclarations();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            DataElementVariable dataElementVariable = DataElementVariable.create(dataDeclaration);
            Object value = initialValues.get(dataDeclaration.getName());
            if (value != null) {
                dataElementVariable.setValue(value);
            }
            dataElementVariables.put(dataDeclaration.getName(), dataElementVariable);
        }
        return dataElementVariables;
    }

    private static void performCopy(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        Object sourceValue = sourceBPMNExpression.evaluateObject(sc, ctx);
        DataHandlingUtils.performCopy(sc, ctx, workItem, sourceValue, targetBPMNExpression);
    }

    private static void performAppend(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        NodeList sourceValue = sourceBPMNExpression.evaluateNodeList(sc, ctx);
        DataElementVariable targetDataElementVariable = DataHandlingUtils.getFirstDataElementVariable(targetBPMNExpression);
        if (targetDataElementVariable != null) {
            if (targetDataElementVariable.isUndefined()) {
                targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if (!targetDataElementVariable.isNativeStructure()) {
                Object variableValue = targetDataElementVariable.getValue();
                BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
                Node toValue = targetBPMNExpression.evaluateSingleNode(sc, ctx);
                BPMNXPathUtil.append(sourceValue, toValue, workItem, sc, ctx);
            }
        }
    }

    private static void performInsertBefore(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        NodeList sourceValue = sourceBPMNExpression.evaluateNodeList(sc, ctx);
        DataElementVariable targetDataElementVariable = DataHandlingUtils.getFirstDataElementVariable(targetBPMNExpression);
        if (targetDataElementVariable != null) {
            if (targetDataElementVariable.isUndefined()) {
                targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if (!targetDataElementVariable.isNativeStructure()) {
                Object variableValue = targetDataElementVariable.getValue();
                BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
                NodeList toValue = targetBPMNExpression.evaluateNodeList(sc, ctx);
                BPMNXPathUtil.insertBefore(sourceValue, toValue, workItem, sc, ctx);
            }
        }
    }

    private static void performInsertAfter(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        NodeList sourceValue = sourceBPMNExpression.evaluateNodeList(sc, ctx);
        DataElementVariable targetDataElementVariable = DataHandlingUtils.getFirstDataElementVariable(targetBPMNExpression);
        if (targetDataElementVariable != null) {
            if (targetDataElementVariable.isUndefined()) {
                targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if (!targetDataElementVariable.isNativeStructure()) {
                Object variableValue = targetDataElementVariable.getValue();
                BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
                NodeList toValue = targetBPMNExpression.evaluateNodeList(sc, ctx);
                BPMNXPathUtil.insertAfter(sourceValue, toValue, workItem, sc, ctx);
            }
        }
    }

    private static void performCopyList(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        NodeList sourceValue = sourceBPMNExpression.evaluateNodeList(sc, ctx);
        DataElementVariable targetDataElementVariable = DataHandlingUtils.getFirstDataElementVariable(targetBPMNExpression);
        if (targetDataElementVariable != null) {
            if (targetDataElementVariable.isUndefined()) {
                targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if (!targetDataElementVariable.isNativeStructure()) {
                Object variableValue = targetDataElementVariable.getValue();
                BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
                NodeList toValue = targetBPMNExpression.evaluateNodeList(sc, ctx);
                BPMNXPathUtil.copyList(sourceValue, toValue, workItem, sc, ctx);
            }
        }
    }

    private static DataElementVariable getFirstDataElementVariable(BPMNExpression bpmnExpression) {
        String dataElement;
        DataElementVariable dataElementVariable = null;
        Iterator dataElementsIterator = bpmnExpression.getBpmnExpressionMetadata().getDataElements().iterator();
        if (dataElementsIterator.hasNext() && (dataElement = (String)dataElementsIterator.next()) != null) {
            dataElementVariable = bpmnExpression.getDataElementVariables().get(dataElement);
        }
        return dataElementVariable;
    }

    public static class ExpressionEvaluatorHelper {
        public static String getStringValueFromExpression(Expression expression, FlowNode flowNode, IScope scope, ICubeContext ctx) throws Exception {
            if (expression == null || expression.getExpressionValue().equals("")) {
                return null;
            }
            BPMNExpression bpmnExpression = ExpressionEvaluatorHelper.getBPMNExpression(expression, scope, flowNode);
            return bpmnExpression.evaluateString(scope, ctx);
        }

        public static String getStringValueFromExpression(Expression expression, FlowNode flowNode, String defaultValue, IScope scope, ICubeContext ctx) throws Exception {
            String result = ExpressionEvaluatorHelper.getStringValueFromExpression(expression, flowNode, scope, ctx);
            if (result == null) {
                result = defaultValue;
            }
            return result;
        }

        public static Object getObjectValueFromExpression(Expression expression, FlowNode flowNode, IScope scope, ICubeContext ctx) throws Exception {
            if (expression == null || expression.getExpressionValue().equals("")) {
                return null;
            }
            BPMNExpression bpmnExpression = ExpressionEvaluatorHelper.getBPMNExpression(expression, scope, flowNode);
            return bpmnExpression.evaluateObject(scope, ctx);
        }

        public static Number getNumberValueFromExpression(Expression expression, FlowNode flowNode, IScope scope, ICubeContext ctx) throws Exception {
            if (expression == null || expression.getExpressionValue().equals("")) {
                return null;
            }
            BPMNExpression bpmnExpression = ExpressionEvaluatorHelper.getBPMNExpression(expression, scope, flowNode);
            return bpmnExpression.evaluateNumber(scope, ctx);
        }

        public static Number getNumberValueFromExpression(Expression expression, FlowNode flowNode, Number defaultValue, IScope sc, ICubeContext ctx) throws Exception {
            Number result = ExpressionEvaluatorHelper.getNumberValueFromExpression(expression, flowNode, sc, ctx);
            if (result == null) {
                result = defaultValue;
            }
            return result;
        }

        public static Boolean getBooleanValueFromExpression(Expression expression, FlowNode flowNode, IScope scope, ICubeContext ctx) throws Exception {
            if (expression == null || expression.getExpressionValue().equals("")) {
                return null;
            }
            BPMNExpression bpmnExpression = ExpressionEvaluatorHelper.getBPMNExpression(expression, scope, flowNode);
            return bpmnExpression.evaluateBoolean(scope, ctx);
        }

        private static BPMNExpression getBPMNExpression(Expression expression, IScope scope, FlowNode flowNode) throws Exception {
            String strExpression = expression.getExpressionValue();
            BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, strExpression, BPMNExpressionLanguage.XPATH, expression.getNamespaces());
            BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, forBPMNExpressionMetadata, scope);
            return forBPMNExpression;
        }
    }

    public static class DataHandlingLogger
    extends BPELExecutionLogger {
        public static void debug(IWorkItem workItem, FlowNode flowNode, Object message) {
            DataHandlingLogger.debug(workItem, flowNode, message, null);
        }

        public static void debug(IWorkItem workItem, FlowNode flowNode, Object message, Throwable throwable) {
            DataHandlingLogger.debug(workItem, flowNode, null, message, throwable);
        }

        public static void debug(IWorkItem workItem, String method, Object message) {
            DataHandlingLogger.debug(workItem, null, method, message, null);
        }

        public static void debug(IWorkItem workItem, String method, Object message, Throwable throwable) {
            DataHandlingLogger.debug(workItem, null, method, message, throwable);
        }

        public static boolean isDebug() {
            return LOG.isDebugPriority();
        }

        private static void debug(IWorkItem workItem, FlowNode flowNode, String method, Object message, Throwable throwable) {
            BPELExecutionLogger.LOG.debug(DataHandlingMsg.INFO_BPMNSUBJECT(workItem).getString(), flowNode != null ? DataHandlingMsg.INFO_BPMNMETHOD(flowNode).getString() : method, new Object[]{message, throwable});
        }
    }

    public static class BPMNWMPHelper
    extends BPELWMPHelper {
        private static final int INDEX_YEAR_START = 0;
        private static final int INDEX_MONTH_START = 5;
        private static final int INDEX_DAY_START = 8;
        private static final int INDEX_YEAR_END = 3;
        private static final int INDEX_MONTH_END = 6;
        private static final int INDEX_DAY_END = 9;
        private static final String ALLOW_BLANK_AS_ZERO = "oracle.bpm.bpmn.allow-blank-as-zero";

        public static Object adjustFromValue(Object fromValue, CXTypeVariable toTypeVar, ICubeContext ctx) throws ParseException {
            Object value = fromValue;
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            if (typeMgr.isSchemaType(toTypeVar.getType())) {
                if (typeMgr.isByte(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx).byteValue();
                } else if (typeMgr.isShort(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx).shortValue();
                } else if (BPMNWMPHelper.isJavaIntegerType(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx).intValue();
                } else if (BPMNWMPHelper.isJavaLongType(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx).longValue();
                } else if (typeMgr.isFloat(toTypeVar.getType().getLocalPart())) {
                    value = Float.valueOf(BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx).floatValue());
                } else if (typeMgr.isBoolean(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToBoolean(fromValue);
                } else if (typeMgr.isDouble(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToDouble(fromValue, ctx);
                } else if (typeMgr.isDecimal(toTypeVar.getType().getLocalPart())) {
                    value = BPMNWMPHelper.convertFromValueToBigDecimal(fromValue);
                } else if (typeMgr.isString(toTypeVar.getType().getLocalPart())) {
                    value = value instanceof XMLElement ? ((XMLElement)value).getTextContent() : String.valueOf(fromValue);
                } else if (BPMNWMPHelper.isDateType(toTypeVar)) {
                    value = BPMNWMPHelper.convertFromValueToDate(fromValue);
                }
            }
            return value;
        }

        public static Object convertFromValueToLong(Object fromValue) {
            if (fromValue instanceof Double && (Double)fromValue == (double)((Double)fromValue).longValue()) {
                return ((Double)fromValue).longValue();
            }
            return fromValue;
        }

        public static void patchSchemaComponentsForCubeDOMNavigator(Object value, Map directives, ICubeContext iCubeContext) {
            XMLElement xmlElement;
            Attr xsiTypeAttr;
            if (value instanceof XMLElement && (xsiTypeAttr = (xmlElement = (XMLElement)value).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                SchemaManager schemaManager = DataHandlingUtils.getSchemaManager(iCubeContext);
                QName typeQName = BPMNWMPHelper.getXsiType(xmlElement);
                if (typeQName != null) {
                    try {
                        Map schemaComponents;
                        XSDNode xsdNode = schemaManager.lookupXSDTypeDefinition(typeQName);
                        if (xsdNode != null && (schemaComponents = (Map)directives.get("variable-schema-components")) != null) {
                            schemaComponents.put(new QName(xmlElement.getNamespaceURI(), xmlElement.getLocalName()), xsdNode);
                        }
                    }
                    catch (XSDException e) {
                        CubeEngineLogger.LOG.debug((Object)e);
                    }
                }
            }
        }

        static Object adjustFromDataValue(Object fromValue, CXTypeVariable toTypeVar, ICubeContext ctx) throws ParseException {
            return BPMNWMPHelper.adjustFromValue(fromValue, toTypeVar, ctx);
        }

        static QName getXsiType(XMLElement xmlElement) {
            QName typeQName = null;
            Attr attr = xmlElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (attr != null) {
                String xsiTypeValue = attr.getValue();
                int index = xsiTypeValue.indexOf(58);
                String prefix = index > 0 ? xsiTypeValue.substring(0, index) : "";
                String namespace = xmlElement.resolveNamespacePrefix(prefix);
                String type = xsiTypeValue.substring(index + 1);
                typeQName = new QName(namespace, type, prefix);
            }
            return typeQName;
        }

        static Object attemptSafeConversionDoubleToLong(Object fromValue) {
            return BPMNWMPHelper.convertFromValueToLong(fromValue);
        }

        private static void patchSchemaComponentsForCubeDOMNavigator(Object value, BPMNExpression bpmnExpression, ICubeContext iCubeContext) {
            BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(value, bpmnExpression.getDirectives(), iCubeContext);
        }

        private static Object convertFromValueToDate(Object fromValue) throws ParseException {
            String s = (String)fromValue;
            if (BPMNWMPHelper.checkValidity(s) == 0) {
                if (fromValue instanceof String) {
                    s = (String)fromValue;
                } else if (fromValue instanceof XMLElement) {
                    s = ((XMLElement)fromValue).getTextContent();
                }
                return s;
            }
            throw new ParseException(s, 0);
        }

        private static int checkValidity(String isoDateTimeValue) throws oracle.fabric.common.xml.xpath.XPathException {
            try {
                int iDate;
                String strISO8601DateTimePattern = "[0-9]{4}(-(([0-0]{1}[1-9]{1})|([1-1]{1}[0-2]{1})){1}(-(([0-0]{1}[1-9]{1}|([1-2]{1}[0-9]{1})|([3-3]{1}[0-1]{1}))){1}((T){1}((([0-1]{1}[0-9]{1})|([2-2]{1}[0-3]{1})){1}:[0-5]{1}[0-9]{1}){1}(:[0-5]{1}[0-9]{1}(\\.[0-9]+)?)?(((\\+|-){1}((([0-1]{1}[0-9]{1})|([2-2]{1}[0-3]{1})){1}:[0-5]{1}[0-9]{1}){1})|(Z))?)?)?)?";
                if (!Pattern.matches(strISO8601DateTimePattern, isoDateTimeValue)) {
                    return 1;
                }
                if (isoDateTimeValue.substring(0, 4).compareToIgnoreCase("0000") == 0) {
                    return 2;
                }
                if (isoDateTimeValue.length() >= 10 && (iDate = Integer.parseInt(isoDateTimeValue.substring(8, 10))) > 28) {
                    int iMonth = Integer.parseInt(isoDateTimeValue.substring(5, 7));
                    switch (iMonth) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 12: {
                            if (iDate <= 31) {
                                return 0;
                            }
                            return 3;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            if (iDate <= 30) {
                                return 0;
                            }
                            return 4;
                        }
                        case 2: {
                            if (iDate > 29) {
                                return 5;
                            }
                            int iYear = Integer.parseInt(isoDateTimeValue.substring(0, 4));
                            if (iYear % 4 == 0 && (iYear % 100 != 0 || iYear % 400 == 0)) break;
                            return iDate < 29 ? 0 : 6;
                        }
                    }
                }
                return 0;
            }
            catch (Exception e) {
                throw new oracle.fabric.common.xml.xpath.XPathException(e);
            }
        }

        private static boolean isDateType(CXTypeVariable typeVariable) {
            return typeVariable.getType().getLocalPart().equals("dateTime");
        }

        private static Object convertFromValueToBigDecimal(Object fromValue) {
            if (fromValue instanceof Double) {
                return new BigDecimal(((Double)fromValue).toString());
            }
            if (fromValue instanceof String) {
                return new BigDecimal((String)fromValue);
            }
            if (fromValue instanceof XMLElement) {
                return new BigDecimal(((XMLElement)fromValue).getTextContent());
            }
            return new BigDecimal(String.valueOf(fromValue));
        }

        private static Object convertFromValueToBoolean(Object fromValue) throws ParseException {
            String aTrue = "true";
            String aFalse = "false";
            if (String.valueOf(fromValue).equals(aTrue) || String.valueOf(fromValue).equals(aFalse)) {
                if (fromValue instanceof Boolean) {
                    return fromValue;
                }
                if (fromValue instanceof String) {
                    return Boolean.parseBoolean((String)fromValue);
                }
                if (fromValue instanceof XMLElement) {
                    return Boolean.parseBoolean(((XMLElement)fromValue).getTextContent());
                }
                return Boolean.parseBoolean(String.valueOf(fromValue));
            }
            throw new ParseException(String.valueOf(fromValue), 0);
        }

        private static Double convertFromValueToDouble(Object fromValue, ICubeContext ctx) {
            ComponentModel componentModel = CubeContextHelper.getScaComponent((ICubeContext)ctx);
            PropertyModel allowBlankAsZeroProperty = componentModel.getComposite().getProperty(ALLOW_BLANK_AS_ZERO);
            boolean allowBlankAsZero = BPMNServiceEngine.booleanValue(allowBlankAsZeroProperty);
            Double result = fromValue instanceof Double ? (Double)fromValue : (fromValue instanceof String ? ("".equals(fromValue) && allowBlankAsZero ? new Double(0.0) : Double.valueOf(Double.parseDouble((String)fromValue))) : (fromValue instanceof XMLElement ? Double.valueOf(Double.parseDouble(((XMLElement)fromValue).getTextContent())) : Double.valueOf(Double.parseDouble(String.valueOf(fromValue)))));
            return result;
        }

        private static boolean isJavaIntegerType(String typeLocalPart) {
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            return typeMgr.isInt(typeLocalPart) || typeMgr.isUnsignedShort(typeLocalPart) || typeMgr.isUnsignedByte(typeLocalPart);
        }

        private static boolean isJavaLongType(String typeLocalPart) {
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            return typeMgr.isLong(typeLocalPart) || typeMgr.isInteger(typeLocalPart) || typeMgr.isUnsignedInt(typeLocalPart) || typeMgr.isNonPositiveInteger(typeLocalPart) || typeMgr.isNegativeInteger(typeLocalPart) || typeMgr.isNonNegativeInteger(typeLocalPart) || typeMgr.isPositiveInteger(typeLocalPart);
        }
    }
}

