/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;

public class CubeModelUtils {
    public static boolean isReceiveActivity(BPMNCubeElement bpmnCubeElement) {
        Object element = bpmnCubeElement.getFlowElement();
        BpmnType bpmnType = element.getBpmnType();
        return bpmnType == BpmnType.RECEIVE_TASK || CubeModelUtils.isCatchIntermediateEventWithSubscription(bpmnType, element) || bpmnType == BpmnType.USER_TASK || CubeModelUtils.isBoundaryEventWithSubscription(bpmnType, element);
    }

    private static boolean isBoundaryEventWithSubscription(BpmnType bpmnType, FlowNode element) {
        boolean result = false;
        if (bpmnType == BpmnType.BOUNDARY_EVENT) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)element.asAnyNode(BoundaryEvent.class);
            EventTriggerType type = boundaryEvent.getEventTriggerType();
            result = CubeModelUtils.hasSubscription(type);
        }
        return result;
    }

    private static boolean isCatchIntermediateEventWithSubscription(BpmnType bpmnType, FlowNode element) {
        boolean result = false;
        if (bpmnType == BpmnType.CATCH_INTERMEDIATE_EVENT) {
            CatchEvent catchEvent = (CatchEvent)element.asAnyNode(CatchEvent.class);
            EventTriggerType type = catchEvent.getEventTriggerType();
            result = CubeModelUtils.hasSubscription(type);
        }
        return result;
    }

    private static boolean hasSubscription(EventTriggerType type) {
        return type == EventTriggerType.MESSAGE || type == EventTriggerType.SIGNAL;
    }
}

