/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.deployment.DeploymentException;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.model.metadataextension.ReceiveMessageElement;
import oracle.bpm.bpmn.engine.model.metadataextension.SendMessageElement;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.interfaces.ConversationHelper;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.ReferenceModel;
import oracle.fabric.composite.model.ServiceModel;
import oracle.fabric.composite.model.WsdlInterfaceModel;
import oracle.j2ee.ws.wsdl.FaultImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationUtils {
    public static MDOperationRef createMDOperationRef(@NotNull BPMNCubeMapBuilderContext context, @NotNull Conversational element, DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet) throws DeploymentException {
        OperationReferenceImpl operationReference = new OperationReferenceImpl(element, context.getCubeMap().getProcessModel());
        QName portType = operationReference.getPortType();
        assert (portType != null);
        String operationName = operationReference.getName();
        WSDLManager manager = context.getWSDLManager();
        QName inputType = null;
        QName outputType = null;
        boolean isTwoWay = false;
        QName faultCodeError = null;
        QName faultMessageType = null;
        if (manager != null) {
            inputType = ConversationUtils.getInputType(context.getWSDLManager(), portType, operationName);
            outputType = ConversationUtils.getOutputType(context.getWSDLManager(), portType, operationName);
            isTwoWay = ConversationUtils.isTwoWay(context.getWSDLManager(), portType, operationName);
            ErrorObject error = null;
            if (element.getConversation().getConversationType() == ConversationType.DEFINE_INTERFACE) {
                error = ((DefineInterfaceConversationalDefinition)element.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class)).getError();
            } else if (element.getConversation().getConversationType() == ConversationType.USE_INTERFACE) {
                error = ((UseInterfaceConversationalDefinition)element.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class)).getError();
            }
            if (error != null) {
                faultCodeError = ConversationUtils.getFaultCodeError(context.getWSDLManager(), portType, operationName, error);
                faultMessageType = ConversationUtils.getFaultMessageType(context.getWSDLManager(), portType, operationName, error);
            }
        }
        return new MDOperationRef((OperationReference)operationReference, isTwoWay, inputType, outputType, faultCodeError, faultMessageType, inputDataAssociationSet, outputDataAssociationSet);
    }

    public static boolean isTwoWay(@NotNull WSDLManager wsdlManager, @NotNull QName portTypeQName, @NotNull String operationName) throws DeploymentException {
        return ConversationUtils.getOutputType(wsdlManager, portTypeQName, operationName) != null;
    }

    public static QName getInputType(@NotNull WSDLManager wsdlManager, @NotNull QName portTypeQName, @NotNull String operationName) throws DeploymentException {
        Input input = ConversationUtils.getOperation(wsdlManager, portTypeQName, operationName).getInput();
        if (input == null) {
            throw new DeploymentException(78008, new Object[]{operationName, portTypeQName});
        }
        return input.getMessage().getQName();
    }

    @Nullable
    public static QName getOutputType(WSDLManager wsdlManager, QName portTypeQName, String operationName) throws DeploymentException {
        Output output = ConversationUtils.getOperation(wsdlManager, portTypeQName, operationName).getOutput();
        if (output != null) {
            return output.getMessage().getQName();
        }
        return null;
    }

    public static QName getFaultMessageType(@NotNull WSDLManager wsdlManager, @NotNull QName portTypeQName, @NotNull String operationName, ErrorObject error) throws DeploymentException {
        Map map = ConversationUtils.getOperation(wsdlManager, portTypeQName, operationName).getFaults();
        if (map == null || map.isEmpty()) {
            return null;
        }
        return ((FaultImpl)map.get(error.getName())).getMessage().getQName();
    }

    public static QName getFaultCodeError(@NotNull WSDLManager wsdlManager, @NotNull QName portTypeQName, @NotNull String operationName, ErrorObject error) throws DeploymentException {
        return new QName(portTypeQName.getNamespaceURI(), error.getName());
    }

    public static String getReferenceName(@NotNull ServiceTask element, @NotNull BPMNCubeMapBuilderContext context) {
        return ConversationHelper.getReferenceNameFrom((Conversation)element.getConversation(), (Process)context.getCubeMap().getProcessModel());
    }

    public static String getServiceName(@NotNull SendMessageElement element, @NotNull BPMNCubeMapBuilderContext context) {
        if (element.getConversation().getConversationType().isInbound()) {
            return ConversationHelper.getServiceNameFrom((Conversation)element.getConversation(), (Process)context.getCubeMap().getProcessModel());
        }
        return ConversationHelper.getReferenceNameFrom((Conversation)element.getConversation(), (Process)context.getCubeMap().getProcessModel());
    }

    public static String getServiceName(@NotNull ReceiveMessageElement element, @NotNull BPMNCubeMapBuilderContext context) {
        if (element.getConversation().getConversationType().isInbound()) {
            return ConversationHelper.getServiceNameFrom((Conversation)element.getConversation(), (Process)context.getCubeMap().getProcessModel());
        }
        return ConversationHelper.getReferenceNameFrom((Conversation)element.getConversation(), (Process)context.getCubeMap().getProcessModel());
    }

    @Nullable
    public static ServiceLink getServiceLinkDeclaration(ComponentModel model, @NotNull String serviceLinkName, boolean serviceComesFromConversation) throws DeploymentException {
        ServiceLink serviceLink = null;
        if (model != null && model.getComponentType() != null && model.getComponentType().getNode() != null) {
            ServiceModel service = model.getComponentType().getService(serviceLinkName);
            if (service != null) {
                WsdlInterfaceModel interfaceModel = (WsdlInterfaceModel)service.getInterfaceType();
                serviceLink = ServiceLink.createService(serviceLinkName, interfaceModel.getInterfaceQName(), interfaceModel.getCallbackInterfaceQName());
            } else {
                ReferenceModel reference = model.getComponentType().getReference(serviceLinkName);
                if (reference != null) {
                    WsdlInterfaceModel interfaceModel = (WsdlInterfaceModel)reference.getInterfaceType();
                    serviceLink = ServiceLink.createReference(serviceLinkName, interfaceModel.getInterfaceQName(), interfaceModel.getCallbackInterfaceQName());
                }
            }
            if (serviceLink == null && !serviceComesFromConversation) {
                throw new DeploymentException(78005, new Object[]{serviceLinkName, model.getName()});
            }
        }
        return serviceLink;
    }

    public static void declareServiceLinks(IScope sc, Set<ServiceLink> extraServiceLinks) throws CubeException {
        ConversationUtils.declareServiceLinks(sc, extraServiceLinks, false);
    }

    public static void declareServiceLinks(IScope sc, Set<ServiceLink> extraServiceLinks, boolean skipIfDeclared) throws CubeException {
        for (ServiceLink serviceLink : extraServiceLinks) {
            if (skipIfDeclared && DataHandlingUtils.isDeclared(serviceLink.getName(), sc)) continue;
            ConversationUtils.declareServiceLink(sc, serviceLink);
        }
    }

    public static Set<ServiceLink> getServiceLinksFromConversations(BPMNCubeMapBuilderContext context, NodeContainer nodeContainer) throws CubeException {
        HashSet<ServiceLink> result = new HashSet<ServiceLink>();
        for (Conversation conversation : ConversationUtils.getConversations(nodeContainer)) {
            String serviceLinkName = ConversationUtils.getServiceLinkName(context.getCubeMap().getProcessModel(), conversation);
            ServiceLink serviceLink = ConversationUtils.getServiceLinkDeclaration(context.getComponentModel(), serviceLinkName, true);
            if (serviceLink == null) continue;
            result.add(serviceLink);
        }
        return result;
    }

    private static Operation getOperation(@NotNull WSDLManager wsdlManager, @NotNull QName portTypeQName, @NotNull String operationName) throws DeploymentException {
        PortType portType = wsdlManager.lookupPortType(portTypeQName);
        if (portType == null) {
            throw new DeploymentException(78006, new Object[]{portTypeQName});
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            throw new DeploymentException(78007, new Object[]{operationName, portTypeQName});
        }
        return operation;
    }

    private static String getServiceLinkName(Process process, Conversation conversation) {
        String serviceLinkName = conversation.getConversationType().isInbound() ? ConversationHelper.getServiceNameFrom((Conversation)conversation, (Process)process) : ConversationHelper.getReferenceNameFrom((Conversation)conversation, (Process)process);
        return serviceLinkName;
    }

    private static Sequence<Conversation> getConversations(NodeContainer nodeContainer) {
        return nodeContainer.getLocalConversations();
    }

    private static void declareServiceLink(IScope sc, ServiceLink serviceLink) throws CubeException {
        CXPartnerLink cxPartnerLink = new CXPartnerLink();
        cxPartnerLink.setName(serviceLink.getName());
        if (serviceLink.isReference()) {
            cxPartnerLink.getMyRole().setPortType(serviceLink.getCallbackInterfacePortType());
            cxPartnerLink.getPartnerRole().setPortType(serviceLink.getInterfacePortType());
            cxPartnerLink.setPartnerLinkType(cxPartnerLink.getPartnerRole().getPortType());
        } else {
            cxPartnerLink.getMyRole().setPortType(serviceLink.getInterfacePortType());
            cxPartnerLink.getPartnerRole().setPortType(serviceLink.getCallbackInterfacePortType());
        }
        sc.declareAndSet(cxPartnerLink.getName(), (Object)cxPartnerLink);
    }
}

