/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.map.builder.util.BPMNCubeMapDotExporter;

public class BPMRuntimeLogger {
    private static boolean debugBoolean = Boolean.getBoolean("debug.bpmn");
    private static final String ORACLE_BPM_RUNTIME_TESTS_ENABLED = "oracle.bpm.runtime.tests.enabled";
    private static boolean runtimeTestEnabled = Boolean.getBoolean("oracle.bpm.runtime.tests.enabled");
    protected static SimpleDateFormat dateFormat;
    protected static Writer outputWriter;
    protected static File logPathFile;
    protected static Map<String, ILoggerListener> listeners;

    public static boolean isRuntimeTestEnabled() {
        return runtimeTestEnabled;
    }

    public static void logSystemOut(String message) {
        if (debugBoolean) {
            System.out.println(message);
        }
    }

    public static void log(Level level, String className, String methodName, String message) {
        if (level.equals(Level.INFO)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[ ").append(className).append("-").append(methodName).append("]").append(message);
            System.out.println(buffer.toString());
        }
    }

    public static void resetLogPath() throws IOException {
        if (outputWriter != null) {
            outputWriter.close();
            outputWriter = null;
            BPMRuntimeLogger.createLogPath();
        }
    }

    public static void logNodeExecuteStatement(IScope scope, ICubeContext ctx, String id, String microInstructionId, int thread, int step, int miStep, String miProcedure, String label) {
        BPELExecutionLogger.LOG.debug(microInstructionId, miProcedure, new Object[]{id + " ", "Thread:" + thread + " ", label});
        if (BPMRuntimeLogger.isRuntimeTestEnabled()) {
            ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
            String composite = ci.getComponentDN().getCompositeName();
            String process = ci.getComponentDN().getComponentName();
            long instanceid = ci.getId();
            if (miProcedure == null || miProcedure.isEmpty()) {
                miProcedure = "generic";
            }
            try {
                if (outputWriter == null) {
                    BPMRuntimeLogger.createLogPath();
                }
                String logKey = null;
                if (scope.contains("LOG_EXECUTION_PATH_KEY")) {
                    logKey = (String)scope.getAsObject("LOG_EXECUTION_PATH_KEY");
                }
                PathRecord record = new PathRecord(true, composite, process, id, microInstructionId, instanceid, new Date(System.currentTimeMillis()), thread, miProcedure, label, logKey);
                outputWriter.write(record.toString());
                outputWriter.flush();
                for (ILoggerListener listener : listeners.values()) {
                    listener.add(record);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File getLogPathFile() throws IOException {
        if (logPathFile == null) {
            logPathFile = new File("./logs/BPMNExecutionPath.log");
        }
        return logPathFile;
    }

    public static void addListener(String key, ILoggerListener listener) {
        listeners.put(key, listener);
    }

    public static void removeListener(String key) {
        listeners.remove(key);
    }

    public static ILoggerListener getListener(String key) {
        return listeners.get(key);
    }

    private static void createLogPath() throws IOException {
        FileOutputStream fos = new FileOutputStream(BPMRuntimeLogger.getLogPathFile());
        outputWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
    }

    static {
        listeners = new HashMap<String, ILoggerListener>();
        dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss:SS");
    }

    public static class PathRecord
    implements Record {
        private Comparator<PathRecord> comparator;
        private String composite;
        private Date date;
        private long instanceid;
        private String label;
        private int lineNumber;
        private String logKey;
        private String microInstruction;
        private String miProcedure;
        private String process;
        private String recordId;
        private boolean skipMIAssertion;
        private int thread;

        public PathRecord(boolean skipMIAssertion, String composite, String process, String recordId, String microInstruction, long instanceid, Date date, int thread, String procedure, String label, String logKey) {
            this.recordId = recordId;
            this.composite = composite;
            this.process = process;
            this.instanceid = instanceid;
            this.date = date;
            this.thread = thread;
            this.miProcedure = procedure;
            this.label = label;
            this.logKey = logKey;
            this.microInstruction = microInstruction;
            this.skipMIAssertion = skipMIAssertion;
        }

        public static PathRecord fromString(boolean skipMIAssertion, String str) throws ParseException {
            String[] recordParts = str.split(" ");
            if (recordParts.length == 17) {
                Date date = dateFormat.parse(recordParts[0] + " " + recordParts[1]);
                String composite = recordParts[2];
                String processId = recordParts[3];
                String id = recordParts[4].substring(0, recordParts[4].indexOf("#"));
                String microInstruction = recordParts[4].substring(recordParts[4].indexOf("#") + 1);
                long instance = Long.valueOf(recordParts[6].substring(0, recordParts[6].length() - 1));
                int thread = Integer.valueOf(recordParts[8].substring(0, recordParts[8].length() - 1));
                String procedure = recordParts[12].substring(0, recordParts[12].length() - 1);
                String label = recordParts[15].replace("_", " ");
                String logKey = recordParts[16].substring(1, recordParts[16].length() - 1);
                return new PathRecord(skipMIAssertion, composite, processId, id, microInstruction, instance, date, thread, procedure, label, logKey);
            }
            if (recordParts.length > 1) {
                Date date = null;
                String composite = recordParts[0];
                String processId = recordParts[1];
                String id = recordParts[2].substring(0, recordParts[2].indexOf("#"));
                String microInstruction = recordParts[2].substring(recordParts[2].indexOf("#") + 1);
                long instance = Long.valueOf(recordParts[4].substring(0, recordParts[4].length() - 1));
                int thread = Integer.valueOf(recordParts[6].substring(0, recordParts[6].length() - 1));
                String procedure = recordParts[10].substring(0, recordParts[10].length() - 1);
                String label = recordParts[13].replace("_", " ");
                String logKey = recordParts[14].substring(1, recordParts[14].length() - 1);
                return new PathRecord(skipMIAssertion, composite, processId, id, microInstruction, instance, date, thread, procedure, label, logKey);
            }
            return null;
        }

        @Override
        public BPMNCubeMapDotExporter.NodeLabel.NodeLabelData getNodeLabelData() {
            return new BPMNCubeMapDotExporter.NodeLabel.NodeLabelData(this.getThread(), this.getMicroInstructionProcedure(), this.getMicroInstruction() + " " + this.getLabel());
        }

        public String getRecordId() {
            return this.recordId;
        }

        public String getMicroInstruction() {
            return this.microInstruction;
        }

        public Date getDate() {
            return this.date;
        }

        public int getThread() {
            return this.thread;
        }

        public String getMicroInstructionProcedure() {
            return this.miProcedure;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isSkipMIAssertion() {
            return this.skipMIAssertion;
        }

        public String getLogKey() {
            return this.logKey;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.getDate() != null) {
                buffer.append(dateFormat.format(this.getDate()));
                buffer.append(" ");
            }
            buffer.append(this.getComposite());
            buffer.append(" ");
            buffer.append(this.getProcessId());
            buffer.append(" ");
            buffer.append(this.getRecordId());
            buffer.append("#");
            buffer.append(this.getMicroInstruction());
            buffer.append(" ");
            buffer.append("[Instance: ");
            buffer.append(this.getInstanceid());
            buffer.append(", Thread: ");
            buffer.append(this.getThread());
            buffer.append(", Step: ");
            buffer.append("-1");
            buffer.append(", MIProcedure: ");
            buffer.append(this.getMicroInstructionProcedure());
            buffer.append(", MIStep: ");
            buffer.append("-1");
            buffer.append("]");
            buffer.append(" ");
            buffer.append(this.label.replace(" ", "_"));
            buffer.append(" (");
            if (this.logKey != null) {
                buffer.append(this.logKey);
            }
            buffer.append(")\n");
            return buffer.toString();
        }

        public String toStringSimplified() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getComposite());
            buffer.append(" ");
            buffer.append(this.getProcessId());
            buffer.append(" ");
            buffer.append(this.getRecordId());
            buffer.append("#");
            buffer.append(this.getMicroInstruction());
            buffer.append(" ");
            buffer.append("[Thread: ");
            buffer.append(this.getThread());
            if (this.getMicroInstructionProcedure() != null && !this.getMicroInstructionProcedure().isEmpty()) {
                buffer.append(", MIProcedure: ");
                buffer.append(this.getMicroInstructionProcedure());
            }
            buffer.append("]");
            buffer.append(" ");
            buffer.append(this.label.replace(" ", "_"));
            return buffer.toString();
        }

        public String getComposite() {
            return this.composite;
        }

        public String getProcessId() {
            return this.process;
        }

        public long getInstanceid() {
            return this.instanceid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof PathRecord)) {
                return false;
            }
            PathRecord record = (PathRecord)o;
            if (this.comparator != null) {
                return this.comparator.compare(this, record) == 0;
            }
            if (record.comparator != null) {
                return record.comparator.compare(this, record) == 0;
            }
            if (!this.skipMIAssertion && !record.skipMIAssertion) {
                if (this.miProcedure != null ? !this.miProcedure.equals(record.miProcedure) : record.miProcedure != null) {
                    return false;
                }
                if (this.microInstruction != null ? !this.microInstruction.equals(record.microInstruction) : record.microInstruction != null) {
                    return false;
                }
            }
            if (this.thread != record.thread) {
                return false;
            }
            if (this.composite != null ? !this.composite.equals(record.composite) : record.composite != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(record.label) : record.label != null) {
                return false;
            }
            if (this.recordId != null ? !this.recordId.equals(record.recordId) : record.recordId != null) {
                return false;
            }
            return !(this.process != null ? !this.process.equals(record.process) : record.process != null);
        }

        public int hashCode() {
            int result = this.composite != null ? this.composite.hashCode() : 0;
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.recordId != null ? this.recordId.hashCode() : 0);
            result = 31 * result + (this.process != null ? this.process.hashCode() : 0);
            if (!this.skipMIAssertion) {
                result = 31 * result + (this.microInstruction != null ? this.microInstruction.hashCode() : 0);
                result = 31 * result + (this.miProcedure != null ? this.miProcedure.hashCode() : 0);
            }
            result = 31 * result + this.thread;
            return result;
        }

        public void setComparator(Comparator<PathRecord> comparator) {
            this.comparator = comparator;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }

    public static class LoggerListenerImpl
    implements ILoggerListener,
    Serializable {
        private StringBuilder buffer = new StringBuilder();
        private String logkey;

        public LoggerListenerImpl(String logkey) {
            this.logkey = logkey;
        }

        @Override
        public void add(PathRecord record) {
            if (this.logkey.equals(record.getLogKey())) {
                this.buffer.append(record.toString());
            }
        }

        public String getLog() {
            return this.buffer.toString();
        }
    }

    public static interface Record {
        public BPMNCubeMapDotExporter.NodeLabel.NodeLabelData getNodeLabelData();
    }

    public static interface ILoggerListener {
        public void add(PathRecord var1);
    }
}

