/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.EngineException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.IAuditEvent;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.persistence.dto.CubeInstance;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import com.oracle.bpel.client.BPELFault;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMappingType;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.ProcessType;
import oracle.bpel.services.workflow.task.model.ScaType;
import oracle.bpel.services.workflow.task.model.SystemMessageAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.bpmn.engine.instancemanagement.IUserInitiateProcessCleanupService;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNPayloadMappingCache;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ScopeUtils;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttributeHelper;
import oracle.bpm.bpmn.engine.runtime.features.SequenceFlowToEndActivityFeature;
import oracle.bpm.bpmn.engine.service.BPMNInstanceObserver;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessFlexAttributes;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ProcessRoleType;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.common.BusinessFaultException;
import oracle.fabric.common.FabricInvocationException;
import oracle.fabric.common.PolicyEnforcementException;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.tip.pc.services.identity.config.BPMConfigException;
import oracle.tip.pc.services.identity.config.ISConfiguration;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import org.w3c.dom.Element;

public class BPMNUtility {
    private static final String BPM_RPOCESS_INSTANCES_CONTEXT_KEY = "bpminstancescontextkey";
    private static final String BPM_PROCESS_OWNER_ROLE_SUFFIX = "SYS.PROCESS.OWNER.ROLE";

    public static void insertInstance2Track(ICubeInstance cubeInstance, FlowNode element, HashMap tokenMetadata, IScope scope, ICubeContext context, String processState, String targetCubeElementId, String workItemKey) throws Exception {
        String tokenKey = BPMNUtility.getTokenKey(scope, targetCubeElementId);
        int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(tokenMetadata);
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(tokenMetadata);
        BPMNUtility.insertInstance2Track(cubeInstance, element, scope, tokenMetadata, context, processState, tokenKey, workItemKey, thread, parentThread, false);
    }

    public static void insertInstance2Track(MicroInstructionContext context, String processState) throws Exception {
        Object element = context.getNode().getFlowElement();
        if (BPMNUtility.isInstanceTrackingNotRequired(element)) {
            return;
        }
        int thread = context.getThread();
        int parentThread = context.getParentThread();
        IWorkItem item = context.getWorkItem();
        String workItemKey = null;
        String tokenKey = null;
        if (item != null) {
            workItemKey = BPMNUtility.getWorkItemKey(item);
        } else {
            tokenKey = BPMNUtility.getTokenKey(context.getScope(), context.getNodeId());
        }
        BPMNUtility.insertInstance2Track((ICubeInstance)context.getCubeInstance(), element, context.getScope(), context.getNodeActivationContext(), context.getCubeContext(), processState, tokenKey, workItemKey, thread, parentThread, false);
    }

    public static void insertInstance2TrackProcess(MicroInstructionContext context, String processState) throws Exception {
        Object element = context.getNode().getFlowElement();
        int thread = 0;
        int parentThread = -1;
        BPMNUtility.insertInstance2Track((ICubeInstance)context.getCubeInstance(), element, context.getScope(), context.getNodeActivationContext(), context.getCubeContext(), processState, null, null, thread, parentThread, true);
    }

    public static String getTokenKey(IScope scope, String cubeElementId) {
        return scope.getAbsoluteScopeId() + "/" + cubeElementId;
    }

    public static String getAbsoluteScopeIdFromTokenKey(String key) {
        int pos;
        if (key != null && (pos = key.lastIndexOf("/")) > -1) {
            return key.substring(0, pos);
        }
        return null;
    }

    public static String getCubeElementIdFromTokenKey(String key) {
        int pos;
        if (key != null && (pos = key.lastIndexOf("/")) > -1) {
            return key.substring(pos + 1);
        }
        return null;
    }

    public static String getWorkItemKey(IWorkItem item) {
        return item.getKey().toURIFormat();
    }

    public static WorkItemKey createWorkItemKey(String key) throws CubeException {
        return new WorkItemKey(key);
    }

    public static void persistProcessInstances(ICubeContext ctx) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)"Start of persisting instances");
        List<IProcessInstance> instances = BPMNUtility.getProcessInstances(ctx);
        IInternalInstanceManagementServiceLocal local = BPMNUtility.getInternalManagementservice(ctx);
        IBPMContext bpmcontext = BPMNUtility.getInternalWorkflowContext();
        int size = instances.size();
        for (int i = 0; i < size; ++i) {
            IProcessInstance instance = instances.get(i);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)("Persisting instance id = " + instance.getSystemAttributes().getProcessInstanceId()));
            local.insertUpdateInstance(bpmcontext, instance);
        }
        instances = null;
        ctx.removeFromEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)"Start of persisting instances");
    }

    public static Object[] getObjects(ICubeInstance instance, FlowNode node) {
        String processName = instance.getComponentName();
        String revision = instance.getCompositeRevision();
        String labelName = node.getDefaultLabel();
        Object[] obj = new Object[]{processName, revision, labelName};
        return obj;
    }

    public static String getLabel(FlowNode node) {
        return node.getDefaultLabel() + "[" + node.getId() + "]";
    }

    public static boolean isSequenceFlowGoesToEnd(SequenceFlowInfo flow, FlowNode node) {
        String flowId = flow.getId();
        SequenceFlowToEndActivityFeature feature = (SequenceFlowToEndActivityFeature)node.getFeature(SequenceFlowToEndActivityFeature.class);
        if (feature != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isSequenceFlowGoesToEnd", (String)("Check sequence flow with id " + flowId + " of node " + BPMNUtility.getLabel(node) + " goes to end "));
            List infos = feature.getValue();
            for (SequenceFlowToEndActivityFeature.EndActivityFlowInfo info : infos) {
                if (!info.getSequenceFlow().getId().equals(flowId)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isSequenceFlowGoesToEnd", (String)("Sequence flow id  " + flowId + " of node " + BPMNUtility.getLabel(node) + " goes to end "));
                return true;
            }
        }
        return false;
    }

    public static IInternalInstanceManagementServiceLocal getInternalManagementservice(ICubeContext ctx) throws Exception {
        IInternalInstanceManagementServiceLocal local = (IInternalInstanceManagementServiceLocal)ctx.getFromEnvironment("internalManagementService");
        if (local == null) {
            InitialContext jContext = new InitialContext();
            local = (IInternalInstanceManagementServiceLocal)jContext.lookup("java:comp/env/oracle/bpm/engine/InternalInstanceManagementService");
            ctx.addToEnvironment("internalManagementService", (Object)local);
        }
        return local;
    }

    public static List<IAuditEvent> persistAuditData(ICubeContext ctx) throws Exception {
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IAuditTrail auditTrail = cubeInstance.getAuditTrail();
        return BPMNUtility.getInternalManagementservice(ctx).persistAuditData(auditTrail);
    }

    public static void publishToMeasurement(ICubeContext ctx) throws Exception {
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IAuditTrail auditTrail = cubeInstance.getAuditTrail();
        BPMNUtility.getInternalManagementservice(ctx).publishToMeasurement(auditTrail);
    }

    public static void throwBPELFault(Exception exc, String className, String methodName) throws CubeException {
        if (exc instanceof BusinessFaultException) {
            BusinessFaultException e = (BusinessFaultException)exc;
            BPELExecutionLogger.LOG.debug(className, methodName, new Object[]{"got BusinessFaultException", e});
            BPELFault fault = new BPELFault(QName.valueOf(e.getFaultName()), (Throwable)e);
            if (e.getFaultMessage() != null) {
                fault.setParts(e.getFaultMessage().getPayload());
                fault.setMessageType(e.getFaultMessage().getMessageType());
            }
            throw fault;
        }
        if (exc instanceof FabricInvocationException) {
            FabricInvocationException fie = (FabricInvocationException)exc;
            if (fie.getCause() == null) {
                BPELExecutionLogger.LOG.debug(className, methodName, new Object[]{"got FabricInvocationException", fie});
            } else {
                BPELExecutionLogger.LOG.debug("UserTaskWMP", methodName, new Object[]{"got FabricInvocationException", fie});
            }
            if (FabricInvocationException.RetryType.ROLLBACK_ONLY == fie.getRetryType()) {
                throw new EngineException(2180);
            }
            if (FabricInvocationException.RetryType.GLOBAL_RETRY == fie.getRetryType()) {
                throw new EngineException(2198);
            }
            BPELFault fault = FabricInvocationException.RetryType.NO_RETRY == fie.getRetryType() ? new BPELFault(BPELDefs.QN_BINDING_FAULT) : new BPELFault(BPELDefs.QN_REMOTE_FAULT);
            String summary = fie.getSummary() == null ? String.valueOf(fie) : fie.getSummary();
            String detail = fie.getDetail() == null ? CubeFabricUtil.getRootCause((Throwable)fie).getMessage() : fie.getDetail();
            fault.setPart("code", (Object)fie.getCode());
            fault.setPart("summary", (Object)summary);
            fault.setPart("detail", (Object)detail);
            throw fault;
        }
        if (exc instanceof PolicyEnforcementException) {
            PolicyEnforcementException pe = (PolicyEnforcementException)exc;
            BPELExecutionLogger.LOG.error(className, methodName, new Object[]{"got PolicyEnforcementException", pe});
            BPELFault fault = new BPELFault(BPELDefs.QN_OWSM_POLICY_FAULT, (Throwable)pe);
            fault.setMessageType(BPELDefs.QN_BPELX_OWSM_POLICY_FAULT_MESSAGE);
            fault.setPart("code", (Object)pe.getErrorCode());
            fault.setPart("summary", (Object)pe.getMessage());
            fault.setPart("detail", (Object)pe.getDetail());
            throw fault;
        }
        if (exc instanceof BPELFault) {
            BPELFault f = (BPELFault)((Object)exc);
            BPELExecutionLogger.LOG.debug(className, methodName, new Object[]{"got BPELFault", f});
            throw f;
        }
        if (exc instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)exc;
            BPELExecutionLogger.LOG.debug(className, methodName, new Object[]{"got RuntimeException", re});
            if (re.getCause() instanceof BusinessFaultException) {
                BusinessFaultException e = (BusinessFaultException)re.getCause();
                BPELFault fault = new BPELFault(QName.valueOf(e.getFaultName()));
                fault.setParts(e.getFaultMessage().getPayload());
                throw fault;
            }
            BPELFault fault = new BPELFault(BPELDefs.QN_REMOTE_FAULT);
            String summary = String.valueOf(re);
            String detail = CubeFabricUtil.getRootCause((Throwable)re).getMessage();
            fault.setPart("summary", (Object)summary);
            fault.setPart("detail", (Object)detail);
            throw fault;
        }
        BPELExecutionLogger.LOG.debug(className, methodName, new Object[]{"got Throwable", exc});
        BPELFault fault = new BPELFault(BPELDefs.QN_REMOTE_FAULT, (Throwable)exc);
        String summary = String.valueOf(exc);
        String detail = CubeFabricUtil.getRootCause((Throwable)exc).getMessage();
        fault.setPart("summary", (Object)summary);
        fault.setPart("detail", (Object)detail);
        throw fault;
    }

    public static Role getRole(Lane lane) {
        Organization organization;
        Project p;
        Role role = null;
        if (lane != null && (p = lane.getProject()) != null && (organization = p.getOrganization()) != null) {
            role = organization.findRoleById(lane.getRole());
        }
        return role;
    }

    public static String removeLabelFromDN(String compositeDN) {
        String METHOD_NAME = "removeLabelFromDN";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"removeLabelFromDN", (String)("Removing label part from compositeDN: " + compositeDN));
        String result = compositeDN;
        int labelIdx = compositeDN.indexOf(42);
        if (labelIdx > 0) {
            result = compositeDN.substring(0, labelIdx + 1);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"removeLabelFromDN", (String)("Returning result: " + result));
        return result;
    }

    public static IBPMContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return (IBPMContext)wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    public static IUserInitiateProcessCleanupService getUserInitiateProcessCleanupService() throws Exception {
        InitialContext ctx = new InitialContext();
        IUserInitiateProcessCleanupService cleanup = (IUserInitiateProcessCleanupService)ctx.lookup("UserInitiateProcessCleanupService#oracle.bpm.bpmn.engine.instancemanagement.ejb.UserInitiateProcessCleanupRemote");
        return cleanup;
    }

    public static void promoteProjectDataObjectToInstance(IProcessInstance instance, Project project, IScope scope) throws Exception {
        if (project == null) {
            return;
        }
        ScaType sca = instance.getSca();
        String dn = sca.getCompositeDN() + "/" + sca.getComponentName();
        Sequence dataObjects = project.getProjectDataObjects();
        if (!dataObjects.isEmpty()) {
            List<PayloadMappingType> mappings = BPMNPayloadMappingCache.getPayloadMappings(dn);
            for (PayloadMappingType mapping : mappings) {
                String variableName = mapping.getPayloadAttribute();
                String attribute = mapping.getLabel().getTaskAttribute();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Variable name from mapping = " + variableName + " with flex attribute is " + attribute));
                ProjectDataObject dataObject = project.findDataObject(variableName);
                if (dataObject != null) {
                    Object object = DataHandlingUtils.getVariableValue(variableName, scope);
                    if (object != null) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Value for data object " + variableName + " is " + object));
                        CatalogType type = dataObject.getType();
                        Object convertedObject = null;
                        if (type.isString()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to string"));
                            convertedObject = object instanceof Element ? ((Element)object).getTextContent() : object.toString();
                        } else if (type.isNumber() || type.isDecimal() || type.isInt()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to Double"));
                            convertedObject = Double.parseDouble(object instanceof Element ? ((Element)object).getTextContent() : object.toString());
                        } else if (type.isTime()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to Date"));
                            convertedObject = JaxbDatatypeConverter.parseDateTime((String)(object instanceof Element ? ((Element)object).getTextContent() : object.toString()));
                        } else if (type.isBoolean()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting boolean value  " + object + " to String"));
                            convertedObject = object instanceof Element ? ((Element)object).getTextContent() : object.toString();
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.WARNING, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Not supported type " + type.getName()));
                        }
                        if (convertedObject == null) continue;
                        SystemMessageAttributesType sysType = ((ProcessFlexAttributes)instance.getFlexAttributes()).getSystemMessageAttributesType();
                        TaskUtil.setSystemMessageAttribute((SystemMessageAttributesType)sysType, (String)attribute, (Object)convertedObject);
                        continue;
                    }
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Value is null for data object " + variableName));
                    continue;
                }
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Warning project data object doesn't exist for " + variableName));
            }
        }
    }

    private static void insertInstance2Track(ICubeInstance cubeInstance, FlowNode element, IScope scope, HashMap nodeActivationContext, ICubeContext context, String processState, String tokenKey, String workItemKey, int thread, int parentThread, boolean processLevel) throws Exception {
        ComponentModel component;
        boolean isAGInstance = BPMNUtility.isAGRootProcess(cubeInstance.getComponentDN());
        if (!isAGInstance && BPMNUtility.isProcessTrackingDisabled(component = CubeContextHelper.getScaComponent((ICubeContext)context))) {
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Start of inserting bpmn instance");
        String realState = processState;
        if (processState.equals("COMPLETED") && thread == 0 && !processLevel) {
            processState = "OPEN";
        }
        IProcessInstance instance = BPMNUtility.getProcessInstance(element, nodeActivationContext, cubeInstance, scope, context, thread, parentThread, isAGInstance, processLevel);
        instance.getSystemAttributes().setState(processState);
        instance.getCallback().setContext(realState);
        if (workItemKey != null) {
            instance.getSystemAttributes().setWorkItemKey(workItemKey);
        }
        if (tokenKey != null) {
            instance.getSystemAttributes().setTokenKey(tokenKey);
        }
        instance.getSystemAttributes().setCaseId(ScopeUtils.getCaseId((ICubeInstanceImpl)cubeInstance));
        BPMNUtility.addProcessInstanceInContext(instance, context, processLevel);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"End of inserting bpmn instance");
    }

    private static IProcessInstance getProcessInstance(FlowNode element, HashMap nodeActivationContext, ICubeInstance cubeinstance, IScope scope, ICubeContext context, int thread, int parentThread, boolean isAGInstance, boolean processLevel) throws Exception {
        Role role;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Creating instance using cube instance");
        String activityId = element.getId();
        String activityName = element.getDefaultLabel();
        int step = BPMNTokenMetadataUtils.getStepFromTokenMetadata(nodeActivationContext);
        long instanceId = cubeinstance.getId();
        Date createdDate = cubeinstance.getCreationDate();
        String appContext = null;
        ProcessInstance instance = new ProcessInstance();
        IIdentityType ownerType = BPMNUtility.setPocessOwner(scope, context, (IProcessInstance)instance);
        IIdentityType assigneeType = null;
        Lane lane = null;
        if (element != null) {
            lane = element.getLane();
        }
        if (lane != null && (role = BPMNUtility.getRole(element.getLane())) != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Role name is " + role.getId()));
            String compositeDN = cubeinstance.getComponentDN().getCompositeDN();
            List<Participant> participants = DeploymentDescriptorUtil.getParticipantsForProcessRole(compositeDN, role.getId(), null);
            if (participants != null && participants.size() > 0) {
                assigneeType = new IdentityType();
                Participant participant = participants.get(0);
                PrincipleRefType pType = (PrincipleRefType)participant.getValue();
                appContext = pType.getApplicationContext();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Application context is " + appContext));
                String name = pType.getName();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("App role name is " + name));
                assigneeType.setId(name);
                if (pType.getType().equals((Object)ParticipantTypeEnum.GROUP)) {
                    assigneeType.setType("group");
                } else if (pType.getType().equals((Object)ParticipantTypeEnum.APPROLE)) {
                    assigneeType.setType("application_role");
                }
            }
        }
        if (assigneeType == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Use process owner as assignee ");
            assigneeType = ownerType;
        }
        if (appContext == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Application context is null. Use hard coded application context");
            appContext = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Information is   Step = " + step + " thread = " + thread + " parent thread " + parentThread + " instance id " + instanceId));
        instance.setTitle((String)ProcessInstanceAttribute.TITLE.getValue(scope, context));
        try {
            instance.setPriority(((Integer)ProcessInstanceAttribute.PRIORITY.getValue(scope, context)).intValue());
        }
        catch (NumberFormatException e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Invalid number for priority Step = " + step + "thread = " + thread + " parent thread " + parentThread + " instance id " + instanceId));
        }
        instance.setCreator((String)ProcessInstanceAttribute.CREATOR.getValue(scope, context));
        String ouName = (String)ProcessInstanceAttribute.ORGANIZATIONALUNIT.getValue(scope, context);
        Task task = instance.getTask();
        if (ouName != null && !ouName.equals("")) {
            try {
                String ouId = ProcessInstanceAttributeHelper.validateOu(ouName, task.getSystemAttributes().getTaskId());
                task.getSystemAttributes().setOrganizationalUnitName(ouName);
                task.getSystemAttributes().setOrganizationalUnitId(ouId);
            }
            catch (WorkflowException e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Invalid ou name " + ouName + "  Step = " + step + " thread = " + thread + " parent thread " + parentThread + " instance id " + instanceId));
            }
        }
        instance.setCubeInstanceId(String.valueOf(instanceId));
        IProcessSystemAttributes sysAttributes = instance.getSystemAttributes();
        if (createdDate != null) {
            Calendar createdCal = Calendar.getInstance();
            createdCal.setTime(createdDate);
            sysAttributes.setCreatedDate(createdCal);
        }
        sysAttributes.setThread(thread);
        sysAttributes.setParentThread(parentThread);
        sysAttributes.setComponentType("BPMN");
        sysAttributes.setActivityId(activityId);
        sysAttributes.setActivityName(activityName);
        sysAttributes.setActivityType(processLevel ? BpmnType.END_EVENT : element.getBpmnType());
        sysAttributes.setIsGroup(true);
        ScaType sca = instance.getSca();
        CubeInstance cubeInstanceEO = cubeinstance.getCubeInstanceEO();
        sca.setComponentName(cubeInstanceEO.getComponentName());
        String compositeDNString = new CompositeDN(cubeInstanceEO.getDomainName(), cubeInstanceEO.getCompositeName(), cubeInstanceEO.getCompositeRevision(), cubeInstanceEO.getCompositeLabel()).getDN();
        sca.setCompositeDN(compositeDNString);
        sca.setCompositeVersion(cubeInstanceEO.getCompositeRevision());
        sca.setEcId(cubeinstance.getECID());
        sca.setCompositeInstanceId(cubeinstance.getCompositeInstanceId());
        sca.setCompositeCreatedTime(Calendar.getInstance());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Composite DN " + compositeDNString + "  component Name " + sca.getComponentName()));
        String componentDNMinusLabel = BPMNUtility.removeLabelFromDN(compositeDNString) + "/" + sca.getComponentName();
        instance.setProcessDN(componentDNMinusLabel);
        if (appContext != null) {
            instance.setApplicationContext(appContext);
        }
        sysAttributes.addAssignee(assigneeType);
        if (isAGInstance) {
            sysAttributes.setActivityGuideRootId(instanceId);
        }
        String id = BPMNUtility.getId((IProcessInstance)instance);
        task.getSystemAttributes().setTaskId(id);
        if (WorkflowUtil.isNull((String)instance.getIdentityContext())) {
            try {
                instance.setIdentityContext(ISConfiguration.getDefaultRealmName());
            }
            catch (BPMConfigException exc) {
                instance.setIdentityContext("jazn.com");
            }
        }
        BPMNUtility.setProcessModelName(element, task);
        BPMNUtility.promoteProjectDataObjectToInstance((IProcessInstance)instance, element, scope);
        instance.setConversationID(cubeinstance.getConversationId());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"End of Creating instance using cube instance");
        return instance;
    }

    private static IIdentityType setPocessOwner(IScope scope, ICubeContext context, IProcessInstance instance) throws Exception {
        String owner = (String)ProcessInstanceAttribute.OWNER.getValue(scope, context);
        String ownerTypeS = (String)ProcessInstanceAttribute.OWNERTYPE.getValue(scope, context);
        IdentityType ownerType = new IdentityType();
        if (owner != null && !owner.equals("")) {
            ownerType.setId(owner);
            if (ownerTypeS != null && !ownerTypeS.equals("")) {
                if (ownerTypeS.equals(IIdentityType.IDENTITY_TYPE.USER.toString())) {
                    ownerType.setType("user");
                    instance.setOwner(owner, IIdentityType.IDENTITY_TYPE.USER);
                } else if (ownerTypeS.equals(IIdentityType.IDENTITY_TYPE.GROUP.toString())) {
                    ownerType.setType("group");
                    instance.setOwner(owner, IIdentityType.IDENTITY_TYPE.GROUP);
                } else if (ownerTypeS.equals(IIdentityType.IDENTITY_TYPE.ROLE.toString())) {
                    ownerType.setType("application_role");
                    instance.setOwner(owner, IIdentityType.IDENTITY_TYPE.ROLE);
                }
            }
        }
        return ownerType;
    }

    private static String getProcessOwnerRole(String compositeDN) throws Exception {
        oracle.bpm.services.organization.model.Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        List roles = organization.getApplicationRoles().getApplicationRole();
        for (ApplicationRoleType role : roles) {
            ProcessRoleType processRole = role.getProcessRole();
            if (processRole.getId() == null || !processRole.getId().equals("ProcessOwner")) continue;
            return role.getName();
        }
        return null;
    }

    private static void setProcessModelName(FlowNode element, Task taskObject) {
        ProcessType processInfo = taskObject.getProcessInfo();
        ObjectFactory factory = new ObjectFactory();
        if (processInfo == null) {
            processInfo = factory.createProcessType();
            taskObject.setProcessInfo(processInfo);
        }
        processInfo.setProcessName(element.getProcess().getName());
    }

    private static void promoteProjectDataObjectToInstance(IProcessInstance instance, FlowNode node, IScope scope) throws Exception {
        Project project = node.getProject() != null ? node.getProject() : null;
        BPMNUtility.promoteProjectDataObjectToInstance(instance, project, scope);
    }

    private static void addProcessInstanceInContext(IProcessInstance currentInstance, ICubeContext ctx, boolean isEndEvent) {
        IProcessSystemAttributes mAttr;
        List<IProcessInstance> instances = BPMNUtility.getProcessInstances(ctx);
        int size = instances.size();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Start of process instance in list of size =  " + size));
        IProcessSystemAttributes currentAttributes = currentInstance.getSystemAttributes();
        String currentId = currentAttributes.getProcessInstanceId();
        String currentState = currentAttributes.getState();
        boolean canRemoveChildOpenInstance = false;
        if (currentState.equals("OPEN") || isEndEvent && currentState.equals("COMPLETED")) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)"Setting flag to to true for removing open child instances from the list ");
            canRemoveChildOpenInstance = true;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Adding instance id=  " + currentId));
        IProcessInstance mainInstance = null;
        int currentThread = currentAttributes.getThread();
        boolean includesChildOpenInstances = false;
        if (currentThread == 0) {
            mainInstance = currentInstance;
        } else if (currentState.equals("OPEN")) {
            includesChildOpenInstances = true;
        }
        for (int i = 0; i < instances.size(); ++i) {
            IProcessInstance pInstance = instances.get(i);
            IProcessSystemAttributes pAttr = pInstance.getSystemAttributes();
            String pState = pAttr.getState();
            String pTaskId = pInstance.getSystemAttributes().getProcessInstanceId();
            if (pInstance.getSystemAttributes().getProcessInstanceId().equals(currentId)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("ID is already exist just copy over =  " + currentId));
                if (pState.equals("COMPLETED") && currentState.equals("OPEN") && BPMNUtility.isAssigneesDifferent(currentAttributes, pAttr)) {
                    currentInstance.setRemoveAssignees(pAttr.getAssignees());
                }
                instances.remove(pInstance);
                continue;
            }
            if (pAttr.getThread() != 0 && canRemoveChildOpenInstance && pState.equals("OPEN")) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Removing the instance of type from the list " + pAttr.getActivityName()));
                int pParentThread = pInstance.getSystemAttributes().getParentThread();
                if (pParentThread == currentAttributes.getThread()) {
                    instances.remove(pInstance);
                    continue;
                }
            }
            if (pAttr.getThread() == 0) {
                mainInstance = pInstance;
                continue;
            }
            if (includesChildOpenInstances || pAttr.getThread() == 0 || !pAttr.getState().equals("OPEN")) continue;
            includesChildOpenInstances = true;
        }
        if (mainInstance != null && includesChildOpenInstances && mainInstance.getSystemAttributes().getState().equals("COMPLETED") && (mAttr = mainInstance.getSystemAttributes()).getState().equals("COMPLETED")) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.INFORMATION, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)"Changing the state of close of main task to open as it includes some open child");
            mAttr.setState("OPEN");
            mAttr.clearAssignees();
        }
        instances.add(currentInstance);
    }

    private static boolean isAssigneesDifferent(IProcessSystemAttributes open, IProcessSystemAttributes close) {
        List openAssignees = open.getAssignees();
        List closeAssignees = close.getAssignees();
        if (openAssignees.size() != closeAssignees.size()) {
            return true;
        }
        for (int i = 0; i < openAssignees.size(); ++i) {
            IIdentityType type = (IIdentityType)openAssignees.get(i);
            boolean exist = false;
            for (int j = 0; j < closeAssignees.size(); ++j) {
                IIdentityType type1 = (IIdentityType)closeAssignees.get(j);
                if (!type.getId().equals(type1.getId())) continue;
                exist = true;
            }
            if (exist) continue;
            return true;
        }
        return false;
    }

    private static List<IProcessInstance> getProcessInstances(ICubeContext ctx) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"getProcessInstances", (String)"Start of getting instances from context");
        ArrayList<IProcessInstance> instances = (ArrayList<IProcessInstance>)ctx.getFromEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY);
        if (instances == null) {
            instances = new ArrayList<IProcessInstance>();
            ctx.addToEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY, instances);
            BPMNInstanceObserver.addBPMNObserver(ctx);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"getProcessInstances", (String)("End of getting instances from context size = " + instances.size()));
        return instances;
    }

    private static boolean checkIfProcessRoleExists(String compositeDN, String processRole) throws Exception {
        oracle.bpm.services.organization.model.Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        List roles = organization.getApplicationRoles().getApplicationRole();
        for (ApplicationRoleType role : roles) {
            String name = role.getName();
            if (!processRole.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAGRootProcess(ComponentDN dn) throws Exception {
        String processId = dn.getComponentName();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isAGRooProcess", (String)("Start of isAGRootProcess for " + processId));
        boolean isAgRootProcess = false;
        IBpmAGMetadataService service = BPMServiceLocator.getBpmAGMetadataService();
        IActivityGuide activityGuide = service.getAGDefinition(dn.getCompositeDN());
        if (activityGuide != null) {
            String agRootprocessId = activityGuide.getRootProcessId();
            isAgRootProcess = agRootprocessId.equals(processId);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isAGRooProcess", (String)("End of isAGRootProcess = " + isAgRootProcess));
        return isAgRootProcess;
    }

    private static String getId(IProcessInstance instance) {
        String cubeInstanceId = instance.getCubeInstanceId();
        int thread = instance.getSystemAttributes().getThread();
        int parentThread = instance.getSystemAttributes().getParentThread();
        String taskId = cubeInstanceId;
        if (thread > 0 || parentThread > 0) {
            taskId = taskId + "-" + thread;
            taskId = taskId + "-" + parentThread;
        }
        return taskId;
    }

    private static boolean isProcessTrackingDisabled(ComponentModel compModel) {
        String flag;
        PropertyModel flagProperty = compModel.getProperty("disableProcessTracking");
        if (flagProperty != null && (flag = flagProperty.getValue()) != null) {
            return flag.equals("true");
        }
        BPMNServiceEngine engine = BPMNServiceEngine.getInstance();
        BPMNConfig config = engine.getBPMNConfig();
        if (config != null) {
            return config.getDisableProcessTracking();
        }
        return true;
    }

    private static boolean isInstanceTrackingNotRequired(FlowNode node) {
        return false;
    }
}

