/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public abstract class BPMNTokenMetadataUtils {
    private static final String ACTIVATION_TOKEN = "ACTIVATION_TOKEN";

    public static HashMap<String, Object> createNewTokenMetadata(IScope scope) throws CubeException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("STEP", 0);
        result.put("THREAD", BPMNTokenMetadataUtils.getNewThreadNumber(scope));
        return result;
    }

    public static HashMap<String, Object> createFaultTokenMetadata(BPELFault fault) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("FAULT", (Object)fault);
        return result;
    }

    public static HashMap<String, Object> addFault(BPELFault fault, HashMap<String, Object> metadata) {
        metadata.put("FAULT", (Object)fault);
        return metadata;
    }

    public static BPELFault getFault(HashMap<String, Object> metadata) {
        return (BPELFault)((Object)metadata.get("FAULT"));
    }

    public static String getActivationIdsFromTokenMetadata(HashMap<String, Object> tokenMetadata) {
        String activationIds = (String)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(tokenMetadata, "ACTIVATION_IDS");
        if (activationIds == null) {
            activationIds = "";
        }
        return activationIds;
    }

    public static void setActivationIdsToTokenMetadata(HashMap<String, Object> tokenMetadata, String activationIds) {
        tokenMetadata.put("ACTIVATION_IDS", activationIds);
    }

    public static int getNewThreadNumber(@NotNull IScope scope) throws CubeException {
        IScope rootScope = BPMNTokenMetadataUtils.getRootScope(scope);
        int newThread = 0;
        if (!rootScope.contains("threadNumberCounter")) {
            rootScope.declareAndSet("threadNumberCounter", newThread);
            return 0;
        }
        int currentThread = rootScope.getInt("threadNumberCounter");
        newThread = currentThread + 1;
        rootScope.set("threadNumberCounter", newThread);
        return newThread;
    }

    public static int getThreadFromTokenMetadata(HashMap<String, Object> tokenMetadata) {
        return (Integer)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(tokenMetadata, "THREAD");
    }

    public static void setThreadToTokenMetadata(HashMap<String, Object> tokenMetadata, int thread) {
        tokenMetadata.put("THREAD", thread);
    }

    public static int getStepFromTokenMetadata(HashMap<String, Object> tokenMetadata) {
        Integer step = (Integer)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(tokenMetadata, "STEP");
        if (step == null) {
            step = 0;
        }
        return step;
    }

    public static void setStepToTokenMetadata(HashMap<String, Object> tokenMetadata, int step) {
        tokenMetadata.put("STEP", step);
    }

    public static void setIncreaseCountThreadFromTokenMetadata(HashMap<String, Object> tokenMetadata, boolean value) {
        tokenMetadata.put("INCREASE_THREAD_COUNT", value);
    }

    public static boolean removeIncreaseCountThreadFromTokenMetadata(HashMap<String, Object> tokenMetadata) {
        Boolean value = (Boolean)tokenMetadata.remove("INCREASE_THREAD_COUNT");
        return value != null && value != false;
    }

    public static Object getPropertyFromTokenMetadata(HashMap<String, Object> tokenMetada, String property) {
        return tokenMetada.get(property);
    }

    public static Object removePropertyFromTokenMetadata(HashMap<String, Object> tokenMetada, String property) {
        return tokenMetada.remove(property);
    }

    public static void saveActivationToken(HashMap<String, Object> token, IScope scope) throws CubeException {
        scope.declareAndSet(ACTIVATION_TOKEN, token);
    }

    public static HashMap<String, Object> getActivationToken(IScope scope) throws CubeException {
        return (HashMap)scope.getAsObject(ACTIVATION_TOKEN);
    }

    public static String getUniqueActivationId(IScope iscope) throws CubeException {
        IScope scope = iscope;
        while (!scope.isRootScope()) {
            scope = scope.getParentScope();
        }
        String key = "++activationidCounter";
        String object = null;
        if (!scope.contains(key)) {
            object = "100";
            scope.declare(key);
        } else {
            object = (String)scope.getAsObject(key);
        }
        int activationId = Integer.parseInt(object) + 1;
        scope.set(key, (Object)Integer.toString(activationId));
        return object;
    }

    public static int getParentThreadFromTokenMetadata(HashMap<String, Object> nodeActivationContext) {
        Integer parentThread = (Integer)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(nodeActivationContext, "PARENT_THREAD");
        if (parentThread == null) {
            parentThread = -1;
        }
        return parentThread;
    }

    public static void setParentThreadInTokenMetadata(HashMap<String, Object> tokenMetadata, int parentThread) {
        tokenMetadata.put("PARENT_THREAD", parentThread);
    }

    public static HashMap<String, Object> convertToToken(Object o) {
        if (o instanceof HashMap) {
            return (HashMap)o;
        }
        return new HashMap<String, Object>();
    }

    public static String getMergeGatewayStepKey(String mergeGatewayId, String activationId) {
        return mergeGatewayId + "." + activationId + "." + "STEP";
    }

    public static String getMergeGatewayThreadey(String mergeGatewayId, String activationId) {
        return mergeGatewayId + "." + activationId + "." + "THREAD";
    }

    public static String getMergeGatewayParentThreadey(String mergeGatewayId, String activationId) {
        return mergeGatewayId + "." + activationId + "." + "PARENT_THREAD";
    }

    public static String getSourceFromTokenMetadata(HashMap<String, Object> tokenMetadata) {
        return (String)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(tokenMetadata, "SOURCE_ACTIVITY_ID");
    }

    private static IScope getRootScope(@NotNull IScope scope) {
        IScope rootScope;
        if (!scope.isRootScope()) {
            rootScope = scope.getParentScope();
            while (!rootScope.isRootScope()) {
                rootScope = rootScope.getParentScope();
            }
        } else {
            rootScope = scope;
        }
        return rootScope;
    }
}

