/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMappingType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;

public class BPMNPayloadMappingCache {
    private static Map<String, List<PayloadMappingType>> sPayloadMappingMap = new HashMap<String, List<PayloadMappingType>>();

    public static List<PayloadMappingType> getPayloadMappings(String componentDN) throws Exception {
        List<PayloadMappingType> mappings = sPayloadMappingMap.get(componentDN);
        if (mappings == null) {
            mappings = BPMNPayloadMappingCache.queryPayloadMappings(componentDN);
        }
        return mappings;
    }

    public static synchronized void clearCache() {
        sPayloadMappingMap.clear();
    }

    public static synchronized void clearEntry(String componentDN) {
        sPayloadMappingMap.remove(componentDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized List<PayloadMappingType> queryPayloadMappings(String componentDN) throws WorkflowException {
        List mappings = sPayloadMappingMap.get(componentDN);
        if (mappings == null) {
            IPersistencyService svc = null;
            try {
                svc = PersistencyDriver.getInstance();
                mappings = svc.getBPMPayloadMappings(componentDN);
            }
            finally {
                if (svc != null) {
                    svc.close();
                }
            }
            if (mappings != null) {
                sPayloadMappingMap.put(componentDN, mappings);
            }
        }
        return mappings;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }
}

