/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.sequenceflow;

import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.ConditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.transitions.TransitionMethodFeature;
import oracle.bpm.project.transitions.TransitionOrderFeature;

public class SequenceFlowInfoFactory {
    public static UnconditionalSequenceFlowInfo createUnconditional(SequenceFlow sequenceFlow, String targetNodeId) {
        UnconditionalSequenceFlowInfo result = new UnconditionalSequenceFlowInfo(sequenceFlow.getId(), sequenceFlow.getSource().getId(), sequenceFlow.getTarget().getId(), targetNodeId);
        result.setSequenceFlow(sequenceFlow);
        return result;
    }

    public static UnconditionalSequenceFlowInfo createUnconditional(String id, String sourceId, String targetId, String targetNodeId) {
        return new UnconditionalSequenceFlowInfo(id, sourceId, targetId, targetNodeId);
    }

    public static ConditionalSequenceFlowInfo createConditional(ConditionalFlow conditionalFlow, String targetNodeId) {
        ConditionalSequenceFlowInfo conditionalSequenceFlowInfo = new ConditionalSequenceFlowInfo(conditionalFlow.getId(), conditionalFlow.getSource().getId(), conditionalFlow.getTarget().getId(), targetNodeId);
        SequenceFlowInfoFactory.setScriptInfo((SequenceFlow)conditionalFlow, conditionalSequenceFlowInfo);
        SequenceFlowInfoFactory.setEvaluationOrder((SequenceFlow)conditionalFlow, conditionalSequenceFlowInfo);
        conditionalSequenceFlowInfo.setSequenceFlow((SequenceFlow)conditionalFlow);
        return conditionalSequenceFlowInfo;
    }

    private static void setEvaluationOrder(SequenceFlow sequenceFlow, ConditionalSequenceFlowInfo conditionalSequenceFlowInfo) {
        TransitionOrderFeature orderFeature = (TransitionOrderFeature)sequenceFlow.getFeature(TransitionOrderFeature.class);
        int evalOrder = orderFeature == null ? -1 : orderFeature.getValue();
        conditionalSequenceFlowInfo.setEvaluationOrder(evalOrder);
    }

    private static void setScriptInfo(SequenceFlow sequenceFlow, ConditionalSequenceFlowInfo conditionalSequenceFlowInfo) {
        TransitionMethodFeature feature = (TransitionMethodFeature)sequenceFlow.getFeature(TransitionMethodFeature.class);
        String scriptLanguage = null;
        String script = null;
        if (feature != null && feature.getValue() != null) {
            scriptLanguage = feature.getValue().getLanguage().toString();
            script = feature.getValue().getExpressionValue();
        }
        conditionalSequenceFlowInfo.setScript(script);
        conditionalSequenceFlowInfo.setScriptLanguage(scriptLanguage);
    }
}

