/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.sequenceflow;

import oracle.bpm.bpmn.engine.model.runtime.scripting.SequenceFlowConditionEvaluator;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.SequenceFlow;

public abstract class SequenceFlowInfo {
    private SequenceFlowConditionEvaluator conditionEvaluator;
    private String id;
    private SequenceFlow sequenceFlow;
    private String sourceActivityId;
    private String targetActivityId;
    private String targetNodeId;

    protected SequenceFlowInfo(String id, String sourceActivityId, String targetActivityId, String targetNodeId) {
        this.targetNodeId = targetNodeId;
        this.id = id;
        this.sourceActivityId = sourceActivityId;
        this.targetActivityId = targetActivityId;
        this.conditionEvaluator = this.createConditionEvaluator();
    }

    public abstract BpmnSequenceFlowType getBpmnSequenceFlowType();

    public abstract int getEvaluationOrder();

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceActivityId() {
        return this.sourceActivityId;
    }

    public String getTargetActivityId() {
        return this.targetActivityId;
    }

    public final SequenceFlowConditionEvaluator getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    public boolean isConditionalFlow() {
        return this.sequenceFlow == null ? false : this.sequenceFlow.isConditionalFlow();
    }

    public Expression getCondition() {
        return this.sequenceFlow.asConditionalFlow().getCondition();
    }

    public String getSequenceFlowId() {
        return this.sequenceFlow.getId();
    }

    public String getSequenceFlowDefaultLabel() {
        return this.sequenceFlow.getDefaultLabel();
    }

    public String getSourceActivityLabel() {
        return this.sequenceFlow.getSource().getDefaultLabel();
    }

    public String getTargetActivityLabel() {
        return this.sequenceFlow.getTarget().getDefaultLabel();
    }

    protected abstract SequenceFlowConditionEvaluator createConditionEvaluator();

    protected SequenceFlow getSequenceFlow() {
        return this.sequenceFlow;
    }

    void setSequenceFlow(SequenceFlow sequenceFlow) {
        this.sequenceFlow = sequenceFlow;
    }
}

