/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.scripting;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.oracle.bpel.client.BPELFault;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Process;

public class ScriptTaskUtils {
    private static final String JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK = "JavaScriptException: __ThrowRollback__ ";
    private static final String BPEL_SCHEMA = "http://schemas.oracle.com/bpel/extension";
    private static final String ROLLBACK = "rollback";
    protected static Map<String, ScriptEngine> scriptEngineCache = new HashMap<String, ScriptEngine>();
    public static final String DEFAULT_SCRIPT_LANGUAGE = "JavaScript";

    public static Object evaluate(Map<String, Object> map, String sl, String script) {
        SimpleBindings sb = new SimpleBindings(map);
        ScriptEngine engine = ScriptTaskUtils.getScriptEngine(sl);
        Object obj = null;
        try {
            obj = engine.eval(script, (Bindings)sb);
        }
        catch (ScriptException e) {
            if (BPMRuntimeLogger.isRuntimeTestEnabled() && e.getMessage().contains(JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK)) {
                throw new BPELFault(new QName(BPEL_SCHEMA, ROLLBACK));
            }
            throw new RuntimeException(e);
        }
        return obj;
    }

    public static Object evaluate(Map<String, Object> map, String sl, Reader reader) {
        SimpleBindings sb = new SimpleBindings(map);
        ScriptEngine engine = ScriptTaskUtils.getScriptEngine(sl);
        Object obj = null;
        try {
            obj = engine.eval(reader, (Bindings)sb);
        }
        catch (ScriptException e) {
            if (e.getMessage().contains(JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK)) {
                throw new BPELFault(new QName(BPEL_SCHEMA, ROLLBACK));
            }
            throw new RuntimeException(e);
        }
        return obj;
    }

    public static Object evaluate(Map<String, Object> map, String scriptLanguage, Object script) {
        Object ret;
        if (script instanceof Reader) {
            Reader reader = (Reader)script;
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, reader);
        } else if (script instanceof InputStream) {
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, new BufferedReader(new InputStreamReader((InputStream)script)));
        } else {
            String reader = (String)script;
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, reader);
        }
        return ret;
    }

    public static String getDefaultScriptLanguage() {
        return DEFAULT_SCRIPT_LANGUAGE;
    }

    public static void bindProcessDataObjects(Process process, IScope iScope, Map<String, Object> bindings) throws CubeException {
        Sequence dataObjects = process.getLocalDeclarations(DataObject.class);
        ScriptTaskUtils.bindDataObjects((Sequence<DataObject>)dataObjects, iScope, bindings);
    }

    public static void bindDataObjects(Sequence<DataObject> dataObjects, IScope iScope, Map<String, Object> bindings) throws CubeException {
        for (DataObject dataObject : dataObjects) {
            String objName = dataObject.getName();
            Object obj = iScope.getObject(objName);
            if (obj instanceof CXTypeVariable) {
                Object value = ((CXTypeVariable)obj).getValue();
                if (value == null) {
                    value = "";
                }
                bindings.put(objName, value);
                continue;
            }
            bindings.put(objName, obj);
        }
    }

    public static void unbindProcessDataObjects(Process process, IScope iScope, Map<String, Object> bindings) throws CubeException {
        ScriptTaskUtils.unbindDataObjects((Sequence<DataObject>)process.getLocalDeclarations(DataObject.class), iScope, bindings);
    }

    public static void unbindDataObjects(Sequence<DataObject> dataObjects, IScope iScope, Map<String, Object> bindings) throws CubeException {
        for (DataObject dataObject : dataObjects) {
            Object newObj;
            String objName = dataObject.getName();
            Object obj = iScope.getObject(objName);
            if (!(obj instanceof CXTypeVariable) || (newObj = bindings.get(objName)) instanceof CXTypeVariable) continue;
            ((CXTypeVariable)obj).setValue(newObj);
        }
    }

    public static Object evaluateScript(String scriptFileName, Map<String, Object> bindings) {
        return ScriptTaskUtils.evaluateScript(ScriptTaskUtils.getScriptFile(scriptFileName), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateScript(File scriptFile, Map<String, Object> bindings) {
        Object object;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(scriptFile));
        try {
            String scriptEngine = "Groovy";
            object = ScriptTaskUtils.evaluate(bindings, scriptEngine, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    public static <T> T createScriptedProxy(String prefix, Class<T> iface, Object context) {
        ScriptBasedInvocationHandler invocationHandler = new ScriptBasedInvocationHandler(prefix + ScriptTaskUtils.buildScriptName(iface), context);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)invocationHandler);
    }

    public static <T> T createScriptedProxy(Class<T> iface, Object context) {
        return ScriptTaskUtils.createScriptedProxy("", iface, context);
    }

    public static File getScriptFile(String scriptFileName) {
        return new File(System.getProperty("scripts.dir", File.separatorChar + "scratch" + File.separatorChar + System.getProperty("user.name") + File.separatorChar + "tmp"), scriptFileName);
    }

    public static String buildScriptName(String component, String composite, String revision) {
        return component + "_" + composite + "_" + revision + ".gy";
    }

    private static String buildScriptName(Class iface) {
        String scriptName = iface.getName();
        int offset = scriptName.lastIndexOf(46);
        if (offset > -1) {
            scriptName = scriptName.substring(offset + 1);
        }
        return scriptName;
    }

    private static ScriptEngine getScriptEngine(String sl) {
        return new ScriptEngineManager().getEngineByName(sl);
    }

    private static class ScriptBasedInvocationHandler
    implements InvocationHandler {
        private Object context;
        private String name;

        private ScriptBasedInvocationHandler(String name, Object context) {
            this.name = name;
            this.context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("parameters", args);
            bindings.put("context", this.context);
            File scriptFile = ScriptTaskUtils.getScriptFile(this.name + "_" + method.getName() + ".gy");
            if (scriptFile.exists()) {
                try {
                    return ScriptTaskUtils.evaluateScript(scriptFile, bindings);
                }
                catch (Exception e) {
                    throw this.extractRealException(e);
                }
            }
            throw new UnsupportedOperationException("Script file " + scriptFile + " not found.");
        }

        private Throwable extractRealException(Exception e) {
            Throwable ex = e.getCause();
            while (ex.getClass().equals(ScriptException.class)) {
                ex = ex.getCause();
            }
            return ex;
        }
    }
}

